/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.bootimage.svd.utils;

import com.nxp.swtools.bootimage.svd.utils.RegisterInfo;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.NonNullByDefault;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

@NonNullByDefault
public class PeripheralInfo {
    private String name = "";
    private String baseAddress = "";
    private String offset = "";
    private String blockSize = "";
    private Map<@NonNull String, @NonNull RegisterInfo> registers = new HashMap<String, RegisterInfo>();
    public static final Comparator<PeripheralInfo> compareByAddressDescending = new Comparator<PeripheralInfo>(){

        @Override
        public int compare(PeripheralInfo left, PeripheralInfo right) {
            long leftValue = left.getFullAddress();
            long rightValue = right.getFullAddress();
            return (int)(rightValue - leftValue);
        }
    };

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getBaseAddress() {
        return this.baseAddress;
    }

    public void setBaseAddress(String baseAddress) {
        this.baseAddress = baseAddress.startsWith("0x") ? baseAddress : "0x" + baseAddress;
    }

    public String getOffset() {
        return this.offset;
    }

    public void setOffset(String offset) {
        this.offset = offset;
    }

    public String getBlockSize() {
        return this.blockSize;
    }

    public void setBlockSize(String blockSize) {
        this.blockSize = blockSize;
    }

    public long getFullAddress() {
        return Long.parseLong(this.baseAddress.substring(2), 16);
    }

    public long getFullAddressLimit() {
        long value = this.getFullAddress();
        long offsetValue = -1L;
        offsetValue = this.offset.startsWith("0x") ? Long.parseLong(this.offset.substring(2), 16) : Long.parseLong(this.offset, 10);
        value += offsetValue;
        long size = -1L;
        size = this.blockSize.startsWith("0x") ? Long.parseLong(this.blockSize.substring(2), 16) : Long.parseLong(this.blockSize, 10);
        return value += size;
    }

    public Map<String, RegisterInfo> getRegisters() {
        return this.registers;
    }

    public void setRegisters(Map<String, RegisterInfo> registers) {
        this.registers = registers;
    }
}

