/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.bootimage.utils;

import com.nxp.swtools.bootimage.utils.ColorAndTooltip;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import java.util.Arrays;
import java.util.NavigableMap;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.Tooltip;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.util.Callback;

public class BinaryTablePreview {
    private TableView<ObservableList<String>> tableView = new TableView();
    private ObservableList<ObservableList<String>> tableData = FXCollections.observableArrayList();

    public TableView<ObservableList<String>> createTableView(byte[] bytes, @Nullable String tableId, int nrCols, @Nullable NavigableMap<Integer, ColorAndTooltip> colorAndTooltipMap) {
        this.tableView.setId(tableId);
        this.tableView.setEditable(false);
        this.tableView.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
        this.tableView.getSelectionModel().setCellSelectionEnabled(true);
        this.tableView.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        this.createTableViewContent(bytes, nrCols, colorAndTooltipMap);
        return this.tableView;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private void createTableViewContent(byte[] bytes, int nrCols, @Nullable NavigableMap<Integer, ColorAndTooltip> colorAndTooltipMap) {
        int currentColumn = 0;
        @NonNull ObservableList row = FXCollections.observableArrayList();
        int i = 0;
        while (i < bytes.length) {
            if (i % nrCols == 0) {
                currentColumn = 0;
                if (i != 0) {
                    this.tableData.add((Object)row);
                }
                row = FXCollections.observableArrayList();
                row.add((Object)String.format("0x%08X", i));
            }
            row.add((Object)String.format("0x%02X", bytes[i]));
            ++currentColumn;
            ++i;
        }
        if (currentColumn <= nrCols) {
            i = currentColumn;
            while (i <= nrCols) {
                row.add((Object)"");
                ++i;
            }
        }
        this.tableData.add((Object)row);
        i = 0;
        while (i <= nrCols) {
            TableColumn col;
            final int j = i;
            if (i == 0) {
                col = new TableColumn("Offset");
                col.setCellFactory(param -> new TableCell<ObservableList<String>, String>(){

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (!this.isEmpty()) {
                            this.setTextFill((Paint)Color.DARKSLATEBLUE);
                            this.setText(item);
                            this.setStyle("-fx-font-weight: bold");
                        }
                    }
                });
                col.setMinWidth(100.0);
            } else {
                col = new TableColumn(String.format("0x%02X", i - 1));
                BinaryTablePreview.updateTableToolTipsAndColors(nrCols, colorAndTooltipMap, j, (TableColumn<ObservableList<String>, String>)col);
                col.setMinWidth(45.0);
            }
            col.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ObservableList<String>, String>, ObservableValue<String>>(){

                public ObservableValue<String> call(TableColumn.CellDataFeatures<ObservableList<String>, String> param) {
                    return new SimpleStringProperty((String)((ObservableList)param.getValue()).get(j));
                }
            });
            col.setSortable(false);
            this.tableView.getColumns().add((Object)col);
            ++i;
        }
        this.tableView.setItems(this.tableData);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public void updateTableViewContent(byte[] bytes, int nrCols, @Nullable NavigableMap<Integer, ColorAndTooltip> colorAndTooltipMap) {
        int i = 0;
        while (i < this.tableData.size()) {
            @NonNull ObservableList row = (ObservableList)this.tableData.get(i);
            row.clear();
            row.add((Object)String.format("0x%07X0", i));
            byte[] rowBytes = Arrays.copyOfRange(bytes, i * nrCols, i * nrCols + nrCols);
            int j = 0;
            while (j < rowBytes.length) {
                if (i * nrCols + j >= bytes.length) {
                    row.add((Object)"");
                } else {
                    row.add((Object)String.format("0x%02X", rowBytes[j]));
                }
                ++j;
            }
            ++i;
        }
        i = 1;
        while (i <= nrCols) {
            int j = i;
            TableColumn col = (TableColumn)this.tableView.getColumns().get(i);
            if (col != null) {
                BinaryTablePreview.updateTableToolTipsAndColors(nrCols, colorAndTooltipMap, j, (TableColumn<ObservableList<String>, String>)col);
            }
            ++i;
        }
        this.tableView.setItems(this.tableData);
        this.tableView.refresh();
    }

    private static void updateTableToolTipsAndColors(final int nrCols, final @Nullable NavigableMap<Integer, ColorAndTooltip> colorAndTooltipMap, final int currentColumn, TableColumn<ObservableList<String>, String> col) {
        col.setCellFactory(param -> new TableCell<ObservableList<String>, String>(){

            public void updateItem(String item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (this.isEmpty()) {
                    return;
                }
                int currRow = this.getIndex();
                int currColumn = currentColumn;
                this.setFont(Font.font((String)"Consolas", (double)15.0));
                TableView localTableView = this.getTableView();
                if (localTableView != null) {
                    localTableView.getSelectionModel().clearSelection();
                    localTableView.getSelectionModel().setCellSelectionEnabled(true);
                }
                if (colorAndTooltipMap != null) {
                    Color c;
                    String tooltip = ((ColorAndTooltip)colorAndTooltipMap.floorEntry(currRow * nrCols + currColumn).getValue()).getTooltip();
                    if (tooltip != null) {
                        this.setTooltip(new Tooltip(tooltip));
                    }
                    this.setTextFill((Paint)((c = ((ColorAndTooltip)colorAndTooltipMap.floorEntry(currRow * nrCols + currColumn).getValue()).getColor()) != null ? c : Color.BLACK));
                }
                this.setOnMouseEntered(mouseEvent -> {
                    if (((String)this.getItem()).equals("")) {
                        this.setTooltip(null);
                        return;
                    }
                    DropShadow shaddowEffect = new DropShadow();
                    shaddowEffect.setOffsetY(5.0);
                    shaddowEffect.setOffsetX(4.0);
                    shaddowEffect.setColor(Color.GREY);
                    this.setEffect((Effect)shaddowEffect);
                    this.setStyle("-fx-border-color: black");
                });
                this.setOnMouseExited(mouseEvent -> {
                    this.setStyle("-fx-border-color: transparent");
                    this.setEffect(null);
                });
                this.setText(item);
            }
        });
    }
}

