/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.bootimage.validation;

import com.nxp.swtools.bootimage.utils.CustomContextMenu;
import com.nxp.swtools.bootimage.validation.IProblemSource;
import com.nxp.swtools.bootimage.validation.IProblemUIContainer;
import com.nxp.swtools.bootimage.validation.ITextFieldValidator;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import java.util.ArrayList;
import java.util.logging.Logger;
import javafx.scene.control.TextField;
import javafx.scene.input.MouseButton;
import org.eclipse.core.runtime.Status;

public abstract class AValidatedTextField
extends TextField
implements IProblemUIContainer,
IProblemSource {
    protected static final Logger LOGGER = LogManager.getLogger(AValidatedTextField.class);
    protected ArrayList<ITextFieldValidator> validators = new ArrayList();
    protected Status validationStatus;
    protected CustomContextMenu menu;

    public AValidatedTextField(String pluginID) {
        this.validationStatus = new Status(0, pluginID, "");
        this.menu = new CustomContextMenu(this);
        this.setContextMenu(this.menu);
        this.menu.setAutoHide(true);
        this.setOnMouseClicked(e -> {
            if (!this.isEditable()) {
                this.menu.hide();
            } else if (!this.menu.isShowing() && e.getButton().equals((Object)MouseButton.SECONDARY)) {
                this.menu.show(this.getScene().getWindow());
            }
        });
        this.setOnContextMenuRequested(e -> {
            if (!this.isEditable()) {
                this.menu.hide();
            }
        });
    }

    public AValidatedTextField(Runnable modelUpdater, String pluginID) {
        this(pluginID);
        this.setOnKeyReleased(e -> {
            if ((e.isControlDown() || e.getCode().getName().equalsIgnoreCase("ctrl")) && !e.getCode().getName().equalsIgnoreCase("x") && !e.getCode().getName().equalsIgnoreCase("v")) {
                e.consume();
            } else {
                modelUpdater.run();
            }
        });
        this.menu.getPasteItem().setOnAction(e -> {
            this.paste();
            modelUpdater.run();
        });
    }

    public void addValidator(ITextFieldValidator validator) {
        this.validators.add(validator);
    }

    protected ArrayList<ITextFieldValidator> getValidators() {
        return this.validators;
    }

    protected void setValidators(ArrayList<ITextFieldValidator> validators) {
        this.validators = validators;
    }

    public void resetStyle() {
        super.getStyleClass().clear();
        super.getStyleClass().add((Object)"text-input");
        super.getStyleClass().add((Object)"text-field");
    }

    public void setDefaultStyle() {
        super.getStyleClass().add((Object)"defaultRegisterField");
    }

    public void setResetStyle() {
        super.getStyleClass().add((Object)"changedRegisterField");
    }

    public void selectAll() {
        if (this.isEditable()) {
            super.selectAll();
        }
    }

    @Override
    public @Nullable String getInvalidFieldValue() {
        return (String)this.textProperty().get();
    }
}

