/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.bootimage.validation;

import com.nxp.swtools.bootimage.utils.Messages;
import com.nxp.swtools.bootimage.validation.ITextFieldValidator;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.number.NumberFormatValidator;
import com.nxp.swtools.common.utils.number.NumberFormatter;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.Status;

public class HexadecimalAddressValidator
implements ITextFieldValidator {
    protected int width = 0;
    boolean isZeroValueValid = true;
    protected static final Logger LOGGER = LogManager.getLogger(HexadecimalAddressValidator.class);

    public HexadecimalAddressValidator(int width) {
        this.width = width;
        this.isZeroValueValid = true;
    }

    public HexadecimalAddressValidator(int width, boolean isZeroValueValid) {
        this.width = width;
        this.isZeroValueValid = isZeroValueValid;
    }

    @Override
    public Status validate(String pluginId, String value) {
        Status hexStatus = this.isValidHexadecimal(pluginId, value);
        if (hexStatus.isOK()) {
            return hexStatus;
        }
        if (!hexStatus.isOK() && NumberFormatValidator.isValidHexadecimal((String)value)) {
            return hexStatus;
        }
        return hexStatus;
    }

    public Status isValidHexadecimal(String pluginId, String value) {
        Status status = new Status(0, pluginId, "");
        long longValue = NumberFormatValidator.getLongValueFromString((String)value);
        if (NumberFormatValidator.isValidHexadecimal((String)value)) {
            if (!NumberFormatValidator.isValidHexadecimal((String)value) || NumberFormatter.hexadecimalToDec((String)value) > NumberFormatValidator.getHighDecimalLimit((int)this.width)) {
                status = new Status(4, pluginId, Messages.InvalidWidthValue);
            } else if (!this.isZeroValueValid && longValue == 0L) {
                status = new Status(4, pluginId, Messages.InvalidTextfieldValueZero);
            } else {
                try {
                    Long.parseLong(value.substring(2), 16);
                }
                catch (NumberFormatException err) {
                    LOGGER.log(Level.SEVERE, "Error parsing the value", err);
                    status = new Status(4, pluginId, Messages.InvalidWidthValue);
                }
            }
        } else {
            status = new Status(4, pluginId, Messages.HexadecimalInvalidValue);
        }
        return status;
    }
}

