/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.bootimage.validation;

import com.nxp.swtools.bootimage.utils.Messages;
import com.nxp.swtools.bootimage.validation.ITextFieldValidator;
import com.nxp.swtools.common.utils.number.NumberFormatValidator;
import java.text.MessageFormat;
import org.eclipse.core.runtime.Status;

public class HexadecimalStringValidator
implements ITextFieldValidator {
    private int width = 0;

    public HexadecimalStringValidator(int width) {
        this.width = width;
    }

    @Override
    public Status validate(String pluginId, String value) {
        Status status = new Status(0, pluginId, "");
        if (value.isEmpty()) {
            status = new Status(4, pluginId, Messages.EmptyTextfield);
        } else if (!NumberFormatValidator.HEXADECIMAL_CHAR_REGEXP.matcher(value).matches()) {
            status = new Status(4, pluginId, Messages.ErrMsg_InvalidHexString);
        } else if (value.length() != this.width * 2) {
            status = new Status(4, pluginId, MessageFormat.format(Messages.ErrMsg_InvalidHexStringLength, String.valueOf(this.width)));
        }
        return status;
    }
}

