/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.runtime.migration.internal.compatibility;

import com.nxp.s32ds.cle.runtime.migration.diagnostic.MigrationDiagnostic;
import com.nxp.s32ds.cle.runtime.migration.diagnostic.MigrationDiagnosticElementType;
import com.nxp.s32ds.cle.runtime.migration.entity.core.MigrationEntityDescriptors;
import com.nxp.s32ds.cle.runtime.migration.internal.compatibility.MigrationCompatibilityAction;
import com.nxp.s32ds.cle.runtime.migration.internal.compatibility.MigrationCompatibilityActivator;
import com.nxp.s32ds.cle.runtime.migration.internal.compatibility.MigrationCompatibilityEntityDescriptor;
import com.nxp.s32ds.cle.runtime.migration.provider.MigrationProvider;
import com.nxp.s32ds.cle.runtime.migration.provider.MigrationProviderDescriptor;
import com.nxp.s32ds.cle.runtime.migration.sequence.MigrationSequence;
import com.nxp.s32ds.cle.runtime.migration.sequence.MigrationStep;
import com.nxp.s32ds.ext.rcp.registry.EntityDescriptor;
import com.nxp.s32ds.ext.rcp.registry.ReferenceDescriptor;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class MigrationCompatibilitySequence
extends MigrationCompatibilityEntityDescriptor
implements MigrationSequence {
    private final MigrationProvider migrationProvider;
    private final List<MigrationCompatibilityAction> actions;

    public MigrationCompatibilitySequence(MigrationProviderDescriptor descriptor) {
        super((EntityDescriptor)descriptor, (ReferenceDescriptor)descriptor);
        this.migrationProvider = descriptor.getMigrationProvider();
        this.actions = MigrationEntityDescriptors.getMigrationEntityDescriptorsByPorvider((String)descriptor.getId()).stream().map(MigrationCompatibilityAction::new).collect(Collectors.toList());
    }

    public List<MigrationCompatibilityAction> getActions() {
        return this.actions;
    }

    public boolean match(IProject project, MigrationDiagnostic diagnostic) {
        Map<String, Object> createAttributes = MigrationCompatibilityActivator.createAttributes(project);
        return MigrationCompatibilitySequence.evaluate(this.createSequenceDiagnostic(diagnostic), d -> MigrationCompatibilitySequence.evaluate(this.createConditionDiagnostic((MigrationDiagnostic)d), d1 -> this.migrationProvider.checkMigrationConditions(this.getSourceId(), this.getTargetId(), createAttributes)).isOK());
    }

    public List<MigrationStep> getMigrationSteps(IProject project, MigrationDiagnostic diagnostic) {
        MigrationDiagnostic sequenceDiagnostic = this.createSequenceDiagnostic(diagnostic);
        return this.actions.stream().filter(a -> MigrationCompatibilitySequence.evaluate(this.createActionDiagnostic(sequenceDiagnostic, project, (MigrationCompatibilityAction)a), d -> a.isApplicable(project))).map(a -> new MigrationCompatibilityStep(project, (MigrationCompatibilityAction)a)).collect(Collectors.toList());
    }

    public static <R> R evaluate(MigrationDiagnostic diagnostic, Function<MigrationDiagnostic, R> function) {
        R result = function.apply(diagnostic);
        diagnostic.setValue(result);
        return result;
    }

    private MigrationDiagnostic createSequenceDiagnostic(MigrationDiagnostic diagnostic) {
        return diagnostic.subDiagnostic(MigrationDiagnosticElementType.SEQUENCE, this.entityDescriptor.getId(), this.entityDescriptor.getName());
    }

    private MigrationDiagnostic createConditionDiagnostic(MigrationDiagnostic diagnostic) {
        MigrationDiagnostic conditionDiagnostic = diagnostic.subDiagnostic(MigrationDiagnosticElementType.CONDITION, null, null);
        MigrationCompatibilitySequence.createPropertiesDiagnostic(conditionDiagnostic, this);
        return conditionDiagnostic;
    }

    private MigrationDiagnostic createActionDiagnostic(MigrationDiagnostic sequenceDiagnostic, IProject project, MigrationCompatibilityAction a) {
        MigrationDiagnostic actionDiagnostic = sequenceDiagnostic.subDiagnostic(MigrationDiagnosticElementType.ACTION, a.getId(), this.getName());
        MigrationCompatibilitySequence.createPropertiesDiagnostic(actionDiagnostic, a);
        return actionDiagnostic;
    }

    private static MigrationDiagnostic createPropertiesDiagnostic(MigrationDiagnostic diagnostic, MigrationCompatibilityEntityDescriptor descriptor) {
        if (descriptor.getSourceId() != null) {
            diagnostic.subDiagnostic(MigrationDiagnosticElementType.PROPERTY, null, "sourceId").setValue((Object)descriptor.getSourceId());
        }
        if (descriptor.getTargetId() != null) {
            diagnostic.subDiagnostic(MigrationDiagnosticElementType.PROPERTY, null, "targetId").setValue((Object)descriptor.getTargetId());
        }
        return diagnostic;
    }

    private static class MigrationCompatibilityStep
    implements MigrationStep {
        private final IProject project;
        private final MigrationCompatibilityAction action;

        public MigrationCompatibilityStep(IProject project, MigrationCompatibilityAction action) {
            this.project = project;
            this.action = action;
        }

        public void perform(IProgressMonitor monitor) throws CoreException {
            this.action.perform(this.project, monitor);
        }

        public String getName() {
            return this.action.getName();
        }
    }
}

