/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core.scannerconfig.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.cdt.core.envvar.IEnvironmentVariableManager;
import org.eclipse.cdt.core.model.CoreModelUtil;
import org.eclipse.cdt.core.settings.model.ICConfigExtensionReference;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.internal.core.Cygwin;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.internal.core.scannerconfig.util.TraceUtil;
import org.eclipse.cdt.utils.CygPath;
import org.eclipse.cdt.utils.ICygwinToolsFactroy;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;

public class CygpathTranslator {
    private static final String ENV_PATH = "PATH";
    private CygPath cygPath = null;

    public CygpathTranslator(IProject project) {
        try {
            ICConfigExtensionReference[] parserRef = CCorePlugin.getDefault().getDefaultBinaryParserExtensions(project);
            int i = 0;
            while (i < parserRef.length) {
                try {
                    IBinaryParser parser = CoreModelUtil.getBinaryParser((ICConfigExtensionReference)parserRef[i]);
                    ICygwinToolsFactroy cygwinToolFactory = (ICygwinToolsFactroy)parser.getAdapter(ICygwinToolsFactroy.class);
                    if (cygwinToolFactory != null) {
                        this.cygPath = cygwinToolFactory.getCygPath();
                    }
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
                ++i;
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public static List<String> translateIncludePaths(IProject project, List<String> sumIncludes) {
        boolean translationNeeded = false;
        if (Platform.getOS().equals("win32")) {
            for (String include : sumIncludes) {
                if (!include.startsWith("/")) continue;
                translationNeeded = true;
                break;
            }
        }
        if (!translationNeeded) {
            return sumIncludes;
        }
        CygpathTranslator cygpath = new CygpathTranslator(project);
        boolean useCygPathExtension = cygpath.cygPath != null;
        boolean useCygwinFromPath = !useCygPathExtension;
        String envPath = null;
        if (useCygwinFromPath) {
            IEnvironmentVariable envVar;
            ICConfigurationDescription cfgDes;
            IEnvironmentVariable envVar2;
            IEnvironmentVariableManager mngr = CCorePlugin.getDefault().getBuildEnvironmentManager();
            ICProjectDescription prjDes = CCorePlugin.getDefault().getProjectDescription(project, false);
            if (prjDes != null && (envVar2 = mngr.getVariable(ENV_PATH, cfgDes = prjDes.getDefaultSettingConfiguration(), true)) != null) {
                envPath = envVar2.getValue();
            }
            if (envPath == null && (envVar = mngr.getVariable(ENV_PATH, null, true)) != null) {
                envPath = envVar.getValue();
            }
            useCygwinFromPath = Cygwin.isAvailable(envPath);
        }
        ArrayList<String> translatedIncludePaths = new ArrayList<String>();
        for (String includePath : sumIncludes) {
            String drive;
            Path realPath = new Path(includePath);
            if (realPath.getDevice() != null && realPath.toFile().exists()) {
                translatedIncludePaths.add(includePath);
                continue;
            }
            String translatedPath = includePath;
            if (useCygPathExtension) {
                try {
                    translatedPath = cygpath.cygPath.getFileName(includePath);
                }
                catch (IOException e) {
                    TraceUtil.outputError("CygpathTranslator unable to translate path: ", includePath);
                }
            } else if (useCygwinFromPath) {
                try {
                    translatedPath = Cygwin.cygwinToWindowsPath((String)includePath, (String)envPath);
                }
                catch (Exception e) {
                    MakeCorePlugin.log(e);
                }
            } else if (realPath.segmentCount() >= 2 && "cygdrive".equals(realPath.segment(0)) && (drive = realPath.segment(1)).length() == 1) {
                translatedPath = realPath.removeFirstSegments(2).makeAbsolute().setDevice(String.valueOf(drive.toUpperCase()) + ':').toOSString();
            }
            if (!translatedPath.equals(includePath)) {
                if (new File(translatedPath).exists()) {
                    translatedIncludePaths.add(translatedPath);
                    continue;
                }
                if (useCygPathExtension || useCygwinFromPath) {
                    translatedIncludePaths.add(translatedPath);
                    continue;
                }
                translatedIncludePaths.add(includePath);
                continue;
            }
            translatedIncludePaths.add(translatedPath);
        }
        if (useCygPathExtension) {
            cygpath.cygPath.dispose();
        }
        return translatedIncludePaths;
    }
}

