/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.memory.spaces.internal.base;

import com.nxp.s32ds.cle.cdt.memory.spaces.base.MemoryAccessor;
import com.nxp.s32ds.cle.cdt.memory.spaces.base.MemorySpace;
import com.nxp.s32ds.cle.cdt.memory.spaces.internal.base.DsfMemoryCmdRequestor;
import com.nxp.s32ds.cle.cdt.memory.spaces.internal.base.MemorySpaceActivator;
import com.nxp.s32ds.cle.cdt.memory.spaces.internal.base.Messages;
import com.nxp.s32ds.cle.runtime.memory.spaces.core.DeviceCoreMemorySpaceDescriptor;
import com.nxp.s32ds.cle.runtime.memory.spaces.core.MemorySpaces;
import com.nxp.s32ds.debug.ide.core.S32DSGdbLaunch;
import com.nxp.s32ds.ext.cdt.dsf.DsfRequest;
import com.nxp.s32ds.ext.cdt.dsf.DsfResponse;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IMemory;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControlService;
import org.eclipse.cdt.dsf.gdb.launching.GdbLaunch;
import org.eclipse.cdt.dsf.gdb.service.IGDBProcesses;
import org.eclipse.cdt.dsf.mi.service.IMIContainerDMContext;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.MemoryByte;
import org.eclipse.osgi.util.NLS;

public class MemoryAccessorImpl
implements MemoryAccessor {
    private GdbLaunch launch;
    private IDMContext idmContext;
    private GdbLaunch cachedLaunch;
    private IDMContext cachedIdmContext;

    @Override
    public CompletableFuture<DsfResponse<MemorySpace, MemoryByte[]>> scheduleReadRequest(MemorySpace memSpace) {
        DsfSession session = this.getSession();
        if (session != null) {
            return DsfMemoryCmdRequestor.getInstance().requestRead(DsfRequest.readRequest((DsfSession)session, (IDMContext)this.idmContext, (Object)memSpace));
        }
        return null;
    }

    @Override
    public CompletableFuture<DsfResponse<MemorySpace, MemoryByte[]>> scheduleWriteRequest(MemorySpace memSpace, byte[] value) {
        DsfSession session = this.getSession();
        if (session != null) {
            return DsfMemoryCmdRequestor.getInstance().requestWrite(DsfRequest.writeRequest((DsfSession)session, (IDMContext)this.idmContext, (Object)memSpace, (Object)value));
        }
        return null;
    }

    private DsfSession getSession() {
        if (this.launch == null) {
            MemorySpaceActivator.getInstance().logError(Messages.MemoryAccessor_error_no_launch);
            return null;
        }
        DsfSession session = this.launch.getSession();
        if (session == null) {
            MemorySpaceActivator.getInstance().logError(NLS.bind((String)Messages.MemoryAccessor_error_no_dsf_session, (Object)this.launch.getLaunchConfiguration().getName()));
            return null;
        }
        return session;
    }

    @Override
    public void setCurrentContext(IAdaptable adaptable) {
        IDMContext idmCurrentContext;
        if (adaptable == null) {
            return;
        }
        GdbLaunch launchFromContext = MemoryAccessorImpl.getLaunchFromContext(adaptable);
        if (launchFromContext != null) {
            this.launch = launchFromContext;
        }
        if ((idmCurrentContext = this.getIdmContext(adaptable)) != null) {
            this.idmContext = idmCurrentContext;
        }
    }

    @Override
    public void saveCurrentContext() {
        this.cachedLaunch = this.launch;
        this.cachedIdmContext = this.idmContext;
    }

    @Override
    public void restoreSavedContext() {
        if (this.cachedLaunch != null) {
            this.launch = this.cachedLaunch;
            this.cachedLaunch = null;
        }
        if (this.cachedIdmContext != null) {
            this.idmContext = this.cachedIdmContext;
            this.cachedIdmContext = null;
        }
    }

    private IDMContext getIdmContext(IAdaptable adaptable) {
        IDMContext idmContext = (IDMContext)adaptable.getAdapter(IDMContext.class);
        if (idmContext != null) {
            return DMContexts.getAncestorOfType((IDMContext)idmContext, IMemory.IMemoryDMContext.class);
        }
        if (this.launch != null) {
            DsfServicesTracker tracker = new DsfServicesTracker(MemorySpaceActivator.getInstance().getContext(), this.launch.getSession().getId());
            try {
                IGDBProcesses service = (IGDBProcesses)tracker.getService(IGDBProcesses.class);
                ICommandControlService commandControl = (ICommandControlService)tracker.getService(ICommandControlService.class);
                if (service != null && commandControl != null) {
                    IMIContainerDMContext iMIContainerDMContext = service.createContainerContextFromThreadId(commandControl.getContext(), this.launch.getSession().getId());
                    return iMIContainerDMContext;
                }
            }
            finally {
                tracker.dispose();
            }
        }
        return null;
    }

    private static GdbLaunch getLaunchFromContext(IAdaptable adaptable) {
        ILaunch launch = (ILaunch)adaptable.getAdapter(ILaunch.class);
        if (!(launch instanceof GdbLaunch)) {
            return null;
        }
        if (launch.isTerminated()) {
            return null;
        }
        return (GdbLaunch)launch;
    }

    @Override
    public GdbLaunch getLaunch() {
        return this.launch;
    }

    @Override
    public IDMContext getIDMContext() {
        return this.idmContext;
    }

    @Override
    public List<DeviceCoreMemorySpaceDescriptor> getDeviceMemorySpaceDescriptors(ILaunch launch) {
        if (launch != null && !S32DSGdbLaunch.isShutdowned((ILaunch)launch)) {
            return MemorySpaces.getDeviceCoreMemorySpaceDescriptors((ILaunchConfiguration)launch.getLaunchConfiguration());
        }
        return Collections.emptyList();
    }
}

