/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.memory.spaces.internal.base;

import com.nxp.s32ds.cle.cdt.memory.spaces.base.MemorySpace;
import com.nxp.s32ds.cle.runtime.memory.spaces.core.DeviceCoreMemorySpaceDescriptor;
import java.math.BigInteger;

public class MemorySpaceImpl
implements MemorySpace {
    private String id;
    private String device;
    private String core;
    private String name;
    private int bytesPerAddress;
    private int bytesPerRow;
    private BigInteger baseAddress;
    private boolean enabled;
    private long memoryBlockSize;

    public MemorySpaceImpl(DeviceCoreMemorySpaceDescriptor descriptor) {
        this(descriptor.getId(), descriptor.getName(), descriptor.getDevice(), descriptor.getCore(), descriptor.getAddressBytes(), descriptor.getBytesPerRow());
    }

    public MemorySpaceImpl(String id, String name, String device, String core, int bytesPerAddress, int bytesPerRow) {
        this.id = id;
        this.name = name;
        this.device = device;
        this.core = core;
        this.enabled = true;
        this.memoryBlockSize = 0L;
        this.bytesPerAddress = bytesPerAddress;
        this.bytesPerRow = bytesPerRow;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getDevice() {
        return this.device;
    }

    @Override
    public String getCore() {
        return this.core;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public BigInteger getBaseAddress() {
        return this.baseAddress;
    }

    @Override
    public void setBaseAddress(BigInteger address) {
        this.baseAddress = address;
    }

    @Override
    public void setDataSize(long size) {
        this.memoryBlockSize = size;
    }

    @Override
    public long getDataSize() {
        return this.memoryBlockSize;
    }

    @Override
    public MemorySpace getWorkingCopy() {
        return new MemorySpaceImpl(this.id, this.name, this.device, this.core, this.bytesPerAddress, this.bytesPerRow);
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public int getBytesPerAddress() {
        return this.bytesPerAddress;
    }

    @Override
    public int getBytesPerRow() {
        return this.bytesPerRow;
    }

    @Override
    public String toModelString() {
        return String.valueOf(this.device) + "." + this.core + "." + this.id;
    }
}

