/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.runtime.hardware.registry.ui.tree;

import com.nxp.s32ds.cle.runtime.hardware.debugger.core.DeviceCoreDebuggerDescriptors;
import com.nxp.s32ds.cle.runtime.hardware.registry.DeviceCoreDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.DeviceDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.FamilyDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.core.DeviceDescriptors;
import com.nxp.s32ds.cle.runtime.hardware.registry.core.DeviceRevisionDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.core.FamilyDescriptors;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jface.viewers.ITreeContentProvider;

public abstract class HardwareContentProvider
implements ITreeContentProvider {
    public abstract List<FamilyDescriptor> getFamilyDescriptors();

    public abstract List<String> getFamilyIds();

    public abstract List<String> getDeviceIds();

    public abstract List<String> getDeviceCoreIds();

    public abstract Class<?> getSelectionType();

    protected static Map<FamilyDescriptor, Map<DeviceDescriptor, List<DeviceCoreDescriptor>>> getFamilyToDeviceMap(String debuggerId) {
        return HardwareContentProvider.cleanupEmptyValues(FamilyDescriptors.getFamilyDescriptors().stream().collect(Collectors.toMap(Function.identity(), familyDesc -> HardwareContentProvider.getDeviceToCoreMap(familyDesc, debuggerId))), v -> !v.isEmpty());
    }

    private static Stream<DeviceDescriptor> getDeviceWithRevision(DeviceDescriptor deviceDesc) {
        Collection revisions = DeviceDescriptors.getRevisions((String)deviceDesc.getId());
        if (revisions.isEmpty()) {
            return Stream.of(deviceDesc);
        }
        return revisions.stream().map(revision -> new DeviceRevisionDescriptor(deviceDesc, revision));
    }

    private static List<DeviceDescriptor> getDeviceDescriptors(FamilyDescriptor familyDesc) {
        return FamilyDescriptors.getDeviceDescriptors((String)familyDesc.getId()).stream().flatMap(deviceDesc -> HardwareContentProvider.getDeviceWithRevision(deviceDesc)).collect(Collectors.toList());
    }

    private static Map<DeviceDescriptor, List<DeviceCoreDescriptor>> getDeviceToCoreMap(FamilyDescriptor familyDesc, String debuggerId) {
        return HardwareContentProvider.cleanupEmptyValues(HardwareContentProvider.getDeviceDescriptors(familyDesc).stream().collect(Collectors.toMap(Function.identity(), deviceDesc -> DeviceCoreDebuggerDescriptors.getDeviceCoreDescriptorsByDebuggerId((String)deviceDesc.getId(), (String)debuggerId))), v -> !v.isEmpty());
    }

    private static <K, V> Map<K, V> cleanupEmptyValues(Map<K, V> map, Predicate<V> emptyPredicate) {
        return map.entrySet().stream().filter(e -> emptyPredicate.test(e.getValue())).collect(Collectors.toMap(e -> e.getKey(), e -> e.getValue()));
    }
}

