/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.compare;

import java.util.Stack;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTASMDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNodeLocation;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorIncludeStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorMacroDefinition;
import org.eclipse.cdt.core.dom.ast.IASTProblemDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTExplicitTemplateInstantiation;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTLinkageSpecification;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNamespaceAlias;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNamespaceDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTUsingDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTUsingDirective;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTVisibilityLabel;
import org.eclipse.cdt.internal.core.model.ASTStringUtil;
import org.eclipse.cdt.internal.core.model.CoreModelMessages;
import org.eclipse.cdt.internal.ui.CUIMessages;
import org.eclipse.cdt.internal.ui.compare.CNode;
import org.eclipse.compare.structuremergeviewer.DocumentRangeNode;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;

class CStructureCreatorVisitor
extends ASTVisitor {
    private static final String TRANSLATION_UNIT_NAME = CUIMessages.CStructureCreatorVisitor_translationUnitName;
    private static final String ANONYMOUS_NAME = CoreModelMessages.getString((String)"CElementLabels.anonymous");
    private Stack<DocumentRangeNode> fStack = new Stack();
    private IDocument fDocument;
    private String fTranslationUnitFileName;

    public CStructureCreatorVisitor(DocumentRangeNode root) {
        this.fDocument = root.getDocument();
        this.fStack.clear();
        this.fStack.push(root);
        this.shouldVisitTranslationUnit = true;
        this.shouldVisitDeclarations = true;
        this.shouldVisitEnumerators = true;
        this.shouldVisitNamespaces = true;
    }

    public int visit(IASTTranslationUnit tu) {
        this.fTranslationUnitFileName = tu.getFilePath();
        this.push(60, TRANSLATION_UNIT_NAME, 0);
        IASTPreprocessorIncludeStatement[] includeDirectives = tu.getIncludeDirectives();
        int i = 0;
        while (i < includeDirectives.length) {
            IASTPreprocessorIncludeStatement includeDirective = includeDirectives[i];
            if (this.isLocalToFile((IASTNode)includeDirective)) {
                this.push(75, new String(includeDirective.getName().toCharArray()), this.getStartOffset((IASTNode)includeDirective));
                this.pop(this.getEndOffset((IASTNode)includeDirective));
            }
            ++i;
        }
        IASTPreprocessorMacroDefinition[] macroDefinitions = tu.getMacroDefinitions();
        int i2 = 0;
        while (i2 < macroDefinitions.length) {
            IASTPreprocessorMacroDefinition macroDefinition = macroDefinitions[i2];
            if (this.isLocalToFile((IASTNode)macroDefinition)) {
                this.push(79, new String(macroDefinition.getName().toCharArray()), this.getStartOffset((IASTNode)macroDefinition));
                this.pop(this.getEndOffset((IASTNode)macroDefinition));
            }
            ++i2;
        }
        return super.visit(tu);
    }

    private boolean isLocalToFile(IASTNode node) {
        return this.fTranslationUnitFileName.equals(node.getContainingFilename());
    }

    private int getStartOffset(IASTNode node) {
        IASTFileLocation fileLocation = CStructureCreatorVisitor.getMinFileLocation(node.getNodeLocations());
        if (fileLocation != null) {
            return fileLocation.getNodeOffset();
        }
        DocumentRangeNode container = this.getCurrentContainer();
        Object[] children = container.getChildren();
        if (children != null && children.length > 0) {
            Position prevRange = ((DocumentRangeNode)children[children.length - 1]).getRange();
            return prevRange.getOffset() + prevRange.getLength();
        }
        Position containerRange = container.getRange();
        return containerRange.getOffset();
    }

    private int getEndOffset(IASTNode node) {
        IASTFileLocation fileLocation = CStructureCreatorVisitor.getMaxFileLocation(node.getNodeLocations());
        if (fileLocation != null) {
            return fileLocation.getNodeOffset() + fileLocation.getNodeLength();
        }
        DocumentRangeNode container = this.getCurrentContainer();
        Position containerRange = container.getRange();
        return containerRange.getOffset() + containerRange.getLength();
    }

    public int leave(IASTTranslationUnit tu) {
        super.leave(tu);
        assert (this.getCurrentContainer().getTypeCode() == 60);
        this.pop(this.fDocument.getLength());
        return 1;
    }

    public int visit(IASTDeclaration node) {
        boolean isTemplateDecl = this.isTemplateDecl(node);
        int startOffset = isTemplateDecl ? this.getStartOffset(node.getParent()) : this.getStartOffset((IASTNode)node);
        int endOffset = this.getEndOffset((IASTNode)node);
        if (node instanceof IASTFunctionDefinition) {
            IASTFunctionDefinition functionDef = (IASTFunctionDefinition)node;
            int nodeType = this.inClassBody() ? (isTemplateDecl ? 91 : 70) : (isTemplateDecl ? 89 : 74);
            this.push(nodeType, this.getDeclaratorName((IASTDeclarator)functionDef.getDeclarator()), startOffset);
            this.pop(endOffset);
            return 1;
        }
        if (node instanceof IASTSimpleDeclaration) {
            IASTSimpleDeclaration simpleDecl = (IASTSimpleDeclaration)node;
            IASTDeclSpecifier declSpec = simpleDecl.getDeclSpecifier();
            if (declSpec instanceof ICPPASTCompositeTypeSpecifier) {
                int nodeType;
                ICPPASTCompositeTypeSpecifier compositeTypeSpec = (ICPPASTCompositeTypeSpecifier)declSpec;
                String nodeName = this.getTypeName((IASTCompositeTypeSpecifier)compositeTypeSpec);
                switch (compositeTypeSpec.getKey()) {
                    case 1: {
                        nodeType = isTemplateDecl ? 85 : 67;
                        break;
                    }
                    case 2: {
                        nodeType = isTemplateDecl ? 87 : 69;
                        break;
                    }
                    case 3: {
                        nodeType = isTemplateDecl ? 83 : 65;
                        break;
                    }
                    default: {
                        assert (false) : "Unexpected composite type specifier";
                        return 3;
                    }
                }
                this.push(nodeType, nodeName, startOffset);
            } else if (declSpec instanceof IASTEnumerationSpecifier) {
                IASTEnumerationSpecifier enumSpecifier = (IASTEnumerationSpecifier)declSpec;
                this.push(63, this.getEnumerationName(enumSpecifier), startOffset);
            } else {
                IASTDeclarator[] declarators = simpleDecl.getDeclarators();
                int i = 0;
                while (i < declarators.length) {
                    int nodeType;
                    IASTDeclarator declarator = declarators[i];
                    int declStartOffset = declarators.length == 1 ? startOffset : this.getStartOffset((IASTNode)declarator);
                    int declEndOffset = declarators.length == 1 ? endOffset : this.getEndOffset((IASTNode)declarator);
                    String nodeName = this.getDeclaratorName(declarator);
                    if (declSpec.getStorageClass() == 1) {
                        this.push(80, nodeName, declStartOffset);
                        this.pop(declEndOffset);
                    } else if (declarator instanceof IASTFunctionDeclarator && !this.hasNestedPointerOperators(declarator)) {
                        nodeType = this.inClassBody() ? (isTemplateDecl ? 90 : 71) : (isTemplateDecl ? 88 : 73);
                        this.push(nodeType, nodeName, declStartOffset);
                        this.pop(declEndOffset);
                    } else if (declarator != null) {
                        nodeType = this.inClassBody() ? 72 : (declSpec.getStorageClass() == 2 ? 77 : (isTemplateDecl ? 92 : 76));
                        this.push(nodeType, nodeName, declStartOffset);
                        this.pop(declEndOffset);
                    }
                    ++i;
                }
            }
        } else if (!(node instanceof IASTASMDeclaration || node instanceof ICPPASTVisibilityLabel || node instanceof ICPPASTNamespaceDefinition || node instanceof ICPPASTNamespaceAlias)) {
            if (node instanceof ICPPASTUsingDeclaration) {
                ICPPASTUsingDeclaration usingDecl = (ICPPASTUsingDeclaration)node;
                this.push(62, ASTStringUtil.getQualifiedName((IASTName)usingDecl.getName()), startOffset);
                this.pop(endOffset);
            } else if (node instanceof ICPPASTUsingDirective) {
                ICPPASTUsingDirective usingDirective = (ICPPASTUsingDirective)node;
                this.push(62, ASTStringUtil.getQualifiedName((IASTName)usingDirective.getQualifiedName()), startOffset);
                this.pop(endOffset);
            } else if (!(node instanceof ICPPASTLinkageSpecification || node instanceof ICPPASTTemplateDeclaration || node instanceof ICPPASTTemplateSpecialization || node instanceof ICPPASTExplicitTemplateInstantiation)) {
                boolean cfr_ignored_0 = node instanceof IASTProblemDeclaration;
            }
        }
        return super.visit(node);
    }

    public int visit(ICPPASTNamespaceDefinition namespace) {
        this.push(61, ASTStringUtil.getQualifiedName((IASTName)namespace.getName()), this.getStartOffset((IASTNode)namespace));
        return super.visit(namespace);
    }

    public int visit(IASTEnumerationSpecifier.IASTEnumerator enumerator) {
        this.push(81, ASTStringUtil.getQualifiedName((IASTName)enumerator.getName()), this.getStartOffset((IASTNode)enumerator));
        this.pop(this.getEndOffset((IASTNode)enumerator));
        return super.visit(enumerator);
    }

    public int leave(IASTDeclaration node) {
        int endOffset;
        super.leave(node);
        boolean isTemplateDecl = this.isTemplateDecl(node);
        int n = endOffset = isTemplateDecl ? this.getEndOffset(node.getParent()) : this.getEndOffset((IASTNode)node);
        if (node instanceof IASTFunctionDefinition) {
            int nodeType;
            if (this.inClassBody()) {
                nodeType = isTemplateDecl ? 91 : 70;
            } else {
                int n2 = nodeType = isTemplateDecl ? 89 : 74;
            }
            assert (this.getCurrentContainer().getTypeCode() == nodeType);
            this.pop(endOffset);
        } else if (node instanceof IASTSimpleDeclaration) {
            IASTSimpleDeclaration simpleDecl = (IASTSimpleDeclaration)node;
            IASTDeclSpecifier declSpec = simpleDecl.getDeclSpecifier();
            boolean isCompositeType = false;
            if (declSpec instanceof ICPPASTCompositeTypeSpecifier) {
                int nodeType;
                isCompositeType = true;
                ICPPASTCompositeTypeSpecifier compositeTypeSpec = (ICPPASTCompositeTypeSpecifier)declSpec;
                switch (compositeTypeSpec.getKey()) {
                    case 1: {
                        nodeType = isTemplateDecl ? 85 : 67;
                        break;
                    }
                    case 2: {
                        nodeType = isTemplateDecl ? 87 : 69;
                        break;
                    }
                    case 3: {
                        nodeType = isTemplateDecl ? 83 : 65;
                        break;
                    }
                    default: {
                        assert (false) : "Unexpected composite type specifier";
                        return 3;
                    }
                }
                assert (this.getCurrentContainer().getTypeCode() == nodeType);
                this.pop(isTemplateDecl ? endOffset : this.getEndOffset((IASTNode)declSpec));
            } else if (declSpec instanceof IASTEnumerationSpecifier) {
                isCompositeType = true;
                assert (this.getCurrentContainer().getTypeCode() == 63);
                this.pop(this.getEndOffset((IASTNode)declSpec));
            }
            if (isCompositeType) {
                IASTDeclarator[] declarators = simpleDecl.getDeclarators();
                int i = 0;
                while (i < declarators.length) {
                    int nodeType;
                    IASTDeclarator declarator = declarators[i];
                    String nodeName = this.getDeclaratorName(declarator);
                    int declStartOffset = this.getStartOffset((IASTNode)declarator);
                    int declEndOffset = this.getEndOffset((IASTNode)declarator);
                    if (declSpec.getStorageClass() == 1) {
                        this.push(80, nodeName, declStartOffset);
                        this.pop(declEndOffset);
                    } else if (declarator instanceof IASTFunctionDeclarator && !this.hasNestedPointerOperators(declarator)) {
                        nodeType = this.inClassBody() ? (isTemplateDecl ? 90 : 71) : (isTemplateDecl ? 88 : 73);
                        this.push(nodeType, nodeName, declStartOffset);
                        this.pop(declEndOffset);
                    } else if (declarator != null) {
                        nodeType = this.inClassBody() ? 72 : (declSpec.getStorageClass() == 2 ? 77 : (isTemplateDecl ? 92 : 76));
                        this.push(nodeType, nodeName, declStartOffset);
                        this.pop(declEndOffset);
                    }
                    ++i;
                }
            }
        } else if (!(node instanceof IASTASMDeclaration || node instanceof ICPPASTVisibilityLabel || node instanceof ICPPASTNamespaceDefinition || node instanceof ICPPASTNamespaceAlias || node instanceof ICPPASTUsingDeclaration || node instanceof ICPPASTUsingDirective || node instanceof ICPPASTLinkageSpecification || node instanceof ICPPASTTemplateDeclaration || node instanceof ICPPASTTemplateSpecialization || node instanceof ICPPASTExplicitTemplateInstantiation)) {
            boolean cfr_ignored_0 = node instanceof IASTProblemDeclaration;
        }
        return 3;
    }

    public int leave(ICPPASTNamespaceDefinition namespace) {
        assert (this.getCurrentContainer().getTypeCode() == 61);
        this.pop(this.getEndOffset((IASTNode)namespace));
        return super.leave(namespace);
    }

    private DocumentRangeNode getCurrentContainer() {
        return this.fStack.peek();
    }

    private void push(int type, String name, int declarationStart) {
        if (name.length() == 0) {
            name = ANONYMOUS_NAME;
        }
        this.fStack.push(new CNode(this.getCurrentContainer(), type, name, declarationStart, 0));
    }

    private void pop(int declarationEnd) {
        DocumentRangeNode current = this.getCurrentContainer();
        current.setAppendPosition(declarationEnd);
        current.setLength(declarationEnd - current.getRange().getOffset());
        this.fStack.pop();
    }

    private boolean inClassBody() {
        int typeCode = this.getCurrentContainer().getTypeCode();
        return typeCode == 65 || typeCode == 83 || typeCode == 67 || typeCode == 85 || typeCode == 69 || typeCode == 87;
    }

    private boolean isTemplateDecl(IASTDeclaration node) {
        return node.getParent() instanceof ICPPASTTemplateDeclaration;
    }

    private boolean hasNestedPointerOperators(IASTDeclarator declarator) {
        declarator = declarator.getNestedDeclarator();
        while (declarator != null) {
            if (declarator.getPointerOperators().length > 0) {
                return true;
            }
            declarator = declarator.getNestedDeclarator();
        }
        return false;
    }

    private String getEnumerationName(IASTEnumerationSpecifier enumSpecifier) {
        String nodeName = ASTStringUtil.getQualifiedName((IASTName)enumSpecifier.getName());
        if (nodeName.length() == 0) {
            nodeName = ANONYMOUS_NAME;
        }
        return nodeName;
    }

    private String getTypeName(IASTCompositeTypeSpecifier compositeTypeSpec) {
        String nodeName = ASTStringUtil.getQualifiedName((IASTName)compositeTypeSpec.getName());
        if (nodeName.length() == 0) {
            nodeName = ANONYMOUS_NAME;
        }
        return nodeName;
    }

    private String getDeclaratorName(IASTDeclarator node) {
        IASTName name = (node = this.getInnermostDeclarator(node)).getName();
        String nodeName = ASTStringUtil.getQualifiedName((IASTName)name);
        if (nodeName.length() == 0) {
            nodeName = ANONYMOUS_NAME;
        }
        return nodeName;
    }

    private IASTDeclarator getInnermostDeclarator(IASTDeclarator node) {
        IASTDeclarator nested = node.getNestedDeclarator();
        while (nested != null) {
            node = nested;
            nested = node.getNestedDeclarator();
        }
        return node;
    }

    private static IASTFileLocation getMaxFileLocation(IASTNodeLocation[] locations) {
        if (locations == null || locations.length == 0) {
            return null;
        }
        IASTNodeLocation nodeLocation = locations[locations.length - 1];
        return nodeLocation.asFileLocation();
    }

    private static IASTFileLocation getMinFileLocation(IASTNodeLocation[] locations) {
        if (locations == null || locations.length == 0) {
            return null;
        }
        IASTNodeLocation nodeLocation = locations[0];
        return nodeLocation.asFileLocation();
    }
}

