/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;

public class FileContentHelper {
    private static final int bufferSize = 512;

    public static String getContent(IFile file, int start) throws CoreException, IOException {
        InputStreamReader reader = FileContentHelper.getReaderForFile(file);
        FileContentHelper.skip(start, reader);
        return FileContentHelper.readRest(reader);
    }

    public static String getContent(IFile file, int start, int length) {
        try {
            InputStreamReader r = FileContentHelper.getReaderForFile(file);
            char[] bytes = new char[length];
            FileContentHelper.skip(start, r);
            FileContentHelper.read(length, r, bytes);
            return new String(bytes);
        }
        catch (IOException e) {
            CUIPlugin.log(e);
        }
        catch (CoreException e) {
            CUIPlugin.log(e);
        }
        return "";
    }

    private static InputStreamReader getReaderForFile(IFile file) throws CoreException, UnsupportedEncodingException {
        InputStream contents = file.getContents();
        InputStreamReader r = new InputStreamReader(contents, file.getCharset());
        return r;
    }

    private static String readRest(InputStreamReader reader) throws IOException {
        StringBuilder content = new StringBuilder();
        char[] buffer = new char[512];
        int bytesRead = 0;
        while ((bytesRead = reader.read(buffer)) >= 0) {
            content.append(buffer, 0, bytesRead);
        }
        return content.toString();
    }

    private static void read(int length, InputStreamReader r, char[] bytes) throws IOException {
        int bufferOffset = 0;
        int charactersRead = 0;
        while (charactersRead >= 0 && length > 0) {
            charactersRead = r.read(bytes, bufferOffset, length);
            if (charactersRead <= 0) continue;
            bufferOffset += charactersRead;
            length -= charactersRead;
        }
    }

    private static void skip(int count, InputStreamReader r) throws IOException {
        long skipped = 0L;
        while (skipped >= 0L && count > 0 && r.ready()) {
            skipped = r.skip(count);
            if (skipped <= 0L) continue;
            count = (int)((long)count - skipped);
        }
    }
}

