/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.resourcetables.model.config;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.expression.Expression;
import com.nxp.swtools.common.utils.expression.ExpressionException;
import com.nxp.swtools.common.utils.expression.FormatOptions;
import com.nxp.swtools.common.utils.expression.FunctionInvocation;
import com.nxp.swtools.common.utils.expression.IContext;
import com.nxp.swtools.common.utils.expression.IExpressionPrintable;
import com.nxp.swtools.common.utils.expression.IFunction;
import com.nxp.swtools.common.utils.expression.IResolvable;
import com.nxp.swtools.common.utils.expression.IValue;
import com.nxp.swtools.common.utils.expression.Value;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.rational.BigRational;
import com.nxp.swtools.configuration.properties.SWToolsProperties;
import com.nxp.swtools.core.service.scriptapi.db.IRegBitFieldAPI;
import com.nxp.swtools.core.service.scriptapi.db.IRegParentPeripheralAPI;
import com.nxp.swtools.core.service.scriptapi.db.IRegisterAPI;
import com.nxp.swtools.core.service.scriptapi.db.IRegistersDatabaseAPI;
import com.nxp.swtools.expert.processor.properties.PackageProperties;
import com.nxp.swtools.kex.selector.IMcuIdentification;
import com.nxp.swtools.resourcetables.model.config.ArrayConfig;
import com.nxp.swtools.resourcetables.model.config.ChildContext;
import com.nxp.swtools.resourcetables.model.config.ChildProviderHelper;
import com.nxp.swtools.resourcetables.model.config.EmptyRoot;
import com.nxp.swtools.resourcetables.model.config.ExpressionFunctions;
import com.nxp.swtools.resourcetables.model.config.ExpressionFunctionsUtils;
import com.nxp.swtools.resourcetables.model.config.IChild;
import com.nxp.swtools.resourcetables.model.config.IComponentConfig;
import com.nxp.swtools.resourcetables.model.config.IFunctionalGroup;
import com.nxp.swtools.resourcetables.model.config.ISettingConfig;
import com.nxp.swtools.resourcetables.model.config.PeripheralExpressionException;
import com.nxp.swtools.resourcetables.model.config.RegistersModelSingleton;
import com.nxp.swtools.resourcetables.model.data.ConfigurationComponentTypeId;
import com.nxp.swtools.resourcetables.model.data.FunctionDef;
import com.nxp.swtools.resourcetables.model.data.IConfigurationComponent;
import com.nxp.swtools.resourcetables.model.data.UserFunctions;
import com.nxp.swtools.resourcetables.model.mcu.EmptyCommonMcu;
import com.nxp.swtools.resourcetables.model.mcu.ICommonMcu;
import com.nxp.swtools.utils.profiler.Profiler;
import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import java.util.logging.Logger;
import java.util.stream.IntStream;

public class ExpressionContext
implements IContext {
    private static final String FUNCTION_REQUIRES_LAMBDA = "[DATA] Function requires lambda function format";
    private static final Logger LOGGER = LogManager.getLogger(ExpressionContext.class);
    public final ChildContext childContext;
    private final ICommonMcu mcu;
    @Nullable
    private ExpressionException exception;
    private Set<Integer> invalidArguments = Collections.emptySet();

    public ExpressionContext(ChildContext childContext, ICommonMcu mcu) {
        this.childContext = childContext;
        this.mcu = mcu;
    }

    public static ExpressionContext getEmpty() {
        EmptyCommonMcu mcuLoc = new EmptyCommonMcu();
        return new ExpressionContext(new EmptyRoot(mcuLoc).getChildContext(), mcuLoc);
    }

    public long getBitFieldValue(String registerName, String bitFieldName) throws IllegalArgumentException {
        IFunctionalGroup functionalGroup = this.childContext.getFunctionalGroup();
        if (functionalGroup == null) {
            throw new IllegalArgumentException("Functional group is null");
        }
        BigInteger valueOfBitField = RegistersModelSingleton.getInstance().getValueOfBitField(functionalGroup, registerName, bitFieldName);
        if (valueOfBitField == null) {
            String[] split = registerName.split("::");
            if (split.length != 2) {
                throw new IllegalArgumentException("Name of register is not in format PERIPHERAL::REGISTER");
            }
            return RegistersModelSingleton.getResetValueOfBitfieldInternal(this.mcu, split[0], split[1], bitFieldName).longValue();
        }
        return valueOfBitField.longValue();
    }

    public Object getSettingValue(String settingName) throws IllegalArgumentException {
        Object propertyValue = PackageProperties.getProperty((String)settingName, (IMcuIdentification)this.mcu.getMcuIdentification());
        if (propertyValue != null) {
            return propertyValue;
        }
        IChild child = ChildProviderHelper.getChild(this.childContext, settingName);
        if (child != null) {
            return child;
        }
        throw new IllegalArgumentException("Value of: " + settingName + " not found");
    }

    public int getBitFiledWidth(String registerName, String bitFieldName) {
        String[] parts = registerName.split("::");
        IRegistersDatabaseAPI registersDb = this.mcu.getRegistersDb();
        if (registersDb == null) {
            throw new IllegalArgumentException("Register database is null");
        }
        IRegParentPeripheralAPI peripheral = ExpressionFunctions.getPeripheral(registersDb, parts[0]);
        IRegisterAPI register = ExpressionFunctions.getRegister(peripheral, parts[1]);
        IRegBitFieldAPI bitfield = ExpressionFunctions.getBitfield(register, bitFieldName);
        return bitfield.getWidth();
    }

    public String getBitFieldId(String registerName, String bitFieldName) {
        throw new UnsupportedOperationException("Bit-fields not supported");
    }

    public String getSettingId(String settingName) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    private @Nullable IConfigurationComponent determineFunctionComponent(FunctionInvocation function) {
        IConfigurationComponent currentComp;
        String compType = function.getLocation();
        IComponentConfig config = this.childContext.getComponentConfig();
        IConfigurationComponent iConfigurationComponent = currentComp = config != null ? config.getComponent() : null;
        if (compType.isEmpty()) {
            return currentComp;
        }
        if (currentComp != null && compType.equalsIgnoreCase(currentComp.getId())) {
            return currentComp;
        }
        ConfigurationComponentTypeId activeComponentOfTheType = this.childContext.getRoot().getActiveComponentTypeIdByType(compType);
        if (activeComponentOfTheType != null) {
            return activeComponentOfTheType.getConfigurationComponent();
        }
        List<ConfigurationComponentTypeId> typeIds = this.childContext.getRoot().getAvailableComponentTypeIdsByType(compType);
        if (typeIds == null || typeIds.isEmpty()) {
            ExpressionFunctionsUtils.throwSevere("Unknown function: " + function.getName() + ", at location: " + compType, ExpressionContext.class, function);
            return null;
        }
        assert (typeIds.size() == 1) : "There can be only one component of the given type " + compType;
        IConfigurationComponent result = typeIds.get(0).getConfigurationComponent();
        if (SWToolsProperties.isVerificationOn() && !result.getComponents().isEmpty()) {
            LOGGER.severe("[DATA] Function " + function.getName() + ", referencing non-global component: " + compType + "cannot be resolved for: " + currentComp);
        }
        return result;
    }

    private static @Nullable FunctionDef findFunction(FunctionInvocation func, IContext argContext, @Nullable UserFunctions userFuncs) {
        if (userFuncs != null) {
            for (FunctionDef def : userFuncs.getFunctionDefs()) {
                if (!def.getId().equals(func.getName())) continue;
                Expression funcBody = def.getTextExpr();
                if (funcBody != null) {
                    IValue resolvedExpression = funcBody.resolve(argContext);
                    try {
                        IFunction functionReference = resolvedExpression.getFunctionReference();
                        if (func.getArgNum() != functionReference.getArgNum()) {
                            continue;
                        }
                    }
                    catch (ExpressionException expressionException) {
                        ExpressionFunctionsUtils.throwSevere(FUNCTION_REQUIRES_LAMBDA, ExpressionContext.class, func);
                        return null;
                    }
                }
                return def;
            }
        }
        return null;
    }

    public IValue resolveFunction(FunctionInvocation function, IContext argContext) {
        FunctionDef def;
        IConfigurationComponent funcComp = this.determineFunctionComponent(function);
        Profiler profiler = Profiler.getInstance((Object)"Peripherals");
        if (funcComp != null && (def = ExpressionContext.findFunction(function, argContext, funcComp.getUserFunctions())) != null) {
            IFunction functionReference;
            Expression expression = def.getTextExpr();
            if (expression == null) {
                throw new IllegalStateException("Expression with code: " + def.getText() + " cannot be parsed.");
            }
            Object[] resolvedArgs = new Object[function.getArgNum()];
            int i = 0;
            while (i < resolvedArgs.length) {
                resolvedArgs[i] = function.getArgument(i).resolve(argContext).getValue();
                ++i;
            }
            try {
                functionReference = expression.resolve((IContext)this).getFunctionReference();
            }
            catch (ExpressionException e) {
                LOGGER.severe(FUNCTION_REQUIRES_LAMBDA);
                throw e;
            }
            String profilerMessage = "";
            if (profiler.isEnabled()) {
                StringJoiner joiner = new StringJoiner(", ", MessageFormat.format("User function {0}(", def.getId()), MessageFormat.format(") called in {0}", this.childContext.getCurrent().getId()));
                int i2 = 0;
                while (i2 < function.getArgNum()) {
                    joiner.add(function.getArgument(i2).formatOutput(FormatOptions.DEFAULT, (IExpressionPrintable)function));
                    ++i2;
                }
                profilerMessage = joiner.toString();
            }
            BigInteger index = profiler.start(ExpressionContext.class, (Object)profilerMessage);
            IValue result = functionReference.invokeOn(argContext, resolvedArgs);
            profiler.stop(index, ExpressionContext.class, null);
            return result;
        }
        ExpressionFunctions expressionFunction = new ExpressionFunctions(function, argContext, this.childContext, this.mcu);
        String profilerMessage = "";
        if (profiler.isEnabled()) {
            StringJoiner joiner = new StringJoiner(", ", MessageFormat.format("Expression function {0}(", function.getName()), MessageFormat.format(") called in {0}", this.childContext.getCurrent().getId()));
            int i = 0;
            while (i < function.getArgNum()) {
                joiner.add(function.getArgument(i).formatOutput(FormatOptions.DEFAULT, (IExpressionPrintable)function));
                ++i;
            }
            profilerMessage = joiner.toString();
        }
        BigInteger profilerIndex = profiler.start(ExpressionContext.class, (Object)profilerMessage);
        try {
            switch (function.getName()) {
                case "featureDefined": {
                    ExpressionContext.checkNumberOfArgs(function, 1);
                    String feature = function.getArgument(0).resolve(argContext).getString();
                    IValue iValue = expressionFunction.featureDefined(feature);
                    return iValue;
                }
                case "peripheralFeatureDefined": {
                    ExpressionContext.checkNumberOfArgs(function, 2);
                    String feature = function.getArgument(0).resolve(argContext).getString();
                    String peripheral = function.getArgument(1).resolve(argContext).getString();
                    IValue iValue = expressionFunction.peripheralFeatureDefined(feature, peripheral);
                    return iValue;
                }
                case "getFeature": {
                    ExpressionContext.checkNumberOfArgs(function, 1, 2);
                    String feature = function.getArgument(0).resolve(argContext).getString();
                    IResolvable defaultValue = null;
                    if (function.getArgNum() == 2) {
                        defaultValue = function.getArgument(1);
                    }
                    IValue iValue = expressionFunction.getFeature(feature, defaultValue);
                    return iValue;
                }
                case "getPeripheralFeature": {
                    ExpressionContext.checkNumberOfArgs(function, 2, 3);
                    String feature = function.getArgument(0).resolve(argContext).getString();
                    String peripheral = function.getArgument(1).resolve(argContext).getString();
                    IResolvable defaultValue = null;
                    if (function.getArgNum() == 3) {
                        defaultValue = function.getArgument(2);
                    }
                    IValue iValue = expressionFunction.getPeripheralFeature(feature, peripheral, defaultValue);
                    return iValue;
                }
                case "hasOption": {
                    ExpressionContext.checkNumberOfArgs(function, 2);
                    IChild settingConfig = ExpressionContext.getChildFromArgAtIndex(function, argContext, 0);
                    String optionName = function.getArgument(1).resolve(argContext).getString();
                    IValue iValue = expressionFunction.hasOption(settingConfig, optionName);
                    return iValue;
                }
                case "getOptionValue": 
                case "optionValue": {
                    ExpressionContext.checkNumberOfArgs(function, 2, 3);
                    IChild settingConfig = ExpressionContext.getChildFromArgAtIndex(function, argContext, 0);
                    String optionName = function.getArgument(1).resolve(argContext).getString();
                    IResolvable defaultValue = null;
                    if (function.getArgNum() == 3) {
                        defaultValue = function.getArgument(2);
                    }
                    IValue iValue = expressionFunction.getOptionValue(settingConfig, optionName, defaultValue);
                    return iValue;
                }
                case "value": 
                case "getValue": {
                    ExpressionContext.checkNumberOfArgs(function, 1, 2);
                    IResolvable defaultValue = null;
                    Object node = function.getArgument(0).resolve(argContext).getValue();
                    if (function.getArgNum() == 2) {
                        defaultValue = function.getArgument(1);
                    }
                    IValue iValue = expressionFunction.value(node, defaultValue);
                    return iValue;
                }
                case "getUserEnteredValue": {
                    ExpressionContext.checkNumberOfArgs(function, 1);
                    Object node = function.getArgument(0).resolve(argContext).getValue();
                    IValue iValue = expressionFunction.getUserEnteredValue(node);
                    return iValue;
                }
                case "getDescription": {
                    ExpressionContext.checkNumberOfArgs(function, 1, 2);
                    Object node = function.getArgument(0).resolve(argContext).getValue();
                    IResolvable defaultDescription = null;
                    if (function.getArgNum() == 2) {
                        defaultDescription = function.getArgument(1);
                    }
                    IValue iValue = expressionFunction.getDescription(node, defaultDescription);
                    return iValue;
                }
                case "getLabel": {
                    ExpressionContext.checkNumberOfArgs(function, 1);
                    Object node = function.getArgument(0).resolve(argContext).getValue();
                    IValue iValue = expressionFunction.getLabel(node);
                    return iValue;
                }
                case "getValueDescription": {
                    ExpressionContext.checkNumberOfArgs(function, 1);
                    IChild child = ExpressionContext.getChildFromArgAtIndex(function, argContext, 0);
                    IValue iValue = expressionFunction.getValueDescription(child);
                    return iValue;
                }
                case "getID": 
                case "getId": {
                    ExpressionContext.checkNumberOfArgs(function, 1);
                    Object node = function.getArgument(0).resolve(argContext).getValue();
                    IValue iValue = expressionFunction.getID(node);
                    return iValue;
                }
                case "getFullID": 
                case "getFullId": {
                    ExpressionContext.checkNumberOfArgs(function, 1);
                    Object node = function.getArgument(0).resolve(argContext).getValue();
                    IValue iValue = expressionFunction.getFullID(node);
                    return iValue;
                }
                case "getPeripheral": {
                    ExpressionContext.checkNumberOfArgs(function, 1);
                    IChild child = ExpressionContext.getChildFromArgAtIndex(function, argContext, 0);
                    IValue iValue = expressionFunction.getPeripheral(child);
                    return iValue;
                }
                case "getMode": {
                    ExpressionContext.checkNumberOfArgs(function, 1);
                    IChild child = ExpressionContext.getChildFromArgAtIndex(function, argContext, 0);
                    IValue iValue = expressionFunction.getMode(child);
                    return iValue;
                }
                case "getFnGroupName": {
                    ExpressionContext.checkNumberOfArgs(function, 1);
                    IChild child = ExpressionContext.getChildFromArgAtIndex(function, argContext, 0);
                    IValue iValue = expressionFunction.getFnGroupName(child);
                    return iValue;
                }
                case "getFnGroupPrefix": {
                    ExpressionContext.checkNumberOfArgs(function, 1);
                    IChild child = ExpressionContext.getChildFromArgAtIndex(function, argContext, 0);
                    IValue iValue = expressionFunction.getFnGroupPrefix(child);
                    return iValue;
                }
                case "isCalledFromDefaultInit": {
                    ExpressionContext.checkNumberOfArgs(function, 1);
                    IChild child = ExpressionContext.getChildFromArgAtIndex(function, argContext, 0);
                    IValue iValue = expressionFunction.isCalledFromDefaultInit(child);
                    return iValue;
                }
                case "getType": {
                    ExpressionContext.checkNumberOfArgs(function, 1);
                    IChild child = ExpressionContext.getChildFromArgAtIndex(function, argContext, 0);
                    IValue iValue = expressionFunction.getType(child);
                    return iValue;
                }
                case "getTypeOfValue": {
                    ExpressionContext.checkNumberOfArgs(function, 1);
                    IValue resolvedValue = function.getArgument(0).resolve(argContext);
                    IValue iValue = expressionFunction.getTypeOfValue(resolvedValue);
                    return iValue;
                }
                case "getCValue": {
                    ExpressionContext.checkNumberOfArgs(function, 1, 2);
                    IResolvable defaultValue = null;
                    IChild child = ExpressionContext.getChildFromArgAtIndex(function, argContext, 0);
                    if (function.getArgNum() == 2) {
                        defaultValue = function.getArgument(1);
                    }
                    IValue iValue = expressionFunction.getCValue(child, defaultValue);
                    return iValue;
                }
                case "isAvailable": {
                    ExpressionContext.checkNumberOfArgs(function, 1);
                    Object resolvedArg = function.getArgument(0).resolve(argContext).getValue();
                    IValue iValue = expressionFunction.isAvailable(resolvedArg);
                    return iValue;
                }
                case "isEnabled": {
                    ExpressionContext.checkNumberOfArgs(function, 1);
                    Object resolvedArg = function.getArgument(0).resolve(argContext).getValue();
                    IValue iValue = expressionFunction.isEnabled(resolvedArg);
                    return iValue;
                }
                case "isCIdentifier": {
                    ExpressionContext.checkNumberOfArgs(function, 1);
                    String name = function.getArgument(0).resolve(argContext).getString();
                    IValue iValue = expressionFunction.isCIdentifier(name);
                    return iValue;
                }
                case "length": 
                case "getSize": 
                case "size": 
                case "getLength": {
                    IValue resultSize;
                    ExpressionContext.checkNumberOfArgs(function, 1);
                    IValue value = function.getArgument(0).resolve(argContext);
                    if (value.getType().equals((Object)IValue.Type.STRING)) {
                        resultSize = expressionFunction.size(value.getString());
                    } else {
                        List<?> array = ExpressionFunctions.listAdapter(function, 0, argContext);
                        resultSize = expressionFunction.size(array);
                    }
                    IValue iValue = resultSize;
                    return iValue;
                }
                case "leftPadding": {
                    ExpressionContext.checkNumberOfArgs(function, 2);
                    String text = function.getArgument(0).resolve(argContext).getString();
                    long level = function.getArgument(1).resolve(argContext).getLong();
                    IValue iValue = expressionFunction.leftPadding(text, level);
                    return iValue;
                }
                case "toLowerCase": {
                    ExpressionContext.checkNumberOfArgs(function, 1);
                    String text = function.getArgument(0).resolve(argContext).getString();
                    IValue iValue = expressionFunction.toLowerCase(text);
                    return iValue;
                }
                case "toUpperCase": {
                    ExpressionContext.checkNumberOfArgs(function, 1);
                    String text = function.getArgument(0).resolve(argContext).getString();
                    IValue iValue = expressionFunction.toUpperCase(text);
                    return iValue;
                }
                case "getPeripheralSignals": {
                    ExpressionContext.checkNumberOfArgs(function, 1);
                    String peripheral = function.getArgument(0).resolve(argContext).getString();
                    IValue iValue = expressionFunction.getPeripheralSignals(peripheral);
                    return iValue;
                }
                case "extractSignalID": 
                case "extractSignalId": {
                    ExpressionContext.checkNumberOfArgs(function, 1);
                    String signal = function.getArgument(0).resolve(argContext).getString();
                    IValue iValue = expressionFunction.extractSignalId(signal);
                    return iValue;
                }
                case "extractChannelID": 
                case "extractChannelId": {
                    ExpressionContext.checkNumberOfArgs(function, 1);
                    String channel = function.getArgument(0).resolve(argContext).getString();
                    IValue iValue = expressionFunction.extractChannelId(channel);
                    return iValue;
                }
                case "regexSubstr": {
                    ExpressionContext.checkNumberOfArgs(function, 3);
                    String text = function.getArgument(0).resolve(argContext).getString();
                    String regex = function.getArgument(1).resolve(argContext).getString();
                    int groupIndex = (int)function.getArgument(2).resolve(argContext).getLong();
                    IValue iValue = expressionFunction.regexSubstr(text, regex, groupIndex);
                    return iValue;
                }
                case "regexMatch": {
                    ExpressionContext.checkNumberOfArgs(function, 2);
                    String text = function.getArgument(0).resolve(argContext).getString();
                    String regex = function.getArgument(1).resolve(argContext).getString();
                    IValue iValue = expressionFunction.regexMatch(text, regex);
                    return iValue;
                }
                case "contains": {
                    ExpressionContext.checkNumberOfArgs(function, 2);
                    String text = function.getArgument(0).resolve(argContext).getString();
                    String searchFor = function.getArgument(1).resolve(argContext).getString();
                    IValue iValue = expressionFunction.contains(text, searchFor);
                    return iValue;
                }
                case "queryFeature": {
                    ExpressionContext.checkNumberOfArgs(function, 3);
                    String resType = function.getArgument(0).resolve(argContext).getString();
                    String resId = function.getArgument(1).resolve(argContext).getString();
                    String featureName = function.getArgument(2).resolve(argContext).getString();
                    IValue iValue = expressionFunction.queryFeature(resType, resId, featureName);
                    return iValue;
                }
                case "queryFeatureAdvanced": {
                    ExpressionContext.checkNumberOfArgs(function, 3, 5);
                    String resType = function.getArgument(0).resolve(argContext).getString();
                    String resId = function.getArgument(1).resolve(argContext).getString();
                    String featureName = function.getArgument(2).resolve(argContext).getString();
                    boolean defaultFuncGroup = false;
                    String functionalGroup = null;
                    if (function.getArgNum() > 3) {
                        defaultFuncGroup = function.getArgument(3).resolve(argContext).getBoolean();
                    }
                    if (function.getArgNum() > 4) {
                        functionalGroup = function.getArgument(4).resolve(argContext).getString();
                    }
                    IValue iValue = expressionFunction.queryFeatureAdvanced(resType, resId, featureName, defaultFuncGroup, functionalGroup);
                    return iValue;
                }
                case "filter": {
                    ExpressionContext.checkNumberOfArgs(function, 2, 3);
                    List<?> array = ExpressionFunctions.listAdapter(function, 0, argContext);
                    IFunction condExpr = this.getLambdaFunction(function, argContext, 1);
                    if (condExpr == null) {
                        IValue iValue = this.throwLambdaFunctionArgumentException(function);
                        return iValue;
                    }
                    boolean recursive = function.getArgNum() == 2 ? false : function.getArgument(2).resolve(argContext).getBoolean();
                    IValue iValue = expressionFunction.filter(array, condExpr, recursive);
                    return iValue;
                }
                case "enumItemsOf": {
                    ExpressionContext.checkNumberOfArgs(function, 1);
                    Object enumConfig = function.getArgument(0).resolve(argContext).getValue();
                    IValue iValue = expressionFunction.enumItemsOf(enumConfig);
                    return iValue;
                }
                case "getResource": {
                    ExpressionContext.checkNumberOfArgs(function, 2, 3);
                    String tableId = function.getArgument(0).resolve(argContext).getString();
                    String definitionId = function.getArgument(1).resolve(argContext).getString();
                    if (function.getArgNum() == 2) {
                        IValue iValue = expressionFunction.getResource(tableId, definitionId);
                        return iValue;
                    }
                    String component = function.getArgument(2).resolve(argContext).getString();
                    IValue iValue = expressionFunction.getResource(tableId, definitionId, component);
                    return iValue;
                }
                case "hasResource": {
                    ExpressionContext.checkNumberOfArgs(function, 2, 3);
                    String tableId = function.getArgument(0).resolve(argContext).getString();
                    String definitionId = function.getArgument(1).resolve(argContext).getString();
                    if (function.getArgNum() == 2) {
                        IValue iValue = expressionFunction.hasResource(tableId, definitionId);
                        return iValue;
                    }
                    String component = function.getArgument(2).resolve(argContext).getString();
                    IValue iValue = expressionFunction.hasResource(tableId, definitionId, component);
                    return iValue;
                }
                case "arrayToEnumItems": {
                    ExpressionContext.checkNumberOfArgs(function, 5, 7);
                    IFunction descriptionExpr = null;
                    IFunction enableExpr = null;
                    List<?> array = ExpressionFunctions.listAdapter(function, 0, argContext);
                    IFunction filterExpr = this.getLambdaFunction(function, argContext, 1);
                    IFunction idSelectExpr = this.getLambdaFunction(function, argContext, 2);
                    IFunction labelSelectExpr = this.getLambdaFunction(function, argContext, 3);
                    IFunction valueSelectExpr = this.getLambdaFunction(function, argContext, 4);
                    int argNumber = function.getArgNum();
                    if (argNumber >= 6) {
                        descriptionExpr = this.getLambdaFunction(function, argContext, 5);
                        if (argNumber == 7) {
                            enableExpr = this.getLambdaFunction(function, argContext, 6);
                        }
                    }
                    if (filterExpr == null || idSelectExpr == null || labelSelectExpr == null || valueSelectExpr == null) {
                        IValue iValue = this.throwLambdaFunctionArgumentException(function);
                        return iValue;
                    }
                    IValue iValue = expressionFunction.arrayToEnumItems(array, filterExpr, idSelectExpr, labelSelectExpr, valueSelectExpr, descriptionExpr, enableExpr);
                    return iValue;
                }
                case "searchInArray": {
                    ExpressionContext.checkNumberOfArgs(function, 2);
                    List<?> array = ExpressionFunctions.listAdapter(function, 0, argContext);
                    IFunction condExpr = this.getLambdaFunction(function, argContext, 1);
                    if (condExpr == null) {
                        IValue iValue = this.throwLambdaFunctionArgumentException(function);
                        return iValue;
                    }
                    IValue iValue = expressionFunction.searchInArray(array, condExpr);
                    return iValue;
                }
                case "getParent": {
                    ExpressionContext.checkNumberOfArgs(function, 1);
                    Object child = function.getArgument(0).resolve(argContext).getValue();
                    IValue iValue = expressionFunction.getParent(child);
                    return iValue;
                }
                case "getSetting": {
                    ExpressionContext.checkNumberOfArgs(function, 2);
                    Object child = function.getArgument(0).resolve(argContext).getValue();
                    String id = function.getArgument(1).resolve(argContext).getString();
                    IValue iValue = expressionFunction.getSetting(child, id);
                    return iValue;
                }
                case "getCoreID": 
                case "getCoreId": {
                    ExpressionContext.checkNumberOfArgs(function, 1);
                    IChild child = ExpressionContext.getChildFromArgAtIndex(function, argContext, 0);
                    IValue iValue = expressionFunction.getCoreId(child);
                    return iValue;
                }
                case "getPeriphInstanceIndex": {
                    ExpressionContext.checkNumberOfArgs(function, 1);
                    String name = function.getArgument(0).resolve(argContext).getString();
                    IValue iValue = expressionFunction.getPeriphInstanceIndex(name);
                    return iValue;
                }
                case "getPeripheralType": {
                    ExpressionContext.checkNumberOfArgs(function, 1);
                    String name = function.getArgument(0).resolve(argContext).getString();
                    IValue iValue = expressionFunction.getPeripheralType(name);
                    return iValue;
                }
                case "allDifferent": {
                    ExpressionContext.checkNumberOfArgs(function, 1);
                    List<?> array = ExpressionFunctions.listAdapter(function, 0, argContext);
                    IValue iValue = expressionFunction.allDifferent(array);
                    return iValue;
                }
                case "forEachChildTrue": 
                case "allMatch": {
                    ExpressionContext.checkNumberOfArgs(function, 2);
                    List<?> array = ExpressionFunctions.listAdapter(function, 0, argContext);
                    IFunction condExpr = this.getLambdaFunction(function, argContext, 1);
                    if (condExpr == null) {
                        IValue iValue = this.throwLambdaFunctionArgumentException(function);
                        return iValue;
                    }
                    IValue iValue = expressionFunction.allMatch(array, condExpr);
                    return iValue;
                }
                case "anyMatch": {
                    ExpressionContext.checkNumberOfArgs(function, 2);
                    List<?> array = ExpressionFunctions.listAdapter(function, 0, argContext);
                    IFunction condExpr = this.getLambdaFunction(function, argContext, 1);
                    if (condExpr == null) {
                        IValue iValue = this.throwLambdaFunctionArgumentException(function);
                        return iValue;
                    }
                    IValue iValue = expressionFunction.anyMatch(array, condExpr);
                    return iValue;
                }
                case "noneMatch": {
                    ExpressionContext.checkNumberOfArgs(function, 2);
                    List<?> array = ExpressionFunctions.listAdapter(function, 0, argContext);
                    IFunction condExpr = this.getLambdaFunction(function, argContext, 1);
                    if (condExpr == null) {
                        IValue iValue = this.throwLambdaFunctionArgumentException(function);
                        return iValue;
                    }
                    IValue iValue = expressionFunction.noneMatch(array, condExpr);
                    return iValue;
                }
                case "map": {
                    ExpressionContext.checkNumberOfArgs(function, 2);
                    List<?> array = ExpressionFunctions.listAdapter(function, 0, argContext);
                    IFunction funcExpr = this.getLambdaFunction(function, argContext, 1);
                    if (funcExpr == null) {
                        IValue iValue = this.throwLambdaFunctionArgumentException(function);
                        return iValue;
                    }
                    IValue iValue = expressionFunction.map(array, funcExpr);
                    return iValue;
                }
                case "flatMap": {
                    ExpressionContext.checkNumberOfArgs(function, 2);
                    List<?> array = ExpressionFunctions.listAdapter(function, 0, argContext);
                    IFunction funcExpr = this.getLambdaFunction(function, argContext, 1);
                    if (funcExpr == null) {
                        IValue iValue = this.throwLambdaFunctionArgumentException(function);
                        return iValue;
                    }
                    IValue iValue = expressionFunction.flatMap(array, funcExpr);
                    return iValue;
                }
                case "reduce": {
                    ExpressionContext.checkNumberOfArgs(function, 3);
                    List<?> array = ExpressionFunctions.listAdapter(function, 0, argContext);
                    Object identity = function.getArgument(1).resolve(argContext).getValue();
                    IFunction funcExpr = this.getLambdaFunction(function, argContext, 2);
                    if (funcExpr == null) {
                        IValue iValue = this.throwLambdaFunctionArgumentException(function);
                        return iValue;
                    }
                    IValue iValue = expressionFunction.reduce(array, identity, funcExpr);
                    return iValue;
                }
                case "removeDuplicates": {
                    ExpressionContext.checkNumberOfArgs(function, 2);
                    List<?> array = ExpressionFunctions.listAdapter(function, 0, argContext);
                    IFunction keyExpr = this.getLambdaFunction(function, argContext, 1);
                    if (keyExpr == null) {
                        IValue iValue = this.throwLambdaFunctionArgumentException(function);
                        return iValue;
                    }
                    IValue iValue = expressionFunction.removeDuplicates(array, keyExpr);
                    return iValue;
                }
                case "findFirst": {
                    ExpressionContext.checkNumberOfArgs(function, 2, 3);
                    List<?> array = ExpressionFunctions.listAdapter(function, 0, argContext);
                    IFunction condExpr = this.getLambdaFunction(function, argContext, 1);
                    if (condExpr == null) {
                        IValue iValue = this.throwLambdaFunctionArgumentException(function);
                        return iValue;
                    }
                    if (function.getArgNum() == 3) {
                        IResolvable defaultValue = function.getArgument(2);
                        IValue iValue = expressionFunction.findFirst(array, condExpr, defaultValue);
                        return iValue;
                    }
                    IValue iValue = expressionFunction.findFirst(array, condExpr);
                    return iValue;
                }
                case "get": {
                    ExpressionContext.checkNumberOfArgs(function, 2, 3);
                    List<?> array = ExpressionFunctions.listAdapter(function, 0, argContext);
                    long index = function.getArgument(1).resolve(argContext).getLong();
                    IResolvable defaultValue = null;
                    if (function.getArgNum() == 3) {
                        defaultValue = function.getArgument(2);
                    }
                    IValue iValue = expressionFunction.get(array, index, defaultValue);
                    return iValue;
                }
                case "getFirst": {
                    ExpressionContext.checkNumberOfArgs(function, 1);
                    List<?> array = ExpressionFunctions.listAdapter(function, 0, argContext);
                    IValue iValue = expressionFunction.getFirst(array);
                    return iValue;
                }
                case "getLast": {
                    ExpressionContext.checkNumberOfArgs(function, 1);
                    List<?> array = ExpressionFunctions.listAdapter(function, 0, argContext);
                    IValue iValue = expressionFunction.getLast(array);
                    return iValue;
                }
                case "isPeripheralUsed": {
                    ExpressionContext.checkNumberOfArgs(function, 2);
                    IChild child = ExpressionContext.getChildFromArgAtIndex(function, argContext, 0);
                    String name = function.getArgument(1).resolve(argContext).getString();
                    IValue iValue = expressionFunction.isPeripheralUsed(child, name);
                    return iValue;
                }
                case "toInt": {
                    ExpressionContext.checkNumberOfArgs(function, 1);
                    IValue arg0 = function.getArgument(0).resolve(argContext);
                    if (arg0.getType() == IValue.Type.BIG_RATIONAL) {
                        BigRational rational = arg0.getRational();
                        IValue iValue = expressionFunction.toInt(rational);
                        return iValue;
                    }
                    String text = arg0.getString();
                    IValue iValue = expressionFunction.toInt(text);
                    return iValue;
                }
                case "toString": {
                    ExpressionContext.checkNumberOfArgsEx(function, 1, 2);
                    if (function.getArgNum() == 1) {
                        Object firstArg = function.getArgument(0).resolve(argContext).getValue();
                        IValue iValue = expressionFunction.toString(firstArg);
                        return iValue;
                    }
                    BigInteger integer = function.getArgument(0).resolve(argContext).getBigInteger();
                    int radix = (int)function.getArgument(1).resolve(argContext).getLong();
                    IValue iValue = expressionFunction.toString(integer, radix);
                    return iValue;
                }
                case "countOccurrences": {
                    ExpressionContext.checkNumberOfArgs(function, 2, 3);
                    List<?> array = ExpressionFunctions.listAdapter(function, 0, argContext);
                    IFunction condExpr = this.getLambdaFunction(function, argContext, 1);
                    if (condExpr == null) {
                        IValue iValue = this.throwLambdaFunctionArgumentException(function);
                        return iValue;
                    }
                    boolean recursive = function.getArgNum() == 2 ? false : function.getArgument(2).resolve(argContext).getBoolean();
                    IValue iValue = expressionFunction.countOccurrences(array, condExpr, recursive);
                    return iValue;
                }
                case "minMatch": {
                    ExpressionContext.checkNumberOfArgs(function, 3, 4);
                    List<?> array = ExpressionFunctions.listAdapter(function, 0, argContext);
                    IFunction condExpr = this.getLambdaFunction(function, argContext, 1);
                    if (condExpr == null) {
                        IValue iValue = this.throwLambdaFunctionArgumentException(function);
                        return iValue;
                    }
                    long limit = function.getArgument(2).resolve(argContext).getLong();
                    boolean recursive = function.getArgNum() == 3 ? false : function.getArgument(3).resolve(argContext).getBoolean();
                    IValue iValue = expressionFunction.minMatch(array, condExpr, limit, recursive);
                    return iValue;
                }
                case "maxMatch": {
                    ExpressionContext.checkNumberOfArgs(function, 3, 4);
                    List<?> array = ExpressionFunctions.listAdapter(function, 0, argContext);
                    IFunction condExpr = this.getLambdaFunction(function, argContext, 1);
                    if (condExpr == null) {
                        IValue iValue = this.throwLambdaFunctionArgumentException(function);
                        return iValue;
                    }
                    long limit = function.getArgument(2).resolve(argContext).getLong();
                    boolean recursive = function.getArgNum() == 3 ? false : function.getArgument(3).resolve(argContext).getBoolean();
                    IValue iValue = expressionFunction.maxMatch(array, condExpr, limit, recursive);
                    return iValue;
                }
                case "exactMatch": {
                    ExpressionContext.checkNumberOfArgs(function, 3, 4);
                    List<?> array = ExpressionFunctions.listAdapter(function, 0, argContext);
                    IFunction condExpr = this.getLambdaFunction(function, argContext, 1);
                    if (condExpr == null) {
                        IValue iValue = this.throwLambdaFunctionArgumentException(function);
                        return iValue;
                    }
                    long limit = function.getArgument(2).resolve(argContext).getLong();
                    boolean recursive = function.getArgNum() == 3 ? false : function.getArgument(3).resolve(argContext).getBoolean();
                    IValue iValue = expressionFunction.exactMatch(array, condExpr, limit, recursive);
                    return iValue;
                }
                case "getEnumItemId": {
                    ExpressionContext.checkNumberOfArgs(function, 1);
                    IChild node = ExpressionContext.getChildFromArgAtIndex(function, argContext, 0);
                    IValue iValue = expressionFunction.getEnumItemId(node);
                    return iValue;
                }
                case "getEnumItemLabel": {
                    ExpressionContext.checkNumberOfArgs(function, 1);
                    IChild node = ExpressionContext.getChildFromArgAtIndex(function, argContext, 0);
                    IValue iValue = expressionFunction.getEnumItemLabel(node);
                    return iValue;
                }
                case "getEnumItemValue": {
                    ExpressionContext.checkNumberOfArgs(function, 1, 2);
                    IResolvable defaultValue = null;
                    IChild node = ExpressionContext.getChildFromArgAtIndex(function, argContext, 0);
                    if (function.getArgNum() == 2) {
                        defaultValue = function.getArgument(1);
                    }
                    IValue iValue = expressionFunction.getEnumItemValue(node, defaultValue);
                    return iValue;
                }
                case "getEnumItemDescription": {
                    ExpressionContext.checkNumberOfArgs(function, 1);
                    IChild node = ExpressionContext.getChildFromArgAtIndex(function, argContext, 0);
                    IValue iValue = expressionFunction.getEnumItemDescription(node);
                    return iValue;
                }
                case "getSetItemValue": {
                    ExpressionContext.checkNumberOfArgs(function, 1, 2);
                    IResolvable defaultValue = null;
                    IChild node = ExpressionContext.getChildFromArgAtIndex(function, argContext, 0);
                    if (function.getArgNum() == 2) {
                        defaultValue = function.getArgument(1);
                    }
                    IValue iValue = expressionFunction.getSetItemValue(node, defaultValue);
                    return iValue;
                }
                case "paramExists": {
                    ExpressionContext.checkNumberOfArgs(function, 1);
                    String paramName = function.getArgument(0).resolve(argContext).getString();
                    Value value = Value.of((boolean)expressionFunction.paramExists(paramName));
                    return value;
                }
                case "findDuplicates": {
                    ExpressionContext.checkNumberOfArgs(function, 2);
                    List<?> array = ExpressionFunctions.listAdapter(function, 0, argContext);
                    IFunction keyExpr = this.getLambdaFunction(function, argContext, 1);
                    if (keyExpr == null) {
                        IValue iValue = this.throwLambdaFunctionArgumentException(function);
                        return iValue;
                    }
                    IValue iValue = expressionFunction.findDuplicates(array, keyExpr);
                    return iValue;
                }
                case "join": {
                    ExpressionContext.checkNumberOfArgs(function, 2);
                    List<?> list = ExpressionFunctions.listAdapter(function, 0, argContext);
                    String delimiter = function.getArgument(1).resolve(argContext).getString();
                    IValue iValue = expressionFunction.join(list, delimiter);
                    return iValue;
                }
                case "formatMessage": {
                    ExpressionContext.checkMinNumberOfArgs(function, 2);
                    String message = function.getArgument(0).resolve(argContext).getString();
                    @Nullable Object[] parameters = new Object[function.getArgNum() - 1];
                    int i = 1;
                    while (i < function.getArgNum()) {
                        parameters[i - 1] = function.getArgument(i).resolve(argContext).getValue();
                        ++i;
                    }
                    IValue iValue = expressionFunction.formatMessage(message, parameters);
                    return iValue;
                }
                case "replaceText": {
                    ExpressionContext.checkNumberOfArgs(function, 3);
                    String original = function.getArgument(0).resolve(argContext).getString();
                    String textToReplace = function.getArgument(1).resolve(argContext).getString();
                    String replacement = function.getArgument(2).resolve(argContext).getString();
                    IValue iValue = expressionFunction.replaceText(original, textToReplace, replacement);
                    return iValue;
                }
                case "log": {
                    ExpressionContext.checkNumberOfArgs(function, 1, 2);
                    BigRational exponent = function.getArgument(0).resolve(argContext).getRational();
                    int base = 0;
                    if (function.getArgNum() == 2) {
                        base = function.getArgument(1).resolve(argContext).getBigInteger().intValue();
                    }
                    IValue iValue = expressionFunction.log(exponent, base);
                    return iValue;
                }
                case "nodeExists": {
                    ExpressionContext.checkNumberOfArgs(function, 1, 2);
                    if (function.getArgNum() == 1) {
                        String id = function.getArgument(0).resolve(argContext).getString();
                        IValue iValue = expressionFunction.nodeExists(null, id);
                        return iValue;
                    }
                    IChild node = ExpressionContext.getChildFromArgAtIndex(function, argContext, 0);
                    String id = function.getArgument(1).resolve(argContext).getString();
                    IValue iValue = expressionFunction.nodeExists(node, id);
                    return iValue;
                }
                case "addItemToList": {
                    ExpressionContext.checkNumberOfArgs(function, 5, 7);
                    Object firstArg = function.getArgument(0).resolve(argContext).getValue();
                    if (!(firstArg instanceof List)) {
                        ExpressionFunctionsUtils.throwSevere("First argument is not a list", ExpressionContext.class, function);
                    }
                    List list = (List)firstArg;
                    String id = function.getArgument(1).resolve(argContext).getString();
                    String name = function.getArgument(2).resolve(argContext).getString();
                    String value = function.getArgument(3).resolve(argContext).getString();
                    String description = null;
                    String enableCondition = null;
                    int argNumber = function.getArgNum();
                    if (argNumber >= 6) {
                        description = function.getArgument(5).resolve(argContext).getString();
                        if (argNumber == 7) {
                            enableCondition = function.getArgument(6).resolve(argContext).getString();
                        }
                    }
                    IResolvable expression = function.getArgument(4);
                    IValue iValue = expressionFunction.addItemToList(list, id, name, value, expression, description, enableCondition);
                    return iValue;
                }
                case "toArray": {
                    Object[] arguments = new Object[function.getArgNum()];
                    int i = 0;
                    while (i < arguments.length) {
                        arguments[i] = function.getArgument(i).resolve(argContext).getValue();
                        ++i;
                    }
                    IValue iValue = expressionFunction.toArray(arguments);
                    return iValue;
                }
                case "toUnresolvedExpressionsArray": {
                    Object[] arguments = new Object[function.getArgNum()];
                    int i = 0;
                    while (i < arguments.length) {
                        arguments[i] = function.getArgument(i);
                        ++i;
                    }
                    IValue iValue = expressionFunction.toUnresolvedExpressionsArray(arguments);
                    return iValue;
                }
                case "merge": {
                    List[] lists = new List[function.getArgNum()];
                    int index = 0;
                    while (index < function.getArgNum()) {
                        lists[index] = ExpressionFunctions.listAdapter(function, index, argContext);
                        ++index;
                    }
                    IValue iValue = expressionFunction.merge(lists);
                    return iValue;
                }
                case "createArray": {
                    ExpressionContext.checkNumberOfArgsEx(function, 0, 3);
                    if (function.getArgNum() == 0) {
                        IValue iValue = expressionFunction.createArray();
                        return iValue;
                    }
                    BigInteger firstValue = function.getArgument(0).resolve(argContext).getBigInteger();
                    BigInteger stepValue = function.getArgument(1).resolve(argContext).getBigInteger();
                    BigInteger stepCount = function.getArgument(2).resolve(argContext).getBigInteger();
                    IValue iValue = expressionFunction.createArray(firstValue, stepValue, stepCount);
                    return iValue;
                }
                case "isCoreMaster": {
                    ExpressionContext.checkNumberOfArgs(function, 1);
                    String coreId = function.getArgument(0).resolve(argContext).getString();
                    IValue iValue = expressionFunction.isCoreMaster(coreId);
                    return iValue;
                }
                case "toRational": {
                    ExpressionContext.checkNumberOfArgsEx(function, 1);
                    String textToConvert = function.getArgument(0).resolve(argContext).getString();
                    IValue iValue = expressionFunction.toRational(textToConvert);
                    return iValue;
                }
                case "getPeripherals": {
                    ExpressionContext.checkNumberOfArgs(function, 1);
                    String type = function.getArgument(0).resolve(argContext).getString();
                    IValue iValue = expressionFunction.getPeripherals(type);
                    return iValue;
                }
                case "getPeripheralClock": {
                    ExpressionContext.checkNumberOfArgs(function, 2);
                    String peripheral = function.getArgument(0).resolve(argContext).getString();
                    String clockRole = function.getArgument(1).resolve(argContext).getString();
                    IValue iValue = expressionFunction.getPeripheralClock(peripheral, clockRole);
                    return iValue;
                }
                case "getPeripheralClockFrequency": {
                    ExpressionContext.checkNumberOfArgs(function, 3);
                    String peripheral = function.getArgument(0).resolve(argContext).getString();
                    String clockRole = function.getArgument(1).resolve(argContext).getString();
                    String functionalGroup = function.getArgument(2).resolve(argContext).getString();
                    IValue iValue = expressionFunction.getPeripheralClockFrequency(peripheral, clockRole, functionalGroup);
                    return iValue;
                }
                case "peripheralClockExists": {
                    ExpressionContext.checkNumberOfArgs(function, 2);
                    String peripheral = function.getArgument(0).resolve(argContext).getString();
                    String clockRole = function.getArgument(1).resolve(argContext).getString();
                    IValue iValue = expressionFunction.peripheralClockExists(peripheral, clockRole);
                    return iValue;
                }
                case "frequencyToString": {
                    ExpressionContext.checkNumberOfArgs(function, 1, 2);
                    int decimalPlaces = -1;
                    BigRational frequencyInHertz = function.getArgument(0).resolve(argContext).getRational();
                    if (function.getArgNum() == 2) {
                        decimalPlaces = (int)function.getArgument(1).resolve(argContext).getLong();
                    }
                    IValue iValue = expressionFunction.frequencyToString(frequencyInHertz, decimalPlaces);
                    return iValue;
                }
                case "timeToString": {
                    ExpressionContext.checkNumberOfArgs(function, 1);
                    BigRational timeInMicroseconds = function.getArgument(0).resolve(argContext).getRational();
                    IValue iValue = expressionFunction.timeToString(timeInMicroseconds);
                    return iValue;
                }
                case "getClockFunctionalGroups": {
                    ExpressionContext.checkNumberOfArgs(function, 0);
                    IValue iValue = expressionFunction.getClockFunctionalGroups();
                    return iValue;
                }
                case "hasPeripheralClockSignal": {
                    ExpressionContext.checkNumberOfArgs(function, 2);
                    String peripheral = function.getArgument(0).resolve(argContext).getString();
                    String clockRole = function.getArgument(1).resolve(argContext).getString();
                    IValue iValue = expressionFunction.hasPeripheralClockSignal(peripheral, clockRole);
                    return iValue;
                }
                case "getPeripheralClockSignal": {
                    ExpressionContext.checkNumberOfArgs(function, 2);
                    String peripheral = function.getArgument(0).resolve(argContext).getString();
                    String clockRole = function.getArgument(1).resolve(argContext).getString();
                    IValue iValue = expressionFunction.getPeripheralClockSignal(peripheral, clockRole);
                    return iValue;
                }
                case "getPeripheralClockDescription": {
                    ExpressionContext.checkNumberOfArgs(function, 2);
                    String peripheral = function.getArgument(0).resolve(argContext).getString();
                    String clockRole = function.getArgument(1).resolve(argContext).getString();
                    IValue iValue = expressionFunction.getPeripheralClockDescription(peripheral, clockRole);
                    return iValue;
                }
                case "getPeripheralClockType": {
                    ExpressionContext.checkNumberOfArgs(function, 2);
                    String peripheral = function.getArgument(0).resolve(argContext).getString();
                    String clockRole = function.getArgument(1).resolve(argContext).getString();
                    IValue iValue = expressionFunction.getPeripheralClockType(peripheral, clockRole);
                    return iValue;
                }
                case "getSettingByKey": {
                    ExpressionContext.checkNumberOfArgs(function, 2);
                    Object firstArg = function.getArgument(0).resolve(argContext).getValue();
                    if (!(firstArg instanceof ArrayConfig)) {
                        ExpressionFunctionsUtils.throwSevere("First argument is not an array", ExpressionContext.class, function);
                    }
                    ArrayConfig array = (ArrayConfig)firstArg;
                    String key = function.getArgument(1).resolve(argContext).getString();
                    IValue iValue = expressionFunction.getSettingByKey(array, key);
                    return iValue;
                }
                case "settingWithKeyExists": {
                    ExpressionContext.checkNumberOfArgs(function, 2);
                    Object firstArg = function.getArgument(0).resolve(argContext).getValue();
                    if (!(firstArg instanceof ArrayConfig)) {
                        ExpressionFunctionsUtils.throwSevere("First argument is not an array", ExpressionContext.class, function);
                    }
                    ArrayConfig array = (ArrayConfig)firstArg;
                    String key = function.getArgument(1).resolve(argContext).getString();
                    IValue iValue = expressionFunction.settingWithKeyExists(array, key);
                    return iValue;
                }
                case "getSettingKey": {
                    ExpressionContext.checkNumberOfArgs(function, 1);
                    Object firstArg = function.getArgument(0).resolve(argContext).getValue();
                    if (!(firstArg instanceof ISettingConfig)) {
                        ExpressionFunctionsUtils.throwSevere("First argument is not a setting", ExpressionContext.class, function);
                    }
                    ISettingConfig setting = (ISettingConfig)firstArg;
                    IValue iValue = expressionFunction.getSettingKey(setting);
                    return iValue;
                }
                case "toHertz": {
                    ExpressionContext.checkNumberOfArgs(function, 1);
                    String input = function.getArgument(0).resolve(argContext).getString();
                    IValue iValue = expressionFunction.toHertz(input);
                    return iValue;
                }
                case "toHertzFloat": {
                    ExpressionContext.checkNumberOfArgs(function, 1);
                    String input = function.getArgument(0).resolve(argContext).getString();
                    IValue iValue = expressionFunction.toHertzFloat(input);
                    return iValue;
                }
                case "isPeripheralAvailable": {
                    ExpressionContext.checkNumberOfArgs(function, 2);
                    String peripheralName = function.getArgument(0).resolve(argContext).getString();
                    String coreId = function.getArgument(1).resolve(argContext).getString();
                    IValue iValue = expressionFunction.isPeripheralAvailable(peripheralName, coreId);
                    return iValue;
                }
                case "getFreq": {
                    ExpressionContext.checkNumberOfArgs(function, 2, 3);
                    String value = function.getArgument(0).resolve(argContext).getString();
                    String wantedUnit = function.getArgument(1).resolve(argContext).getString();
                    String defaultUnit = function.getArgNum() > 2 ? function.getArgument(2).resolve(argContext).getString() : null;
                    IValue iValue = expressionFunction.getFreq(value, wantedUnit, defaultUnit);
                    return iValue;
                }
                case "getFreqFloat": {
                    ExpressionContext.checkNumberOfArgs(function, 2, 3);
                    String value = function.getArgument(0).resolve(argContext).getString();
                    String wantedUnit = function.getArgument(1).resolve(argContext).getString();
                    String defaultUnit = function.getArgNum() > 2 ? function.getArgument(2).resolve(argContext).getString() : null;
                    IValue iValue = expressionFunction.getFreqFloat(value, wantedUnit, defaultUnit);
                    return iValue;
                }
                case "isFreq": {
                    ExpressionContext.checkNumberOfArgs(function, 1);
                    String value = function.getArgument(0).resolve(argContext).getString();
                    IValue iValue = expressionFunction.isFreq(value);
                    return iValue;
                }
                case "getTime": {
                    ExpressionContext.checkNumberOfArgs(function, 2, 3);
                    String value = function.getArgument(0).resolve(argContext).getString();
                    String wantedUnit = function.getArgument(1).resolve(argContext).getString();
                    String defaultUnit = function.getArgNum() > 2 ? function.getArgument(2).resolve(argContext).getString() : null;
                    IValue iValue = expressionFunction.getTime(value, wantedUnit, defaultUnit);
                    return iValue;
                }
                case "getTimeFloat": {
                    ExpressionContext.checkNumberOfArgs(function, 2, 3);
                    String value = function.getArgument(0).resolve(argContext).getString();
                    String wantedUnit = function.getArgument(1).resolve(argContext).getString();
                    String defaultUnit = function.getArgNum() > 2 ? function.getArgument(2).resolve(argContext).getString() : null;
                    IValue iValue = expressionFunction.getTimeFloat(value, wantedUnit, defaultUnit);
                    return iValue;
                }
                case "isTime": {
                    ExpressionContext.checkNumberOfArgs(function, 1);
                    String value = function.getArgument(0).resolve(argContext).getString();
                    IValue iValue = expressionFunction.isTime(value);
                    return iValue;
                }
                case "sort": {
                    ExpressionContext.checkNumberOfArgs(function, 2);
                    List<?> array = ExpressionFunctions.listAdapter(function, 0, argContext);
                    IFunction comparatorExpr = this.getLambdaFunction(function, argContext, 1);
                    if (comparatorExpr == null) {
                        IValue iValue = this.throwLambdaFunctionArgumentException(function);
                        return iValue;
                    }
                    IValue iValue = expressionFunction.sort(array, comparatorExpr);
                    return iValue;
                }
                case "stringCompare": {
                    ExpressionContext.checkNumberOfArgs(function, 2);
                    String first = function.getArgument(0).resolve(argContext).getString();
                    String second = function.getArgument(1).resolve(argContext).getString();
                    IValue iValue = expressionFunction.stringCompare(first, second);
                    return iValue;
                }
                case "getSubType": {
                    ExpressionContext.checkNumberOfArgs(function, 1);
                    IChild child = ExpressionContext.getChildFromArgAtIndex(function, argContext, 0);
                    IValue iValue = expressionFunction.getSubType(child);
                    return iValue;
                }
                case "getComponentInstances": {
                    ExpressionContext.checkNumberOfArgs(function, 2);
                    IChild child = ExpressionContext.getChildFromArgAtIndex(function, argContext, 0);
                    String componentTypeId = function.getArgument(1).resolve(argContext).getString();
                    IValue iValue = expressionFunction.getComponentInstances(child, componentTypeId);
                    return iValue;
                }
                case "getSdkBasePointer": {
                    ExpressionContext.checkNumberOfArgs(function, 1);
                    IChild child = ExpressionContext.getChildFromArgAtIndex(function, argContext, 0);
                    IValue iValue = expressionFunction.getSdkBasePointer(child);
                    return iValue;
                }
                case "execScript": {
                    ExpressionContext.checkNumberOfArgs(function, 2);
                    IChild child = ExpressionContext.getChildFromArgAtIndex(function, argContext, 0);
                    String pathToScript = function.getArgument(1).resolve(argContext).getString();
                    IValue iValue = expressionFunction.execScript(child, pathToScript);
                    return iValue;
                }
                case "execScriptFunction": {
                    ExpressionContext.checkMinNumberOfArgs(function, 3);
                    IChild child = ExpressionContext.getChildFromArgAtIndex(function, argContext, 0);
                    String pathToScript = function.getArgument(1).resolve(argContext).getString();
                    String functionName = function.getArgument(2).resolve(argContext).getString();
                    int argumentCount = function.getArgNum() - 3;
                    Object[] arguments = new Object[argumentCount];
                    int i = 0;
                    while (i < argumentCount) {
                        arguments[i] = function.getArgument(3 + i).resolve(argContext).getValue();
                        ++i;
                    }
                    IValue iValue = expressionFunction.execScriptFunction(child, pathToScript, functionName, arguments);
                    return iValue;
                }
                case "getFamily": {
                    ExpressionContext.checkNumberOfArgs(function, 0);
                    IValue iValue = expressionFunction.getFamily();
                    return iValue;
                }
                case "getSeries": {
                    ExpressionContext.checkNumberOfArgs(function, 0);
                    IValue iValue = expressionFunction.getSeries();
                    return iValue;
                }
                case "getPackage": {
                    ExpressionContext.checkNumberOfArgs(function, 0);
                    IValue iValue = expressionFunction.getPackage();
                    return iValue;
                }
                case "getPartNumber": {
                    ExpressionContext.checkNumberOfArgs(function, 0);
                    IValue iValue = expressionFunction.getPartNumber();
                    return iValue;
                }
                case "getSdkVersion": {
                    ExpressionContext.checkNumberOfArgs(function, 0);
                    IValue iValue = expressionFunction.getSdkVersion();
                    return iValue;
                }
                case "getDataVersion": {
                    ExpressionContext.checkNumberOfArgs(function, 0);
                    IValue iValue = expressionFunction.getDataVersion();
                    return iValue;
                }
                case "floor": {
                    int places = 0;
                    ExpressionContext.checkNumberOfArgs(function, 1, 2);
                    BigRational number = function.getArgument(0).resolve(argContext).getRational();
                    if (function.getArgNum() == 2) {
                        places = (int)function.getArgument(1).resolve(argContext).getLong();
                    }
                    IValue iValue = expressionFunction.floor(number, places);
                    return iValue;
                }
                case "ceil": {
                    int places = 0;
                    ExpressionContext.checkNumberOfArgs(function, 1, 2);
                    BigRational number = function.getArgument(0).resolve(argContext).getRational();
                    if (function.getArgNum() == 2) {
                        places = (int)function.getArgument(1).resolve(argContext).getLong();
                    }
                    IValue iValue = expressionFunction.ceil(number, places);
                    return iValue;
                }
                case "round": {
                    int places = 0;
                    ExpressionContext.checkNumberOfArgs(function, 1, 2);
                    BigRational number = function.getArgument(0).resolve(argContext).getRational();
                    if (function.getArgNum() == 2) {
                        places = (int)function.getArgument(1).resolve(argContext).getLong();
                    }
                    IValue iValue = expressionFunction.round(number, places);
                    return iValue;
                }
                case "floatToString": {
                    ExpressionContext.checkNumberOfArgs(function, 2);
                    BigRational number = function.getArgument(0).resolve(argContext).getRational();
                    int places = (int)function.getArgument(1).resolve(argContext).getLong();
                    IValue iValue = expressionFunction.floatToString(number, places);
                    return iValue;
                }
                case "getChildren": {
                    ExpressionContext.checkNumberOfArgs(function, 1);
                    IChild node = ExpressionContext.getChildFromArgAtIndex(function, argContext, 0);
                    IValue iValue = expressionFunction.getChildren(node);
                    return iValue;
                }
                case "indexOf": {
                    IValue resultSize;
                    ExpressionContext.checkNumberOfArgs(function, 2);
                    List<?> array = ExpressionFunctions.listAdapter(function, 0, argContext);
                    Object child = function.getArgument(1).resolve(argContext).getValue();
                    IValue iValue = resultSize = expressionFunction.indexOf(array, child);
                    return iValue;
                }
                case "getArrayDifferences": {
                    ExpressionContext.checkNumberOfArgs(function, 2, 3);
                    List<?> firstArray = ExpressionFunctions.listAdapter(function, 0, argContext);
                    List<?> secondArray = ExpressionFunctions.listAdapter(function, 1, argContext);
                    List<Object> defaultValueArray = new ArrayList();
                    if (function.getArgNum() == 3) {
                        defaultValueArray = ExpressionFunctions.listAdapter(function, 2, argContext);
                    }
                    IValue iValue = expressionFunction.getArrayDifferences(firstArray, secondArray, defaultValueArray);
                    return iValue;
                }
                case "toFloat": {
                    ExpressionContext.checkNumberOfArgs(function, 1);
                    String text = function.getArgument(0).resolve(argContext).getString();
                    IValue iValue = expressionFunction.toFloat(text);
                    return iValue;
                }
                case "isFloat": {
                    ExpressionContext.checkNumberOfArgs(function, 1);
                    String text = function.getArgument(0).resolve(argContext).getString();
                    IValue iValue = expressionFunction.isFloat(text);
                    return iValue;
                }
                case "isInt": {
                    ExpressionContext.checkNumberOfArgs(function, 1);
                    String text = function.getArgument(0).resolve(argContext).getString();
                    IValue iValue = expressionFunction.isInt(text);
                    return iValue;
                }
                case "enumItemsOfType": {
                    ExpressionContext.checkNumberOfArgs(function, 2);
                    IChild node = ExpressionContext.getChildFromArgAtIndex(function, argContext, 0);
                    String path = function.getArgument(1).resolve(argContext).getString();
                    IValue iValue = expressionFunction.enumItemsOfType(node, path);
                    return iValue;
                }
                case "getBitFieldResetValue": {
                    ExpressionContext.checkNumberOfArgs(function, 3);
                    String peripheralName = function.getArgument(0).resolve(argContext).getString();
                    String registerName = function.getArgument(1).resolve(argContext).getString();
                    String bitfieldName = function.getArgument(2).resolve(argContext).getString();
                    IValue iValue = expressionFunction.getBitFieldResetValue(peripheralName, registerName, bitfieldName);
                    return iValue;
                }
                case "getRegisterResetValue": {
                    ExpressionContext.checkNumberOfArgs(function, 2);
                    String peripheralName = function.getArgument(0).resolve(argContext).getString();
                    String registerName = function.getArgument(1).resolve(argContext).getString();
                    IValue iValue = expressionFunction.getRegisterResetValue(peripheralName, registerName);
                    return iValue;
                }
                case "getRegisterAddress": {
                    ExpressionContext.checkNumberOfArgs(function, 2, 3);
                    String peripheralName = function.getArgument(0).resolve(argContext).getString();
                    String registerName = function.getArgument(1).resolve(argContext).getString();
                    String mode = null;
                    if (function.getArgNum() == 3) {
                        mode = function.getArgument(2).resolve(argContext).getString();
                    }
                    IValue iValue = expressionFunction.getRegisterAddress(peripheralName, registerName, mode);
                    return iValue;
                }
                case "getBitfieldOffset": {
                    ExpressionContext.checkNumberOfArgs(function, 3);
                    String peripheralName = function.getArgument(0).resolve(argContext).getString();
                    String registerName = function.getArgument(1).resolve(argContext).getString();
                    String bitfieldName = function.getArgument(2).resolve(argContext).getString();
                    IValue iValue = expressionFunction.getBitfieldOffset(peripheralName, registerName, bitfieldName);
                    return iValue;
                }
                case "getBitFieldWidth": {
                    ExpressionContext.checkNumberOfArgs(function, 3);
                    String peripheralName = function.getArgument(0).resolve(argContext).getString();
                    String registerName = function.getArgument(1).resolve(argContext).getString();
                    String bitfieldName = function.getArgument(2).resolve(argContext).getString();
                    IValue iValue = expressionFunction.getBitFieldWidth(peripheralName, registerName, bitfieldName);
                    return iValue;
                }
                case "getBitFieldValue": {
                    ExpressionContext.checkNumberOfArgs(function, 3);
                    String peripheralName = function.getArgument(0).resolve(argContext).getString();
                    String registerName = function.getArgument(1).resolve(argContext).getString();
                    String bitfieldName = function.getArgument(2).resolve(argContext).getString();
                    IValue iValue = expressionFunction.getBitFieldValue(peripheralName, registerName, bitfieldName);
                    return iValue;
                }
                case "getRegisterValue": {
                    ExpressionContext.checkNumberOfArgs(function, 2);
                    String peripheralName = function.getArgument(0).resolve(argContext).getString();
                    String registerName = function.getArgument(1).resolve(argContext).getString();
                    IValue iValue = expressionFunction.getRegisterValue(peripheralName, registerName);
                    return iValue;
                }
                case "getRegisterOffset": {
                    ExpressionContext.checkNumberOfArgs(function, 2);
                    String peripheralName = function.getArgument(0).resolve(argContext).getString();
                    String registerName = function.getArgument(1).resolve(argContext).getString();
                    IValue iValue = expressionFunction.getRegisterOffset(peripheralName, registerName);
                    return iValue;
                }
                case "getRegisterWidth": {
                    ExpressionContext.checkNumberOfArgs(function, 2);
                    String peripheralName = function.getArgument(0).resolve(argContext).getString();
                    String registerName = function.getArgument(1).resolve(argContext).getString();
                    IValue iValue = expressionFunction.getRegisterWidth(peripheralName, registerName);
                    return iValue;
                }
                case "getRegisterName": {
                    ExpressionContext.checkNumberOfArgs(function, 2);
                    String peripheralName = function.getArgument(0).resolve(argContext).getString();
                    String registerName = function.getArgument(1).resolve(argContext).getString();
                    IValue iValue = expressionFunction.getRegisterName(peripheralName, registerName);
                    return iValue;
                }
                case "getPeripheralAliasValue": {
                    ExpressionContext.checkNumberOfArgs(function, 2);
                    String peripheralName = function.getArgument(0).resolve(argContext).getString();
                    String aliasType = function.getArgument(1).resolve(argContext).getString();
                    IValue iValue = expressionFunction.getPeripheralAliasValue(peripheralName, aliasType);
                    return iValue;
                }
                case "hasPeripheralAliasValue": {
                    ExpressionContext.checkNumberOfArgs(function, 2);
                    String peripheralName = function.getArgument(0).resolve(argContext).getString();
                    String aliasType = function.getArgument(1).resolve(argContext).getString();
                    IValue iValue = expressionFunction.hasPeripheralAliasValue(peripheralName, aliasType);
                    return iValue;
                }
                case "getRegisterAliasValue": {
                    ExpressionContext.checkNumberOfArgs(function, 3);
                    String peripheralName = function.getArgument(0).resolve(argContext).getString();
                    String registerName = function.getArgument(1).resolve(argContext).getString();
                    String aliasType = function.getArgument(2).resolve(argContext).getString();
                    IValue iValue = expressionFunction.getRegisterAliasValue(peripheralName, registerName, aliasType);
                    return iValue;
                }
                case "hasRegisterAliasValue": {
                    ExpressionContext.checkNumberOfArgs(function, 3);
                    String peripheralName = function.getArgument(0).resolve(argContext).getString();
                    String registerName = function.getArgument(1).resolve(argContext).getString();
                    String aliasType = function.getArgument(2).resolve(argContext).getString();
                    IValue iValue = expressionFunction.hasRegisterAliasValue(peripheralName, registerName, aliasType);
                    return iValue;
                }
                case "getBitFieldAliasValue": {
                    ExpressionContext.checkNumberOfArgs(function, 4);
                    String peripheralName = function.getArgument(0).resolve(argContext).getString();
                    String registerName = function.getArgument(1).resolve(argContext).getString();
                    String bitfieldIdentification = function.getArgument(2).resolve(argContext).getString();
                    String aliasType = function.getArgument(3).resolve(argContext).getString();
                    IValue iValue = expressionFunction.getBitFieldAliasValue(peripheralName, registerName, bitfieldIdentification, aliasType);
                    return iValue;
                }
                case "hasBitFieldAliasValue": {
                    ExpressionContext.checkNumberOfArgs(function, 4);
                    String peripheralName = function.getArgument(0).resolve(argContext).getString();
                    String registerName = function.getArgument(1).resolve(argContext).getString();
                    String bitfieldIdentification = function.getArgument(2).resolve(argContext).getString();
                    String aliasType = function.getArgument(3).resolve(argContext).getString();
                    IValue iValue = expressionFunction.hasBitFieldAliasValue(peripheralName, registerName, bitfieldIdentification, aliasType);
                    return iValue;
                }
                case "getPeripheralBaseAddress": {
                    ExpressionContext.checkNumberOfArgs(function, 2, 3);
                    String peripheralName = function.getArgument(0).resolve(argContext).getString();
                    String core = function.getArgument(1).resolve(argContext).getString();
                    String mode = null;
                    if (function.getArgNum() == 3) {
                        mode = function.getArgument(2).resolve(argContext).getString();
                    }
                    IValue iValue = expressionFunction.getPeripheralBaseAddress(peripheralName, core, mode);
                    return iValue;
                }
                case "getRegisters": {
                    ExpressionContext.checkNumberOfArgs(function, 1);
                    String peripheralName = function.getArgument(0).resolve(argContext).getString();
                    IValue iValue = expressionFunction.getRegisters(peripheralName);
                    return iValue;
                }
                case "getBitfields": {
                    ExpressionContext.checkNumberOfArgs(function, 2);
                    String peripheralName = function.getArgument(0).resolve(argContext).getString();
                    String registerName = function.getArgument(1).resolve(argContext).getString();
                    IValue iValue = expressionFunction.getBitfields(peripheralName, registerName);
                    return iValue;
                }
                case "peripheralExists": {
                    ExpressionContext.checkNumberOfArgs(function, 1);
                    String peripheralName = function.getArgument(0).resolve(argContext).getString();
                    IValue iValue = expressionFunction.peripheralExists(peripheralName);
                    return iValue;
                }
                case "registerExists": {
                    ExpressionContext.checkNumberOfArgs(function, 2);
                    String peripheralName = function.getArgument(0).resolve(argContext).getString();
                    String registerName = function.getArgument(1).resolve(argContext).getString();
                    IValue iValue = expressionFunction.registerExists(peripheralName, registerName);
                    return iValue;
                }
                case "bitfieldExists": {
                    ExpressionContext.checkNumberOfArgs(function, 3);
                    String peripheralName = function.getArgument(0).resolve(argContext).getString();
                    String registerName = function.getArgument(1).resolve(argContext).getString();
                    String bitfieldName = function.getArgument(2).resolve(argContext).getString();
                    IValue iValue = expressionFunction.bitfieldExists(peripheralName, registerName, bitfieldName);
                    return iValue;
                }
                case "getHash": {
                    ExpressionContext.checkNumberOfArgs(function, 2);
                    String algorithm = function.getArgument(0).resolve(argContext).getString();
                    String data = function.getArgument(1).resolve(argContext).getString();
                    IValue iValue = expressionFunction.getHash(algorithm, data);
                    return iValue;
                }
                case "isSdkComponentDefined": {
                    ExpressionContext.checkNumberOfArgs(function, 1);
                    String driver = function.getArgument(0).resolve(argContext).getString();
                    IValue iValue = expressionFunction.isSdkComponentDefined(driver);
                    return iValue;
                }
                case "getDefinedSdkComponentVersions": {
                    ExpressionContext.checkNumberOfArgs(function, 1);
                    String driver = function.getArgument(0).resolve(argContext).getString();
                    IValue iValue = expressionFunction.getDefinedSdkComponentsVersions(driver);
                    return iValue;
                }
                case "isVersionInRange": {
                    ExpressionContext.checkNumberOfArgs(function, 3, 4);
                    String mode = null;
                    String versionToCheck = function.getArgument(0).resolve(argContext).getString();
                    String minimalVersion = function.getArgument(1).resolve(argContext).getString();
                    String maximalVersion = function.getArgument(2).resolve(argContext).getString();
                    if (function.getArgNum() == 4) {
                        mode = function.getArgument(3).resolve(argContext).getString();
                    }
                    IValue iValue = expressionFunction.isVersionInRange(versionToCheck, minimalVersion, maximalVersion, mode);
                    return iValue;
                }
                case "getClockGatePeripheral": {
                    ExpressionContext.checkNumberOfArgs(function, 1);
                    String peripheralName = function.getArgument(0).resolve(argContext).getString();
                    IValue iValue = expressionFunction.getClockGatePeripheral(peripheralName);
                    return iValue;
                }
                case "getClockGateRegister": {
                    ExpressionContext.checkNumberOfArgs(function, 1);
                    String peripheralName = function.getArgument(0).resolve(argContext).getString();
                    IValue iValue = expressionFunction.getClockGateRegister(peripheralName);
                    return iValue;
                }
                case "getClockGateBitField": {
                    ExpressionContext.checkNumberOfArgs(function, 1);
                    String peripheralName = function.getArgument(0).resolve(argContext).getString();
                    IValue iValue = expressionFunction.getClockGateBitField(peripheralName);
                    return iValue;
                }
                case "getClockGateEnableValue": {
                    ExpressionContext.checkNumberOfArgs(function, 1);
                    String peripheralName = function.getArgument(0).resolve(argContext).getString();
                    IValue iValue = expressionFunction.getClockGateEnableValue(peripheralName);
                    return iValue;
                }
                case "getAssignedPeripherals": {
                    ExpressionContext.checkNumberOfArgs(function, 1);
                    IChild node = ExpressionContext.getChildFromArgAtIndex(function, argContext, 0);
                    IValue iValue = expressionFunction.getAssignedPeripherals(node);
                    return iValue;
                }
                case "getAssignedRegisters": {
                    ExpressionContext.checkNumberOfArgs(function, 2);
                    IChild node = ExpressionContext.getChildFromArgAtIndex(function, argContext, 0);
                    String peripheralName = function.getArgument(1).resolve(argContext).getString();
                    IValue iValue = expressionFunction.getAssignedRegisters(node, peripheralName);
                    return iValue;
                }
                case "getAssignedBitFields": {
                    ExpressionContext.checkNumberOfArgs(function, 3);
                    IChild node = ExpressionContext.getChildFromArgAtIndex(function, argContext, 0);
                    String peripheralName = function.getArgument(1).resolve(argContext).getString();
                    String registerName = function.getArgument(2).resolve(argContext).getString();
                    IValue iValue = expressionFunction.getAssignedBitFields(node, peripheralName, registerName);
                    return iValue;
                }
                case "getUniqueInt64": {
                    ExpressionContext.checkNumberOfArgs(function, 0);
                    IValue iValue = expressionFunction.getUniqueInt64();
                    return iValue;
                }
                case "getEnv": {
                    ExpressionContext.checkNumberOfArgs(function, 1);
                    String var = function.getArgument(0).resolve(argContext).getString();
                    IValue iValue = expressionFunction.getEnv(var);
                    return iValue;
                }
                case "getConfigurationName": {
                    ExpressionContext.checkNumberOfArgs(function, 0);
                    IValue iValue = expressionFunction.getConfigurationName();
                    return iValue;
                }
                case "print": {
                    ExpressionContext.checkNumberOfArgs(function, 1);
                    IValue value = function.getArgument(0).resolve(argContext);
                    IValue iValue = expressionFunction.print(value);
                    return iValue;
                }
                case "hasError": {
                    ExpressionContext.checkNumberOfArgs(function, 1);
                    IChild node = ExpressionContext.getChildFromArgAtIndex(function, argContext, 0);
                    IValue iValue = expressionFunction.hasError(node);
                    return iValue;
                }
                case "hasWarning": {
                    ExpressionContext.checkNumberOfArgs(function, 1);
                    IChild node = ExpressionContext.getChildFromArgAtIndex(function, argContext, 0);
                    IValue iValue = expressionFunction.hasWarning(node);
                    return iValue;
                }
                case "hasInfo": {
                    ExpressionContext.checkNumberOfArgs(function, 1);
                    IChild node = ExpressionContext.getChildFromArgAtIndex(function, argContext, 0);
                    IValue iValue = expressionFunction.hasInfo(node);
                    return iValue;
                }
                case "slice": {
                    ExpressionContext.checkNumberOfArgs(function, 2, 3);
                    Object inputObject = function.getArgument(0).resolve(argContext).getValue();
                    if (!(inputObject instanceof List)) {
                        ExpressionFunctionsUtils.throwSevere("Function slice did not receive array as first argument", ExpressionContext.class, function);
                    }
                    List inputArray = (List)inputObject;
                    int start = (int)function.getArgument(1).resolve(argContext).getLong();
                    if (function.getArgNum() == 3) {
                        int end = (int)function.getArgument(2).resolve(argContext).getLong();
                        IValue iValue = expressionFunction.slice(inputArray, start, end);
                        return iValue;
                    }
                    IValue iValue = expressionFunction.slice(inputArray, start);
                    return iValue;
                }
                case "trim": {
                    ExpressionContext.checkNumberOfArgs(function, 1);
                    String string = function.getArgument(0).resolve(argContext).getString();
                    IValue iValue = expressionFunction.trim(string);
                    return iValue;
                }
                case "split": {
                    ExpressionContext.checkNumberOfArgs(function, 2, 3);
                    String string = function.getArgument(0).resolve(argContext).getString();
                    String delimeter = function.getArgument(1).resolve(argContext).getString();
                    int limit = 0;
                    if (function.getArgNum() == 3) {
                        limit = (int)function.getArgument(2).resolve(argContext).getLong();
                    }
                    IValue iValue = expressionFunction.split(string, delimeter, limit);
                    return iValue;
                }
                case "charAt": {
                    ExpressionContext.checkNumberOfArgs(function, 2);
                    String string = function.getArgument(0).resolve(argContext).getString();
                    int index = (int)function.getArgument(1).resolve(argContext).getLong();
                    IValue iValue = expressionFunction.charAt(string, index);
                    return iValue;
                }
                case "substring": {
                    ExpressionContext.checkNumberOfArgs(function, 2, 3);
                    String string = function.getArgument(0).resolve(argContext).getString();
                    int start = (int)function.getArgument(1).resolve(argContext).getLong();
                    int end = -1;
                    if (function.getArgNum() == 3) {
                        end = (int)function.getArgument(2).resolve(argContext).getLong();
                    }
                    IValue iValue = expressionFunction.substring(string, start, end);
                    return iValue;
                }
                case "isSdkComponentAvailable": {
                    ExpressionContext.checkNumberOfArgs(function, 1);
                    String sdkComponentId = function.getArgument(0).resolve(argContext).getString();
                    IValue iValue = expressionFunction.isSdkComponentAvailable(sdkComponentId);
                    return iValue;
                }
                case "isSdkComponentUsed": {
                    ExpressionContext.checkNumberOfArgs(function, 1, 2);
                    String sdkComponentId = function.getArgument(0).resolve(argContext).getString();
                    String functionalGroupName = null;
                    if (function.getArgNum() == 2) {
                        functionalGroupName = function.getArgument(1).resolve(argContext).getString();
                    }
                    IValue iValue = expressionFunction.isSdkComponentUsed(sdkComponentId, functionalGroupName);
                    return iValue;
                }
                case "getAvailableSdkComponentVersions": {
                    ExpressionContext.checkNumberOfArgs(function, 1);
                    String sdkComponentId = function.getArgument(0).resolve(argContext).getString();
                    IValue iValue = expressionFunction.getAvailableSdkComponentVersions(sdkComponentId);
                    return iValue;
                }
                case "getCurrentSdkComponentVersions": {
                    ExpressionContext.checkNumberOfArgs(function, 1);
                    String sdkComponentId = function.getArgument(0).resolve(argContext).getString();
                    IValue iValue = expressionFunction.getCurrentSdkComponentVersions(sdkComponentId);
                    return iValue;
                }
                case "getArPackageDocument": {
                    ExpressionContext.checkNumberOfArgs(function, 0);
                    IValue iValue = expressionFunction.getArPackageDocument();
                    return iValue;
                }
                case "isArPackageDocumentCreated": {
                    ExpressionContext.checkNumberOfArgs(function, 0);
                    IValue iValue = expressionFunction.isArPackageDocumentCreated();
                    return iValue;
                }
                case "getAvailableComponentsTypeIds": {
                    String type = function.getArgument(0).resolve(argContext).getString();
                    String version = function.getArgument(1).resolve(argContext).getString();
                    String matchType = null;
                    String untilVersion = null;
                    if (function.getArgNum() > 2) {
                        matchType = function.getArgument(2).resolve(argContext).getString();
                    }
                    if (function.getArgNum() > 3) {
                        untilVersion = function.getArgument(3).resolve(argContext).getString();
                    }
                    IValue iValue = expressionFunction.getAvailableComponentsTypeIds(type, version, matchType, untilVersion);
                    return iValue;
                }
            }
            IValue iValue = ExpressionFunctionsUtils.throwSevere("Unknown function", ExpressionContext.class, function);
            return iValue;
        }
        catch (ExpressionException e) {
            this.invalidArguments.forEach(x -> this.getException().addInvalidArgument(x.intValue()));
            throw e;
        }
        finally {
            profiler.stop(profilerIndex, ExpressionContext.class, null);
        }
    }

    private IValue throwLambdaFunctionArgumentException(FunctionInvocation function) {
        PeripheralExpressionException newException = new PeripheralExpressionException("[DATA] Function requires lambda function format in argument", this.getException(), ExpressionContext.class);
        newException.setFunction(function);
        this.exception = newException;
        throw newException;
    }

    private @Nullable IFunction getLambdaFunction(FunctionInvocation function, IContext argContext, int index) {
        try {
            return function.getArgument(index).resolve(argContext).getFunctionReference();
        }
        catch (ExpressionException e) {
            this.exception = e;
            this.addInvalidArgument(index);
            return null;
        }
    }

    private void addInvalidArgument(Integer position) {
        if (this.invalidArguments.isEmpty()) {
            this.invalidArguments = new HashSet<Integer>();
            this.invalidArguments.add(position);
        }
    }

    private static void checkMinNumberOfArgs(FunctionInvocation function, int expectedMinNumberOfArgs) {
        if (function.getArgNum() < expectedMinNumberOfArgs) {
            ExpressionFunctionsUtils.throwSevere("Function: " + function.getName() + " requires at least " + expectedMinNumberOfArgs + " argument(s)", ExpressionContext.class, function);
        }
    }

    private static void checkNumberOfArgs(FunctionInvocation function, int expectedNumberOfArgs) {
        if (function.getArgNum() != expectedNumberOfArgs) {
            ExpressionFunctionsUtils.throwSevere("Function: " + function.getName() + " requires exactly " + expectedNumberOfArgs + " argument(s)", ExpressionContext.class, function);
        }
    }

    private static void checkNumberOfArgs(FunctionInvocation function, int expectedMinNumberOfArgs, int expectedMaxNumberOfArgs) {
        if (function.getArgNum() < expectedMinNumberOfArgs || function.getArgNum() > expectedMaxNumberOfArgs) {
            ExpressionFunctionsUtils.throwSevere("Function: " + function.getName() + " requires " + expectedMinNumberOfArgs + " to " + expectedMaxNumberOfArgs + " argument(s)", ExpressionContext.class, function);
        }
    }

    private static void checkNumberOfArgsEx(FunctionInvocation function, int ... expectedNumberOfArgs) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (IntStream argNumbers = Arrays.stream(expectedNumberOfArgs);){
            if (!argNumbers.anyMatch(i -> i == function.getArgNum())) {
                ExpressionFunctionsUtils.throwSevere("Function: " + function.getName() + " requires exactly " + Arrays.toString(expectedNumberOfArgs) + " argument(s)", ExpressionContext.class, function);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static IChild getChildFromArgAtIndex(FunctionInvocation function, IContext argContext, int index) {
        Object resolvedArg = function.getArgument(index).resolve(argContext).getValue();
        if (!(resolvedArg instanceof IChild)) {
            ExpressionFunctionsUtils.throwSevere("Argument at given index(" + index + ") is not a child", ExpressionContext.class, function);
        }
        return (IChild)resolvedArg;
    }

    public ChildContext getChildContext() {
        return this.childContext;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[" + " child_context = " + this.childContext.toString() + "]";
    }

    public ExpressionException getException() {
        ExpressionException exceptionLoc = this.exception;
        if (exceptionLoc == null) {
            this.exception = exceptionLoc = new PeripheralExpressionException("Something unspecified went wrong", ExpressionContext.class);
        }
        return exceptionLoc;
    }
}

