/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.resourcetables.model.config;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.constants.CLanguageConstants;
import com.nxp.swtools.common.utils.expression.Expression;
import com.nxp.swtools.common.utils.expression.ExpressionException;
import com.nxp.swtools.common.utils.expression.ExpressionParser;
import com.nxp.swtools.common.utils.expression.FormatOptions;
import com.nxp.swtools.common.utils.expression.FunctionInvocation;
import com.nxp.swtools.common.utils.expression.IContext;
import com.nxp.swtools.common.utils.expression.IExpressionPrintable;
import com.nxp.swtools.common.utils.expression.IFunction;
import com.nxp.swtools.common.utils.expression.IResolvable;
import com.nxp.swtools.common.utils.expression.IValue;
import com.nxp.swtools.common.utils.expression.Value;
import com.nxp.swtools.common.utils.files.UtilsFile;
import com.nxp.swtools.common.utils.frequency.AbstractUnit;
import com.nxp.swtools.common.utils.frequency.Frequency;
import com.nxp.swtools.common.utils.frequency.FrequencyCalculator;
import com.nxp.swtools.common.utils.frequency.FrequencyUnit;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.rational.BigRational;
import com.nxp.swtools.common.utils.stream.CollectorsUtils;
import com.nxp.swtools.common.utils.text.ComparatorHelpers;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.common.utils.time.TimeCalculator;
import com.nxp.swtools.common.utils.time.TimePeriod;
import com.nxp.swtools.common.utils.time.TimeUnit;
import com.nxp.swtools.core.service.scriptapi.db.IRegBitFieldAPI;
import com.nxp.swtools.core.service.scriptapi.db.IRegClockGateConfigAPI;
import com.nxp.swtools.core.service.scriptapi.db.IRegClockGateConfigStateAPI;
import com.nxp.swtools.core.service.scriptapi.db.IRegParentPeripheralAPI;
import com.nxp.swtools.core.service.scriptapi.db.IRegisterAPI;
import com.nxp.swtools.core.service.scriptapi.db.IRegistersDatabaseAPI;
import com.nxp.swtools.expert.clock.modules.ClockSignal;
import com.nxp.swtools.expert.clock.modules.InputSignal;
import com.nxp.swtools.expert.clock.modules.NoSignal;
import com.nxp.swtools.expert.clock.modules.PeripheralComponent;
import com.nxp.swtools.expert.clock.modules.PeripheralComponentInput;
import com.nxp.swtools.expert.clock.modules.PeripheralSignal;
import com.nxp.swtools.expert.clock.modules.PinSignal;
import com.nxp.swtools.expert.clock.modules.PinsToolReference;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.provider.configuration.SharedConfigurationFactory;
import com.nxp.swtools.provider.configuration.dependencies.DependencyQueryFactory;
import com.nxp.swtools.provider.configuration.dependencies.IDependencyQuery;
import com.nxp.swtools.provider.configuration.dependencies.IDependencyQueryResult;
import com.nxp.swtools.provider.configuration.dependencies.pins.RoutableSignal;
import com.nxp.swtools.provider.configuration.dependencies.pins.RoutedPin;
import com.nxp.swtools.resourcetables.model.config.ArrayConfig;
import com.nxp.swtools.resourcetables.model.config.AssignConfig;
import com.nxp.swtools.resourcetables.model.config.CacheHelper;
import com.nxp.swtools.resourcetables.model.config.CastableValue;
import com.nxp.swtools.resourcetables.model.config.ChildContext;
import com.nxp.swtools.resourcetables.model.config.ChildProviderHelper;
import com.nxp.swtools.resourcetables.model.config.ExpressionFunctionsUtils;
import com.nxp.swtools.resourcetables.model.config.IChild;
import com.nxp.swtools.resourcetables.model.config.IChildProvidable;
import com.nxp.swtools.resourcetables.model.config.IComponentConfig;
import com.nxp.swtools.resourcetables.model.config.IComponentInstanceConfig;
import com.nxp.swtools.resourcetables.model.config.IConfigSetConfig;
import com.nxp.swtools.resourcetables.model.config.IFunctionalGroup;
import com.nxp.swtools.resourcetables.model.config.ISettingConfig;
import com.nxp.swtools.resourcetables.model.config.PeripheralExpressionException;
import com.nxp.swtools.resourcetables.model.config.PinsSignalsProvider;
import com.nxp.swtools.resourcetables.model.config.RegisterConfig;
import com.nxp.swtools.resourcetables.model.config.RegistersModelSingleton;
import com.nxp.swtools.resourcetables.model.config.ScalarConfig;
import com.nxp.swtools.resourcetables.model.config.ScalarUtils;
import com.nxp.swtools.resourcetables.model.config.SetConfig;
import com.nxp.swtools.resourcetables.model.data.ConfigurationComponentTypeId;
import com.nxp.swtools.resourcetables.model.data.Description;
import com.nxp.swtools.resourcetables.model.data.SettingOptions;
import com.nxp.swtools.resourcetables.model.data.setting.ArraySetting;
import com.nxp.swtools.resourcetables.model.data.setting.DynamicEnumSetting;
import com.nxp.swtools.resourcetables.model.data.setting.EnumSetting;
import com.nxp.swtools.resourcetables.model.data.setting.FileSetting;
import com.nxp.swtools.resourcetables.model.data.setting.FloatSetting;
import com.nxp.swtools.resourcetables.model.data.setting.IAvailable;
import com.nxp.swtools.resourcetables.model.data.setting.IEnabled;
import com.nxp.swtools.resourcetables.model.data.setting.IID;
import com.nxp.swtools.resourcetables.model.data.setting.ISetting;
import com.nxp.swtools.resourcetables.model.data.setting.IUIName;
import com.nxp.swtools.resourcetables.model.data.setting.IntegerSetting;
import com.nxp.swtools.resourcetables.model.data.setting.SetSetting;
import com.nxp.swtools.resourcetables.model.mcu.ICommonMcu;
import com.nxp.swtools.resourcetables.properties.Properties;
import com.nxp.swtools.utils.registers.BitFieldProvider;
import com.nxp.swtools.utils.scripting.JavaScriptHelper;
import com.nxp.swtools.utils.scripting.api.ScriptUtils;
import com.nxp.swtools.utils.scripting.api.ScriptXMLDocument;
import java.io.File;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.MessageFormat;
import java.time.Clock;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.script.ScriptContext;
import javax.script.SimpleScriptContext;
import org.eclipse.core.runtime.Platform;

public class ExpressionFunctions {
    private static final String FREQUENCY_TO_STRING_INACTIVE = "Inactive";
    private static final String BASE_OF_PERIPHERAL_WITH_GIVEN_NAME_CANNOT_BE_FOUND = "Base of peripheral {0} with given name cannot be found";
    private static final String BASE_OF_REGISTER_WITH_GIVEN_NAME_CANNOT_BE_FOUND = "Base of register {0} with given name cannot be found";
    private static final String BITFIELD_CANNOT_BE_FOUND = "Bitfield {0} cannot be found";
    private static final String REGISTER_CANNOT_BE_FOUND = "Register {0} cannot be found";
    private static final String ALIAS_CANNOT_BE_FOUND = "Alias {0} cannot be found";
    private static final String PERIPHERAL_CANNOT_BE_FOUND = "Peripheral {0} cannot be found";
    private static final String REGISTER_DATABASE_CANNOT_BE_FOUND = "Register database cannot be found";
    private static final Logger LOGGER = LogManager.getLogger(ExpressionFunctions.class);
    private static final String TYPE_NO_SIGNAL = "NOT_CONNECTED";
    private static final String TYPE_INPUT_SIGNAL = "INPUT_SIGNAL";
    private static final String TYPE_PIN_SIGNAL = "PIN_SIGNAL";
    private static final String TYPE_PERIPHERAL_SIGNAL = "PERIPHERAL_SIGNAL";
    private static final String PIN_SIGNAL_PROVIDER = "pinSignalProvider";
    private static final String SCRIPT_CONTEXT_CHILD_ATTRIBUTE = "child";
    private static final String SCRIPT_CONTEXT_PROFILE_ATTRIBUTE = "profile";
    private static final String SCRIPT_CONTEXT_DEBUG_LOGGER = "debugLogger";
    private static final String SCRIPT_CONTEXT_SYSTEM_DIR = "systemDir";
    private static final String COULD_NOT_GET_SETTING_OF_ARGUMENT_MESSAGE = "Could not get setting of argument: {0} with ID: {1} of the function: {2}";
    private static final Pattern LTRIM = Pattern.compile("^\\s+");
    public static long PAD_LEVEL_SIZE = 2L;
    public static final String REGISTER_CLOCK_GATE_ENABLED_STATE_ID = "enabled";
    private final FunctionInvocation function;
    final IContext argContext;
    private final ChildContext childContext;
    private final ICommonMcu mcu;
    public final ScriptUtils utils = new ScriptUtils();

    public ExpressionFunctions(FunctionInvocation function, IContext argContext, ChildContext childContext, ICommonMcu mcu) {
        this.function = function;
        this.argContext = argContext;
        this.childContext = childContext;
        this.mcu = mcu;
    }

    private IValue throwUnknownFunctionForArgument(int index) {
        String description = "Function: " + this.function.getName() + " undefined for: " + this.function.getArgument(index).formatOutput(FormatOptions.DEFAULT, (IExpressionPrintable)this.function);
        return ExpressionFunctionsUtils.throwSevere(description, ExpressionFunctions.class, this.function);
    }

    public IValue featureDefined(String feature) {
        IFunctionalGroup functionalGroup = this.childContext.getFunctionalGroup();
        String core = functionalGroup == null ? null : functionalGroup.getCore();
        String peripheral = ExpressionFunctions.getPeripheral(this.childContext);
        return Value.of((boolean)this.mcu.hasFeature(feature, core, peripheral));
    }

    public IValue peripheralFeatureDefined(String feature, String peripheral) {
        IFunctionalGroup functionalGroup = this.childContext.getFunctionalGroup();
        String core = functionalGroup == null ? null : functionalGroup.getCore();
        return Value.of((boolean)this.mcu.hasFeature(feature, core, peripheral));
    }

    public IValue getFeature(String feature, @Nullable IResolvable defaultValue) {
        return this.getPeripheralFeature(feature, ExpressionFunctions.getPeripheral(this.childContext), defaultValue);
    }

    public IValue getPeripheralFeature(String feature, @Nullable String peripheral, @Nullable IResolvable defaultValue) {
        IFunctionalGroup functionalGroup = this.childContext.getFunctionalGroup();
        String core = functionalGroup == null ? null : functionalGroup.getCore();
        String featureValue = this.mcu.getFeature(feature, core, peripheral);
        if (featureValue == null) {
            if (defaultValue != null) {
                return new CastableValue(defaultValue.resolve(this.argContext).getValue());
            }
            String description = MessageFormat.format("Feature {0} not defined for the part number {1}, core {2} and peripheral {3}", feature, this.mcu.getPartNumber(), core, peripheral);
            return ExpressionFunctionsUtils.throwSevere(description, ExpressionFunctions.class, this.function);
        }
        Expression expression = Expression.tryCreate((String)featureValue);
        if (expression == null) {
            String description = MessageFormat.format("Expression with code: {0} cannot be parsed.", featureValue);
            return ExpressionFunctionsUtils.throwSevere(description, ExpressionFunctions.class, this.function);
        }
        return new CastableValue(expression.resolve(this.argContext).getValue());
    }

    public IValue hasOption(IChild settingConfig, String optionName) {
        return Value.of((settingConfig.isOptionSet(optionName = SettingOptions.normalize(optionName)) && settingConfig.isOptionAvailable(optionName) ? 1 : 0) != 0);
    }

    public IValue getOptionValue(IChild node, String name, @Nullable IResolvable defaultValue) {
        if (!node.isOptionSet(name = SettingOptions.normalize(name))) {
            if (defaultValue != null) {
                return Value.of((Object)defaultValue.resolve(this.argContext).getValue());
            }
            return ExpressionFunctionsUtils.throwSevere(MessageFormat.format("Option: {0} does not exist in child with id: {1}", name, node.getId()), ExpressionFunctions.class, this.function);
        }
        Object optionValue = node.getOptionValue(name);
        if (optionValue == null) {
            if (defaultValue != null) {
                return Value.of((Object)defaultValue.resolve(this.argContext).getValue());
            }
            return ExpressionFunctionsUtils.throwSevere(MessageFormat.format("Value of option: {0} is not set in child with id: {1}", name, node.getId()), ExpressionFunctions.class, this.function);
        }
        return Value.of((Object)optionValue);
    }

    public IValue value(Object node, @Nullable IResolvable defaultValue) {
        block17: {
            IChild child;
            block18: {
                if (!(node instanceof IChild)) break block17;
                child = (IChild)node;
                if (defaultValue == null) {
                    ExpressionFunctions.checkAvailabilityOfChild(child, "value");
                } else if (!child.isAvailable() || !child.isEnabled()) {
                    return defaultValue.resolve(this.argContext);
                }
                if (!(node instanceof ScalarConfig) || ((ScalarConfig)node).getType() != ScalarConfig.Type.FILE) break block18;
                ScalarConfig config = (ScalarConfig)node;
                Object value = config.getValue();
                String string = (String)value;
                if (string.isEmpty()) {
                    return Value.of((String)"");
                }
                String type = FileSetting.getTypePart(string);
                String content = FileSetting.getContentPart(string);
                switch (type) {
                    case "LINK": {
                        File file = new File(content);
                        if (!file.exists() || !file.isFile()) {
                            LOGGER.log(Level.SEVERE, "[TOOL] File \"{0}\" is not available", file.getAbsolutePath());
                            return Value.of((String)"");
                        }
                        String contentOfFile = UtilsFile.readFileToString((String)content, null);
                        if (contentOfFile == null) {
                            return Value.of((String)"");
                        }
                        return Value.of((String)contentOfFile);
                    }
                    case "CONTENT": {
                        return Value.of((String)content.replaceAll("\\\\n", UtilsText.platformEOL));
                    }
                }
            }
            return Value.of((Object)child.getValue());
        }
        if (node instanceof SetSetting.Item) {
            return Value.of((String)((SetSetting.Item)node).getValue());
        }
        String description = MessageFormat.format("Cannot obtain value of a: {0}", node);
        return ExpressionFunctionsUtils.throwSevere(description, ExpressionFunctions.class, this.function);
    }

    public IValue getUserEnteredValue(Object node) {
        if (node instanceof ScalarConfig) {
            ScalarConfig child = (ScalarConfig)node;
            ExpressionFunctions.checkAvailabilityOfChild(child, "value");
            return Value.of((String)child.getStringValue());
        }
        String description = MessageFormat.format("Cannot obtain user entered value of a: {0}", node);
        return ExpressionFunctionsUtils.throwSevere(description, ExpressionFunctions.class, this.function);
    }

    public IValue getDescription(Object node, @Nullable IResolvable defaultDescription) {
        if (node instanceof IChild) {
            IChild child = (IChild)node;
            if (!(child.isAvailable() && child.isEnabled() || defaultDescription == null)) {
                return defaultDescription.resolve(this.argContext);
            }
            return Value.of((String)UtilsText.safeString((String)child.getDescription()));
        }
        if (node instanceof SetSetting.Item) {
            Description description = ((SetSetting.Item)node).getDescription();
            if (description != null) {
                return Value.of((String)UtilsText.safeString((String)description.getDescription(this.argContext)));
            }
            ExpressionFunctionsUtils.throwSevere("Description of item is not set!", ExpressionFunctions.class, this.function);
        }
        return ExpressionFunctionsUtils.throwSevere("Function requires either setting or item to work!", ExpressionFunctions.class, this.function);
    }

    public IValue getLabel(Object node) {
        if (node instanceof IUIName) {
            return Value.of((String)((IUIName)node).getUIName(this.argContext));
        }
        if (node instanceof IChild) {
            return Value.of((String)((IChild)node).getUiName());
        }
        return this.throwUnknownFunctionForArgument(0);
    }

    public IValue getValueDescription(IChild node) {
        return Value.of((String)UtilsText.safeString((String)node.getValueDescription()));
    }

    public IValue getID(Object node) {
        if (node instanceof IID) {
            return Value.of((String)((IID)node).getId());
        }
        if (node instanceof IChild) {
            return Value.of((String)((IChild)node).getName());
        }
        return this.throwUnknownFunctionForArgument(0);
    }

    public IValue getFullID(Object node) {
        if (node instanceof IID) {
            return Value.of((String)((IID)node).getId());
        }
        if (node instanceof IChild) {
            return Value.of((String)((IChild)node).getId());
        }
        return this.throwUnknownFunctionForArgument(0);
    }

    public IValue getPeripheral(IChild child) {
        if (child instanceof IComponentInstanceConfig) {
            return Value.of((String)UtilsText.safeString((String)ExpressionFunctions.getPeripheral(((IComponentInstanceConfig)child).getChildContext())));
        }
        return this.throwUnknownFunctionForArgument(0);
    }

    public IValue getMode(IChild child) {
        return Value.of((String)ExpressionFunctions.getModeId(child.getChildContext()));
    }

    public IValue getFnGroupName(IChild child) {
        if (child instanceof IFunctionalGroup) {
            IFunctionalGroup functionalGroup = child.getChildContext().getFunctionalGroup();
            if (functionalGroup == null) {
                String description = MessageFormat.format("Given child with id: {0} has no functional group", child.getId());
                return ExpressionFunctionsUtils.throwSevere(description, ExpressionFunctions.class, this.function);
            }
            return Value.of((String)functionalGroup.getName());
        }
        return Value.of((String)ExpressionFunctions.getFunctionalGroupName(child.getChildContext()));
    }

    public IValue getFnGroupPrefix(IChild child) {
        return Value.of((String)ExpressionFunctions.getFnGroupPrefixHelper(child));
    }

    public IValue isCalledFromDefaultInit(IChild child) {
        return Value.of((boolean)ExpressionFunctions.isFnGroupDefaultInitHelper(child));
    }

    public IValue getType(IChild child) {
        return Value.of((String)UtilsText.safeString((String)child.getTypeName()));
    }

    public IValue getTypeOfValue(IValue value) {
        String result = "unknown";
        IValue.Type type = value.getType();
        switch (type) {
            case LONG: 
            case BIG_INTEGER: {
                result = "integer";
                break;
            }
            case BIG_RATIONAL: {
                result = "float";
                break;
            }
            case BOOLEAN: {
                result = "bool";
                break;
            }
            case STRING: {
                result = "string";
                break;
            }
            case FUNCTION: {
                result = "lambdaFunction";
                break;
            }
            case OBJECT: {
                result = "object";
                Object valueObject = value.getValue();
                if (valueObject instanceof IChild) {
                    result = "node";
                }
                if (!(valueObject instanceof List)) break;
                result = "array";
            }
        }
        return Value.of((String)result);
    }

    public IValue isAvailable(Object node) {
        if (node instanceof IAvailable) {
            return Value.of((boolean)((IAvailable)node).isAvailable(this.argContext));
        }
        if (node instanceof IChild) {
            return Value.of((boolean)((IChild)node).isAvailable());
        }
        return this.throwUnknownFunctionForArgument(0);
    }

    public IValue isEnabled(Object node) {
        if (node instanceof IEnabled) {
            return Value.of((boolean)((IEnabled)node).isEnabled(this.argContext));
        }
        if (node instanceof IChild) {
            return Value.of((boolean)((IChild)node).isEnabled());
        }
        return this.throwUnknownFunctionForArgument(0);
    }

    public IValue isCIdentifier(String name) {
        return Value.of((boolean)ExpressionFunctions.isCIdentifierHelper(name));
    }

    public IValue toLowerCase(String text) {
        return Value.of((String)UtilsText.safeString((String)text.toLowerCase()));
    }

    public IValue toUpperCase(String text) {
        return Value.of((String)UtilsText.safeString((String)text.toUpperCase()));
    }

    public IValue getCValue(IChild child, @Nullable IResolvable defaultValue) {
        if (!(child.isAvailable() && child.isEnabled() || defaultValue == null)) {
            return defaultValue.resolve(this.argContext);
        }
        if (child instanceof ScalarConfig) {
            ScalarConfig scalarConfig = (ScalarConfig)child;
            switch (scalarConfig.getType()) {
                case STRING: 
                case INFO: {
                    return Value.of((String)("\"" + scalarConfig.getValue() + "\""));
                }
                case BOOL: {
                    return Value.of((boolean)((Boolean)scalarConfig.getValue()));
                }
                case FLOAT: 
                case ENUM: {
                    return Value.of((String)scalarConfig.getValueName());
                }
                case INTEGER: {
                    int radix = ScalarUtils.detectIntegerBase(scalarConfig.getStringValue().trim());
                    if (radix == 2) {
                        radix = 16;
                    }
                    return this.toString(Value.of((Object)scalarConfig.getValue()).getBigInteger(), radix);
                }
            }
        } else if (child instanceof SetConfig) {
            return Value.of((String)((String)((SetConfig)child).getChildren().stream().filter(x -> x.isAvailable()).filter(x -> x.getBoolValue()).map(x -> x.getItem().getId()).collect(CollectorsUtils.joining((CharSequence)" | "))));
        }
        return this.throwUnknownFunctionForArgument(0);
    }

    public IValue leftPadding(String argument, long level) {
        return Value.of((String)ExpressionFunctions.padLeft(ExpressionFunctions.trimLeft(argument), level));
    }

    public IValue hasResource(String tableId, String definitionId) {
        ISettingConfig setting = this.childContext.getRoot().getResource(tableId, definitionId);
        return Value.of((setting != null ? 1 : 0) != 0);
    }

    public IValue hasResource(String tableId, String definitionId, String component) {
        ConfigurationComponentTypeId configurationComponentTypeId = this.childContext.getRoot().getComponentTypeIdByType(component);
        String typeId = configurationComponentTypeId != null ? configurationComponentTypeId.getTypeId() : component;
        ISettingConfig setting = this.childContext.getRoot().getResource(tableId, definitionId, typeId);
        return Value.of((setting != null ? 1 : 0) != 0);
    }

    public IValue getResource(String tableId, String definitionId) {
        ISettingConfig setting = this.childContext.getRoot().getResource(tableId, definitionId);
        if (setting == null) {
            String description = MessageFormat.format("Could not retrieve resource setting for arguments `{0}` and `{1}` of the function: {2}", tableId, definitionId, this.function.getName());
            return ExpressionFunctionsUtils.throwSevere(description, ExpressionFunctions.class, this.function);
        }
        return Value.of((Object)setting);
    }

    public IValue getResource(String tableId, String definitionId, String component) {
        ConfigurationComponentTypeId configurationComponentTypeId = this.childContext.getRoot().getComponentTypeIdByType(component);
        String typeId = configurationComponentTypeId != null ? configurationComponentTypeId.getTypeId() : component;
        ISettingConfig setting = this.childContext.getRoot().getResource(tableId, definitionId, typeId);
        if (setting == null) {
            String description = MessageFormat.format("Could not retrieve resource setting for arguments `{0}` and `{1}` of the function: {2}", tableId, definitionId, this.function.getName());
            return ExpressionFunctionsUtils.throwSevere(description, ExpressionFunctions.class, this.function);
        }
        return Value.of((Object)setting);
    }

    public IValue getPeripheralSignals(String peripheral) {
        IConfigSetConfig configSetConfig = this.childContext.getConfigSetConfig();
        PinsSignalsProvider pinsSignalsProvider = configSetConfig != null ? CacheHelper.getValueCaching(configSetConfig, PIN_SIGNAL_PROVIDER + peripheral, () -> ExpressionFunctions.getPinsSignalProvider(peripheral)) : ExpressionFunctions.getPinsSignalProvider(peripheral);
        if (pinsSignalsProvider == null) {
            LOGGER.warning("[DATA] Cannot resolve query: getPeripheralSignals(" + peripheral + ")");
            return Value.of((boolean)false);
        }
        return Value.of(pinsSignalsProvider.createItemsFromSignals());
    }

    public IValue toInt(String text) {
        try {
            return ExpressionFunctions.getBestFittingTypeOfValue(ScalarUtils.parseInteger(text));
        }
        catch (NumberFormatException numberFormatException) {
            BigRational parsedValue = BigRational.tryParse((String)text);
            if (parsedValue == null) {
                return ExpressionFunctionsUtils.throwSevere(MessageFormat.format("Could not parse string argument: \"{0}\" to rational number", text), ExpressionFunctions.class, this.function);
            }
            return this.toInt(parsedValue);
        }
    }

    public IValue toFloat(String text) {
        BigRational result = BigRational.tryParse((String)text);
        if (result == null) {
            String description = MessageFormat.format("Could not parse float value of argument: {0}", text);
            return ExpressionFunctionsUtils.throwSevere(description, ExpressionFunctions.class, this.function);
        }
        return Value.of((BigRational)result);
    }

    public IValue isFloat(String text) {
        BigRational result = BigRational.tryParse((String)text);
        return Value.of((result != null ? 1 : 0) != 0);
    }

    public IValue isInt(String text) {
        try {
            IValue.Type type = ExpressionParser.parseNumber((String)text).getType();
            if (type == IValue.Type.BIG_INTEGER || type == IValue.Type.LONG) {
                return Value.of((boolean)true);
            }
            return Value.of((boolean)false);
        }
        catch (ArithmeticException | NumberFormatException runtimeException) {
            return Value.of((boolean)false);
        }
    }

    private static IValue getBestFittingTypeOfValue(BigInteger bigInteger) {
        if (bigInteger.compareTo(BigInteger.valueOf(Long.MAX_VALUE)) <= 0) {
            return Value.of((long)bigInteger.longValue());
        }
        return Value.of((BigInteger)bigInteger);
    }

    public IValue toRational(String text) {
        BigRational result;
        String description = MessageFormat.format("Could not parse rational value of argument: {0} of the function: {1}", text, this.function.getName());
        try {
            result = BigRational.tryParse((String)text);
        }
        catch (Exception exception) {
            return ExpressionFunctionsUtils.throwSevere(description, ExpressionFunctions.class, this.function);
        }
        return result != null ? Value.of((BigRational)result) : ExpressionFunctionsUtils.throwSevere(description, ExpressionFunctions.class, this.function);
    }

    public IValue toInt(BigRational rational) {
        return ExpressionFunctions.getBestFittingTypeOfValue(rational.toBigIntegerRounded(RoundingMode.DOWN));
    }

    public IValue toString(Object node) {
        return Value.of((String)UtilsText.safeString((String)node.toString()));
    }

    public IValue toString(BigInteger integer, int radix) {
        String result = integer.toString(radix);
        switch (radix) {
            case 2: {
                result = "0b" + result;
                break;
            }
            case 8: {
                result = "0" + result;
                break;
            }
            case 10: {
                break;
            }
            case 16: {
                result = "0x" + result.toUpperCase();
                break;
            }
            default: {
                String description = MessageFormat.format("Unsupported value of radix argument: {0} of the function: {1}", String.valueOf(radix), this.function.getName());
                return ExpressionFunctionsUtils.throwSevere(description, ExpressionFunctions.class, this.function);
            }
        }
        return Value.of((String)result);
    }

    public IValue extractSignalId(String pinSignalId) {
        String[] signalSplit = pinSignalId.split("\\.");
        if (signalSplit.length < 2) {
            LOGGER.warning("[DATA] Unable to extract signal ID from: " + pinSignalId);
            return Value.of((String)pinSignalId);
        }
        return Value.of((String)UtilsText.safeString((String)signalSplit[signalSplit.length - 2]));
    }

    public IValue extractChannelId(String pinSignalId) {
        String[] signalSplit = pinSignalId.split("\\.", -1);
        if (signalSplit.length < 2) {
            LOGGER.warning("[DATA] Unable to extract channel ID from: " + pinSignalId);
            return Value.of((String)pinSignalId);
        }
        return Value.of((String)UtilsText.safeString((String)signalSplit[signalSplit.length - 1]));
    }

    public IValue regexSubstr(String text, String regExp, int groupIndex) {
        Pattern regExpPattern = Pattern.compile(regExp);
        Matcher regExpMatcher = regExpPattern.matcher(text);
        if (!regExpMatcher.find()) {
            ExpressionFunctionsUtils.throwSevere(MessageFormat.format("Regex \"{0}\" did not match anything in string \"{1}\"", regExp, text), ExpressionFunctions.class, this.function);
        }
        String substr = regExpMatcher.group(groupIndex);
        return Value.of((String)UtilsText.safeString((String)substr));
    }

    public IValue regexMatch(String text, String regex) {
        return Value.of((boolean)text.matches(regex));
    }

    public IValue contains(String text, String searchFor) {
        return Value.of((boolean)text.contains(searchFor));
    }

    public IValue getParent(Object node) {
        if (!(node instanceof IChild)) {
            return ExpressionFunctionsUtils.throwSevere(MessageFormat.format("Could not get parent of argument: {0} of the function: {1}", this.function.getArgument(0).formatOutput(FormatOptions.DEFAULT, (IExpressionPrintable)this.function), this.function.getName()), ExpressionFunctions.class, this.function);
        }
        IChildProvidable parent = ((IChild)node).getChildContext().getParent();
        if (parent == null) {
            return ExpressionFunctionsUtils.throwSevere(MessageFormat.format("Could not get parent of argument: {0} of the function: {1}", this.function.getArgument(0).formatOutput(FormatOptions.DEFAULT, (IExpressionPrintable)this.function), this.function.getName()), ExpressionFunctions.class, this.function);
        }
        return Value.of((Object)parent);
    }

    public IValue queryFeature(String resType, String resId, String featureName) {
        boolean result = false;
        if (Platform.isRunning()) {
            ISharedConfiguration configuration = SharedConfigurationFactory.getSharedConfigurationSingleton();
            IDependencyQuery queryEngine = DependencyQueryFactory.getQueryInstance((ISharedConfiguration)configuration);
            Collection results = queryEngine.query(configuration, resType, resId, featureName);
            result = CollectionsUtils.getInstancesOf(results.stream().map(IDependencyQueryResult::getValue), Boolean.class).anyMatch(Boolean::booleanValue);
        } else {
            LOGGER.warning("[TOOL] Cannot resolve query due to inactive workbench: (" + resType + ", " + resId + ", " + featureName + ")");
        }
        return Value.of((boolean)result);
    }

    public IValue queryFeatureAdvanced(String resType, String resId, String featureName, boolean defaultGroupOnly, @Nullable String functionalGroup) {
        ArrayList result = "";
        if (Platform.isRunning()) {
            ISharedConfiguration configuration = SharedConfigurationFactory.getSharedConfigurationSingleton();
            IDependencyQuery queryEngine = DependencyQueryFactory.getQueryInstance((ISharedConfiguration)configuration);
            Collection results = queryEngine.query(configuration, resType, resId, featureName);
            boolean singleResult = false;
            Stream<Object> stream = results.stream();
            if (functionalGroup != null) {
                stream = stream.filter(r -> r.getConfiguration().getConfigurationName().equals(functionalGroup));
                singleResult = true;
            }
            if (defaultGroupOnly) {
                stream = stream.filter(r -> r.getConfiguration().isCalledFromInit());
                singleResult = true;
            }
            Stream<Object> valuesStream = CollectionsUtils.getInstancesOf(stream.map(IDependencyQueryResult::getValue), Object.class);
            valuesStream = valuesStream.map(v -> {
                Serializable value = v;
                if (value instanceof Double) {
                    value = new BigRational(new BigDecimal((Double)value));
                } else if (value instanceof Frequency) {
                    value = ExpressionFunctions.toHertzFloat((Frequency)value);
                } else if (value instanceof Set) {
                    value = new ArrayList((Set)((Object)value));
                } else if (value instanceof Integer) {
                    value = (long)((Integer)value).intValue();
                }
                return value;
            });
            if (singleResult) {
                Object first = CollectionsUtils.nullableOptionalGet(valuesStream.findFirst());
                if (first != null) {
                    result = first;
                }
            } else {
                result = new ArrayList(valuesStream.collect(Collectors.toList()));
            }
        } else {
            LOGGER.warning("[TOOL] Cannot resolve query due to inactive workbench: (" + resType + ", " + resId + ", " + featureName + ")");
        }
        return Value.of((Object)result);
    }

    public IValue enumItemsOf(Object enumItems) {
        if (enumItems instanceof ScalarConfig) {
            return Value.of(((ScalarConfig)enumItems).getEnumItems());
        }
        String description = "Could not create enum from argument: " + this.function.getArgument(0).formatOutput(FormatOptions.DEFAULT, (IExpressionPrintable)this.function) + " of the function: " + this.function.getName();
        return ExpressionFunctionsUtils.throwSevere(description, ExpressionFunctions.class, this.function);
    }

    public IValue addItemToList(List<SetSetting.Item> list, String id, String name, String value, IResolvable expression, @Nullable String descriptionText, @Nullable String enableCondition) {
        if (expression.resolve(this.argContext).getBoolean()) {
            Description description = new Description(descriptionText, null);
            list.add(new SetSetting.Item(id, name, null, value, description, "", enableCondition));
        }
        return Value.of(list);
    }

    public IValue log(BigRational exponent, int base) {
        double value = 0.0;
        value = base == 0 ? Math.log(exponent.doubleValue()) : Math.log10(exponent.doubleValue()) / Math.log10(base);
        String valueString = String.valueOf(value);
        int digitsDec = valueString.length() - 1 - valueString.indexOf(46);
        long denom = 1L;
        int i = 0;
        while (i < digitsDec) {
            value *= 10.0;
            denom *= 10L;
            ++i;
        }
        value = Math.round(value);
        BigRational result = new BigRational((long)value, denom);
        return Value.of((BigRational)result);
    }

    public IValue getSetting(Object node, String id) {
        if (!(node instanceof IChild)) {
            String description = MessageFormat.format(COULD_NOT_GET_SETTING_OF_ARGUMENT_MESSAGE, this.function.getArgument(0).formatOutput(FormatOptions.DEFAULT, (IExpressionPrintable)this.function), this.function.getArgument(1).formatOutput(FormatOptions.DEFAULT, (IExpressionPrintable)this.function), this.function.getName());
            return ExpressionFunctionsUtils.throwSevere(description, ExpressionFunctions.class, this.function);
        }
        IChild found = ChildProviderHelper.getChild(((IChild)node).getChildContext(), id);
        if (found == null) {
            String description = MessageFormat.format(COULD_NOT_GET_SETTING_OF_ARGUMENT_MESSAGE, this.function.getArgument(0).formatOutput(FormatOptions.DEFAULT, (IExpressionPrintable)this.function), this.function.getArgument(1).formatOutput(FormatOptions.DEFAULT, (IExpressionPrintable)this.function), this.function.getName());
            return ExpressionFunctionsUtils.throwSevere(description, ExpressionFunctions.class, this.function);
        }
        return Value.of((Object)found);
    }

    public IValue getCoreId(IChild node) {
        IFunctionalGroup functionalGroup = node.getChildContext().getFunctionalGroup();
        if (functionalGroup == null) {
            String description = "Given IChild node " + this.function.getArgument(0).formatOutput(FormatOptions.DEFAULT, (IExpressionPrintable)this.function) + " has no functional group assigned";
            return ExpressionFunctionsUtils.throwSevere(description, ExpressionFunctions.class, this.function);
        }
        return Value.of((String)UtilsText.safeString((String)functionalGroup.getCore()));
    }

    public IValue getPeriphInstanceIndex(String name) {
        String type = this.mcu.getPeripheralType(name);
        long index = 0L;
        IRegistersDatabaseAPI registersDB = this.mcu.getRegistersDb();
        if (registersDB != null) {
            IRegParentPeripheralAPI[] iRegParentPeripheralAPIArray = registersDB.getPeripherals();
            int n = iRegParentPeripheralAPIArray.length;
            int n2 = 0;
            while (n2 < n) {
                IRegParentPeripheralAPI api = iRegParentPeripheralAPIArray[n2];
                if (api.getName().equals(name)) {
                    return Value.of((long)index);
                }
                if (Objects.equals(api.getAlias("type"), type)) {
                    ++index;
                }
                ++n2;
            }
        }
        return Value.of((long)-1L);
    }

    public IValue getPeripheralType(String name) {
        String type = this.mcu.getPeripheralType(name);
        if (type == null) {
            String description = "Could not get peripheral type of argument: " + this.function.getArgument(0).formatOutput(FormatOptions.DEFAULT, (IExpressionPrintable)this.function) + " of the function: " + this.function.getName();
            return ExpressionFunctionsUtils.throwSevere(description, ExpressionFunctions.class, this.function);
        }
        return Value.of((String)type);
    }

    public IValue allDifferent(List<?> array) {
        HashSet set = new HashSet(array);
        return Value.of((set.size() == array.size() ? 1 : 0) != 0);
    }

    public IValue isPeripheralUsed(IChild node, String name) {
        IFunctionalGroup functionalGroup = node.getChildContext().getFunctionalGroup();
        if (functionalGroup == null) {
            String description = "The function: " + this.function.getName() + " needs child of functional group as an argument." + " Given node(" + node + ") doesn't have functional group!";
            return ExpressionFunctionsUtils.throwSevere(description, ExpressionFunctions.class, this.function);
        }
        return Value.of((boolean)functionalGroup.isPeripheralUsed(name));
    }

    public IValue arrayToEnumItems(List<@NonNull ?> array, IFunction filterExpr, IFunction idSelectExpr, IFunction labelSelectExpr, IFunction valueSelectExpr, @Nullable IFunction descriptionExpr, @Nullable IFunction enableExpr) {
        ArrayList<SetSetting.Item> enumItems = new ArrayList<SetSetting.Item>();
        if (array.isEmpty()) {
            return Value.of(enumItems);
        }
        for (Object item : array) {
            if (!filterExpr.invokeOn(this.argContext, new Object[]{item}).getBoolean()) continue;
            Description description = null;
            if (descriptionExpr != null) {
                description = new Description(descriptionExpr.invokeOn(this.argContext, new Object[]{item}).getString(), null);
            }
            String enableCondition = "";
            if (enableExpr != null) {
                enableCondition = enableExpr.invokeOn(this.argContext, new Object[]{item}).getString();
            }
            enumItems.add(new SetSetting.Item(idSelectExpr.invokeOn(this.argContext, new Object[]{item}).getString(), labelSelectExpr.invokeOn(this.argContext, new Object[]{item}).getString(), null, valueSelectExpr.invokeOn(this.argContext, new Object[]{item}).getString(), description, "", enableCondition));
        }
        return Value.of(enumItems);
    }

    public IValue allMatch(List<@NonNull ?> array, IFunction condExpr) {
        boolean result = true;
        for (Object item : array) {
            result &= condExpr.invokeOn(this.argContext, new Object[]{item}).getBoolean();
        }
        return Value.of((boolean)result);
    }

    public IValue anyMatch(List<@NonNull ?> array, IFunction condExpr) {
        for (Object item : array) {
            if (!condExpr.invokeOn(this.argContext, new Object[]{item}).getBoolean()) continue;
            return Value.of((boolean)true);
        }
        return Value.of((boolean)false);
    }

    public IValue noneMatch(List<@NonNull ?> array, IFunction condExpr) {
        return Value.of((!this.anyMatch(array, condExpr).getBoolean() ? 1 : 0) != 0);
    }

    public IValue filter(List<@NonNull ?> array, IFunction condExpr, boolean recursive) {
        ExpressionFunctionArrayList newArray = new ExpressionFunctionArrayList();
        List<?> iterableList = array;
        if (recursive) {
            iterableList = new ArrayList(array);
            for (Object item : array) {
                if (item instanceof IChildProvidable) {
                    iterableList.addAll(ChildProviderHelper.getAllChildren((IChildProvidable)item));
                    continue;
                }
                if (!(item instanceof List)) continue;
                iterableList.addAll(ExpressionFunctions.expandList((List)item));
            }
        }
        for (Object item : iterableList) {
            if (!condExpr.invokeOn(this.argContext, new Object[]{item}).getBoolean()) continue;
            newArray.add(item);
        }
        return Value.of(newArray);
    }

    public IValue findFirst(List<@NonNull ?> array, IFunction condExpr) {
        for (Object item : array) {
            if (!condExpr.invokeOn(this.argContext, new Object[]{item}).getBoolean()) continue;
            return Value.of(item);
        }
        String description = "Could not find element of argument: " + this.function.getArgument(0).formatOutput(FormatOptions.DEFAULT, (IExpressionPrintable)this.function) + " of the function: " + this.function.getName();
        return ExpressionFunctionsUtils.throwSevere(description, ExpressionFunctions.class, this.function);
    }

    public IValue findFirst(List<@NonNull ?> array, IFunction condExpr, IResolvable defaultValue) {
        for (Object item : array) {
            if (!condExpr.invokeOn(this.argContext, new Object[]{item}).getBoolean()) continue;
            return Value.of(item);
        }
        return defaultValue.resolve(this.argContext);
    }

    public IValue get(List<?> array, long index, @Nullable IResolvable defaultValue) {
        if ((long)array.size() <= index) {
            if (defaultValue != null) {
                return defaultValue.resolve(this.argContext);
            }
            String description = "Could not get element of argument: " + this.function.getArgument(1).formatOutput(FormatOptions.DEFAULT, (IExpressionPrintable)this.function) + " of the function: " + this.function.getName();
            return ExpressionFunctionsUtils.throwSevere(description, ExpressionFunctions.class, this.function);
        }
        Object obj = array.get((int)index);
        assert (obj != null);
        return Value.of(obj);
    }

    public IValue getFirst(List<?> array) {
        if (array.isEmpty()) {
            String description = "Could not get element of argument: " + this.function.getArgument(0).formatOutput(FormatOptions.DEFAULT, (IExpressionPrintable)this.function) + " of the function: " + this.function.getName();
            return ExpressionFunctionsUtils.throwSevere(description, ExpressionFunctions.class, this.function);
        }
        Object obj = array.get(0);
        assert (obj != null);
        return Value.of(obj);
    }

    public IValue getLast(List<?> array) {
        if (array.isEmpty()) {
            String description = "Could not get element of argument: " + this.function.getArgument(0).formatOutput(FormatOptions.DEFAULT, (IExpressionPrintable)this.function) + " of the function: " + this.function.getName();
            return ExpressionFunctionsUtils.throwSevere(description, ExpressionFunctions.class, this.function);
        }
        Object obj = array.get(array.size() - 1);
        assert (obj != null);
        return Value.of(obj);
    }

    public IValue map(List<@NonNull ?> array, IFunction funcExpr) {
        ArrayList<Object> newArray = new ArrayList<Object>();
        for (Object item : array) {
            newArray.add(funcExpr.invokeOn(this.argContext, new Object[]{item}).getValue());
        }
        return Value.of(newArray);
    }

    public IValue flatMap(List<@NonNull ?> array, IFunction funcExpr) {
        ArrayList newArray = new ArrayList();
        for (Object item : array) {
            List<@NonNull ?> value = ExpressionFunctions.listAdapter(funcExpr.invokeOn(this.argContext, new Object[]{item}).getValue());
            newArray.addAll(value);
        }
        return Value.of(newArray);
    }

    public IValue reduce(List<@NonNull ?> array, Object identity, IFunction funcExpr) {
        Object reducedValue = identity;
        for (Object item : array) {
            reducedValue = funcExpr.invokeOn(this.argContext, new Object[]{reducedValue, item}).getValue();
        }
        return Value.of((Object)reducedValue);
    }

    public IValue removeDuplicates(List<@NonNull ?> array, IFunction keyExpr) {
        LinkedHashMap map = new LinkedHashMap();
        for (Object item : array) {
            Object key = keyExpr.invokeOn(this.argContext, new Object[]{item}).getValue();
            map.put(key, item);
        }
        return Value.of(new ArrayList(map.values()));
    }

    public IValue searchInArray(List<?> array, IFunction condExpr) {
        int i = 0;
        while (i < array.size()) {
            if (condExpr.invokeOn(this.argContext, new Object[]{array.get(i)}).getBoolean()) {
                return Value.of((long)i);
            }
            ++i;
        }
        return Value.of((long)-1L);
    }

    public IValue countOccurrences(List<?> array, IFunction condExpr, boolean recursive) {
        Object value = this.filter(array, condExpr, recursive).getValue();
        if (value instanceof List) {
            return Value.of((long)((List)value).size());
        }
        return Value.of((long)0L);
    }

    public IValue minMatch(List<?> array, IFunction condExpr, long minimum, boolean recursive) {
        Object value = ExpressionFunctions.filterLimited(array, condExpr, recursive, minimum + 1L, this.argContext).getValue();
        if (value instanceof List) {
            int size = ((List)value).size();
            return Value.of(((long)size >= minimum ? 1 : 0) != 0);
        }
        return Value.of((boolean)false);
    }

    public IValue maxMatch(List<?> array, IFunction condExpr, long maximum, boolean recursive) {
        Object value = ExpressionFunctions.filterLimited(array, condExpr, recursive, maximum + 1L, this.argContext).getValue();
        if (value instanceof List) {
            int size = ((List)value).size();
            return Value.of(((long)size <= maximum ? 1 : 0) != 0);
        }
        return Value.of((boolean)false);
    }

    public IValue exactMatch(List<?> array, IFunction condExpr, long expected, boolean recursive) {
        Object value = ExpressionFunctions.filterLimited(array, condExpr, recursive, expected + 1L, this.argContext).getValue();
        if (value instanceof List) {
            int size = ((List)value).size();
            return Value.of(((long)size == expected ? 1 : 0) != 0);
        }
        return Value.of((boolean)false);
    }

    public IValue size(List<?> array) {
        return Value.of((long)array.size());
    }

    public IValue size(String string) {
        return Value.of((long)string.length());
    }

    public IValue toArray(Object ... values) {
        return Value.of(new ArrayList<Object>(Arrays.asList(values)));
    }

    public IValue merge(List<?> ... arrays) {
        ArrayList newList = new ArrayList();
        List<?>[] listArray = arrays;
        int n = arrays.length;
        int n2 = 0;
        while (n2 < n) {
            List<?> array = listArray[n2];
            newList.addAll(array);
            ++n2;
        }
        return Value.of(newList);
    }

    public IValue createArray() {
        return Value.of(new ArrayList());
    }

    public IValue createArray(BigInteger firstValue, BigInteger stepValue, BigInteger stepCount) {
        if (stepCount.compareTo(BigInteger.ZERO) < 0) {
            String description = "Number of array value increments cannot be negative. Argument value: " + stepCount + " used for the function: " + this.function.getName();
            return ExpressionFunctionsUtils.throwSevere(description, ExpressionFunctions.class, this.function);
        }
        ArrayList<Object> result = new ArrayList<Object>();
        Value nextValue = Value.of((BigInteger)firstValue);
        Value increment = Value.of((BigInteger)stepValue);
        long i = 0L;
        while (i <= stepCount.longValue()) {
            result.add(nextValue.getValue());
            nextValue = (Value)nextValue.add((IValue)increment);
            ++i;
        }
        return Value.of(result);
    }

    public IValue isCoreMaster(String coreId) {
        String masterCoreId = this.childContext.getRoot().getMcu().getMasterCore();
        return Value.of((boolean)masterCoreId.equals(coreId));
    }

    public IValue getEnumItemId(IChild node) {
        if (node instanceof ScalarConfig && ((ScalarConfig)node).getType() == ScalarConfig.Type.ENUM) {
            return Value.of((String)this.getEnumItemId((ScalarConfig)node));
        }
        String description = "Function: " + this.function.getName() + " undefined for: " + this.function.getArgument(0).formatOutput(FormatOptions.DEFAULT, (IExpressionPrintable)this.function);
        return ExpressionFunctionsUtils.throwSevere(description, ExpressionFunctions.class, this.function);
    }

    public IValue getEnumItemLabel(IChild node) {
        if (node instanceof ScalarConfig && ((ScalarConfig)node).getType() == ScalarConfig.Type.ENUM) {
            return Value.of((String)this.getEnumItemLabel((ScalarConfig)node));
        }
        String description = "Function: " + this.function.getName() + " undefined for: " + this.function.getArgument(0).formatOutput(FormatOptions.DEFAULT, (IExpressionPrintable)this.function);
        return ExpressionFunctionsUtils.throwSevere(description, ExpressionFunctions.class, this.function);
    }

    public IValue getEnumItemValue(IChild node, @Nullable IResolvable defaultValue) {
        if (node instanceof ScalarConfig && ((ScalarConfig)node).getType() == ScalarConfig.Type.ENUM) {
            if (!(defaultValue == null || node.isAvailable() && node.isEnabled())) {
                return defaultValue.resolve(this.argContext);
            }
            ExpressionFunctions.checkAvailabilityOfChild(node, "enumItemValue");
            return Value.of((String)this.getEnumItemValue((ScalarConfig)node));
        }
        String description = "Function does not accept argument: " + this.function.getArgument(0).formatOutput(FormatOptions.DEFAULT, (IExpressionPrintable)this.function);
        return ExpressionFunctionsUtils.throwSevere(description, ExpressionFunctions.class, this.function);
    }

    public IValue getEnumItemDescription(IChild node) {
        if (node instanceof ScalarConfig) {
            ScalarConfig scalar = (ScalarConfig)node;
            if (scalar.getType() == ScalarConfig.Type.ENUM) {
                ExpressionFunctions.checkAvailabilityOfChild(scalar, "enumItemDescription");
                SetSetting.Item selectedEnumItem = this.getSelectedEnumItem(scalar);
                if (selectedEnumItem == null) {
                    return ExpressionFunctionsUtils.throwSevere("Selected item was not found", ExpressionFunctions.class, this.function);
                }
                Description description = selectedEnumItem.getDescription();
                String descriptionText = description == null ? null : description.getDescription(scalar.getExpressionContext());
                return Value.of((String)UtilsText.safeString((String)descriptionText));
            }
            return ExpressionFunctionsUtils.throwSevere("Given node is not an enum, but " + (Object)((Object)scalar.getType()), ExpressionFunctions.class, this.function);
        }
        return ExpressionFunctionsUtils.throwSevere("Given node is not scalar setting, but " + node.getClass().getSimpleName(), ExpressionFunctions.class, this.function);
    }

    public IValue getSetItemValue(IChild node, @Nullable IResolvable defaultValue) {
        if (node instanceof SetConfig.SetPresence) {
            if (!(defaultValue == null || node.isAvailable() && node.isEnabled())) {
                return defaultValue.resolve(this.argContext);
            }
            ExpressionFunctions.checkAvailabilityOfChild(node, "setItemValue");
            return Value.of((String)((SetConfig.SetPresence)node).getItem().getValue());
        }
        String description = "Function: " + this.function.getName() + " undefined for: " + this.function.getArgument(0).formatOutput(FormatOptions.DEFAULT, (IExpressionPrintable)this.function);
        return ExpressionFunctionsUtils.throwSevere(description, ExpressionFunctions.class, this.function);
    }

    public IValue findDuplicates(List<@NonNull ?> array, IFunction keyExpr) {
        ArrayList duplicates = new ArrayList();
        HashMap<Object, List> map = new HashMap<Object, List>();
        for (Object item : array) {
            Object key = keyExpr.invokeOn(this.argContext, new Object[]{item}).getValue();
            List values = map.getOrDefault(key, new ArrayList());
            values.add(item);
            map.put(key, values);
        }
        for (List dupes : map.values()) {
            if (dupes.size() <= 1) continue;
            duplicates.addAll(dupes);
        }
        return Value.of(duplicates);
    }

    public IValue formatMessage(String message, Object ... parameters) {
        return Value.of((String)UtilsText.safeString((String)MessageFormat.format(message, parameters)));
    }

    public IValue replaceText(String original, String textToReplace, String replacement) {
        return Value.of((String)UtilsText.safeString((String)original.replaceAll(Pattern.quote(textToReplace), Matcher.quoteReplacement(replacement))));
    }

    public boolean paramExists(String paramName) {
        String setting = "$param." + paramName;
        try {
            this.argContext.getSettingValue(setting);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public IValue join(List<?> list, String delimiter) {
        return Value.of((String)UtilsText.join(list, (String)delimiter));
    }

    public IValue nodeExists(@Nullable IChild node, String id) {
        return Value.of((ChildProviderHelper.getChild(node == null ? this.childContext : node.getChildContext(), id) != null ? 1 : 0) != 0);
    }

    public IValue frequencyToString(BigRational frequencyInHertz, int decimalPlaces) {
        Frequency frequency = Frequency.parseRational((BigRational)frequencyInHertz);
        String frequencyToString = ExpressionFunctions.frequencyToString(frequency, decimalPlaces);
        if (frequencyToString.equals(FREQUENCY_TO_STRING_INACTIVE)) {
            return Value.of((String)"0 Hz");
        }
        return Value.of((String)frequencyToString);
    }

    public IValue timeToString(BigRational timeInMicroSeconds) {
        TimePeriod time = new TimePeriod(timeInMicroSeconds, TimeUnit.MICRO_SECOND);
        time = TimeCalculator.normalize((TimePeriod)time);
        return Value.of((String)time.toString());
    }

    public IValue getPeripherals(String type) {
        return Value.of(this.mcu.getPeripherals(type));
    }

    public IValue getPeripheralClock(String peripheral, String clockRole) {
        String result = this.getClockFrequenciesFromClocks(peripheral, clockRole);
        if (result == null) {
            result = this.getClockFrequencyStringFromPeripheralSignal(peripheral, clockRole);
        }
        if (result == null) {
            result = this.getPeripheralSignalNameFromPinSignal(peripheral, clockRole);
        }
        if (result == null) {
            result = this.getDescriptionFromNoSignal(peripheral, clockRole);
        }
        if (result == null) {
            result = "";
            LOGGER.severe("[DATA] No signal defined for peripheral: " + peripheral + " and clock role: " + clockRole);
        }
        return Value.of((String)result);
    }

    public IValue getPeripheralClockDescription(String peripheral, String clockRole) {
        PeripheralComponentInput signal;
        String result = "";
        PeripheralComponent peripheralComponent = this.mcu.getClockConsumers().findPeriphComponentById(peripheral);
        if (peripheralComponent != null && (signal = peripheralComponent.findSignal(clockRole)) != null) {
            result = signal.getDescription();
        }
        return Value.of((String)result);
    }

    public IValue getPeripheralClockType(String peripheral, String clockRole) {
        String result = TYPE_NO_SIGNAL;
        PeripheralComponent peripheralComponent = this.mcu.getClockConsumers().findPeriphComponentById(peripheral);
        if (peripheralComponent != null) {
            PeripheralComponentInput signal = peripheralComponent.findSignal(clockRole);
            if (signal instanceof InputSignal) {
                result = TYPE_INPUT_SIGNAL;
            } else if (signal instanceof PeripheralSignal) {
                result = TYPE_PERIPHERAL_SIGNAL;
            } else if (signal instanceof PinSignal) {
                result = TYPE_PIN_SIGNAL;
            }
        }
        return Value.of((String)result);
    }

    public IValue getPeripheralClockFrequency(String peripheral, String clockRole, String functionalGroup) {
        Frequency result = this.getClockFrequencyFromClocks(peripheral, clockRole, functionalGroup);
        if (result == null) {
            result = this.getClockFrequencyFromPeripheralSignal(peripheral, clockRole);
        }
        if (result == null) {
            result = Frequency.ZERO;
            if (this.getPeripheralSignalNameFromPinSignal(peripheral, clockRole) == null && this.getDescriptionFromNoSignal(peripheral, clockRole) == null) {
                LOGGER.severe("[DATA] No signal defined for peripheral: " + peripheral + " and clock role: " + clockRole);
            }
        }
        return Value.of((long)ExpressionFunctions.toHertz(result));
    }

    public IValue peripheralClockExists(String peripheral, String clockRole) {
        boolean result = false;
        PeripheralComponent peripheralComponent = this.mcu.getClockConsumers().findPeriphComponentById(peripheral);
        if (peripheralComponent != null) {
            result = peripheralComponent.findSignal(clockRole) != null;
        }
        return Value.of((boolean)result);
    }

    public IValue getClockFunctionalGroups() {
        LinkedList namesWithFinalOrder = new LinkedList();
        if (Platform.isRunning()) {
            ISharedConfiguration configuration = SharedConfigurationFactory.getSharedConfigurationSingleton();
            IDependencyQuery queryEngine = DependencyQueryFactory.getQueryInstance((ISharedConfiguration)configuration);
            Collection queryResults = queryEngine.query(configuration, "Tool", "Clocks", "funcGroupNames");
            Set namesSet = (Set)CollectionsUtils.nullableOptionalGet(CollectionsUtils.getInstancesOf(queryResults.stream().map(x -> x.getValue()), Set.class).filter(set -> set.iterator().hasNext() && set.iterator().next() instanceof String).findFirst());
            List names = new ArrayList();
            if (namesSet != null) {
                names = (List)CollectionsUtils.getInstancesOf((Collection)namesSet, String.class).collect(CollectorsUtils.toList());
            }
            List initFGNames = new ArrayList();
            queryResults = queryEngine.query(configuration, "Tool", "Clocks", "initGroupNames");
            namesSet = (Set)CollectionsUtils.nullableOptionalGet(CollectionsUtils.getInstancesOf(queryResults.stream().map(x -> x.getValue()), Set.class).filter(set -> set.iterator().hasNext() && set.iterator().next() instanceof String).findFirst());
            if (namesSet != null) {
                initFGNames = (List)CollectionsUtils.getInstancesOf((Collection)namesSet, String.class).collect(CollectorsUtils.toList());
            }
            namesWithFinalOrder.addAll(initFGNames);
            names.removeAll(initFGNames);
            namesWithFinalOrder.addAll(names);
        }
        return Value.of(namesWithFinalOrder);
    }

    public IValue hasPeripheralClockSignal(String peripheral, String clockRole) {
        return Value.of((this.getPeripheralClockSignalName(peripheral, clockRole) != null ? 1 : 0) != 0);
    }

    public IValue getPeripheralClockSignal(String peripheral, String clockRole) {
        String result = this.getPeripheralClockSignalName(peripheral, clockRole);
        if (result == null) {
            String description = "[DATA] No signal defined for peripheral: " + peripheral + " and clock role: " + clockRole;
            return ExpressionFunctionsUtils.throwSevere(description, ExpressionFunctions.class, this.function);
        }
        return Value.of((String)result);
    }

    public IValue getSettingByKey(ArrayConfig array, String key) {
        ISettingConfig result = array.getSettingByKey(key, this.argContext);
        if (result == null) {
            String description = "Key: " + key + " does not exist in array with id:" + array.getId();
            return ExpressionFunctionsUtils.throwSevere(description, ExpressionFunctions.class, this.function);
        }
        return Value.of((Object)result);
    }

    public IValue settingWithKeyExists(ArrayConfig array, String key) {
        return Value.of((boolean)array.settingWithKeyExists(key, this.argContext));
    }

    public IValue getSettingKey(ISettingConfig setting) {
        ArrayConfig array;
        IChildProvidable parent = setting.getChildContext().getParent();
        ArrayConfig arrayConfig = array = !(parent instanceof ArrayConfig) ? null : (ArrayConfig)parent;
        if (array == null || !array.getChildren().contains(setting)) {
            String description = "Setting: " + setting + " is not a part of the array: " + array;
            return ExpressionFunctionsUtils.throwSevere(description, ExpressionFunctions.class, this.function);
        }
        return Value.of((String)UtilsText.safeString((String)array.getSettingKey(setting, this.argContext)));
    }

    public IValue toHertz(String input) {
        return ExpressionFunctions.getBestFittingTypeOfValue(this.toHertzFloat(input).getBigInteger());
    }

    public IValue toHertzFloat(String input) {
        if (!input.toLowerCase().endsWith("hz")) {
            input = String.valueOf(input) + "Hz";
        }
        try {
            Frequency frequency = Frequency.parseNonNull((String)input);
            return Value.of((BigRational)ExpressionFunctions.toHertzFloat(frequency));
        }
        catch (IllegalArgumentException e) {
            return ExpressionFunctionsUtils.throwSevere(UtilsText.safeString((String)e.getLocalizedMessage()), ExpressionFunctions.class, this.function);
        }
    }

    public IValue isPeripheralAvailable(String peripheralName, String coreId) {
        return Value.of((boolean)this.mcu.isPeripheralAvailableForCore(coreId, peripheralName));
    }

    public IValue getFreq(String value, String desiredUnits, @Nullable String defaultUnits) {
        return ExpressionFunctions.getBestFittingTypeOfValue(this.getFreqFloat(value, desiredUnits, defaultUnits).getBigInteger());
    }

    public IValue getFreqFloat(String value, String desiredUnits, @Nullable String defaultUnits) {
        Frequency frequency;
        try {
            frequency = ExpressionFunctions.getFrequencyObject(value, defaultUnits == null ? UtilsText.safeString((String)FrequencyUnit.HERTZ.toString()) : defaultUnits);
        }
        catch (ExpressionException e) {
            e.setFunction(this.function);
            throw e;
        }
        FrequencyUnit desiredUnitObject = FrequencyUnit.parse((String)desiredUnits);
        if (desiredUnitObject == null) {
            String description = "The desired units: `" + desiredUnits + "` are not valid";
            return ExpressionFunctionsUtils.throwSevere(description, ExpressionFunctions.class, this.function);
        }
        frequency = FrequencyCalculator.toUnit((Frequency)frequency, (FrequencyUnit)desiredUnitObject);
        return Value.of((BigRational)frequency.getValue());
    }

    public IValue getTime(String value, String desiredUnits, @Nullable String defaultUnits) {
        return ExpressionFunctions.getBestFittingTypeOfValue(this.getTimeFloat(value, desiredUnits, defaultUnits).getBigInteger());
    }

    public IValue getTimeFloat(String value, String desiredUnits, @Nullable String defaultUnits) {
        TimePeriod timePeriod;
        String defaultUnitNonNull = defaultUnits == null ? TimeUnit.MICRO_SECOND.toString() : defaultUnits;
        try {
            Frequency frequency = ExpressionFunctions.getFrequencyObject(value, defaultUnitNonNull);
            frequency = FrequencyCalculator.toUnit((Frequency)frequency, (FrequencyUnit)FrequencyUnit.HERTZ);
            BigRational rational = frequency.getValue().swap();
            timePeriod = new TimePeriod(rational, TimeUnit.SECOND);
        }
        catch (Exception exception) {
            timePeriod = TimePeriod.parse((String)AbstractUnit.prepareForParsing((String)value, (String)defaultUnitNonNull));
        }
        if (timePeriod == null) {
            String description = "Value " + value + " cannot be parsed";
            return ExpressionFunctionsUtils.throwSevere(description, ExpressionFunctions.class, this.function);
        }
        TimeUnit wantedUnitObject = TimeUnit.parse((String)desiredUnits);
        if (wantedUnitObject == null) {
            String description = "The desired units are not valid in function " + this.function.getName();
            return ExpressionFunctionsUtils.throwSevere(description, ExpressionFunctions.class, this.function);
        }
        timePeriod = TimeCalculator.toUnit((TimePeriod)timePeriod, (TimeUnit)wantedUnitObject);
        return Value.of((BigRational)timePeriod.getValue());
    }

    public IValue isFreq(String value) {
        return Value.of((boolean)Frequency.isFrequency((String)value));
    }

    public IValue isTime(String value) {
        return Value.of((boolean)TimePeriod.isTime((String)value));
    }

    public IValue getSubType(IChild config) {
        String type = "";
        if (!(config instanceof ISettingConfig)) {
            String description = "Function getSubType cannot work with " + config.getTypeName();
            return ExpressionFunctionsUtils.throwSevere(description, ExpressionFunctions.class, this.function);
        }
        ISetting setting = ((ISettingConfig)config).getModelData();
        if (setting instanceof ArraySetting) {
            type = ((ArraySetting)setting).getReferenceID();
        }
        if (setting instanceof IntegerSetting) {
            type = ((IntegerSetting)setting).getType().toString();
        }
        if (setting instanceof FloatSetting) {
            type = ((FloatSetting)setting).getType().toString();
        }
        return Value.of((String)type);
    }

    public IValue getComponentInstances(IChild node, String componentTypeId) {
        IFunctionalGroup functionalGroup = node.getChildContext().getFunctionalGroup();
        if (functionalGroup == null) {
            String description = "Given IChild node " + this.function.getArgument(0).formatOutput(FormatOptions.DEFAULT, (IExpressionPrintable)this.function) + " has no functional group assigned";
            return ExpressionFunctionsUtils.throwSevere(description, ExpressionFunctions.class, this.function);
        }
        return Value.of(functionalGroup.getInstancesOfType(componentTypeId));
    }

    public IValue getSdkBasePointer(IChild node) {
        IRegParentPeripheralAPI peripheral;
        String peripheralName = ExpressionFunctions.getPeripheral(node.getChildContext());
        if (peripheralName == null) {
            LOGGER.warning("[DATA] Trying to get sdk base pointer on Setting with id: \"" + node.getId() + "\". Peripheral for component instance config is not defined");
            return Value.of((String)"");
        }
        IRegistersDatabaseAPI registersDB = this.mcu.getRegistersDb();
        IRegParentPeripheralAPI iRegParentPeripheralAPI = peripheral = registersDB != null ? registersDB.getPeripheral(peripheralName) : null;
        if (peripheral == null) {
            LOGGER.warning("[DATA] Trying to get sdk base pointer on Setting with id: \"" + node.getId() + "\". Peripheral with name \"" + peripheralName + "\" was not found in register DB");
            return Value.of((String)"");
        }
        String alias = peripheral.getAlias("sdk_base_pointer");
        if (alias == null) {
            return Value.of((String)peripheralName);
        }
        return Value.of((String)alias);
    }

    public IValue floor(BigRational input, int precision) {
        if (precision < 0) {
            ExpressionFunctionsUtils.throwSevere("Precicion digits are set below zero!", ExpressionFunctions.class, this.function);
        }
        return Value.of((BigRational)input.floor(precision));
    }

    public IValue ceil(BigRational input, int precision) {
        if (precision < 0) {
            ExpressionFunctionsUtils.throwSevere("Precicion digits are set below zero!", ExpressionFunctions.class, this.function);
        }
        return Value.of((BigRational)input.ceil(precision));
    }

    public IValue round(BigRational input, int precision) {
        if (precision < 0) {
            ExpressionFunctionsUtils.throwSevere("Precicion digits are set below zero!", ExpressionFunctions.class, this.function);
        }
        return Value.of((BigRational)input.round(precision));
    }

    public IValue getChildren(IChild node) {
        if (!(node instanceof IChildProvidable)) {
            return Value.of(Collections.emptyList());
        }
        IChildProvidable providable = (IChildProvidable)node;
        return Value.of(providable.getChildren());
    }

    public IValue floatToString(BigRational input, int precision) {
        IComponentConfig currentComponent;
        if (precision < 0) {
            ExpressionFunctionsUtils.throwSevere("[DATA] Significant digits are set below zero!", ExpressionFunctions.class, this.function);
        }
        if (precision > 34) {
            LOGGER.log(Level.WARNING, "[DATA] Precision of {0} digits is over supported 34 significant digits", precision);
        }
        if ((currentComponent = this.childContext.getComponentConfig()) != null && currentComponent.getComponent().schemaVersionOlderThan("7.0")) {
            return Value.of((String)input.toString(precision));
        }
        return Value.of((String)input.formatWithSignificantPlaces(precision));
    }

    public IValue enumItemsOfType(IChild node, String path) {
        IConfigSetConfig configSetConfig = node.getChildContext().getConfigSetConfig();
        if (configSetConfig == null) {
            return ExpressionFunctionsUtils.throwSevere("Config set of given node cannot be found", ExpressionFunctions.class, this.function);
        }
        ISetting setting = configSetConfig.getConfigSet().find(path);
        if (setting == null) {
            return ExpressionFunctionsUtils.throwSevere("Setting with given ID \"" + path + "\" was not be found", ExpressionFunctions.class, this.function);
        }
        if (setting instanceof EnumSetting) {
            EnumSetting enumSetting = (EnumSetting)setting;
            List items = (List)enumSetting.getItems().stream().filter(i -> i.isAvailable(this.argContext)).collect(CollectorsUtils.toList());
            return Value.of((Object)items);
        }
        return ExpressionFunctionsUtils.throwSevere("Found setting is not enum setting", ExpressionFunctions.class, this.function);
    }

    public IValue getBitFieldResetValue(String peripheralName, String registerName, String bitfieldName) {
        BigInteger result = RegistersModelSingleton.getResetValueOfBitfieldInternal(this.mcu, peripheralName, registerName, bitfieldName);
        if (result == RegistersModelSingleton.ERROR_REGISTER_DATABASE_NOT_FOUND) {
            return ExpressionFunctionsUtils.throwSevere(REGISTER_DATABASE_CANNOT_BE_FOUND, ExpressionFunctions.class, this.function);
        }
        if (result == RegistersModelSingleton.ERROR_PERIPHERAL_NOT_FOUND) {
            return ExpressionFunctionsUtils.throwSevere(MessageFormat.format(PERIPHERAL_CANNOT_BE_FOUND, peripheralName), ExpressionFunctions.class, this.function);
        }
        if (result == RegistersModelSingleton.ERROR_REGISTER_NOT_FOUND) {
            return ExpressionFunctionsUtils.throwSevere(MessageFormat.format(REGISTER_CANNOT_BE_FOUND, registerName), ExpressionFunctions.class, this.function);
        }
        if (result == RegistersModelSingleton.ERROR_BITFIELD_NOT_FOUND) {
            return ExpressionFunctionsUtils.throwSevere(MessageFormat.format(BITFIELD_CANNOT_BE_FOUND, bitfieldName), ExpressionFunctions.class, this.function);
        }
        return Value.of((BigInteger)result);
    }

    public IValue getRegisterResetValue(String peripheralName, String registerName) {
        BigInteger result = RegistersModelSingleton.getResetValueOfRegisterInternal(this.mcu, peripheralName, registerName);
        if (result == RegistersModelSingleton.ERROR_REGISTER_DATABASE_NOT_FOUND) {
            return ExpressionFunctionsUtils.throwSevere(REGISTER_DATABASE_CANNOT_BE_FOUND, ExpressionFunctions.class, this.function);
        }
        if (result == RegistersModelSingleton.ERROR_PERIPHERAL_NOT_FOUND) {
            return ExpressionFunctionsUtils.throwSevere(MessageFormat.format(PERIPHERAL_CANNOT_BE_FOUND, peripheralName), ExpressionFunctions.class, this.function);
        }
        if (result == RegistersModelSingleton.ERROR_REGISTER_NOT_FOUND) {
            return ExpressionFunctionsUtils.throwSevere(MessageFormat.format(REGISTER_CANNOT_BE_FOUND, registerName), ExpressionFunctions.class, this.function);
        }
        return Value.of((BigInteger)result);
    }

    public IValue getRegisterAddress(String peripheralName, String registerName, @Nullable String mode) {
        String core = this.childContext.getRoot().getActiveCoreId();
        BigInteger result = ExpressionFunctions.getAddressOfRegisterInternal(this.mcu, peripheralName, registerName, core, mode);
        if (result == RegistersModelSingleton.ERROR_REGISTER_DATABASE_NOT_FOUND) {
            return ExpressionFunctionsUtils.throwSevere(REGISTER_DATABASE_CANNOT_BE_FOUND, ExpressionFunctions.class, this.function);
        }
        if (result == RegistersModelSingleton.ERROR_PERIPHERAL_NOT_FOUND) {
            return ExpressionFunctionsUtils.throwSevere(MessageFormat.format(PERIPHERAL_CANNOT_BE_FOUND, peripheralName), ExpressionFunctions.class, this.function);
        }
        if (result == RegistersModelSingleton.ERROR_REGISTER_NOT_FOUND) {
            return ExpressionFunctionsUtils.throwSevere(MessageFormat.format(REGISTER_CANNOT_BE_FOUND, registerName), ExpressionFunctions.class, this.function);
        }
        if (result == RegistersModelSingleton.ERROR_REGISTER_BASE_ADDRESS_NOT_FOUND) {
            return ExpressionFunctionsUtils.throwSevere(MessageFormat.format(BASE_OF_REGISTER_WITH_GIVEN_NAME_CANNOT_BE_FOUND, registerName), ExpressionFunctions.class, this.function);
        }
        return Value.of((BigInteger)result);
    }

    public IValue getBitfieldOffset(String peripheralName, String registerName, String bitfieldName) {
        BigInteger result = ExpressionFunctions.getOffsetOfBitfieldInternal(this.mcu, peripheralName, registerName, bitfieldName);
        if (result == RegistersModelSingleton.ERROR_REGISTER_DATABASE_NOT_FOUND) {
            return ExpressionFunctionsUtils.throwSevere(REGISTER_DATABASE_CANNOT_BE_FOUND, ExpressionFunctions.class, this.function);
        }
        if (result == RegistersModelSingleton.ERROR_PERIPHERAL_NOT_FOUND) {
            return ExpressionFunctionsUtils.throwSevere(MessageFormat.format(PERIPHERAL_CANNOT_BE_FOUND, peripheralName), ExpressionFunctions.class, this.function);
        }
        if (result == RegistersModelSingleton.ERROR_REGISTER_NOT_FOUND) {
            return ExpressionFunctionsUtils.throwSevere(MessageFormat.format(REGISTER_CANNOT_BE_FOUND, registerName), ExpressionFunctions.class, this.function);
        }
        if (result == RegistersModelSingleton.ERROR_BITFIELD_NOT_FOUND) {
            return ExpressionFunctionsUtils.throwSevere(MessageFormat.format(BITFIELD_CANNOT_BE_FOUND, bitfieldName), ExpressionFunctions.class, this.function);
        }
        return Value.of((BigInteger)result);
    }

    public IValue getBitFieldWidth(String peripheralName, String registerName, String bitfieldName) {
        BigInteger result = ExpressionFunctions.getBitFieldWidthInternal(this.mcu, peripheralName, registerName, bitfieldName);
        if (result == RegistersModelSingleton.ERROR_REGISTER_DATABASE_NOT_FOUND) {
            return ExpressionFunctionsUtils.throwSevere(REGISTER_DATABASE_CANNOT_BE_FOUND, ExpressionFunctions.class, this.function);
        }
        if (result == RegistersModelSingleton.ERROR_PERIPHERAL_NOT_FOUND) {
            return ExpressionFunctionsUtils.throwSevere(MessageFormat.format(PERIPHERAL_CANNOT_BE_FOUND, peripheralName), ExpressionFunctions.class, this.function);
        }
        if (result == RegistersModelSingleton.ERROR_REGISTER_NOT_FOUND) {
            return ExpressionFunctionsUtils.throwSevere(MessageFormat.format(REGISTER_CANNOT_BE_FOUND, registerName), ExpressionFunctions.class, this.function);
        }
        if (result == RegistersModelSingleton.ERROR_BITFIELD_NOT_FOUND) {
            return ExpressionFunctionsUtils.throwSevere(MessageFormat.format(BITFIELD_CANNOT_BE_FOUND, bitfieldName), ExpressionFunctions.class, this.function);
        }
        return Value.of((BigInteger)result);
    }

    public IValue getBitFieldValue(String peripheralName, String registerName, String bitfieldName) {
        IFunctionalGroup functionalGroup = this.childContext.getFunctionalGroup();
        if (functionalGroup == null) {
            return ExpressionFunctionsUtils.throwSevere("Functional group is null", ExpressionFunctions.class, this.function);
        }
        BigInteger result = ExpressionFunctions.getBitFieldValueInternal(functionalGroup, peripheralName, registerName, bitfieldName);
        if (result == RegistersModelSingleton.ERROR_REGISTER_DATABASE_NOT_FOUND) {
            return ExpressionFunctionsUtils.throwSevere(REGISTER_DATABASE_CANNOT_BE_FOUND, ExpressionFunctions.class, this.function);
        }
        if (result == RegistersModelSingleton.ERROR_PERIPHERAL_NOT_FOUND) {
            return ExpressionFunctionsUtils.throwSevere(MessageFormat.format(PERIPHERAL_CANNOT_BE_FOUND, peripheralName), ExpressionFunctions.class, this.function);
        }
        if (result == RegistersModelSingleton.ERROR_REGISTER_NOT_FOUND) {
            return ExpressionFunctionsUtils.throwSevere(MessageFormat.format(REGISTER_CANNOT_BE_FOUND, registerName), ExpressionFunctions.class, this.function);
        }
        if (result == RegistersModelSingleton.ERROR_BITFIELD_NOT_FOUND) {
            return ExpressionFunctionsUtils.throwSevere(MessageFormat.format(BITFIELD_CANNOT_BE_FOUND, bitfieldName), ExpressionFunctions.class, this.function);
        }
        return Value.of((BigInteger)result);
    }

    public IValue getRegisterValue(String peripheralName, String registerName) {
        IFunctionalGroup functionalGroup = this.childContext.getFunctionalGroup();
        if (functionalGroup == null) {
            return ExpressionFunctionsUtils.throwSevere("Functional group is null", ExpressionFunctions.class, this.function);
        }
        BigInteger result = ExpressionFunctions.getRegisterValueInternal(functionalGroup, peripheralName, registerName);
        if (result == RegistersModelSingleton.ERROR_REGISTER_DATABASE_NOT_FOUND) {
            return ExpressionFunctionsUtils.throwSevere(REGISTER_DATABASE_CANNOT_BE_FOUND, ExpressionFunctions.class, this.function);
        }
        if (result == RegistersModelSingleton.ERROR_PERIPHERAL_NOT_FOUND) {
            return ExpressionFunctionsUtils.throwSevere(MessageFormat.format(PERIPHERAL_CANNOT_BE_FOUND, peripheralName), ExpressionFunctions.class, this.function);
        }
        if (result == RegistersModelSingleton.ERROR_REGISTER_NOT_FOUND) {
            return ExpressionFunctionsUtils.throwSevere(MessageFormat.format(REGISTER_CANNOT_BE_FOUND, registerName), ExpressionFunctions.class, this.function);
        }
        return Value.of((BigInteger)result);
    }

    public IValue getRegisters(String peripheralName) {
        return Value.of(ExpressionFunctions.getRegistersInternal(this.mcu, peripheralName));
    }

    public IValue getBitfields(String peripheralName, String registerName) {
        return Value.of(ExpressionFunctions.getBitfieldsInternal(this.mcu, peripheralName, registerName));
    }

    public IValue peripheralExists(String peripheralName) {
        return Value.of((boolean)ExpressionFunctions.peripheralExists(this.mcu, peripheralName));
    }

    public IValue registerExists(String peripheralName, String registerName) {
        return Value.of((boolean)ExpressionFunctions.registerExists(this.mcu, peripheralName, registerName));
    }

    public IValue bitfieldExists(String peripheralName, String registerName, String bitfieldName) {
        return Value.of((boolean)ExpressionFunctions.bitfieldExists(this.mcu, peripheralName, registerName, bitfieldName));
    }

    public IValue getPeripheralBaseAddress(String peripheralIdentification, String coreId, @Nullable String mode) {
        BigInteger result = ExpressionFunctions.getPeripheralBaseAddressInternal(this.mcu, peripheralIdentification, coreId, mode);
        if (result == RegistersModelSingleton.ERROR_REGISTER_DATABASE_NOT_FOUND) {
            return ExpressionFunctionsUtils.throwSevere(REGISTER_DATABASE_CANNOT_BE_FOUND, ExpressionFunctions.class, this.function);
        }
        if (result == RegistersModelSingleton.ERROR_PERIPHERAL_NOT_FOUND) {
            return ExpressionFunctionsUtils.throwSevere(MessageFormat.format(PERIPHERAL_CANNOT_BE_FOUND, peripheralIdentification), ExpressionFunctions.class, this.function);
        }
        if (result == RegistersModelSingleton.ERROR_PERIPHERAL_BASE_ADDRESS_NOT_FOUND) {
            return ExpressionFunctionsUtils.throwSevere(MessageFormat.format(BASE_OF_PERIPHERAL_WITH_GIVEN_NAME_CANNOT_BE_FOUND, peripheralIdentification), ExpressionFunctions.class, this.function);
        }
        return Value.of((BigInteger)result);
    }

    public IValue getRegisterOffset(String peripheralIdentification, String registerIdentification) {
        BigInteger result = ExpressionFunctions.getRegisterOffsetInternal(this.mcu, peripheralIdentification, registerIdentification);
        if (result == RegistersModelSingleton.ERROR_REGISTER_DATABASE_NOT_FOUND) {
            return ExpressionFunctionsUtils.throwSevere(REGISTER_DATABASE_CANNOT_BE_FOUND, ExpressionFunctions.class, this.function);
        }
        if (result == RegistersModelSingleton.ERROR_PERIPHERAL_NOT_FOUND) {
            return ExpressionFunctionsUtils.throwSevere(MessageFormat.format(PERIPHERAL_CANNOT_BE_FOUND, peripheralIdentification), ExpressionFunctions.class, this.function);
        }
        if (result == RegistersModelSingleton.ERROR_REGISTER_NOT_FOUND) {
            return ExpressionFunctionsUtils.throwSevere(MessageFormat.format(REGISTER_CANNOT_BE_FOUND, registerIdentification), ExpressionFunctions.class, this.function);
        }
        return Value.of((BigInteger)result);
    }

    public IValue getRegisterWidth(String peripheralIdentification, String registerIdentification) {
        BigInteger result = ExpressionFunctions.getRegisterWidthInternal(this.mcu, peripheralIdentification, registerIdentification);
        if (result == RegistersModelSingleton.ERROR_REGISTER_DATABASE_NOT_FOUND) {
            return ExpressionFunctionsUtils.throwSevere(REGISTER_DATABASE_CANNOT_BE_FOUND, ExpressionFunctions.class, this.function);
        }
        if (result == RegistersModelSingleton.ERROR_PERIPHERAL_NOT_FOUND) {
            return ExpressionFunctionsUtils.throwSevere(MessageFormat.format(PERIPHERAL_CANNOT_BE_FOUND, peripheralIdentification), ExpressionFunctions.class, this.function);
        }
        if (result == RegistersModelSingleton.ERROR_REGISTER_NOT_FOUND) {
            return ExpressionFunctionsUtils.throwSevere(MessageFormat.format(REGISTER_CANNOT_BE_FOUND, registerIdentification), ExpressionFunctions.class, this.function);
        }
        return Value.of((BigInteger)result);
    }

    public IValue getRegisterName(String peripheralIdentification, String registerIdentification) {
        // Could not load outer class - annotation placement on inner may be incorrect
        CollectionsUtils.Pair<@Nullable String, BigInteger> result = ExpressionFunctions.getRegisterNameInternal(this.mcu, peripheralIdentification, registerIdentification);
        if (result.getSecond() == RegistersModelSingleton.ERROR_REGISTER_DATABASE_NOT_FOUND) {
            return ExpressionFunctionsUtils.throwSevere(REGISTER_DATABASE_CANNOT_BE_FOUND, ExpressionFunctions.class, this.function);
        }
        if (result.getSecond() == RegistersModelSingleton.ERROR_PERIPHERAL_NOT_FOUND) {
            return ExpressionFunctionsUtils.throwSevere(MessageFormat.format(PERIPHERAL_CANNOT_BE_FOUND, peripheralIdentification), ExpressionFunctions.class, this.function);
        }
        if (result.getSecond() == RegistersModelSingleton.ERROR_REGISTER_NOT_FOUND) {
            return ExpressionFunctionsUtils.throwSevere(MessageFormat.format(REGISTER_CANNOT_BE_FOUND, registerIdentification), ExpressionFunctions.class, this.function);
        }
        return Value.of((String)UtilsText.safeString((String)((String)result.getFirst())));
    }

    public IValue getPeripheralAliasValue(String peripheralIdentification, String aliasType) {
        // Could not load outer class - annotation placement on inner may be incorrect
        CollectionsUtils.Pair<@Nullable String, BigInteger> result = ExpressionFunctions.getPeripheralAliasValueInternal(this.mcu, peripheralIdentification, aliasType);
        if (result.getSecond() == RegistersModelSingleton.ERROR_REGISTER_DATABASE_NOT_FOUND) {
            return ExpressionFunctionsUtils.throwSevere(REGISTER_DATABASE_CANNOT_BE_FOUND, ExpressionFunctions.class, this.function);
        }
        if (result.getSecond() == RegistersModelSingleton.ERROR_PERIPHERAL_NOT_FOUND) {
            return ExpressionFunctionsUtils.throwSevere(MessageFormat.format(PERIPHERAL_CANNOT_BE_FOUND, peripheralIdentification), ExpressionFunctions.class, this.function);
        }
        if (result.getSecond() == RegistersModelSingleton.ERROR_ALIAS_WITH_TYPE_NOT_FOUND) {
            return ExpressionFunctionsUtils.throwSevere(MessageFormat.format(ALIAS_CANNOT_BE_FOUND, aliasType), ExpressionFunctions.class, this.function);
        }
        return Value.of((String)UtilsText.safeString((String)((String)result.getFirst())));
    }

    public IValue hasPeripheralAliasValue(String peripheralIdentification, String aliasType) {
        // Could not load outer class - annotation placement on inner may be incorrect
        CollectionsUtils.Pair<@Nullable String, BigInteger> result = ExpressionFunctions.getPeripheralAliasValueInternal(this.mcu, peripheralIdentification, aliasType);
        if (result.getSecond() == RegistersModelSingleton.ERROR_REGISTER_DATABASE_NOT_FOUND) {
            return ExpressionFunctionsUtils.throwSevere(REGISTER_DATABASE_CANNOT_BE_FOUND, ExpressionFunctions.class, this.function);
        }
        if (result.getSecond() == RegistersModelSingleton.ERROR_PERIPHERAL_NOT_FOUND) {
            return ExpressionFunctionsUtils.throwSevere(MessageFormat.format(PERIPHERAL_CANNOT_BE_FOUND, peripheralIdentification), ExpressionFunctions.class, this.function);
        }
        if (result.getSecond() == RegistersModelSingleton.ERROR_ALIAS_WITH_TYPE_NOT_FOUND) {
            return Value.of((boolean)false);
        }
        return Value.of((boolean)true);
    }

    public IValue getRegisterAliasValue(String peripheralIdentification, String registerIdentification, String aliasType) {
        // Could not load outer class - annotation placement on inner may be incorrect
        CollectionsUtils.Pair<@Nullable String, BigInteger> result = ExpressionFunctions.getRegisterAliasValueInternal(this.mcu, peripheralIdentification, registerIdentification, aliasType);
        if (result.getSecond() == RegistersModelSingleton.ERROR_REGISTER_DATABASE_NOT_FOUND) {
            return ExpressionFunctionsUtils.throwSevere(REGISTER_DATABASE_CANNOT_BE_FOUND, ExpressionFunctions.class, this.function);
        }
        if (result.getSecond() == RegistersModelSingleton.ERROR_PERIPHERAL_NOT_FOUND) {
            return ExpressionFunctionsUtils.throwSevere(MessageFormat.format(PERIPHERAL_CANNOT_BE_FOUND, peripheralIdentification), ExpressionFunctions.class, this.function);
        }
        if (result.getSecond() == RegistersModelSingleton.ERROR_REGISTER_NOT_FOUND) {
            return ExpressionFunctionsUtils.throwSevere(MessageFormat.format(REGISTER_CANNOT_BE_FOUND, registerIdentification), ExpressionFunctions.class, this.function);
        }
        if (result.getSecond() == RegistersModelSingleton.ERROR_ALIAS_WITH_TYPE_NOT_FOUND) {
            return ExpressionFunctionsUtils.throwSevere(MessageFormat.format(ALIAS_CANNOT_BE_FOUND, aliasType), ExpressionFunctions.class, this.function);
        }
        return Value.of((String)UtilsText.safeString((String)((String)result.getFirst())));
    }

    public IValue hasRegisterAliasValue(String peripheralIdentification, String registerIdentification, String aliasType) {
        // Could not load outer class - annotation placement on inner may be incorrect
        CollectionsUtils.Pair<@Nullable String, BigInteger> result = ExpressionFunctions.getRegisterAliasValueInternal(this.mcu, peripheralIdentification, registerIdentification, aliasType);
        if (result.getSecond() == RegistersModelSingleton.ERROR_REGISTER_DATABASE_NOT_FOUND) {
            return ExpressionFunctionsUtils.throwSevere(REGISTER_DATABASE_CANNOT_BE_FOUND, ExpressionFunctions.class, this.function);
        }
        if (result.getSecond() == RegistersModelSingleton.ERROR_PERIPHERAL_NOT_FOUND) {
            return ExpressionFunctionsUtils.throwSevere(MessageFormat.format(PERIPHERAL_CANNOT_BE_FOUND, peripheralIdentification), ExpressionFunctions.class, this.function);
        }
        if (result.getSecond() == RegistersModelSingleton.ERROR_REGISTER_NOT_FOUND) {
            return ExpressionFunctionsUtils.throwSevere(MessageFormat.format(REGISTER_CANNOT_BE_FOUND, registerIdentification), ExpressionFunctions.class, this.function);
        }
        if (result.getSecond() == RegistersModelSingleton.ERROR_ALIAS_WITH_TYPE_NOT_FOUND) {
            return Value.of((boolean)false);
        }
        return Value.of((boolean)true);
    }

    public IValue getBitFieldAliasValue(String peripheralIdentification, String registerIdentification, String bitfieldIdentification, String aliasType) {
        // Could not load outer class - annotation placement on inner may be incorrect
        CollectionsUtils.Pair<@Nullable String, BigInteger> result = ExpressionFunctions.getBitFieldAliasValueInternal(this.mcu, peripheralIdentification, registerIdentification, bitfieldIdentification, aliasType);
        if (result.getSecond() == RegistersModelSingleton.ERROR_REGISTER_DATABASE_NOT_FOUND) {
            return ExpressionFunctionsUtils.throwSevere(REGISTER_DATABASE_CANNOT_BE_FOUND, ExpressionFunctions.class, this.function);
        }
        if (result.getSecond() == RegistersModelSingleton.ERROR_PERIPHERAL_NOT_FOUND) {
            return ExpressionFunctionsUtils.throwSevere(MessageFormat.format(PERIPHERAL_CANNOT_BE_FOUND, peripheralIdentification), ExpressionFunctions.class, this.function);
        }
        if (result.getSecond() == RegistersModelSingleton.ERROR_REGISTER_NOT_FOUND) {
            return ExpressionFunctionsUtils.throwSevere(MessageFormat.format(REGISTER_CANNOT_BE_FOUND, registerIdentification), ExpressionFunctions.class, this.function);
        }
        if (result.getSecond() == RegistersModelSingleton.ERROR_BITFIELD_NOT_FOUND) {
            return ExpressionFunctionsUtils.throwSevere(MessageFormat.format(BITFIELD_CANNOT_BE_FOUND, bitfieldIdentification), ExpressionFunctions.class, this.function);
        }
        if (result.getSecond() == RegistersModelSingleton.ERROR_ALIAS_WITH_TYPE_NOT_FOUND) {
            return ExpressionFunctionsUtils.throwSevere(MessageFormat.format(ALIAS_CANNOT_BE_FOUND, aliasType), ExpressionFunctions.class, this.function);
        }
        return Value.of((String)UtilsText.safeString((String)((String)result.getFirst())));
    }

    public IValue hasBitFieldAliasValue(String peripheralIdentification, String registerIdentification, String bitfieldIdentification, String aliasType) {
        // Could not load outer class - annotation placement on inner may be incorrect
        CollectionsUtils.Pair<@Nullable String, BigInteger> result = ExpressionFunctions.getBitFieldAliasValueInternal(this.mcu, peripheralIdentification, registerIdentification, bitfieldIdentification, aliasType);
        if (result.getSecond() == RegistersModelSingleton.ERROR_REGISTER_DATABASE_NOT_FOUND) {
            return ExpressionFunctionsUtils.throwSevere(REGISTER_DATABASE_CANNOT_BE_FOUND, ExpressionFunctions.class, this.function);
        }
        if (result.getSecond() == RegistersModelSingleton.ERROR_PERIPHERAL_NOT_FOUND) {
            return ExpressionFunctionsUtils.throwSevere(MessageFormat.format(PERIPHERAL_CANNOT_BE_FOUND, peripheralIdentification), ExpressionFunctions.class, this.function);
        }
        if (result.getSecond() == RegistersModelSingleton.ERROR_REGISTER_NOT_FOUND) {
            return ExpressionFunctionsUtils.throwSevere(MessageFormat.format(REGISTER_CANNOT_BE_FOUND, registerIdentification), ExpressionFunctions.class, this.function);
        }
        if (result.getSecond() == RegistersModelSingleton.ERROR_BITFIELD_NOT_FOUND) {
            return ExpressionFunctionsUtils.throwSevere(MessageFormat.format(BITFIELD_CANNOT_BE_FOUND, bitfieldIdentification), ExpressionFunctions.class, this.function);
        }
        if (result.getSecond() == RegistersModelSingleton.ERROR_ALIAS_WITH_TYPE_NOT_FOUND) {
            return Value.of((boolean)false);
        }
        return Value.of((boolean)true);
    }

    public IValue getAssignedPeripherals(IChild node) {
        return Value.of(ExpressionFunctions.getAssignedPeripheralsInternal(node));
    }

    public IValue getAssignedRegisters(IChild node, String peripheralIdentification) {
        return Value.of(ExpressionFunctions.getAssignedRegistersInternal(node, peripheralIdentification));
    }

    public IValue getAssignedBitFields(IChild node, String peripheralIdentification, String registerIdentification) {
        return Value.of(ExpressionFunctions.getAssignedBitFieldsInternal(node, peripheralIdentification, registerIdentification));
    }

    public IValue getHash(String algorithm, String data) {
        try {
            MessageDigest hashAlgorithm = MessageDigest.getInstance(algorithm.toUpperCase());
            byte[] hash = hashAlgorithm.digest(data.getBytes("utf-8"));
            StringBuilder joiner = new StringBuilder();
            byte[] byArray = hash;
            int n = hash.length;
            int n2 = 0;
            while (n2 < n) {
                byte b = byArray[n2];
                String string = Integer.toString((b & 0xFF) + 256, 16);
                joiner.append(string.substring(1));
                ++n2;
            }
            return Value.of((String)joiner.toString());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return ExpressionFunctionsUtils.throwSevere(MessageFormat.format("Algorithm {0} is not implemented", algorithm), ExpressionFunctions.class, this.function);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return ExpressionFunctionsUtils.throwSevere("UTF-8 encoding is not supported on this platform", ExpressionFunctions.class, this.function);
        }
    }

    public IValue isSdkComponentDefined(String driver) {
        return Value.of((boolean)this.childContext.getRoot().isDriverDefined(driver));
    }

    public IValue getDefinedSdkComponentsVersions(String driver) {
        return Value.of(this.childContext.getRoot().getDefinedDriverVersions(driver).stream().sorted((a, b) -> b.compareTo((String)a)).collect(CollectorsUtils.toList()));
    }

    public IValue isVersionInRange(String versionStringToCheck, String minimalVersionString, String maximalVersionString, @Nullable String mode) {
        try {
            return Value.of((boolean)ExpressionFunctions.isVersionInRangeInternal(versionStringToCheck, minimalVersionString, maximalVersionString, mode));
        }
        catch (IllegalArgumentException e) {
            return ExpressionFunctionsUtils.throwSevere("Problem occured when checking the range, see following expcetption: " + e.getLocalizedMessage(), ExpressionFunctions.class, this.function);
        }
    }

    public IValue getClockGatePeripheral(String peripheralName) {
        IRegClockGateConfigAPI peripheral = ExpressionFunctions.getClockGateInternal(this.mcu, peripheralName, null);
        if (peripheral == null) {
            return ExpressionFunctionsUtils.throwSevere(MessageFormat.format("Clock gate could not be found for given peripheral: {0}", peripheralName), ExpressionFunctions.class, this.function);
        }
        return Value.of((String)peripheral.getControlPeripheralName());
    }

    public IValue getClockGateRegister(String peripheralName) {
        IRegClockGateConfigAPI peripheral = ExpressionFunctions.getClockGateInternal(this.mcu, peripheralName, null);
        if (peripheral == null) {
            return ExpressionFunctionsUtils.throwSevere(MessageFormat.format("Clock gate could not be found for given peripheral: {0}", peripheralName), ExpressionFunctions.class, this.function);
        }
        return Value.of((String)peripheral.getControlRegisterName());
    }

    public IValue getClockGateBitField(String peripheralName) {
        IRegClockGateConfigAPI peripheral = ExpressionFunctions.getClockGateInternal(this.mcu, peripheralName, null);
        if (peripheral == null) {
            return ExpressionFunctionsUtils.throwSevere(MessageFormat.format("Clock gate could not be found for given peripheral: {0}", peripheralName), ExpressionFunctions.class, this.function);
        }
        return Value.of((String)peripheral.getControlBitFieldName());
    }

    public IValue getClockGateEnableValue(String peripheralName) {
        IRegClockGateConfigAPI peripheral = ExpressionFunctions.getClockGateInternal(this.mcu, peripheralName, null);
        if (peripheral == null) {
            return ExpressionFunctionsUtils.throwSevere(MessageFormat.format("Clock gate could not be found for given peripheral: {0}", peripheralName), ExpressionFunctions.class, this.function);
        }
        IRegClockGateConfigStateAPI state = peripheral.getState(REGISTER_CLOCK_GATE_ENABLED_STATE_ID);
        if (state == null) {
            return ExpressionFunctionsUtils.throwSevere(MessageFormat.format("Clock gate does not specify enable value for given peripheral: {0}", peripheralName), ExpressionFunctions.class, this.function);
        }
        return Value.of((long)state.getValue());
    }

    public IValue getUniqueInt64() {
        long now = ExpressionFunctions.getUniqueInt64Internal();
        return Value.of((long)now);
    }

    public static long getUniqueInt64Internal() {
        long now;
        long start = Instant.now(Clock.systemUTC()).toEpochMilli();
        while (start == (now = Instant.now(Clock.systemUTC()).toEpochMilli())) {
        }
        return now;
    }

    public IValue print(IValue value) {
        LOGGER.log(Level.INFO, value.getString());
        return value;
    }

    public IValue hasWarning(IChild node) {
        return Value.of((node.getWarning() != null ? 1 : 0) != 0);
    }

    public IValue hasInfo(IChild node) {
        return Value.of((node.getInfo() != null ? 1 : 0) != 0);
    }

    public IValue hasError(IChild node) {
        String error = node.getError();
        return Value.of((error != null ? 1 : 0) != 0);
    }

    public IValue charAt(String string, int index) {
        try {
            return Value.of((String)String.valueOf(string.charAt(index)));
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            return ExpressionFunctionsUtils.throwSevere(MessageFormat.format("Function charAt received index ({0}) which is not present in the input string", String.valueOf(index)), ExpressionFunctions.class, this.function);
        }
    }

    public IValue split(String string, String delimeter, int limit) {
        String[] split = string.split(delimeter, limit);
        ArrayList<String> result = new ArrayList<String>(split.length);
        String[] stringArray = split;
        int n = split.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            if (part != null) {
                result.add(part);
            }
            ++n2;
        }
        return Value.of(result);
    }

    public IValue trim(String string) {
        return Value.of((String)string.trim());
    }

    public IValue substring(String string, int start, int end) {
        if (end == -1) {
            end = string.length();
        }
        if (end < 0) {
            ExpressionFunctionsUtils.throwSevere("End index is lower than zero", ExpressionFunctions.class, this.function);
        }
        return Value.of((String)string.substring(start, end));
    }

    public IValue slice(List<Object> array, int start) {
        if (start < 0) {
            start = array.size() + start;
        }
        if (start < 0) {
            return ExpressionFunctionsUtils.throwSevere("Start is bellow zero even after first correction", ExpressionFunctions.class, this.function);
        }
        int end = array.size();
        try {
            return Value.of(new ArrayList<Object>(array.subList(start, end)));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return ExpressionFunctionsUtils.throwSevere("Index of start or end was out of bounds", ExpressionFunctions.class, this.function);
        }
    }

    public IValue slice(List<Object> array, int start, int end) {
        if (start < 0) {
            start = array.size() + start;
        }
        if (end < 0) {
            end = array.size() + end;
        }
        if (start < 0) {
            return ExpressionFunctionsUtils.throwSevere("Start is bellow zero even after correction", ExpressionFunctions.class, this.function);
        }
        if (end < 0) {
            return ExpressionFunctionsUtils.throwSevere("End is bellow zero even after correction", ExpressionFunctions.class, this.function);
        }
        if (end < start) {
            return Value.of(Collections.emptyList());
        }
        try {
            return Value.of(new ArrayList<Object>(array.subList(start, end)));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return ExpressionFunctionsUtils.throwSevere("Index of start or end was out of bounds", ExpressionFunctions.class, this.function);
        }
    }

    public IValue isSdkComponentAvailable(String sdkComponentId) {
        return Value.of((!this.childContext.getRoot().getAvailableComponentForSdkComponent(sdkComponentId).isEmpty() ? 1 : 0) != 0);
    }

    public IValue isSdkComponentUsed(String sdkComponentId, @Nullable String functionalGroupName) {
        List<String> functionalGroupNames = functionalGroupName != null ? Arrays.asList(functionalGroupName) : this.getNamesOfAllFunctionalGroups();
        boolean result = false;
        for (String groupName : functionalGroupNames) {
            if (this.childContext.getRoot().getConfiguredComponentForSdkComponent(sdkComponentId, groupName).isEmpty()) continue;
            result = true;
            break;
        }
        return Value.of((boolean)result);
    }

    public IValue getAvailableSdkComponentVersions(String sdkComponentId) {
        List<ConfigurationComponentTypeId> components = this.childContext.getRoot().getAvailableComponentForSdkComponent(sdkComponentId);
        List versions = (List)components.stream().flatMap(ccti -> ccti.getComponentReferences().stream()).filter(swcomp -> swcomp.getName().equals(sdkComponentId)).map(swcomp -> swcomp.getVersionStr()).collect(CollectorsUtils.toList());
        return Value.of((Object)versions);
    }

    public IValue getCurrentSdkComponentVersions(String sdkComponentId) {
        List<String> functionalGroupNames = this.getNamesOfAllFunctionalGroups();
        ArrayList versions = new ArrayList();
        for (String groupName : functionalGroupNames) {
            List<ConfigurationComponentTypeId> list = this.childContext.getRoot().getConfiguredComponentForSdkComponent(sdkComponentId, groupName);
            for (ConfigurationComponentTypeId component : list) {
                List references = (List)component.getComponentReferences().stream().filter(swcomp -> swcomp.getName().equals(sdkComponentId)).map(swcomp -> swcomp.getVersionStr()).collect(CollectorsUtils.toList());
                versions.addAll(references);
            }
        }
        return Value.of(versions);
    }

    public IValue getAvailableComponentsTypeIds(String type, String version, @Nullable String matchType, @Nullable String untilVersion) {
        return Value.of(this.childContext.getRoot().getAvailableComponentsTypeIds(type, version, matchType, untilVersion).stream().map(x -> x.getTypeId()).collect(CollectorsUtils.toList()));
    }

    private List<String> getNamesOfAllFunctionalGroups() {
        return (List)this.childContext.getRoot().getFunctionalGroups().stream().map(IChild::getUiName).collect(CollectorsUtils.toList());
    }

    private static IValue filterLimited(List<?> array, IFunction condExpr, boolean recursive, @Nullable Long limit, IContext context) {
        ExpressionFunctionArrayList newArray = new ExpressionFunctionArrayList();
        List<?> iterableList = array;
        if (recursive) {
            iterableList = new ArrayList(array);
            for (Object item : array) {
                if (item instanceof IChildProvidable) {
                    iterableList.addAll(ChildProviderHelper.getAllChildren((IChildProvidable)item));
                    continue;
                }
                if (!(item instanceof List)) continue;
                iterableList.addAll(ExpressionFunctions.expandList((List)item));
            }
        }
        for (Object item : iterableList) {
            if (!condExpr.invokeOn(context, new Object[]{item}).getBoolean()) continue;
            newArray.add(item);
            if (limit == null || (long)newArray.size() < limit) continue;
            return Value.of(newArray);
        }
        return Value.of(newArray);
    }

    private static List<Object> expandList(List<Object> list) {
        ArrayList<Object> result = new ArrayList<Object>(list.size());
        for (Object obj : list) {
            if (obj instanceof List) {
                result.addAll(ExpressionFunctions.expandList((List)obj));
                continue;
            }
            if (obj instanceof IChildProvidable) {
                result.addAll(ChildProviderHelper.getAllChildren((IChildProvidable)obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    public static List<String> getAssignedPeripheralsInternal(IChild node) {
        IChildProvidable providable;
        ArrayList<String> result = new ArrayList<String>();
        if (node instanceof IChildProvidable && (providable = (IChildProvidable)node).isEnabled() && providable.isAvailable()) {
            for (IChild iChild : providable.getChildren()) {
                result.addAll(ExpressionFunctions.getAssignedPeripheralsInternal(iChild));
            }
        }
        if (node instanceof ISettingConfig) {
            IComponentInstanceConfig instance;
            ISettingConfig setting = (ISettingConfig)node;
            if (!setting.isEnabled() || !setting.isAvailable()) {
                return result;
            }
            List<AssignConfig> list = setting.getAssignConfigs();
            boolean addInstancePeripheral = false;
            List<AssignConfig> list2 = ExpressionFunctions.addSetPresenceAssigns(node, list);
            for (AssignConfig assign : list2) {
                if (!assign.isEnabled()) continue;
                for (RegisterConfig register : assign.getRegisters()) {
                    try {
                        String registerPeripheral = register.getPeripheral(assign.getParent().getExpressionContext());
                        if (registerPeripheral != null) {
                            result.add(registerPeripheral);
                            continue;
                        }
                        addInstancePeripheral = true;
                    }
                    catch (RegistersModelSingleton.RegisterNotFoundException e) {
                        e.log(node.getId());
                    }
                }
            }
            if (addInstancePeripheral && (instance = node.getChildContext().getComponentInstanceConfig()) != null) {
                String instancePeripheral = UtilsText.safeString((String)instance.getPeripheral());
                result.add(instancePeripheral);
            }
        }
        return (List)result.stream().distinct().collect(CollectorsUtils.toList());
    }

    public static List<String> getAssignedRegistersInternal(IChild node, String peripheralIdentification) {
        IChildProvidable providable;
        ArrayList<String> result = new ArrayList<String>();
        if (node instanceof IChildProvidable && (providable = (IChildProvidable)node).isEnabled() && providable.isAvailable()) {
            for (IChild iChild : providable.getChildren()) {
                result.addAll(ExpressionFunctions.getAssignedRegistersInternal(iChild, peripheralIdentification));
            }
        }
        if (node instanceof ISettingConfig) {
            String instancePeripheral = ExpressionFunctions.getInstancePeripheral(node);
            ISettingConfig iSettingConfig = (ISettingConfig)node;
            if (!iSettingConfig.isEnabled() || !iSettingConfig.isAvailable()) {
                return result;
            }
            List<AssignConfig> assigns = iSettingConfig.getAssignConfigs();
            assigns = ExpressionFunctions.addSetPresenceAssigns(node, assigns);
            for (AssignConfig assign : assigns) {
                if (!assign.isEnabled()) continue;
                for (RegisterConfig register : assign.getRegisters()) {
                    try {
                        String registerPeripheral = register.getPeripheral(assign.getParent().getExpressionContext());
                        if (!peripheralIdentification.equals(registerPeripheral) && (registerPeripheral != null || !peripheralIdentification.equals(instancePeripheral))) continue;
                        result.add(register.getName(assign.getParent().getExpressionContext()));
                    }
                    catch (RegistersModelSingleton.RegisterNotFoundException e) {
                        e.log(iSettingConfig.getId());
                    }
                }
            }
        }
        return (List)result.stream().distinct().collect(CollectorsUtils.toList());
    }

    public static List<String> getAssignedBitFieldsInternal(IChild node, String peripheralIdentification, String registerIdentification) {
        IChildProvidable providable;
        ArrayList<String> result = new ArrayList<String>();
        if (node instanceof IChildProvidable && (providable = (IChildProvidable)node).isEnabled() && providable.isAvailable()) {
            for (IChild iChild : providable.getChildren()) {
                result.addAll(ExpressionFunctions.getAssignedBitFieldsInternal(iChild, peripheralIdentification, registerIdentification));
            }
        }
        if (node instanceof ISettingConfig) {
            String instancePeripheral = ExpressionFunctions.getInstancePeripheral(node);
            ISettingConfig iSettingConfig = (ISettingConfig)node;
            if (!iSettingConfig.isEnabled() || !iSettingConfig.isAvailable()) {
                return result;
            }
            List<AssignConfig> assigns = iSettingConfig.getAssignConfigs();
            assigns = ExpressionFunctions.addSetPresenceAssigns(node, assigns);
            for (AssignConfig assign : assigns) {
                if (!assign.isEnabled()) continue;
                for (RegisterConfig register : assign.getRegisters()) {
                    try {
                        if (!peripheralIdentification.equals(register.getPeripheral(assign.getParent().getExpressionContext())) && (register.getPeripheral(assign.getParent().getExpressionContext()) != null || !peripheralIdentification.equals(instancePeripheral)) || !register.getName(assign.getParent().getExpressionContext()).equals(registerIdentification)) continue;
                        result.add(register.getBitfield(assign.getParent().getExpressionContext()));
                    }
                    catch (RegistersModelSingleton.RegisterNotFoundException e) {
                        e.log(iSettingConfig.getId());
                    }
                }
            }
        }
        return (List)result.stream().distinct().collect(CollectorsUtils.toList());
    }

    public static List<AssignConfig> addSetPresenceAssigns(IChild node, List<AssignConfig> assigns) {
        if (node instanceof SetConfig) {
            SetConfig set = (SetConfig)node;
            ArrayList<AssignConfig> newList = new ArrayList<AssignConfig>(assigns);
            for (SetConfig.SetPresence setPresence : set.getChildren()) {
                if (!setPresence.isAvailable() || !setPresence.isEnabled()) continue;
                newList.addAll(setPresence.getAssignConfigs());
            }
            return newList;
        }
        return assigns;
    }

    public static @Nullable String getInstancePeripheral(IChild node) {
        String instancePeripheral = null;
        IComponentInstanceConfig instance = node.getChildContext().getComponentInstanceConfig();
        if (instance != null) {
            instancePeripheral = instance.getPeripheral();
        }
        return instancePeripheral;
    }

    public static @Nullable IRegClockGateConfigAPI getClockGateInternal(ICommonMcu mcu, String peripheralIdentification, @Nullable String registerName) {
        IRegistersDatabaseAPI registersDb = mcu.getRegistersDb();
        return ExpressionFunctions.getClockGateInternal(registersDb, peripheralIdentification, registerName);
    }

    public static @Nullable IRegClockGateConfigAPI getClockGateInternal(@Nullable IRegistersDatabaseAPI registersDb, String peripheralIdentification, @Nullable String registerName) {
        if (registersDb == null) {
            return null;
        }
        IRegParentPeripheralAPI peripheral = BitFieldProvider.findPeripheral((String)peripheralIdentification, (IRegistersDatabaseAPI)registersDb);
        if (peripheral == null) {
            return null;
        }
        IRegisterAPI register = registerName == null ? peripheral.getRegisters()[0] : BitFieldProvider.findRegister((IRegParentPeripheralAPI)peripheral, (String)registerName);
        if (register == null) {
            return null;
        }
        return registersDb.getClockGate(peripheral, register);
    }

    /*
     * Exception decompiling
     */
    public static final boolean isVersionInRangeInternal(String versionStringToCheck, String minimalVersionString, String maximalVersionString, @Nullable String mode) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[14] lbl129 : CaseStatement: default:\u000a, @NONE, blocks:[14] lbl129 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void checkAvailabilityOfChild(IChild child, String detail) {
        if (!child.isAvailable() && Properties.isVerificationOn()) {
            LOGGER.log(Level.WARNING, () -> MessageFormat.format("[DATA] Asking for {0} of child: {1} which is currently unavailable", detail, child.getId()));
        }
    }

    public static IRegParentPeripheralAPI getPeripheral(IRegistersDatabaseAPI registersDb, String peripheralName) {
        IRegParentPeripheralAPI peripheral = RegistersModelSingleton.getPeripheralInternal(registersDb, peripheralName);
        if (peripheral == null) {
            throw new IllegalArgumentException("Peripheral with name " + peripheralName + " does not exist");
        }
        return peripheral;
    }

    public static IRegisterAPI getRegister(IRegParentPeripheralAPI peripheral, String registerName) {
        IRegisterAPI register = RegistersModelSingleton.getRegisterInternal(peripheral, registerName);
        if (register == null) {
            throw new IllegalArgumentException("Register with name " + registerName + " does not exist");
        }
        return register;
    }

    public static IRegBitFieldAPI getBitfield(IRegisterAPI register, String bitfieldName) {
        IRegBitFieldAPI bitfield = RegistersModelSingleton.getBitfieldInternal(register, bitfieldName);
        if (bitfield == null) {
            throw new IllegalArgumentException("Bitfield with name " + bitfieldName + " does not exist");
        }
        return bitfield;
    }

    public static boolean peripheralExists(ICommonMcu mcu, String peripheralName) {
        IRegistersDatabaseAPI registerDb = mcu.getRegistersDb();
        return ExpressionFunctions.peripheralExists(registerDb, peripheralName);
    }

    public static boolean peripheralExists(@Nullable IRegistersDatabaseAPI registersDb, String peripheralName) {
        if (registersDb == null) {
            return false;
        }
        return RegistersModelSingleton.getPeripheralInternal(registersDb, peripheralName) != null;
    }

    public static boolean registerExists(ICommonMcu mcu, String peripheralName, String registerName) {
        IRegistersDatabaseAPI registerDb = mcu.getRegistersDb();
        return ExpressionFunctions.registerExists(registerDb, peripheralName, registerName);
    }

    public static boolean registerExists(@Nullable IRegistersDatabaseAPI registersDb, String peripheralName, String registerName) {
        if (registersDb == null) {
            return false;
        }
        IRegParentPeripheralAPI peripheral = RegistersModelSingleton.getPeripheralInternal(registersDb, peripheralName);
        if (peripheral == null) {
            return false;
        }
        return RegistersModelSingleton.getRegisterInternal(peripheral, registerName) != null;
    }

    public static boolean bitfieldExists(ICommonMcu mcu, String peripheralName, String registerName, String bitfieldName) {
        IRegistersDatabaseAPI registerDb = mcu.getRegistersDb();
        return ExpressionFunctions.bitfieldExists(registerDb, peripheralName, registerName, bitfieldName);
    }

    public static boolean bitfieldExists(@Nullable IRegistersDatabaseAPI registersDb, String peripheralName, String registerName, String bitfieldName) {
        if (registersDb == null) {
            return false;
        }
        IRegParentPeripheralAPI peripheral = RegistersModelSingleton.getPeripheralInternal(registersDb, peripheralName);
        if (peripheral == null) {
            return false;
        }
        IRegisterAPI register = RegistersModelSingleton.getRegisterInternal(peripheral, registerName);
        if (register == null) {
            return false;
        }
        return RegistersModelSingleton.getBitfieldInternal(register, bitfieldName) != null;
    }

    public static BigInteger getBitFieldValueInternal(IFunctionalGroup group, String peripheralName, String registerName, String bitfieldName) {
        String fullRegisterName = RegistersModelSingleton.computeFullNameOfRegister(peripheralName, registerName);
        return RegistersModelSingleton.getInstance().getValueOfBitField(group, fullRegisterName, bitfieldName);
    }

    public static BigInteger getRegisterValueInternal(IFunctionalGroup group, String peripheralName, String registerName) {
        return RegistersModelSingleton.getInstance().getValueOfRegister(group, peripheralName, registerName);
    }

    public static BigInteger getAddressOfRegisterInternal(ICommonMcu mcu, String peripheralName, String registerName, String coreId, @Nullable String mode) {
        IRegistersDatabaseAPI registersDb = mcu.getRegistersDb();
        return ExpressionFunctions.getAddressOfRegisterInternal(registersDb, peripheralName, registerName, coreId, mode);
    }

    public static BigInteger getAddressOfRegisterInternal(@Nullable IRegistersDatabaseAPI registersDb, String peripheralName, String registerName, String coreId, @Nullable String mode) {
        if (registersDb == null) {
            return RegistersModelSingleton.ERROR_REGISTER_DATABASE_NOT_FOUND;
        }
        IRegParentPeripheralAPI peripheral = RegistersModelSingleton.getPeripheralInternal(registersDb, peripheralName);
        if (peripheral == null) {
            return RegistersModelSingleton.ERROR_PERIPHERAL_NOT_FOUND;
        }
        IRegisterAPI register = RegistersModelSingleton.getRegisterInternal(peripheral, registerName);
        if (register == null) {
            return RegistersModelSingleton.ERROR_REGISTER_NOT_FOUND;
        }
        BigInteger baseAddress = peripheral.getBaseAddress(coreId, mode);
        if (baseAddress == null) {
            return RegistersModelSingleton.ERROR_REGISTER_BASE_ADDRESS_NOT_FOUND;
        }
        return baseAddress.add(BigInteger.valueOf(register.getOffset()));
    }

    public static BigInteger getPeripheralBaseAddressInternal(ICommonMcu mcu, String peripheralName, String coreId, @Nullable String mode) {
        IRegistersDatabaseAPI registersDb = mcu.getRegistersDb();
        return ExpressionFunctions.getPeripheralBaseAddressInternal(registersDb, peripheralName, coreId, mode);
    }

    public static BigInteger getPeripheralBaseAddressInternal(@Nullable IRegistersDatabaseAPI registersDb, String peripheralName, String coreId, @Nullable String mode) {
        if (registersDb == null) {
            return RegistersModelSingleton.ERROR_REGISTER_DATABASE_NOT_FOUND;
        }
        IRegParentPeripheralAPI peripheral = RegistersModelSingleton.getPeripheralInternal(registersDb, peripheralName);
        if (peripheral == null) {
            return RegistersModelSingleton.ERROR_PERIPHERAL_NOT_FOUND;
        }
        BigInteger baseAddress = peripheral.getBaseAddress(coreId, mode);
        if (baseAddress == null) {
            return RegistersModelSingleton.ERROR_PERIPHERAL_BASE_ADDRESS_NOT_FOUND;
        }
        return baseAddress;
    }

    public static BigInteger getOffsetOfBitfieldInternal(ICommonMcu mcu, String peripheralName, String registerName, String bitfieldName) {
        IRegistersDatabaseAPI registersDb = mcu.getRegistersDb();
        return ExpressionFunctions.getOffsetOfBitfieldInternal(registersDb, peripheralName, registerName, bitfieldName);
    }

    public static BigInteger getOffsetOfBitfieldInternal(@Nullable IRegistersDatabaseAPI registersDb, String peripheralName, String registerName, String bitfieldName) {
        if (registersDb == null) {
            return RegistersModelSingleton.ERROR_REGISTER_DATABASE_NOT_FOUND;
        }
        IRegParentPeripheralAPI peripheral = RegistersModelSingleton.getPeripheralInternal(registersDb, peripheralName);
        if (peripheral == null) {
            return RegistersModelSingleton.ERROR_PERIPHERAL_NOT_FOUND;
        }
        IRegisterAPI register = RegistersModelSingleton.getRegisterInternal(peripheral, registerName);
        if (register == null) {
            return RegistersModelSingleton.ERROR_REGISTER_NOT_FOUND;
        }
        IRegBitFieldAPI bitfield = RegistersModelSingleton.getBitfieldInternal(register, bitfieldName);
        if (bitfield == null) {
            return RegistersModelSingleton.ERROR_BITFIELD_NOT_FOUND;
        }
        return BigInteger.valueOf(bitfield.getOffset());
    }

    public static BigInteger getRegisterOffsetInternal(ICommonMcu mcu, String peripheralName, String registerName) {
        IRegistersDatabaseAPI registersDb = mcu.getRegistersDb();
        return ExpressionFunctions.getRegisterOffsetInternal(registersDb, peripheralName, registerName);
    }

    public static BigInteger getRegisterOffsetInternal(@Nullable IRegistersDatabaseAPI registersDb, String peripheralName, String registerName) {
        if (registersDb == null) {
            return RegistersModelSingleton.ERROR_REGISTER_DATABASE_NOT_FOUND;
        }
        IRegParentPeripheralAPI peripheral = RegistersModelSingleton.getPeripheralInternal(registersDb, peripheralName);
        if (peripheral == null) {
            return RegistersModelSingleton.ERROR_PERIPHERAL_NOT_FOUND;
        }
        IRegisterAPI register = RegistersModelSingleton.getRegisterInternal(peripheral, registerName);
        if (register == null) {
            return RegistersModelSingleton.ERROR_REGISTER_NOT_FOUND;
        }
        return BigInteger.valueOf(register.getOffset());
    }

    public static BigInteger getRegisterWidthInternal(ICommonMcu mcu, String peripheralName, String registerName) {
        IRegistersDatabaseAPI registersDb = mcu.getRegistersDb();
        return ExpressionFunctions.getRegisterWidthInternal(registersDb, peripheralName, registerName);
    }

    public static BigInteger getRegisterWidthInternal(@Nullable IRegistersDatabaseAPI registersDb, String peripheralName, String registerName) {
        if (registersDb == null) {
            return RegistersModelSingleton.ERROR_REGISTER_DATABASE_NOT_FOUND;
        }
        IRegParentPeripheralAPI peripheral = RegistersModelSingleton.getPeripheralInternal(registersDb, peripheralName);
        if (peripheral == null) {
            return RegistersModelSingleton.ERROR_PERIPHERAL_NOT_FOUND;
        }
        IRegisterAPI register = RegistersModelSingleton.getRegisterInternal(peripheral, registerName);
        if (register == null) {
            return RegistersModelSingleton.ERROR_REGISTER_NOT_FOUND;
        }
        return BigInteger.valueOf(register.getWidth());
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
    CollectionsUtils.Pair<@Nullable String, BigInteger> getRegisterNameInternal(ICommonMcu mcu, String peripheralName, String registerName) {
        IRegistersDatabaseAPI registersDb = mcu.getRegistersDb();
        return ExpressionFunctions.getRegisterNameInternal(registersDb, peripheralName, registerName);
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
    CollectionsUtils.Pair<@Nullable String, BigInteger> getRegisterNameInternal(@Nullable IRegistersDatabaseAPI registersDb, String peripheralName, String registerName) {
        if (registersDb == null) {
            return new CollectionsUtils.Pair(null, (Object)RegistersModelSingleton.ERROR_REGISTER_DATABASE_NOT_FOUND);
        }
        IRegParentPeripheralAPI peripheral = RegistersModelSingleton.getPeripheralInternal(registersDb, peripheralName);
        if (peripheral == null) {
            return new CollectionsUtils.Pair(null, (Object)RegistersModelSingleton.ERROR_PERIPHERAL_NOT_FOUND);
        }
        IRegisterAPI register = RegistersModelSingleton.getRegisterInternal(peripheral, registerName);
        if (register == null) {
            return new CollectionsUtils.Pair(null, (Object)RegistersModelSingleton.ERROR_REGISTER_NOT_FOUND);
        }
        return new CollectionsUtils.Pair((Object)register.getName(), (Object)BigInteger.ZERO);
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
    CollectionsUtils.Pair<@Nullable String, BigInteger> getPeripheralAliasValueInternal(ICommonMcu mcu, String peripheralIdentification, String aliasType) {
        IRegistersDatabaseAPI registersDb = mcu.getRegistersDb();
        return ExpressionFunctions.getPeripheralAliasValueInternal(registersDb, peripheralIdentification, aliasType);
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
    CollectionsUtils.Pair<@Nullable String, BigInteger> getPeripheralAliasValueInternal(@Nullable IRegistersDatabaseAPI registersDb, String peripheralIdentification, String aliasType) {
        if (registersDb == null) {
            return new CollectionsUtils.Pair(null, (Object)RegistersModelSingleton.ERROR_REGISTER_DATABASE_NOT_FOUND);
        }
        IRegParentPeripheralAPI peripheral = RegistersModelSingleton.getPeripheralInternal(registersDb, peripheralIdentification);
        if (peripheral == null) {
            return new CollectionsUtils.Pair(null, (Object)RegistersModelSingleton.ERROR_PERIPHERAL_NOT_FOUND);
        }
        String aliasValue = peripheral.getAlias(aliasType);
        if (aliasValue == null) {
            return new CollectionsUtils.Pair(null, (Object)RegistersModelSingleton.ERROR_ALIAS_WITH_TYPE_NOT_FOUND);
        }
        return new CollectionsUtils.Pair((Object)aliasValue, (Object)BigInteger.ZERO);
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
    CollectionsUtils.Pair<@Nullable String, BigInteger> getRegisterAliasValueInternal(ICommonMcu mcu, String peripheralIdentification, String registerIdentification, String aliasType) {
        IRegistersDatabaseAPI registersDb = mcu.getRegistersDb();
        return ExpressionFunctions.getRegisterAliasValueInternal(registersDb, peripheralIdentification, registerIdentification, aliasType);
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
    CollectionsUtils.Pair<@Nullable String, BigInteger> getRegisterAliasValueInternal(@Nullable IRegistersDatabaseAPI registersDb, String peripheralIdentification, String registerIdentification, String aliasType) {
        if (registersDb == null) {
            return new CollectionsUtils.Pair(null, (Object)RegistersModelSingleton.ERROR_REGISTER_DATABASE_NOT_FOUND);
        }
        IRegParentPeripheralAPI peripheral = RegistersModelSingleton.getPeripheralInternal(registersDb, peripheralIdentification);
        if (peripheral == null) {
            return new CollectionsUtils.Pair(null, (Object)RegistersModelSingleton.ERROR_PERIPHERAL_NOT_FOUND);
        }
        IRegisterAPI register = RegistersModelSingleton.getRegisterInternal(peripheral, registerIdentification);
        if (register == null) {
            return new CollectionsUtils.Pair(null, (Object)RegistersModelSingleton.ERROR_REGISTER_NOT_FOUND);
        }
        String aliasValue = register.getAlias(aliasType);
        if (aliasValue == null) {
            return new CollectionsUtils.Pair(null, (Object)RegistersModelSingleton.ERROR_ALIAS_WITH_TYPE_NOT_FOUND);
        }
        return new CollectionsUtils.Pair((Object)aliasValue, (Object)BigInteger.ZERO);
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
    CollectionsUtils.Pair<@Nullable String, BigInteger> getBitFieldAliasValueInternal(ICommonMcu mcu, String peripheralIdentification, String registerIdentification, String bitfieldIdentification, String aliasType) {
        IRegistersDatabaseAPI registersDb = mcu.getRegistersDb();
        return ExpressionFunctions.getBitFieldAliasValueInternal(registersDb, peripheralIdentification, registerIdentification, bitfieldIdentification, aliasType);
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
    CollectionsUtils.Pair<@Nullable String, BigInteger> getBitFieldAliasValueInternal(@Nullable IRegistersDatabaseAPI registersDb, String peripheralIdentification, String registerIdentification, String bitfieldIdentification, String aliasType) {
        if (registersDb == null) {
            return new CollectionsUtils.Pair(null, (Object)RegistersModelSingleton.ERROR_REGISTER_DATABASE_NOT_FOUND);
        }
        IRegParentPeripheralAPI peripheral = RegistersModelSingleton.getPeripheralInternal(registersDb, peripheralIdentification);
        if (peripheral == null) {
            return new CollectionsUtils.Pair(null, (Object)RegistersModelSingleton.ERROR_PERIPHERAL_NOT_FOUND);
        }
        IRegisterAPI register = RegistersModelSingleton.getRegisterInternal(peripheral, registerIdentification);
        if (register == null) {
            return new CollectionsUtils.Pair(null, (Object)RegistersModelSingleton.ERROR_REGISTER_NOT_FOUND);
        }
        IRegBitFieldAPI bitfield = RegistersModelSingleton.getBitfieldInternal(register, bitfieldIdentification);
        if (bitfield == null) {
            return new CollectionsUtils.Pair(null, (Object)RegistersModelSingleton.ERROR_BITFIELD_NOT_FOUND);
        }
        String aliasValue = bitfield.getAlias(aliasType);
        if (aliasValue == null) {
            return new CollectionsUtils.Pair(null, (Object)RegistersModelSingleton.ERROR_ALIAS_WITH_TYPE_NOT_FOUND);
        }
        return new CollectionsUtils.Pair((Object)aliasValue, (Object)BigInteger.ZERO);
    }

    public static List<String> getRegistersInternal(ICommonMcu mcu, String peripheralName) {
        IRegistersDatabaseAPI registersDb = mcu.getRegistersDb();
        return ExpressionFunctions.getRegistersInternal(registersDb, peripheralName);
    }

    public static List<String> getRegistersInternal(@Nullable IRegistersDatabaseAPI registersDb, String peripheralName) {
        if (registersDb == null) {
            return Collections.emptyList();
        }
        IRegParentPeripheralAPI peripheral = RegistersModelSingleton.getPeripheralInternal(registersDb, peripheralName);
        if (peripheral == null) {
            return Collections.emptyList();
        }
        IRegisterAPI[] registers = peripheral.getRegisters();
        ArrayList<String> registerNames = new ArrayList<String>(registers.length);
        IRegisterAPI[] iRegisterAPIArray = registers;
        int n = registers.length;
        int n2 = 0;
        while (n2 < n) {
            IRegisterAPI register = iRegisterAPIArray[n2];
            registerNames.add(register.getName());
            ++n2;
        }
        return registerNames;
    }

    public static List<String> getBitfieldsInternal(ICommonMcu mcu, String peripheralName, String registerName) {
        IRegistersDatabaseAPI registersDb = mcu.getRegistersDb();
        return ExpressionFunctions.getBitfieldsInternal(registersDb, peripheralName, registerName);
    }

    public static List<String> getBitfieldsInternal(@Nullable IRegistersDatabaseAPI registersDb, String peripheralName, String registerName) {
        if (registersDb == null) {
            return Collections.emptyList();
        }
        IRegParentPeripheralAPI peripheral = RegistersModelSingleton.getPeripheralInternal(registersDb, peripheralName);
        if (peripheral == null) {
            return Collections.emptyList();
        }
        IRegisterAPI register = RegistersModelSingleton.getRegisterInternal(peripheral, registerName);
        if (register == null) {
            return Collections.emptyList();
        }
        IRegBitFieldAPI[] bitFields = register.getBitFields();
        ArrayList<String> bitfieldNames = new ArrayList<String>(bitFields.length);
        IRegBitFieldAPI[] iRegBitFieldAPIArray = bitFields;
        int n = bitFields.length;
        int n2 = 0;
        while (n2 < n) {
            IRegBitFieldAPI bitfield = iRegBitFieldAPIArray[n2];
            bitfieldNames.add(bitfield.getName());
            ++n2;
        }
        return bitfieldNames;
    }

    public static BigInteger getBitFieldWidthInternal(ICommonMcu mcu, String peripheralName, String registerName, String bitfieldName) {
        IRegistersDatabaseAPI registersDb = mcu.getRegistersDb();
        return ExpressionFunctions.getBitFieldWidthInternal(registersDb, peripheralName, registerName, bitfieldName);
    }

    public static BigInteger getBitFieldWidthInternal(@Nullable IRegistersDatabaseAPI registersDb, String peripheralName, String registerName, String bitfieldName) {
        if (registersDb == null) {
            return RegistersModelSingleton.ERROR_REGISTER_DATABASE_NOT_FOUND;
        }
        IRegParentPeripheralAPI peripheral = RegistersModelSingleton.getPeripheralInternal(registersDb, peripheralName);
        if (peripheral == null) {
            return RegistersModelSingleton.ERROR_PERIPHERAL_NOT_FOUND;
        }
        IRegisterAPI register = RegistersModelSingleton.getRegisterInternal(peripheral, registerName);
        if (register == null) {
            return RegistersModelSingleton.ERROR_REGISTER_NOT_FOUND;
        }
        IRegBitFieldAPI bitfield = RegistersModelSingleton.getBitfieldInternal(register, bitfieldName);
        if (bitfield == null) {
            return RegistersModelSingleton.ERROR_BITFIELD_NOT_FOUND;
        }
        return BigInteger.valueOf(bitfield.getWidth());
    }

    private static Frequency getFrequencyObject(String value, String defaultUnit) {
        String valueWithUnit = AbstractUnit.prepareForParsing((String)value, (String)defaultUnit);
        Frequency frequency = AbstractUnit.parseIntoFrequency((String)valueWithUnit);
        if (frequency == null) {
            String description = "Frequency: `" + value + "` cannot be parsed";
            throw new PeripheralExpressionException(description, ExpressionFunctions.class);
        }
        return frequency;
    }

    public static String getFnGroupPrefixHelper(IChild node) {
        IFunctionalGroup funcGroup = node.getChildContext().getFunctionalGroup();
        return funcGroup == null ? "" : funcGroup.getIdPrefix();
    }

    public static boolean isFnGroupDefaultInitHelper(IChild node) {
        IFunctionalGroup funcGroup = node.getChildContext().getFunctionalGroup();
        return funcGroup == null ? false : funcGroup.isCalledFromDefaultInit();
    }

    @Deprecated
    public static boolean isCalledFromDefaultInit(IFunctionalGroup functionalGroup) {
        return functionalGroup.isCalledFromDefaultInit();
    }

    public static @Nullable List<@NonNull ?> listAdapter(Object object) {
        if (object instanceof ExpressionFunctionArrayList) {
            return (ExpressionFunctionArrayList)object;
        }
        if (object instanceof List) {
            ExpressionFunctionArrayList<@NonNull T> list = new ExpressionFunctionArrayList((List)object);
            list.removeIf(Objects::isNull);
            return list;
        }
        if (object instanceof IChildProvidable) {
            return new ExpressionFunctionArrayList<IChild>((Collection<? extends IChild>)((IChildProvidable)object).getChildren());
        }
        return null;
    }

    public static @Nullable List<@NonNull ?> listAdapterUnmodifiable(Object object) {
        if (object instanceof List) {
            return CollectionsUtils.unmodifiableList((List)((List)object));
        }
        if (object instanceof IChildProvidable) {
            return CollectionsUtils.unmodifiableList(((IChildProvidable)object).getChildren());
        }
        return null;
    }

    public static List<@NonNull ?> listAdapter(FunctionInvocation function, int argIndex, IContext argContext) throws PeripheralExpressionException {
        Object object = function.getArgument(argIndex).resolve(argContext).getValue();
        List<@NonNull ?> result = ExpressionFunctions.listAdapter(object);
        if (result == null) {
            String description = "Could not create a list from argument: " + function.getArgument(argIndex).formatOutput(FormatOptions.DEFAULT, (IExpressionPrintable)function) + " of the function: " + function.getName();
            throw new PeripheralExpressionException(description, ExpressionFunctions.class);
        }
        return result;
    }

    public static @Nullable String getPeripheral(ChildContext childContext) {
        IComponentInstanceConfig componentInstance = childContext.getComponentInstanceConfig();
        return componentInstance == null ? null : componentInstance.getPeripheral();
    }

    public static String getModeId(ChildContext childContext) {
        IComponentInstanceConfig componentInstanceConfig = childContext.getComponentInstanceConfig();
        String modeId = componentInstanceConfig == null ? null : componentInstanceConfig.getMode().getId();
        return UtilsText.safeString((String)modeId);
    }

    public static String getFunctionalGroupName(ChildContext childContext) {
        IFunctionalGroup funcGroup = childContext.getFunctionalGroup();
        return funcGroup == null ? "" : funcGroup.getName();
    }

    private static String trimLeft(String s) {
        return LTRIM.matcher(s).replaceAll("");
    }

    private static String padLeft(String s, long level) {
        assert (0L != PAD_LEVEL_SIZE);
        long totalLen = Math.addExact((long)s.length(), Math.multiplyExact(PAD_LEVEL_SIZE, level));
        if (0L == totalLen) {
            return s;
        }
        return UtilsText.safeString((String)String.format("%1$" + totalLen + "s", s));
    }

    private static @Nullable PinsSignalsProvider getPinsSignalProvider(String peripheral) {
        if (Platform.isRunning()) {
            ISharedConfiguration configuration = SharedConfigurationFactory.getSharedConfigurationSingleton();
            List<RoutableSignal> routableSignals = ExpressionFunctions.getRoutableSignals(configuration, peripheral);
            HashMap<String, List<RoutedPin>> routedPins = ExpressionFunctions.getRoutedPins(configuration, routableSignals);
            PinsSignalsProvider pinsSignalsProvider = new PinsSignalsProvider(routableSignals, routedPins);
            return pinsSignalsProvider;
        }
        return null;
    }

    private static HashMap<String, List<RoutedPin>> getRoutedPins(ISharedConfiguration configuration, List<RoutableSignal> routableSignals) {
        HashMap<String, List<RoutedPin>> routedPins = new HashMap<String, List<RoutedPin>>();
        IDependencyQuery queryEngine = DependencyQueryFactory.getQueryInstance((ISharedConfiguration)configuration);
        for (RoutableSignal routableSignal : routableSignals) {
            String resourceId = String.valueOf(routableSignal.getPeripheral()) + "." + routableSignal.getId();
            Collection queryResults = queryEngine.query(configuration, "PinSignal", resourceId, "routedToPins");
            LinkedHashSet routedPinsForSignal = CollectionsUtils.getInstancesOf(queryResults.stream().map(x -> x.getValue()).filter(y -> y instanceof List).map(y -> (List)y).flatMap(z -> z.stream()), RoutedPin.class).filter(s -> s.getSignal().equals(resourceId)).collect(Collectors.toCollection(LinkedHashSet::new));
            routedPins.put(routableSignal.getId(), new ArrayList(routedPinsForSignal));
        }
        return routedPins;
    }

    private static List<RoutableSignal> getRoutableSignals(ISharedConfiguration configuration, String peripheral) {
        IDependencyQuery queryEngine = DependencyQueryFactory.getQueryInstance((ISharedConfiguration)configuration);
        Collection queryResults = queryEngine.query(configuration, "Peripheral", peripheral, "routableSignals");
        List routableSignals = (List)CollectionsUtils.getInstancesOf(queryResults.stream().map(x -> x.getValue()).filter(y -> y instanceof List).map(y -> (List)y).flatMap(z -> z.stream()), RoutableSignal.class).filter(s -> s.getPeripheral().equals(peripheral)).collect(CollectorsUtils.toList());
        return routableSignals;
    }

    private static boolean isCIdentifierHelper(String s) {
        boolean validIdentifier = s.matches("[A-Za-z_][0-9A-Za-z_]*");
        boolean unusableIdentifier = CLanguageConstants.getC90UnusableIdentifiers().contains(s);
        return validIdentifier && !unusableIdentifier;
    }

    public String getEnumItemId(ScalarConfig enumConfig) {
        SetSetting.Item item = this.getSelectedEnumItem(enumConfig);
        if (item != null) {
            return item.getId();
        }
        return "";
    }

    public String getEnumItemLabel(ScalarConfig enumConfig) {
        SetSetting.Item item = this.getSelectedEnumItem(enumConfig);
        if (item != null) {
            return item.getUIName(this.argContext);
        }
        return "";
    }

    public String getEnumItemValue(ScalarConfig enumConfig) {
        SetSetting.Item item = this.getSelectedEnumItem(enumConfig);
        if (item != null) {
            return item.getValue();
        }
        return "";
    }

    public IValue sort(List<?> array, IFunction comparatorExpr) {
        ArrayList newArray = new ArrayList(array);
        class SortComparator
        implements Comparator<Object> {
            private final /* synthetic */ IFunction val$comparatorExpr;

            SortComparator(IFunction iFunction) {
                this.val$comparatorExpr = iFunction;
            }

            @Override
            public int compare(Object a, Object b) {
                return (int)this.val$comparatorExpr.invokeOn(ExpressionFunctions.this.argContext, new Object[]{a, b}).getLong();
            }
        }
        newArray.sort(new SortComparator(comparatorExpr));
        return Value.of(newArray);
    }

    public IValue stringCompare(String first, String second) {
        int difference = ComparatorHelpers.compareSignalNames((String)first, (String)second);
        return Value.of((long)difference);
    }

    private @Nullable SetSetting.Item getSelectedEnumItem(ScalarConfig enumConfig) {
        DynamicEnumSetting dynamicEnumSetting;
        if (enumConfig.getType() != ScalarConfig.Type.ENUM) {
            String description = MessageFormat.format("Invalid input type: {0} for this function", new Object[]{enumConfig.getType()});
            ExpressionFunctionsUtils.throwSevere(description, ExpressionFunctions.class, this.function);
        }
        String itemName = (String)enumConfig.getValue();
        if (enumConfig.setting instanceof DynamicEnumSetting && (dynamicEnumSetting = (DynamicEnumSetting)enumConfig.setting).getCustomValueSupport() != null && (itemName = enumConfig.getStringValue()).startsWith("custom:")) {
            itemName = "custom";
        }
        String itemId = itemName;
        SetSetting.Item item = (SetSetting.Item)CollectionsUtils.nullableOptionalGet(enumConfig.getEnumItems().stream().filter(x -> x.getId().equals(itemId)).findFirst());
        return item;
    }

    private static String frequencyToString(Frequency frequency, int decimalPlaces) {
        String result = FREQUENCY_TO_STRING_INACTIVE;
        if (decimalPlaces < 0) {
            BigRational value = frequency.getValue();
            BigDecimal bigDecimal = value.toBigDecimal();
            decimalPlaces = bigDecimal.scale();
        }
        if (Frequency.ZERO.compareTo(frequency) < 0) {
            result = frequency.toString(decimalPlaces);
        }
        return result;
    }

    private @Nullable Frequency getClockFrequencyFromClocks(String peripheral, String clockRole, String functionalGroup) {
        InputSignal inputSignal;
        PeripheralComponent peripheralComponent = this.mcu.getClockConsumers().findPeriphComponentById(peripheral);
        if (peripheralComponent != null && (inputSignal = peripheralComponent.findInputSignal(clockRole)) != null) {
            String clockSignalId = inputSignal.getSignal();
            return ExpressionFunctions.getClockFrequenciesFromClocks(clockSignalId).get(functionalGroup);
        }
        return null;
    }

    private static Map<String, Frequency> getClockFrequenciesFromClocks(String clockSignalId) {
        LinkedHashMap<String, Frequency> result = new LinkedHashMap<String, Frequency>();
        ISharedConfiguration configuration = SharedConfigurationFactory.getSharedConfigurationSingleton();
        IDependencyQuery queryEngine = DependencyQueryFactory.getQueryInstance((ISharedConfiguration)configuration);
        Collection queryResults = queryEngine.query(configuration, "ClockOutput", clockSignalId, "frequency");
        for (IDependencyQueryResult queryResult : queryResults) {
            Object resultValue = queryResult.getValue();
            if (!(resultValue instanceof Frequency)) continue;
            String configurationName = queryResult.getConfiguration().getConfigurationName();
            result.put(configurationName, (Frequency)resultValue);
        }
        return result;
    }

    private @Nullable Frequency getClockFrequencyFromPeripheralSignal(String peripheral, String clockRole) {
        PeripheralComponent peripheralComponent = this.mcu.getClockConsumers().findPeriphComponentById(peripheral);
        if (peripheralComponent != null) {
            PeripheralSignal peripheralSignal = peripheralComponent.findPeripheralSignal(clockRole);
            if (peripheralSignal != null) {
                return Frequency.parse((String)peripheralSignal.getFrequency());
            }
            return Frequency.ZERO;
        }
        return null;
    }

    private @Nullable String getClockFrequenciesFromClocks(String peripheral, String clockRole) {
        InputSignal inputSignal;
        PeripheralComponent peripheralComponent = this.mcu.getClockConsumers().findPeriphComponentById(peripheral);
        if (peripheralComponent != null && (inputSignal = peripheralComponent.findInputSignal(clockRole)) != null) {
            String frequenciesString;
            String clockSignalId = inputSignal.getSignal();
            ClockSignal clockSignal = this.mcu.getClockConsumers().findClockSignalById(clockSignalId);
            String clockSignalName = clockSignalId;
            if (clockSignal != null) {
                clockSignalName = clockSignal.getName();
            }
            String result = (frequenciesString = ExpressionFunctions.getClockFrequenciesFromClocks(clockSignalId).entrySet().stream().map(x -> MessageFormat.format("{0}: {1}", x.getKey(), ExpressionFunctions.frequencyToString((Frequency)x.getValue(), -1))).collect(Collectors.joining(", "))).isEmpty() ? clockSignalName : String.valueOf(clockSignalName) + " - " + frequenciesString;
            return result;
        }
        return null;
    }

    private @Nullable String getClockFrequencyStringFromPeripheralSignal(String peripheral, String clockRole) {
        PeripheralSignal peripheralSignal;
        PeripheralComponent peripheralComponent = this.mcu.getClockConsumers().findPeriphComponentById(peripheral);
        if (peripheralComponent != null && (peripheralSignal = peripheralComponent.findPeripheralSignal(clockRole)) != null) {
            String frequency = peripheralSignal.getFrequency();
            return String.valueOf(peripheralSignal.getDescription()) + (frequency.isEmpty() ? "" : " - " + frequency);
        }
        return null;
    }

    private @Nullable String getPeripheralSignalNameFromPinSignal(String peripheral, String clockRole) {
        PinSignal pinSignal;
        PeripheralComponent peripheralComponent = this.mcu.getClockConsumers().findPeriphComponentById(peripheral);
        if (peripheralComponent != null && (pinSignal = peripheralComponent.findPinSignal(clockRole)) != null) {
            PinsToolReference pinsRef = pinSignal.getPinsRef();
            return ExpressionFunctions.createPinSignal(pinsRef.getSignalID(), pinsRef.getChannelID());
        }
        return null;
    }

    private @Nullable String getDescriptionFromNoSignal(String peripheral, String clockRole) {
        NoSignal noSignal;
        PeripheralComponent peripheralComponent = this.mcu.getClockConsumers().findPeriphComponentById(peripheral);
        if (peripheralComponent != null && (noSignal = peripheralComponent.findNoSignal(clockRole)) != null) {
            return String.valueOf(noSignal.getDescription()) + " - not connected";
        }
        return null;
    }

    private @Nullable String getPeripheralClockSignalName(String peripheral, String clockRole) {
        String result = null;
        PeripheralComponent peripheralComponent = this.mcu.getClockConsumers().findPeriphComponentById(peripheral);
        if (peripheralComponent != null) {
            PeripheralComponentInput signal = peripheralComponent.findSignal(clockRole);
            if (signal instanceof InputSignal) {
                result = ((InputSignal)signal).getSignal();
            } else if (signal instanceof PinSignal) {
                PinSignal pinSignal = (PinSignal)signal;
                result = ExpressionFunctions.createPinSignal(pinSignal.getSignal(), pinSignal.getChannel());
            }
        }
        return result;
    }

    private static String createPinSignal(String signal, String channel) {
        return String.valueOf(signal) + (channel.isEmpty() ? "" : "." + channel);
    }

    private static long toHertz(Frequency frequency) {
        BigDecimal bigDecimal = ExpressionFunctions.toHertzFloat(frequency).toBigDecimal();
        return bigDecimal.longValue();
    }

    private static BigRational toHertzFloat(Frequency frequency) {
        Frequency hertz = FrequencyCalculator.toHertz((Frequency)frequency);
        return hertz.getValue();
    }

    public IValue execScript(IChild child, String scriptPath) {
        File scriptFile = ExpressionFunctions.solveScriptPath(child, scriptPath);
        if (scriptFile == null) {
            String description = "Can't resolve path to javascript in " + this.function.getName();
            return ExpressionFunctionsUtils.throwSevere(description, ExpressionFunctions.class, this.function);
        }
        ArrayList result = null;
        SimpleScriptContext simpleScriptContext = new SimpleScriptContext();
        simpleScriptContext.setAttribute(SCRIPT_CONTEXT_CHILD_ATTRIBUTE, child, 100);
        simpleScriptContext.setAttribute(SCRIPT_CONTEXT_DEBUG_LOGGER, LOGGER, 100);
        ExpressionFunctions.setSystemDirectory(child, simpleScriptContext);
        try {
            result = JavaScriptHelper.eval((File)scriptFile, (ScriptContext)simpleScriptContext);
            if (result instanceof Map) {
                result = new ArrayList(((Map)((Object)result)).values());
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, e.getMessage());
        }
        if (result == null) {
            String description = "Script result value is null in " + this.function.getName();
            return ExpressionFunctionsUtils.throwSevere(description, ExpressionFunctions.class, this.function);
        }
        return Value.of((Object)result);
    }

    public IValue execScriptFunction(IChild child, String scriptPath, String functionName, Object ... arguments) {
        File scriptFile = ExpressionFunctions.solveScriptPath(child, scriptPath);
        if (scriptFile == null) {
            String description = "Can't resolve path to javascript in " + this.function.getName();
            return ExpressionFunctionsUtils.throwSevere(description, ExpressionFunctions.class, this.function);
        }
        SimpleScriptContext simpleScriptContext = new SimpleScriptContext();
        simpleScriptContext.setAttribute(SCRIPT_CONTEXT_PROFILE_ATTRIBUTE, child.getChildContext().getRoot(), 100);
        simpleScriptContext.setAttribute(SCRIPT_CONTEXT_CHILD_ATTRIBUTE, child, 100);
        simpleScriptContext.setAttribute(SCRIPT_CONTEXT_DEBUG_LOGGER, LOGGER, 100);
        ExpressionFunctions.setSystemDirectory(child, simpleScriptContext);
        ArrayList result = null;
        try {
            result = JavaScriptHelper.execFunction((File)scriptFile, (ScriptContext)simpleScriptContext, (String)functionName, (Object[])arguments);
            if (result == null) {
                return ExpressionFunctionsUtils.throwSevere(MessageFormat.format("Execution of javascript function {0} failed", functionName), ExpressionFunctions.class, this.function);
            }
            if (result instanceof Map) {
                result = new ArrayList(((Map)((Object)result)).values());
            }
        }
        catch (Exception e) {
            return ExpressionFunctionsUtils.throwSevere(UtilsText.safeString((String)e.getMessage()), ExpressionFunctions.class, this.function);
        }
        return Value.of((Object)result);
    }

    public IValue getSeries() {
        return Value.of((String)this.mcu.getSeries());
    }

    public IValue getPartNumber() {
        return Value.of((String)this.mcu.getPartNumber());
    }

    public IValue getFamily() {
        return Value.of((String)this.mcu.getFamily());
    }

    public IValue getPackage() {
        return Value.of((String)this.mcu.getPackage());
    }

    public IValue getSdkVersion() {
        return Value.of((String)this.mcu.getSdkVersion());
    }

    public IValue getDataVersion() {
        return Value.of((String)this.mcu.getDataVersion());
    }

    public IValue indexOf(List<?> array, Object child) {
        return Value.of((long)array.indexOf(child));
    }

    public IValue getArrayDifferences(List<?> firstArray, List<?> secondArray, List<?> defaultArray) {
        ArrayList result = new ArrayList(firstArray);
        result.removeAll(secondArray);
        if (result.isEmpty()) {
            return Value.of(defaultArray);
        }
        return Value.of(result);
    }

    public IValue getEnv(String variable) {
        return Value.of((String)this.utils.getEnv(variable));
    }

    public IValue getConfigurationName() {
        return Value.of((String)this.utils.getConfigurationName());
    }

    private static @Nullable File solveScriptPath(IChild child, String scriptPath) {
        File scriptFile = new File(scriptPath);
        if (!scriptFile.isAbsolute()) {
            IComponentConfig componentConfig = child.getChildContext().getComponentConfig();
            if (componentConfig == null && (componentConfig = child.getChildContext().getRoot().getSystemComponentConfig()) == null) {
                return null;
            }
            Path currentComponentPath = componentConfig.getConfigCompTypeId().getFileLocation();
            scriptFile = currentComponentPath.resolve(scriptPath).normalize().toFile();
        }
        return scriptFile;
    }

    private static void setSystemDirectory(IChild child, ScriptContext context) {
        IComponentConfig systemComp = child.getChildContext().getRoot().getSystemComponentConfig();
        if (systemComp != null) {
            context.setAttribute(SCRIPT_CONTEXT_SYSTEM_DIR, systemComp.getConfigCompTypeId().getFileLocation().toString(), 100);
        }
    }

    public IValue toUnresolvedExpressionsArray(Object ... values) {
        return this.toArray(values);
    }

    public IValue getArPackageDocument() {
        ScriptXMLDocument arPackageDocument = this.utils.getArPackageDocument();
        if (arPackageDocument == null) {
            return ExpressionFunctionsUtils.throwSevere("ArPackage Document is not available.", ExpressionFunctions.class, this.function);
        }
        return Value.of((Object)arPackageDocument);
    }

    public IValue isArPackageDocumentCreated() {
        return Value.of((this.utils.getArPackageDocument() != null ? 1 : 0) != 0);
    }

    public static class ExpressionFunctionArrayList<T>
    extends ArrayList<T> {
        private static final long serialVersionUID = 1L;

        public ExpressionFunctionArrayList() {
        }

        public ExpressionFunctionArrayList(Collection<? extends T> c) {
            super(c);
        }

        public ExpressionFunctionArrayList(int initialCapacity) {
            super(initialCapacity);
        }
    }
}

