/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.resourcetables.model.data;

import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class ComponentLoadingStatus {
    private static final Map<Object, ComponentLoadingStatus> INSTANCES = new HashMap<Object, ComponentLoadingStatus>();
    private String currentlyLoadingComponent = "";

    private static final synchronized ComponentLoadingStatus getInstance(Object key) {
        ComponentLoadingStatus instance = INSTANCES.get(key);
        if (instance == null) {
            instance = new ComponentLoadingStatus();
            INSTANCES.put(key, instance);
        }
        return instance;
    }

    public static final ComponentLoadingStatus getInstanceForCurrentThread() {
        return ComponentLoadingStatus.getInstance(Thread.currentThread());
    }

    public void setCurrentlyLoadingComponent(File component) {
        this.currentlyLoadingComponent = ComponentLoadingStatus.getFolder(component);
    }

    public void clearCurrentlyLoadingComponent() {
        this.currentlyLoadingComponent = "";
    }

    public String getCurrentlyLoadingComponent() {
        return this.currentlyLoadingComponent;
    }

    private static String getFolder(File file) {
        File componentFolder;
        if (file.isFile() && (componentFolder = file.getParentFile()) != null && componentFolder.isDirectory()) {
            return componentFolder.getName();
        }
        return file.getAbsolutePath();
    }
}

