/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.resourcetables.model.data.setting;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.expression.Expression;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.resourcetables.model.data.Description;
import com.nxp.swtools.resourcetables.model.data.OptionsExpr;
import com.nxp.swtools.resourcetables.model.data.setting.ASetting;
import com.nxp.swtools.resourcetables.model.data.setting.IUIName;
import com.nxp.swtools.resourcetables.model.data.setting.ReferenceSetting;
import java.util.Collection;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Root;

@Root(name="string", strict=false)
public class StringSetting
extends ASetting {
    @Nullable
    private Expression validationExpr;
    @Nullable
    private String validationExprString = null;

    public StringSetting(String id, @Nullable String uiName, @Nullable String uiNameExpr, @Nullable Description description, @Nullable String availableCond, @Nullable String enableCond, @Nullable String publicCond, @Nullable String options, @Nullable OptionsExpr optionsExpression, @Nullable String validationExpressionString) {
        super(id, uiName, uiNameExpr, description, availableCond, enableCond, publicCond, options, optionsExpression);
        this.setValidationExprString(UtilsText.safeString((String)validationExpressionString));
    }

    @Deprecated
    protected StringSetting() {
    }

    @Attribute(name="validation_expr", required=false)
    public void setValidationExprString(String validationExprString) {
        this.validationExprString = validationExprString;
        try {
            this.validationExpr = UtilsText.isEmpty((String)validationExprString) ? null : Expression.create((String)validationExprString);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Validation condition of string setting \"" + this.getId() + "\" caused exception: " + e.getLocalizedMessage());
        }
    }

    public @Nullable Expression getValidationExpression() {
        return this.validationExpr;
    }

    @Attribute(name="validation_expr", required=false)
    public @Attribute(name="validation_expr", required=false) String getValidationExprString() {
        if (this.validationExprString != null) {
            return this.validationExprString;
        }
        return "";
    }

    @Override
    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " [" + super.toString() + "]";
    }

    @Override
    public StringSetting fromReference(ReferenceSetting ref) {
        // Could not load outer class - annotation placement on inner may be incorrect
        CollectionsUtils.Pair<@Nullable String, @Nullable String> uiNames = IUIName.getUiNames(ref, this);
        StringSetting stringSetting = new StringSetting(ref.getId(), (String)uiNames.getFirst(), (String)uiNames.getSecond(), this.getDescription(ref.getDescription()), StringSetting.andConditions(ref.getAvailableExprString(), this.getAvailableExprString()), StringSetting.andConditions(ref.getEnableExprString(), this.getEnableExprString()), StringSetting.andConditions(ref.getPublicCondition(), this.getPublicCondition()), null, null, this.getValidationExprString());
        stringSetting.setOptionsMap(this.createOptionsMap(this.getOptionsMap(), ref.getOptionsMap()));
        stringSetting.setValidation(this.mergeValidations(ref.getValidation(), this.getValidation()));
        stringSetting.setMigrations(ref.getMigrations());
        stringSetting.setAssigns(CollectionsUtils.mergeToList((Collection[])new Collection[]{ref.getAssigns(), this.getAssigns()}));
        stringSetting.verify();
        return stringSetting;
    }

    @Override
    public @NonNull String getTypeName() {
        return "string";
    }
}

