/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.resourcetables.model.mcu;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.ArraysUtils;
import com.nxp.swtools.core.service.scriptapi.db.IRegParentPeripheralAPI;
import com.nxp.swtools.core.service.scriptapi.db.IRegistersDatabaseAPI;
import com.nxp.swtools.expert.clock.modules.PeripheralComponentFile;
import com.nxp.swtools.kex.selector.IMcuIdentification;
import com.nxp.swtools.provider.configuration.storage.ProcessorCore;
import com.nxp.swtools.resourcetables.model.data.McuResourceTables;
import com.nxp.swtools.utils.scripting.api.IMcuInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public interface ICommonMcu
extends IMcuInfo {
    public static final String ALIAS_ID_SDK_BASE_POINTER = "sdk_base_pointer";
    public static final String ALIAS_ID_PERIPHERAL_TYPE = "type";

    public @Nullable McuResourceTables getMcuResourceTables();

    public IMcuIdentification getMcuIdentification();

    public Collection<ProcessorCore> getCores();

    public @Nullable ProcessorCore getCore(String var1);

    public @Nullable String getPeripheralType(String var1);

    public List<String> getPeripherals();

    public List<String> getPeripherals(String var1);

    default public List<IRegParentPeripheralAPI> getPeripheralsForCore(String core) {
        ArrayList<IRegParentPeripheralAPI> result = new ArrayList<IRegParentPeripheralAPI>();
        IRegistersDatabaseAPI registersDB = this.getRegistersDb();
        if (registersDB != null) {
            for (String peripheralInstance : this.getPeripherals()) {
                Object[] cores;
                IRegParentPeripheralAPI api = registersDB.getPeripheral(peripheralInstance);
                if (api == null || !Objects.isNull(cores = api.getCores()) && !ArraysUtils.contains((Object[])cores, (Object)core)) continue;
                result.add(api);
            }
        }
        return result;
    }

    public @Nullable IRegistersDatabaseAPI getRegistersDb();

    default public IRegistersDatabaseAPI requireRegistersDb() {
        return Objects.requireNonNull(this.getRegistersDb());
    }

    public boolean isMulticore();

    public String getMasterCore();

    public @Nullable String getCoreUiName(String var1);

    public PeripheralComponentFile getClockConsumers();

    public boolean hasFeature(String var1, @Nullable String var2, @Nullable String var3);

    public @Nullable String getFeature(String var1, @Nullable String var2, @Nullable String var3);

    default public boolean isPeripheralAvailableForCore(String core, String peripheralInstance) {
        IRegistersDatabaseAPI registersDB = this.getRegistersDb();
        if (registersDB == null) {
            return false;
        }
        IRegParentPeripheralAPI api = registersDB.getPeripheral(peripheralInstance);
        if (api == null) {
            return false;
        }
        String[] cores = api.getCores();
        if (cores == null) {
            return true;
        }
        return Arrays.asList(cores).contains(core);
    }
}

