/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.launching.launcher;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.launching.PDELaunchingPlugin;
import org.eclipse.pde.internal.launching.PDEMessages;
import org.eclipse.pde.internal.launching.launcher.BundleLauncherHelper;
import org.eclipse.pde.internal.launching.launcher.LaunchValidationOperation;
import org.eclipse.pde.internal.launching.launcher.RequirementHelper;

public class EclipsePluginValidationOperation
extends LaunchValidationOperation {
    public static final int CREATE_EXTENSION_ERROR_CODE = 1000;
    private Map<Object, Object[]> fExtensionErrors = new HashMap<Object, Object[]>(2);
    private static Object[] EMPTY = new Object[0];

    public EclipsePluginValidationOperation(ILaunchConfiguration configuration) {
        super(configuration);
    }

    @Override
    protected IPluginModelBase[] getModels() throws CoreException {
        return BundleLauncherHelper.getMergedBundles(this.fLaunchConfiguration, false);
    }

    @Override
    public void run(IProgressMonitor monitor) throws CoreException {
        super.run(monitor);
        if (!this.fExtensionErrors.isEmpty()) {
            this.fExtensionErrors.clear();
        }
        this.validateExtensions();
    }

    private void validateExtensions() {
        try {
            String[] required;
            String[] stringArray = required = RequirementHelper.getApplicationRequirements(this.fLaunchConfiguration);
            int n = required.length;
            int n2 = 0;
            while (n2 < n) {
                String element = stringArray[n2];
                BundleDescription bundle = this.getState().getBundle(element, null);
                if (bundle == null) {
                    String message = NLS.bind((String)PDEMessages.EclipsePluginValidationOperation_pluginMissing, (Object)element);
                    Status status = new Status(4, "org.eclipse.pde.launching", 1000, message, null);
                    IStatusHandler statusHandler = DebugPlugin.getDefault().getStatusHandler((IStatus)status);
                    Object extensionError = null;
                    extensionError = statusHandler == null ? status.getMessage() : statusHandler.handleStatus((IStatus)status, (Object)element);
                    this.fExtensionErrors.put(extensionError, EMPTY);
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            PDELaunchingPlugin.log(e);
        }
    }

    @Override
    public boolean hasErrors() {
        return super.hasErrors() || this.fExtensionErrors.size() >= 1;
    }

    @Override
    public Map<Object, Object[]> getInput() {
        Map<Object, Object[]> map = super.getInput();
        map.putAll(this.fExtensionErrors);
        return map;
    }
}

