/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.debug.ide.s32debugger.core;

import com.nxp.s32ds.debug.ide.s32debugger.core.GtaErrorCodes;
import com.nxp.s32ds.debug.ide.s32debugger.core.S32DebuggerErrorMessages;
import java.io.IOException;
import java.util.Properties;

public class BoardConnectionDescriptor {
    public static final String ANSWER_PARAMETER_SEPARATOR = ":";
    private static final String SUCCESS_ANSWER = "Success";
    private static final String SOC_REQUEST = "SoC Request";
    private static final String SOC_ERROR = "SoC Error";
    private static final String SOC_RESET_STATE = "SoC Reset";
    private static final String SOC_TYPE = "SoC Type";
    private static final String SOC_ID_CODE = "SoC IDCODE";
    private static final String SOC_UID_CODE = "SoC UID";
    private static final String SOC_DEBUG_STATE = "SoC Debug";
    private final boolean successful;
    private final int errorCode;
    private String resetStatus;
    private String boardType;
    private String idCodeHex;
    private String uId;
    private String debugState;

    public static BoardConnectionDescriptor createFromProperties(Properties boardConenctionStrings) throws IOException {
        return new BoardConnectionDescriptor(boardConenctionStrings);
    }

    private BoardConnectionDescriptor(Properties boardConenctionStrings) throws IOException {
        if (!boardConenctionStrings.containsKey(SOC_REQUEST)) {
            throw new IOException(S32DebuggerErrorMessages.S32DebuggerBoardConnection_no_status_field);
        }
        this.successful = SUCCESS_ANSWER.equals((String)boardConenctionStrings.get(SOC_REQUEST));
        if (!boardConenctionStrings.containsKey(SOC_ERROR)) {
            throw new IOException(S32DebuggerErrorMessages.S32DebuggerBoardConnection_no_error_field);
        }
        this.errorCode = Integer.valueOf((String)boardConenctionStrings.get(SOC_ERROR));
        if (boardConenctionStrings.containsKey(SOC_RESET_STATE)) {
            this.resetStatus = (String)boardConenctionStrings.get(SOC_RESET_STATE);
        }
        if (boardConenctionStrings.containsKey(SOC_TYPE)) {
            this.boardType = (String)boardConenctionStrings.get(SOC_TYPE);
        }
        if (boardConenctionStrings.containsKey(SOC_ID_CODE)) {
            this.idCodeHex = (String)boardConenctionStrings.get(SOC_ID_CODE);
        }
        if (boardConenctionStrings.containsKey(SOC_UID_CODE)) {
            this.uId = (String)boardConenctionStrings.get(SOC_UID_CODE);
        }
        if (boardConenctionStrings.containsKey(SOC_DEBUG_STATE)) {
            this.debugState = (String)boardConenctionStrings.get(SOC_DEBUG_STATE);
        }
    }

    public boolean isSuccessful() {
        return this.successful;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public String getResetStatus() {
        return this.resetStatus;
    }

    public String getBoardType() {
        return this.boardType;
    }

    public String getIdCodeHex() {
        return this.idCodeHex;
    }

    public String getUId() {
        return this.uId;
    }

    public String getDebugStatus() {
        return this.debugState;
    }

    public String getErrorMessage() {
        return GtaErrorCodes.getErrorByCode(this.errorCode);
    }
}

