/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.debug.ide.s32debugger.internal.core;

import com.nxp.s32ds.cle.runtime.hardware.registry.DeviceCoreDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.core.DeviceDescriptors;
import com.nxp.s32ds.cle.runtime.hardware.registry.core.HardwareCompatibilityDescriptors;
import com.nxp.s32ds.debug.ide.core.DebuggerLaunchSequence;
import com.nxp.s32ds.debug.ide.core.DebuggerUtils;
import com.nxp.s32ds.debug.ide.core.S32DSGdbLaunch;
import com.nxp.s32ds.debug.ide.core.S32DSGdbServerProcess;
import com.nxp.s32ds.debug.ide.core.S32DebuggerErrorStatuses;
import com.nxp.s32ds.debug.ide.s32debugger.core.S32DebuggerBackend;
import com.nxp.s32ds.debug.ide.s32debugger.core.S32DebuggerCoreActivator;
import com.nxp.s32ds.debug.ide.s32debugger.core.S32DebuggerErrorMessages;
import com.nxp.s32ds.debug.ide.s32debugger.validation.S32DebuggerAttributesValidator;
import com.nxp.s32ds.debug.ide.s32debugger.validation.S32DebuggerParams;
import com.nxp.s32ds.debug.ide.s32debugger.validation.S32DebuggerStartupParams;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ReflectionSequence;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitorWithProgress;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IMemory;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.command.ICommand;
import org.eclipse.cdt.dsf.gdb.service.IGDBMemory;
import org.eclipse.cdt.dsf.gdb.service.command.IGDBControl;
import org.eclipse.cdt.dsf.mi.service.IMIContainerDMContext;
import org.eclipse.cdt.dsf.mi.service.IMIProcesses;
import org.eclipse.cdt.dsf.mi.service.MIBreakpointsManager;
import org.eclipse.cdt.dsf.mi.service.command.commands.CLICommand;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;

public class S32DebuggerLaunchSequence
extends DebuggerLaunchSequence {
    private static final String NONE = "None";
    private static final String CONTINUE_CMD = "-exec-continue";
    private static final String TBREAK_S = "tbreak %s";
    private static final String SET_PC_S = "set $pc=%s";
    private static final String LOAD_S_S = "load \"%s\" %s";
    private static final String SYMBOL_FILE_S = "symbol-file \"%s\"";
    private static final String ADD_SYMBOL_FILE_S_S = "add-symbol-file \"%s\" %s";
    private static final String FLUSH_REGS = "flushregs";
    private static final String PY_BOARD_INIT = "py board_init()";
    private static final String PY_CORE_INIT = "py core_init()";
    private static final String PY_REMOTE_TIMEOUT_S = "py _REMOTE_TIMEOUT = %s";
    private static final String PY_CORE_NAME_S = "py _CORE_NAME = \"%s\"";
    private static final String PY_PROBE_IP_NONE = "py _PROBE_IP = None";
    private static final String STEP_EXECUTE_USER_RUN_COMMANDS = "stepExecuteUserRunCommands";
    private static final String STEP_RESUME = "stepResume";
    private static final String STEP_SET_BREAKPOINT = "stepSetBreakpoint";
    private static final String STEP_SET_PC = "stepSetPc";
    private static final String STEP_START_TRACKING_BREAKPOINTS = "stepStartTrackingBreakpoints";
    private static final String STEP_INITIALIZE_MEMORY = "stepInitializeMemory";
    private static final String STEP_ASSIGN_P_ID_TO_CONTAINER = "stepAssignPIdToContainer";
    private static final String STEP_LOAD_IMAGE = "stepLoadImage";
    private static final String STEP_LOAD_SYMBOLS = "stepLoadSymbols";
    private static final String STEP_SOURCE_INITIALIZATION_SCRIPT = "stepSourceInitializationScript";
    private static final String STEP_INIT_BOARD = "stepInitializeBoard";
    private static final String STEP_INIT_CORE = "stepInitializeCore";
    private static final String STEP_INITIALIZE_SEMIHOSTING_CONSOLE = "stepInitializeSemihostingConsole";
    private IGDBControl commandControl;
    private IMIProcesses procService;
    private IMIContainerDMContext containerContext;
    private S32DebuggerBackend gdbServerBackend;
    private S32DebuggerAttributesValidator validator;
    private S32DebuggerParams debuggerParams;
    private S32DebuggerStartupParams startupParams;
    private boolean doLaunchServer;

    public S32DebuggerLaunchSequence(DsfSession session, Map<String, Object> attributes, RequestMonitorWithProgress rm) {
        super(session, attributes, rm);
        ILaunchConfiguration lc = this.launch.getLaunchConfiguration();
        this.debuggerParams = S32DebuggerParams.getParams((ILaunchConfiguration)lc);
        this.startupParams = S32DebuggerStartupParams.getParams((ILaunchConfiguration)lc);
        this.validator = new S32DebuggerAttributesValidator();
        this.doLaunchServer = this.debuggerParams.isDoLaunchServer();
        IStatus status = this.validator.validateParameters(this.debuggerParams, this.startupParams, true);
        if (status.isOK()) {
            if (this.debuggerParams.isInitialCore() && this.debuggerParams.isUseSecureDebugging()) {
                if ("PWD".equals(this.debuggerParams.getSecureDebuggingType())) {
                    rm.setStatus(this.getSecureDebuggingKeyWord());
                } else {
                    rm.setStatus(this.getSmartCardPassword());
                }
            }
        } else {
            rm.setStatus(status);
        }
        if (!rm.getStatus().isOK()) {
            rm.done();
        }
    }

    private void queueCommand(String command, RequestMonitor rm) {
        if (!command.isEmpty()) {
            this.commandControl.queueCommand((ICommand)new CLICommand((IDMContext)this.commandControl.getContext(), command), new DataRequestMonitor((Executor)this.getExecutor(), rm));
        } else {
            rm.done();
        }
    }

    protected String[] getExecutionOrder(String group) {
        if ("GROUP_TOP_LEVEL".equals(group)) {
            ArrayList<String> orderList = new ArrayList<String>(Arrays.asList(super.getExecutionOrder("GROUP_TOP_LEVEL")));
            orderList.removeAll(Arrays.asList("stepNewProcess"));
            orderList.add(orderList.indexOf("stepDataModelInitializationComplete"), "GROUP_S32Debugger");
            return orderList.toArray(new String[orderList.size()]);
        }
        if ("GROUP_S32Debugger".equals(group)) {
            return new String[]{"stepInitializeDebuggerFinalLaunchSequence", "stepInitializeGdbServerProcess", STEP_INITIALIZE_SEMIHOSTING_CONSOLE, STEP_SOURCE_INITIALIZATION_SCRIPT, STEP_INIT_BOARD, STEP_INIT_CORE, STEP_LOAD_SYMBOLS, STEP_LOAD_IMAGE, STEP_ASSIGN_P_ID_TO_CONTAINER, STEP_INITIALIZE_MEMORY, STEP_START_TRACKING_BREAKPOINTS, STEP_SET_PC, STEP_SET_BREAKPOINT, STEP_RESUME, STEP_EXECUTE_USER_RUN_COMMANDS, "stepDebuggerCleanup"};
        }
        return super.getExecutionOrder(group);
    }

    @ReflectionSequence.Execute
    public void stepInitializeDebuggerFinalLaunchSequence(RequestMonitor rm) {
        this.tracker = new DsfServicesTracker(S32DebuggerCoreActivator.getContext(), this.launch.getSession().getId());
        this.gdbServerBackend = (S32DebuggerBackend)((Object)this.tracker.getService(S32DebuggerBackend.class));
        if (this.gdbServerBackend == null) {
            this.shutdownOnError("com.nxp.s32ds.debug.ide.s32debugger.ui.gdbErrorStatusHandler", S32DebuggerErrorStatuses.getGDBNoBackendStatus());
            rm.done();
            return;
        }
        this.commandControl = (IGDBControl)this.tracker.getService(IGDBControl.class);
        if (this.commandControl == null) {
            this.shutdownOnError("com.nxp.s32ds.debug.ide.s32debugger.ui.gdbErrorStatusHandler", S32DebuggerErrorStatuses.getGDBNoControlStatus());
            rm.done();
            return;
        }
        this.procService = (IMIProcesses)this.tracker.getService(IMIProcesses.class);
        if (this.procService == null) {
            this.shutdownOnError("com.nxp.s32ds.debug.ide.s32debugger.ui.gdbErrorStatusHandler", S32DebuggerErrorStatuses.getGDBNoStatusProcessor());
            rm.done();
            return;
        }
        this.containerContext = this.procService.createContainerContextFromGroupId(this.commandControl.getContext(), "i1");
        if (!this.debuggerParams.getClientCommands().isEmpty()) {
            String gdbSetCommands = String.valueOf(this.debuggerParams.getClientCommands()) + "\n";
            this.queueCommand(gdbSetCommands, rm);
        }
        rm.done();
    }

    @ReflectionSequence.RollBack(value="stepInitializeDebuggerFinalLaunchSequence")
    public void rollBackInitializeFinalLaunchSequenceS32DS(RequestMonitor rm) {
        this.cleanUp();
        rm.done();
    }

    @ReflectionSequence.Execute
    public void stepInitializeGdbServerProcess(RequestMonitor rm) throws DebugException {
        if (!S32DSGdbServerProcess.isServerRunning()) {
            if (this.debuggerParams.isInitialCore()) {
                this.shutdownOnError("com.nxp.s32ds.debug.ide.s32debugger.ui.gdbErrorStatusHandler", (IStatus)new Status(4, "com.nxp.s32ds.debug.ide.core", S32DebuggerErrorMessages.S32DebuggerGTANo_server_for_initial_launch));
                this.launch.shutdownSession((RequestMonitor)new ImmediateRequestMonitor());
            } else {
                this.shutdownOnError("com.nxp.s32ds.debug.ide.s32debugger.ui.gdbErrorStatusHandler", (IStatus)new Status(4, "com.nxp.s32ds.debug.ide.core", S32DebuggerErrorMessages.S32DebuggerGTANo_initial_launch));
            }
            rm.done();
            return;
        }
        if (this.doLaunchServer && !this.gdbServerBackend.initializeGdbServerProcess()) {
            this.shutdownOnError("com.nxp.s32ds.debug.ide.s32debugger.ui.gdbErrorStatusHandler", null);
            rm.done();
            return;
        }
        rm.done();
    }

    @ReflectionSequence.Execute
    public void stepInitializeSemihostingConsole(RequestMonitor rm) throws DebugException {
        if (this.doLaunchServer && this.debuggerParams.isSemihostingEnabled()) {
            this.gdbServerBackend.initializeSemihostingConsole(this.debuggerParams.getSemihostingPort());
        }
        rm.done();
    }

    @ReflectionSequence.Execute
    public void stepSourceInitializationScript(RequestMonitor rm) {
        String deviceCoreId = this.debuggerParams.getDeviceCoreId();
        DeviceCoreDescriptor deviceCoreDescriptor = DeviceDescriptors.getDeviceCoreDescriptor((String)deviceCoreId);
        String coreName = HardwareCompatibilityDescriptors.computeCompatibleHardwareByComponent((String)"s32debugger", (String)deviceCoreDescriptor.getId());
        String coreCommand = String.format(PY_CORE_NAME_S, coreName);
        String deviceCommand = String.format("py _SOC_NAME = \"%s\"", deviceCoreDescriptor.getDeviceId());
        String gdbServerCommand = String.format("py _GDB_SERVER_PORT = %s", this.debuggerParams.getServerPort());
        if (this.doLaunchServer) {
            String isLoggingEnabledCommand = String.format("py _IS_LOGGING_ENABLED = %s", this.debuggerParams.isLogEnabled() ? "True" : "False");
            this.queueCommand(isLoggingEnabledCommand, (RequestMonitor)new ImmediateRequestMonitor());
        } else {
            this.queueCommand(String.format("py _IS_LOGGING_ENABLED = %s", "False"), (RequestMonitor)new ImmediateRequestMonitor());
        }
        this.queueCommand(String.format(PY_REMOTE_TIMEOUT_S, this.debuggerParams.getRemoteTimeoutInSeconds()), (RequestMonitor)new ImmediateRequestMonitor());
        this.queueCommand(coreCommand, (RequestMonitor)new ImmediateRequestMonitor());
        this.queueCommand(deviceCommand, (RequestMonitor)new ImmediateRequestMonitor());
        if (!this.debuggerParams.getDeviceRevision().isEmpty()) {
            String revisionCommand = String.format("py _SOC_REVISION = \"%s\"", this.debuggerParams.getDeviceRevision());
            this.queueCommand(revisionCommand, (RequestMonitor)new ImmediateRequestMonitor());
        }
        this.queueCommand(gdbServerCommand, (RequestMonitor)new ImmediateRequestMonitor());
        if (this.debuggerParams.isInitialCore()) {
            String jtagSpeedKHz = this.debuggerParams.getJtagSpeedKHz();
            if (jtagSpeedKHz != null && !jtagSpeedKHz.isEmpty()) {
                this.queueCommand(String.format("py _JTAG_SPEED = %s", jtagSpeedKHz), (RequestMonitor)new ImmediateRequestMonitor());
            } else {
                this.queueCommand(String.format("py _JTAG_SPEED = %s", NONE), (RequestMonitor)new ImmediateRequestMonitor());
            }
            boolean doResetAndDelay = this.debuggerParams.isDoResetAndDelay();
            if (doResetAndDelay) {
                this.queueCommand(String.format("py _RESET_DELAY = %s", this.debuggerParams.getDelayInMSeconds()), (RequestMonitor)new ImmediateRequestMonitor());
            } else {
                this.queueCommand(String.format("py _RESET_DELAY = %s", 0), (RequestMonitor)new ImmediateRequestMonitor());
            }
            this.queueCommand(String.format("py _PROBE_IP = \"%s\"", this.validator.getDebuggerConnectionString()), (RequestMonitor)new ImmediateRequestMonitor());
            String resetTypeCommand = doResetAndDelay ? String.format("py _RESET_TYPE = \"%s\"", "default") : "py _RESET_TYPE = None";
            this.queueCommand(resetTypeCommand, (RequestMonitor)new ImmediateRequestMonitor());
        } else {
            this.queueCommand(String.format("py _JTAG_SPEED = %s", NONE), (RequestMonitor)new ImmediateRequestMonitor());
            this.queueCommand(PY_PROBE_IP_NONE, (RequestMonitor)new ImmediateRequestMonitor());
            this.queueCommand("py _RESET_TYPE = None", (RequestMonitor)new ImmediateRequestMonitor());
            this.queueCommand(String.format("py _RESET_DELAY = %s", 0), (RequestMonitor)new ImmediateRequestMonitor());
        }
        if (this.debuggerParams.isUseSecureDebugging()) {
            this.queueCommand(String.format("py _SECURE_TYPE = \"%s\"", this.debuggerParams.getSecureDebuggingType()), (RequestMonitor)new ImmediateRequestMonitor());
            this.queueCommand(String.format("py _SECURE_KEY = \"%s\"", this.keyWord), (RequestMonitor)new ImmediateRequestMonitor());
        }
        this.queueCommand(String.format("source %s", DebuggerUtils.substitute((String)this.debuggerParams.getInitializationScript())), rm);
    }

    @ReflectionSequence.Execute
    public void stepInitializeBoard(RequestMonitor rm) {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            S32DebuggerCoreActivator.getDefault().logError("Thread was interrupted during delay before board initiailization.");
        }
        if (this.doLaunchServer && !S32DSGdbLaunch.isShutdowned((ILaunch)this.launch)) {
            this.queueCommand(PY_BOARD_INIT, rm);
        } else {
            rm.done();
        }
    }

    @ReflectionSequence.Execute
    public void stepInitializeCore(RequestMonitor rm) {
        if (!S32DSGdbLaunch.isShutdowned((ILaunch)this.launch)) {
            this.queueCommand(PY_CORE_INIT, rm);
        } else {
            rm.done();
        }
    }

    @ReflectionSequence.Execute
    public void stepLoadSymbols(RequestMonitor rm) {
        if (this.startupParams.isDoLoadSymbols() && !S32DSGdbLaunch.isShutdowned((ILaunch)this.launch)) {
            String fileWithSymbolsPath;
            this.launch.setInRunningState();
            if (this.startupParams.isUseProjectBinaryForSymbols()) {
                IPath path = this.gdbServerBackend.getProgramPath();
                fileWithSymbolsPath = path.toOSString();
            } else {
                fileWithSymbolsPath = this.startupParams.getSymbolsFileName();
                fileWithSymbolsPath = DebuggerUtils.substitute((String)fileWithSymbolsPath);
            }
            fileWithSymbolsPath = fileWithSymbolsPath.replace("\\", "\\\\");
            String symbolsOffset = this.startupParams.getSymbolsOffset();
            if (symbolsOffset != null && !symbolsOffset.isEmpty()) {
                symbolsOffset = "0x" + symbolsOffset;
                this.queueCommand(String.format(ADD_SYMBOL_FILE_S_S, fileWithSymbolsPath, symbolsOffset), rm);
            } else {
                this.queueCommand(String.format(SYMBOL_FILE_S, fileWithSymbolsPath), rm);
            }
        } else {
            rm.done();
        }
    }

    @ReflectionSequence.Execute
    public void stepLoadImage(RequestMonitor rm) {
        if (this.startupParams.isDoLoadImage() && !S32DSGdbLaunch.isShutdowned((ILaunch)this.launch)) {
            String imageFilePath;
            if (this.startupParams.isUseProjectBinaryForImage()) {
                imageFilePath = this.gdbServerBackend.getProgramPath().toOSString();
            } else {
                imageFilePath = this.startupParams.getImageFileName();
                imageFilePath = DebuggerUtils.substitute((String)imageFilePath);
            }
            String imageOffset = this.startupParams.getImageOffset();
            if (imageOffset != null && !imageOffset.isEmpty()) {
                imageOffset = "0x" + imageOffset;
            }
            this.queueCommand(String.format(LOAD_S_S, imageFilePath.replace("\\", "\\\\"), imageOffset), rm);
        } else {
            rm.done();
        }
    }

    @ReflectionSequence.Execute
    public void stepAssignPIdToContainer(RequestMonitor rm) {
        this.containerContext = this.procService.createContainerContextFromGroupId(this.commandControl.getContext(), this.containerContext.getGroupId());
        rm.done();
    }

    @ReflectionSequence.Execute
    public void stepInitializeMemory(RequestMonitor rm) {
        IGDBMemory memory = (IGDBMemory)this.tracker.getService(IGDBMemory.class);
        IMemory.IMemoryDMContext memContext = (IMemory.IMemoryDMContext)DMContexts.getAncestorOfType((IDMContext)this.containerContext, IMemory.IMemoryDMContext.class);
        if (memory == null || memContext == null) {
            rm.done();
            return;
        }
        memory.initializeMemoryData(memContext, rm);
    }

    @ReflectionSequence.Execute
    public void stepStartTrackingBreakpoints(RequestMonitor rm) {
        MIBreakpointsManager bpmService = (MIBreakpointsManager)this.tracker.getService(MIBreakpointsManager.class);
        bpmService.startTrackingBpForProcess((IRunControl.IContainerDMContext)this.containerContext, rm);
    }

    @ReflectionSequence.Execute
    public void stepSetPc(RequestMonitor rm) {
        if (this.startupParams.isDoSetPcRegister() && !S32DSGdbLaunch.isShutdowned((ILaunch)this.launch)) {
            this.queueCommand(String.format(SET_PC_S, this.startupParams.getPcRegisterValue()), rm);
        } else {
            rm.done();
        }
    }

    @ReflectionSequence.Execute
    public void stepSetBreakpoint(RequestMonitor rm) {
        if (this.startupParams.isDoSetStopAt() && !S32DSGdbLaunch.isShutdowned((ILaunch)this.launch)) {
            this.queueCommand(String.format(TBREAK_S, this.startupParams.getStopAt()), rm);
        } else {
            rm.done();
        }
    }

    @ReflectionSequence.Execute
    public void stepResume(RequestMonitor rm) {
        if (S32DSGdbLaunch.isShutdowned((ILaunch)this.launch)) {
            rm.done();
        } else {
            this.queueCommand("-list-thread-groups", (RequestMonitor)new ImmediateRequestMonitor());
            this.queueCommand("-thread-select 1", (RequestMonitor)new ImmediateRequestMonitor());
            if (this.startupParams.isDoResume()) {
                this.queueCommand(CONTINUE_CMD, rm);
            } else if (this.startupParams.isDoSetPcRegister()) {
                this.queueCommand(FLUSH_REGS, rm);
            } else {
                rm.done();
            }
        }
    }

    @ReflectionSequence.Execute
    public void stepExecuteUserRunCommands(RequestMonitor rm) {
        String runCommands = this.startupParams.getRunCommands();
        if (!runCommands.isEmpty() && !S32DSGdbLaunch.isShutdowned((ILaunch)this.launch)) {
            this.queueCommand(runCommands, rm);
        } else {
            rm.done();
        }
    }

    @ReflectionSequence.Execute
    public void stepDebuggerCleanup(RequestMonitor rm) {
        DebugEvent initFinishedEvent = new DebugEvent((Object)this.gdbServerBackend, 32);
        initFinishedEvent.setData((Object)this.launch);
        DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{initFinishedEvent});
        rm.done();
    }
}

