/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.runtime.migration.internal.provider.core;

import com.nxp.s32ds.cle.runtime.migration.internal.provider.core.MigrationProviderDescriptorImpl;
import com.nxp.s32ds.cle.runtime.migration.provider.MigrationProviderRegistry;
import com.nxp.s32ds.ext.rcp.runtime.Extensions;
import com.nxp.s32ds.ext.rcp.runtime.RcpBundle;
import org.eclipse.core.runtime.CoreException;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class MigrationProviderActivator
extends RcpBundle {
    public static final String BUNDLE_ID = "com.nxp.s32ds.cle.runtime.migration.provider.core";
    private static final String EXTENSION_ID = "migrationProvider";
    private static final String EXTENSION_ATTRIBUTE_ID = "migrationprovider";
    private ServiceTracker<MigrationProviderRegistry, MigrationProviderRegistry> migrationServiceTracker;
    private static MigrationProviderActivator INSTANCE;
    private BundleContext context;
    private static MigrationProviderRegistry migrationService;

    public String getBundleId() {
        return BUNDLE_ID;
    }

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        INSTANCE = this;
        this.context = bundleContext;
        this.createRegistry();
    }

    private void createRegistry() {
        this.migrationServiceTracker = new ServiceTracker(this.context, MigrationProviderRegistry.class, null);
        this.migrationServiceTracker.open();
        migrationService = (MigrationProviderRegistry)this.migrationServiceTracker.getService();
        if (migrationService != null) {
            this.registerMigrationProviders(migrationService);
        }
    }

    private void registerMigrationProviders(MigrationProviderRegistry migrationService) {
        Extensions.getConfigrationElements((String)BUNDLE_ID, (String)EXTENSION_ID, (String)EXTENSION_ATTRIBUTE_ID, (String[])new String[0]).stream().map(MigrationProviderDescriptorImpl::new).forEach(arg_0 -> ((MigrationProviderRegistry)migrationService).addMigrationProviderDescriptor(arg_0));
        migrationService.getMigrationProviderDescriptors().stream().forEach(c -> {
            try {
                c.contributeProvider();
            }
            catch (CoreException e) {
                this.log(e.getStatus());
            }
        });
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        this.migrationServiceTracker.close();
        this.migrationServiceTracker = null;
        migrationService = null;
        INSTANCE = null;
        this.context = null;
    }

    public static MigrationProviderActivator getInstance() {
        return INSTANCE;
    }

    public static MigrationProviderRegistry getMigrationProviderRegistry() {
        return migrationService;
    }
}

