/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.system.browser.internal.ui;

import com.freescale.system.browser.internal.ui.Tab;
import com.freescale.system.browser.internal.ui.TabDescriptor;
import com.freescale.system.browser.internal.ui.tabbed.ICustomSectionDescriptor;
import com.freescale.system.browser.internal.ui.tabbed.ISectionDescriptor;
import com.freescale.system.browser.ui.ISection;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.viewers.IFilter;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class CustomTabDescriptor
extends TabDescriptor {
    private String fId;
    private static final String ATT_ID = "id";
    protected List<ICustomSectionDescriptor> fSectionDescriptors = new ArrayList<ICustomSectionDescriptor>(5);

    public CustomTabDescriptor(IConfigurationElement configurationElement) {
        super(configurationElement);
        this.fId = configurationElement.getAttribute(ATT_ID);
        this.fTitle = configurationElement.getAttribute("title");
        String iconstr = configurationElement.getAttribute("image");
        if (iconstr != null) {
            this.fIcon = AbstractUIPlugin.imageDescriptorFromPlugin((String)configurationElement.getDeclaringExtension().getNamespaceIdentifier(), (String)iconstr);
        }
        if (this.fId == null || this.fTitle == null) {
            this.handleTabError(configurationElement, null);
        }
    }

    @Override
    protected void addSectionDescriptor(ISectionDescriptor sectionDescriptor) {
        ICustomSectionDescriptor target;
        if (sectionDescriptor instanceof ICustomSectionDescriptor && !this.insertSectionDescriptor(target = (ICustomSectionDescriptor)sectionDescriptor)) {
            this.fSectionDescriptors.add(target);
        }
    }

    private boolean insertSectionDescriptor(ICustomSectionDescriptor target) {
        if (target.getAfterSection().equals("top")) {
            this.fSectionDescriptors.add(0, target);
            return true;
        }
        int i = 0;
        for (ICustomSectionDescriptor sectionDecriptor : this.fSectionDescriptors) {
            if (target.getAfterSection().equals(sectionDecriptor.getId())) {
                this.fSectionDescriptors.add(i + 1, target);
                return true;
            }
            if (sectionDecriptor.getAfterSection().equals(target.getId())) {
                this.fSectionDescriptors.add(i, target);
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    protected Tab createTabEx() {
        ArrayList<ISection> sections = new ArrayList<ISection>(this.fSectionDescriptors.size());
        for (ICustomSectionDescriptor descriptor : this.fSectionDescriptors) {
            sections.add(descriptor.getSection());
        }
        Tab tab = new Tab(this, sections);
        return tab;
    }

    @Override
    public String getId() {
        return this.fId;
    }

    @Override
    public boolean showForInput(Object input) {
        for (ICustomSectionDescriptor descriptor : this.fSectionDescriptors) {
            IFilter filter = descriptor.getFilter();
            if (filter != null) {
                if (!filter.select(input)) continue;
                return true;
            }
            return true;
        }
        return false;
    }
}

