/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.system.browser.internal.ui;

import com.freescale.system.browser.internal.Messages;
import com.freescale.system.browser.internal.SystemBrowserActivator;
import com.freescale.system.browser.internal.ui.CustomSectionDescriptor;
import com.freescale.system.browser.internal.ui.CustomTabDescriptor;
import com.freescale.system.browser.internal.ui.SectionDescriptor;
import com.freescale.system.browser.internal.ui.SimpleTableDataDescriptor;
import com.freescale.system.browser.internal.ui.TabDescriptor;
import com.freescale.system.browser.internal.ui.builtintab.tasks.TasksTabDescriptor;
import com.freescale.system.browser.internal.ui.tabbed.ISectionDescriptor;
import com.freescale.system.browser.internal.ui.tabbed.ITabDescriptor;
import com.freescale.system.browser.ui.IActionProvider;
import com.ibm.icu.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class SystemContributor {
    private static final String NO_TAB_ERROR = Messages.SystemContributor_Non_existing_tab;
    private static final String EXTPT_SYSTEM_CONTRIBUTOR = "systemContributor";
    private static final String EXTPT_TABS = "systemTabs";
    private static final String EXTPT_SECTIONS = "systemSections";
    private static final String ELEMENT_TAB_CUSTOM = "systemTabCustom";
    private static final String ELEMENT_TAB_TASKS = "systemTabTasks";
    private static final String ELEMENT_SECTION = "systemSection";
    private static final String ELEMENT_SECTION_TASKS = "systemSectionTasks";
    private static final String ELEMENT_DEBUGGER = "debugger";
    private static final String ATT_DEBUGGER_ID = "debuggerId";
    public static final String ATT_SYSTEM_CONTRIBUTOR_ID = "contributorId";
    private static final String ATT_LABEL_PROVIDER = "labelProvider";
    private static final String ATT_ACTION_PROVIDER = "actionProvider";
    private static final String ATT_ID = "id";
    private static final String ATT_NAME = "name";
    private static final String ATT_ICON = "icon";
    protected String fSystemContributorId;
    protected ILabelProvider fLabelProvider;
    protected IActionProvider fActionProvider;
    protected String fName;
    protected ImageDescriptor fIcon;
    protected volatile List<ITabDescriptor> fTabDescriptors;
    private Set<String> fDebuggers = new HashSet<String>(3);
    private static List<SystemContributor> sSystemContributors = new ArrayList<SystemContributor>(5);

    public List<ITabDescriptor> getTabDescriptors(Object input) {
        return this.filterTabDescriptors(this.getAllTabDescriptors(), input);
    }

    public ILabelProvider getLabelProvider() {
        return this.fLabelProvider;
    }

    public String getName() {
        return this.fName;
    }

    public ImageDescriptor getIcon() {
        return this.fIcon;
    }

    public IActionProvider getActionProvider() {
        return this.fActionProvider;
    }

    public String getId() {
        return this.fSystemContributorId;
    }

    protected SystemContributor(IConfigurationElement configurationElement) {
        IConfigurationElement[] debuggers;
        String iconStr;
        this.fSystemContributorId = configurationElement.getAttribute(ATT_ID);
        this.fName = configurationElement.getAttribute(ATT_NAME);
        try {
            if (configurationElement.getAttribute(ATT_LABEL_PROVIDER) != null) {
                this.fLabelProvider = (ILabelProvider)configurationElement.createExecutableExtension(ATT_LABEL_PROVIDER);
            }
            if (configurationElement.getAttribute(ATT_ACTION_PROVIDER) != null) {
                this.fActionProvider = (IActionProvider)configurationElement.createExecutableExtension(ATT_ACTION_PROVIDER);
            }
        }
        catch (CoreException e) {
            SystemBrowserActivator.log(e.getStatus());
        }
        if ((iconStr = configurationElement.getAttribute(ATT_ICON)) != null) {
            IExtension extension = configurationElement.getDeclaringExtension();
            this.fIcon = AbstractUIPlugin.imageDescriptorFromPlugin((String)extension.getNamespaceIdentifier(), (String)iconStr);
        }
        IConfigurationElement[] iConfigurationElementArray = debuggers = configurationElement.getChildren(ELEMENT_DEBUGGER);
        int n = debuggers.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement debugger = iConfigurationElementArray[n2];
            String debuggerId = debugger.getAttribute(ATT_DEBUGGER_ID);
            if (debuggerId != null) {
                this.fDebuggers.add(debuggerId);
            }
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SystemContributor getSystemContributorForDebugger(String debuggerId) {
        List<SystemContributor> list = sSystemContributors;
        synchronized (list) {
            IConfigurationElement[] systems;
            for (SystemContributor system : sSystemContributors) {
                if (!system.fDebuggers.contains(debuggerId)) continue;
                return system;
            }
            IConfigurationElement[] iConfigurationElementArray = systems = Platform.getExtensionRegistry().getExtensionPoint(SystemBrowserActivator.getPluginId(), EXTPT_SYSTEM_CONTRIBUTOR).getConfigurationElements();
            int n = systems.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] debuggers;
                IConfigurationElement system = iConfigurationElementArray[n2];
                IConfigurationElement[] iConfigurationElementArray2 = debuggers = system.getChildren(ELEMENT_DEBUGGER);
                int n3 = debuggers.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement debugger = iConfigurationElementArray2[n4];
                    String thisDebuggerId = debugger.getAttribute(ATT_DEBUGGER_ID);
                    if (thisDebuggerId != null && thisDebuggerId.equals(debuggerId)) {
                        SystemContributor syscontr = new SystemContributor(system);
                        sSystemContributors.add(syscontr);
                        return syscontr;
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SystemContributor getSystemContributor(String id) {
        List<SystemContributor> list = sSystemContributors;
        synchronized (list) {
            IConfigurationElement[] systems;
            for (SystemContributor system : sSystemContributors) {
                if (!system.getId().equals(id)) continue;
                return system;
            }
            IConfigurationElement[] iConfigurationElementArray = systems = Platform.getExtensionRegistry().getExtensionPoint(SystemBrowserActivator.getPluginId(), EXTPT_SYSTEM_CONTRIBUTOR).getConfigurationElements();
            int n = systems.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement system = iConfigurationElementArray[n2];
                String systemContributorId = system.getAttribute(ATT_ID);
                if (systemContributorId != null && systemContributorId.equals(id)) {
                    SystemContributor syscontr = new SystemContributor(system);
                    sSystemContributors.add(syscontr);
                    return syscontr;
                }
                ++n2;
            }
        }
        return null;
    }

    protected List<ISectionDescriptor> readSectionDescriptors() {
        IConfigurationElement[] sectionGroups;
        HashSet<SectionDescriptor> result = new HashSet<SectionDescriptor>();
        IConfigurationElement[] iConfigurationElementArray = sectionGroups = this.getAssociatedExtensions(EXTPT_SECTIONS);
        int n = sectionGroups.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement section;
            IConfigurationElement[] sections;
            IConfigurationElement group = iConfigurationElementArray[n2];
            IConfigurationElement[] iConfigurationElementArray2 = sections = group.getChildren(ELEMENT_SECTION);
            int n3 = sections.length;
            int n4 = 0;
            while (n4 < n3) {
                section = iConfigurationElementArray2[n4];
                result.add(new CustomSectionDescriptor(section));
                ++n4;
            }
            iConfigurationElementArray2 = sections = group.getChildren(ELEMENT_SECTION_TASKS);
            n3 = sections.length;
            n4 = 0;
            while (n4 < n3) {
                section = iConfigurationElementArray2[n4];
                result.add(new SimpleTableDataDescriptor(section));
                ++n4;
            }
            ++n2;
        }
        return new ArrayList<ISectionDescriptor>(result);
    }

    protected IConfigurationElement[] getAssociatedExtensions(String extensionPointName) {
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(SystemBrowserActivator.getPluginId(), extensionPointName);
        IConfigurationElement[] extensions = point.getConfigurationElements();
        ArrayList<IConfigurationElement> elements = new ArrayList<IConfigurationElement>(extensions.length);
        IConfigurationElement[] iConfigurationElementArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            String systemContributorId;
            IConfigurationElement extension = iConfigurationElementArray[n2];
            if (extension.getName().equals(extensionPointName) && (systemContributorId = extension.getAttribute(ATT_SYSTEM_CONTRIBUTOR_ID)) != null && this.fSystemContributorId.equals(systemContributorId)) {
                elements.add(extension);
            }
            ++n2;
        }
        return elements.toArray(new IConfigurationElement[elements.size()]);
    }

    protected List<ITabDescriptor> filterTabDescriptors(List<ITabDescriptor> descriptors, Object input) {
        ArrayList<ITabDescriptor> result = new ArrayList<ITabDescriptor>();
        for (ITabDescriptor descriptor : descriptors) {
            if (!descriptor.showForInput(input)) continue;
            result.add(descriptor);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<ITabDescriptor> getAllTabDescriptors() {
        if (this.fTabDescriptors == null) {
            SystemContributor systemContributor = this;
            synchronized (systemContributor) {
                if (this.fTabDescriptors == null) {
                    List<ITabDescriptor> allTabs = this.readTabDescriptors();
                    if (allTabs.size() > 0) {
                        this.populateWithSectionDescriptors(allTabs);
                    }
                    List<ITabDescriptor> sortedList = allTabs;
                    this.sortTabDescriptorsByAfterTab(sortedList);
                    this.fTabDescriptors = sortedList;
                }
            }
        }
        return this.fTabDescriptors;
    }

    protected List<ITabDescriptor> readTabDescriptors() {
        IConfigurationElement[] extensions;
        ArrayList<TabDescriptor> result = new ArrayList<TabDescriptor>();
        IConfigurationElement[] iConfigurationElementArray = extensions = this.getAssociatedExtensions(EXTPT_TABS);
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] children;
            IConfigurationElement tabs = iConfigurationElementArray[n2];
            IConfigurationElement[] iConfigurationElementArray2 = children = tabs.getChildren();
            int n3 = children.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement child = iConfigurationElementArray2[n4];
                if (child.getName().equals(ELEMENT_TAB_CUSTOM)) {
                    result.add(new CustomTabDescriptor(child));
                } else if (child.getName().equals(ELEMENT_TAB_TASKS)) {
                    result.add(new TasksTabDescriptor(child));
                }
                ++n4;
            }
            ++n2;
        }
        return Collections.synchronizedList(result);
    }

    protected void populateWithSectionDescriptors(List<ITabDescriptor> tabDescriptors) {
        List<ISectionDescriptor> sections = this.readSectionDescriptors();
        for (ISectionDescriptor section : sections) {
            this.appendSectionToApplicableTabs(section, tabDescriptors);
        }
    }

    protected void appendSectionToApplicableTabs(ISectionDescriptor section, List<ITabDescriptor> tabDescriptors) {
        for (ITabDescriptor tabDescriptor : tabDescriptors) {
            if (!tabDescriptor.getId().equals(section.getTargetTab())) continue;
            ((TabDescriptor)tabDescriptor).addSectionDescriptor(section);
            return;
        }
        String message = MessageFormat.format((String)NO_TAB_ERROR, (Object[])new Object[]{section.getId(), section.getTargetTab()});
        Status status = new Status(4, SystemBrowserActivator.getPluginId(), 0, message, null);
        SystemBrowserActivator.getPlugin().getLog().log((IStatus)status);
    }

    protected void sortTabDescriptorsByAfterTab(List<ITabDescriptor> tabs) {
        if (tabs.size() > 0) {
            Collections.sort(tabs, new Comparator<Object>(){

                @Override
                public int compare(Object arg0, Object arg1) {
                    TabDescriptor tab1 = (TabDescriptor)arg0;
                    TabDescriptor tab2 = (TabDescriptor)arg1;
                    if (tab2.fAfterTab.equals(tab1.getId())) {
                        return -1;
                    }
                    if (tab1.fAfterTab.equals(tab2.getId())) {
                        return 1;
                    }
                    return 0;
                }
            });
        }
    }
}

