/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.system.browser.internal.ui;

import com.freescale.s32ds.ui.S32dsUtils;
import com.freescale.system.browser.internal.SystemBrowserActivator;
import com.freescale.system.browser.internal.ui.TabDescriptor;
import com.freescale.system.browser.internal.ui.tabbed.TabbedSheetPage;
import com.freescale.system.browser.model.OSAwarenessData;
import com.freescale.system.browser.ui.ISection;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class Tab {
    private TabDescriptor fDescriptor;
    private List<ISection> fSections;
    private Listener fFocusListener;
    private Control fLastControlWithFocus;
    private Composite fPageComposite;

    private Tab(TabDescriptor descriptor) {
        assert (descriptor != null);
        this.fDescriptor = descriptor;
        this.fSections = new ArrayList<ISection>();
        this.fFocusListener = new Listener(){

            public void handleEvent(Event event) {
                if (event.widget instanceof Control && Tab.this.fPageComposite != null) {
                    Control control = (Control)event.widget;
                    while (control != null && control != Tab.this.fPageComposite) {
                        control = control.getParent();
                    }
                    if (control == Tab.this.fPageComposite) {
                        Tab.this.fLastControlWithFocus = (Control)event.widget;
                    }
                }
            }
        };
    }

    public Tab(TabDescriptor tasksTabDescriptor, List<ISection> sections) {
        this(tasksTabDescriptor);
        this.fSections = sections;
    }

    public TabDescriptor getDescriptor() {
        return this.fDescriptor;
    }

    public List<ISection> getSections() {
        return this.fSections;
    }

    public void createControls(Composite parent, final TabbedSheetPage page) {
        this.fPageComposite = page.getWidgetFactory().createComposite(parent, 524288);
        this.fPageComposite.setLayout((Layout)S32dsUtils.makeTight((GridLayout)new GridLayout()));
        for (final ISection section : this.fSections) {
            final Composite sectionComposite = page.getWidgetFactory().createComposite(this.fPageComposite, 524288);
            sectionComposite.setLayout((Layout)new FillLayout());
            GridData data = new GridData(4, 4, true, section.shouldUseExtraSpace());
            data.heightHint = section.getMinimumHeight();
            sectionComposite.setLayoutData((Object)data);
            ISafeRunnable runnable = new ISafeRunnable(){

                public void run() throws Exception {
                    section.createControls(sectionComposite, page);
                }

                public void handleException(Throwable exc) {
                    SystemBrowserActivator.log((IStatus)new Status(4, SystemBrowserActivator.getPluginId(), exc.getMessage()));
                }
            };
            SafeRunner.run((ISafeRunnable)runnable);
        }
    }

    public void dispose() {
        for (final ISection section : this.fSections) {
            ISafeRunnable runnable = new ISafeRunnable(){

                public void run() throws Exception {
                    section.dispose();
                }

                public void handleException(Throwable exc) {
                    SystemBrowserActivator.log((IStatus)new Status(4, SystemBrowserActivator.getPluginId(), exc.getMessage()));
                }
            };
            SafeRunner.run((ISafeRunnable)runnable);
        }
        Display display = Display.getCurrent();
        if (display != null) {
            display.removeFilter(15, this.fFocusListener);
        }
    }

    public void aboutToBeShown() {
        for (final ISection section : this.fSections) {
            ISafeRunnable runnable = new ISafeRunnable(){

                public void run() throws Exception {
                    section.aboutToBeShown();
                }

                public void handleException(Throwable exc) {
                    SystemBrowserActivator.log((IStatus)new Status(4, SystemBrowserActivator.getPluginId(), exc.getMessage()));
                }
            };
            SafeRunner.run((ISafeRunnable)runnable);
        }
        Display display = Display.getCurrent();
        if (display != null) {
            display.removeFilter(15, this.fFocusListener);
            display.addFilter(15, this.fFocusListener);
        }
    }

    public void aboutToBeHidden() {
        for (final ISection section : this.fSections) {
            ISafeRunnable runnable = new ISafeRunnable(){

                public void run() throws Exception {
                    section.aboutToBeHidden();
                }

                public void handleException(Throwable exc) {
                    SystemBrowserActivator.log((IStatus)new Status(4, SystemBrowserActivator.getPluginId(), exc.getMessage()));
                }
            };
            SafeRunner.run((ISafeRunnable)runnable);
        }
        Display display = Display.getCurrent();
        if (display != null) {
            display.removeFilter(15, this.fFocusListener);
        }
    }

    public void setTabInput(final OSAwarenessData input) {
        if (input == null) {
            return;
        }
        SystemBrowserActivator.log(1, "setTabInput =>" + input.toString());
        for (final ISection section : this.fSections) {
            ISafeRunnable runnable = new ISafeRunnable(){

                public void run() throws Exception {
                    section.setSectionInput(input);
                }

                public void handleException(Throwable exc) {
                    SystemBrowserActivator.log((IStatus)new Status(4, SystemBrowserActivator.getPluginId(), exc.getMessage()));
                }
            };
            SafeRunner.run((ISafeRunnable)runnable);
        }
    }

    public boolean controlsHaveBeenCreated() {
        return this.fPageComposite != null;
    }

    public void refresh() {
        if (this.controlsHaveBeenCreated()) {
            for (final ISection section : this.fSections) {
                ISafeRunnable runnable = new ISafeRunnable(){

                    public void run() throws Exception {
                        section.refresh();
                    }

                    public void handleException(Throwable exc) {
                        SystemBrowserActivator.log((IStatus)new Status(4, SystemBrowserActivator.getPluginId(), exc.getMessage()));
                    }
                };
                SafeRunner.run((ISafeRunnable)runnable);
            }
        }
    }

    public void invalidate() {
        if (this.controlsHaveBeenCreated()) {
            for (final ISection section : this.fSections) {
                ISafeRunnable runnable = new ISafeRunnable(){

                    public void run() throws Exception {
                        section.invalidate();
                    }

                    public void handleException(Throwable exc) {
                        SystemBrowserActivator.log((IStatus)new Status(4, SystemBrowserActivator.getPluginId(), exc.getMessage()));
                    }
                };
                SafeRunner.run((ISafeRunnable)runnable);
            }
        }
    }

    public void setFocus() {
        if (this.fLastControlWithFocus != null && !this.fLastControlWithFocus.isDisposed() && this.fLastControlWithFocus.isVisible()) {
            this.fLastControlWithFocus.setFocus();
        } else {
            this.fPageComposite.setFocus();
        }
    }
}

