/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.system.browser.internal.ui;

import com.freescale.system.browser.internal.ui.TabbedList;
import com.freescale.system.browser.internal.ui.TabbedTitle;
import com.freescale.system.browser.ui.TabbedWidgetFactory;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class TabbedComposite
extends Composite {
    private TabbedWidgetFactory fFactory;
    private Composite fMainComposite;
    private Composite fLeftComposite;
    private ScrolledComposite fScrolledComposite;
    private Composite fTabComposite;
    private TabbedTitle fTitle;
    private TabbedList fListComposite;
    private boolean fGainedFocus;
    private boolean fDisplayTitle;
    private Label fOsBannerTextLabel;
    private Label fOsBannerImageLabel;

    public TabbedComposite(Composite parent, TabbedWidgetFactory factory, boolean displayTitle) {
        super(parent, 524288);
        this.fFactory = factory;
        this.fDisplayTitle = displayTitle;
        this.createMainComposite();
    }

    public TabbedList getList() {
        return this.fListComposite;
    }

    public TabbedTitle getTitle() {
        return this.fTitle;
    }

    public Composite getTabComposite() {
        return this.fTabComposite;
    }

    public ScrolledComposite getScrolledComposite() {
        return this.fScrolledComposite;
    }

    public void dispose() {
        this.fListComposite.dispose();
        if (this.fTitle != null) {
            this.fTitle.dispose();
        }
        super.dispose();
    }

    protected void createMainComposite() {
        this.fMainComposite = this.fFactory.createComposite(this, 524288);
        this.fMainComposite.setLayout((Layout)new FormLayout());
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.top = new FormAttachment(0, 0);
        formData.bottom = new FormAttachment(100, 0);
        this.fMainComposite.setLayoutData((Object)formData);
        this.createMainContents();
        this.fMainComposite.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                TabbedComposite.this.fGainedFocus = true;
                TabbedComposite.this.fMainComposite.redraw();
            }

            public void focusLost(FocusEvent e) {
                TabbedComposite.this.fGainedFocus = false;
                TabbedComposite.this.fMainComposite.redraw();
            }
        });
        this.fMainComposite.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (TabbedComposite.this.fGainedFocus) {
                    Rectangle r = TabbedComposite.this.getClientArea();
                    e.gc.drawFocus(0, 0, r.width, r.height);
                }
            }
        });
    }

    protected void createMainContents() {
        FormData data;
        this.fLeftComposite = this.fFactory.createComposite(this.fMainComposite, 524288);
        this.fLeftComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        this.fLeftComposite.setLayout((Layout)gridLayout);
        this.fScrolledComposite = this.fFactory.createScrolledComposite(this.fMainComposite, 525056);
        this.fScrolledComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fScrolledComposite.setLayout((Layout)new FormLayout());
        FormData formData = new FormData();
        formData.left = new FormAttachment((Control)this.fLeftComposite, 0);
        formData.right = new FormAttachment(100, 0);
        formData.top = new FormAttachment(0, 0);
        formData.bottom = new FormAttachment(100, 0);
        this.fScrolledComposite.setLayoutData((Object)formData);
        formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment((Control)this.fScrolledComposite, 0);
        formData.top = new FormAttachment(0, 0);
        formData.bottom = new FormAttachment(100, 0);
        this.fLeftComposite.setLayoutData((Object)formData);
        Composite rightComposite = this.fFactory.createComposite((Composite)this.fScrolledComposite, 524288);
        rightComposite.setLayoutData((Object)new GridData());
        FormLayout formLayout = new FormLayout();
        formLayout.marginHeight = 0;
        formLayout.marginWidth = 0;
        rightComposite.setLayout((Layout)formLayout);
        this.fScrolledComposite.setContent((Control)rightComposite);
        this.fScrolledComposite.setAlwaysShowScrollBars(false);
        this.fScrolledComposite.setExpandVertical(true);
        this.fScrolledComposite.setExpandHorizontal(true);
        Composite osBannerComposite = new Composite(this.fLeftComposite, 0);
        osBannerComposite.setLayoutData((Object)new GridData(4, 1, true, false));
        osBannerComposite.setLayout((Layout)new GridLayout(2, false));
        this.fOsBannerImageLabel = new Label(osBannerComposite, 0);
        this.fOsBannerImageLabel.setLayoutData((Object)new GridData(1, 1, false, false));
        this.fOsBannerTextLabel = new Label(osBannerComposite, 0);
        this.fOsBannerTextLabel.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fOsBannerTextLabel.setBackground(osBannerComposite.getBackground());
        this.fListComposite = new TabbedList(this.fLeftComposite, this.fFactory);
        this.fListComposite.setLayoutData(new GridData(4, 4, true, true));
        if (this.fDisplayTitle) {
            this.fTitle = new TabbedTitle(rightComposite, this.fFactory);
        }
        this.fTabComposite = this.fFactory.createComposite(rightComposite, 524288);
        this.fTabComposite.setLayout((Layout)new FormLayout());
        this.fTabComposite.setBackground(osBannerComposite.getBackground());
        if (this.fDisplayTitle) {
            data = new FormData();
            data.left = new FormAttachment(0, 0);
            data.right = new FormAttachment(100, 0);
            data.top = new FormAttachment(0, 0);
            this.fTitle.setLayoutData(data);
        }
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.top = this.fDisplayTitle ? new FormAttachment((Control)this.fTitle, 0) : new FormAttachment(0, 0);
        data.bottom = new FormAttachment(100, 0);
        this.fTabComposite.setLayoutData((Object)data);
        this.fListComposite.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                Point leftSize = TabbedComposite.this.fLeftComposite.computeSize(-1, -1);
                FormData formData2 = new FormData();
                formData2.left = new FormAttachment(0, leftSize.x);
                formData2.right = new FormAttachment(100, 0);
                formData2.top = new FormAttachment(0, 0);
                formData2.bottom = new FormAttachment(100, 0);
                TabbedComposite.this.fScrolledComposite.setLayoutData((Object)formData2);
                TabbedComposite.this.fMainComposite.layout(true);
            }
        });
    }

    protected TabbedWidgetFactory getFactory() {
        return this.fFactory;
    }

    public void setOsNameAndImage(String name, Image image) {
        this.fOsBannerTextLabel.setText(name);
        this.fOsBannerImageLabel.setImage(image);
        this.fOsBannerTextLabel.getParent().layout(true, true);
    }
}

