/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.system.browser.internal.ui;

import com.freescale.system.browser.internal.SystemBrowserActivator;
import com.freescale.system.browser.internal.ui.TabDescriptor;
import com.freescale.system.browser.internal.ui.TabbedList;
import com.freescale.system.browser.internal.ui.tabbed.ITabDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;

public class TabbedSystemViewer
extends StructuredViewer {
    protected final TabbedList fTabChooser;
    protected List<ITabDescriptor> fTabDescriptors = new ArrayList<ITabDescriptor>();

    public TabbedSystemViewer(TabbedList tabChooser) {
        this.fTabChooser = tabChooser;
        this.hookControl((Control)tabChooser);
    }

    public ITabDescriptor getNthTab(int index) {
        if (index >= 0 && index < this.fTabDescriptors.size()) {
            return this.fTabDescriptors.get(index);
        }
        return null;
    }

    public void reveal(Object element) {
    }

    public Control getControl() {
        return this.fTabChooser;
    }

    protected Widget doFindInputItem(Object element) {
        return null;
    }

    protected Widget doFindItem(Object element) {
        return null;
    }

    protected void doUpdateItem(Widget item, Object element, boolean fullMap) {
    }

    protected List<?> getSelectionFromWidget() {
        int index = this.fTabChooser.getSelectionIndex();
        if (index < 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<ITabDescriptor> result = new ArrayList<ITabDescriptor>(1);
        result.add(this.getNthTab(index));
        return result;
    }

    protected void internalRefresh(Object element) {
    }

    protected void setSelectionToWidget(List list, boolean reveal) {
        if (list == null || list.size() == 0) {
            this.fTabChooser.deselectAll();
        } else {
            TabDescriptor selectedTab = (TabDescriptor)list.get(0);
            int i = 0;
            for (ITabDescriptor tab : this.fTabDescriptors) {
                if (tab == selectedTab) {
                    this.fTabChooser.select(i, reveal);
                    return;
                }
                ++i;
            }
            SystemBrowserActivator.log(4, "Unexpected tab selection");
        }
    }

    protected void inputChanged(Object input, Object oldInput) {
        if (input == null) {
            return;
        }
        ITabDescriptor[] children = (ITabDescriptor[])this.getSortedChildren(input);
        this.fTabChooser.removeAll();
        this.fTabDescriptors.clear();
        ITabDescriptor[] iTabDescriptorArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            ITabDescriptor child = iTabDescriptorArray[n2];
            this.fTabDescriptors.add(child);
            this.mapElement(child, (Widget)this.fTabChooser);
            ++n2;
        }
        this.fTabChooser.setElements(children);
    }
}

