/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.system.browser.internal.ui.builtintab.tasks;

import com.freescale.system.browser.internal.Messages;
import com.freescale.system.browser.internal.SystemBrowserActivator;
import com.freescale.system.browser.internal.ui.builtintab.tasks.TasksTabDescriptor;
import com.freescale.system.browser.internal.ui.builtintab.tasks.TasksTreeComparator;
import com.freescale.system.browser.internal.ui.builtintab.tasks.TasksTreeContentProvider;
import com.freescale.system.browser.internal.ui.builtintab.tasks.TasksTreeLabelProvider;
import com.freescale.system.browser.model.ISimpleTableDataProvider;
import com.freescale.system.browser.model.OSAwarenessData;
import com.freescale.system.browser.ui.AbstractSection;
import java.util.ArrayList;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.part.Page;

public class TasksSection
extends AbstractSection {
    private static final int DEFAULT_COLUMN_WIDTH = 100;
    private TreeViewer fTasksTableViewer;
    private TasksTabDescriptor.Column[] fCustomColumns;
    private Object fInput;
    private boolean fHideNameColumn;
    private Integer fNameColumnWidth;
    private boolean fHideStatusColumn;
    private boolean fHideIdColumn;
    private boolean fHexIdColumn;
    private MouseAdapter fMouseListener = new MouseAdapter(){
        private static final int LEFT_BUTTON_CODE = 1;
        private static final int RIGHT_BUTTON_CODE = 3;

        public void mouseDoubleClick(MouseEvent e) {
            int cfr_ignored_0 = e.button;
        }

        public void mouseDown(MouseEvent e) {
            Object source;
            if (3 == e.button && (source = e.getSource()) instanceof Tree) {
                Tree tree = (Tree)source;
                this.createContextMenu(tree);
            }
        }

        private void createContextMenu(Tree tree) {
            MenuManager menuMgr = new MenuManager("#PopupMenu");
            menuMgr.setRemoveAllWhenShown(true);
            menuMgr.addMenuListener(new IMenuListener(){

                public void menuAboutToShow(IMenuManager m) {
                }
            });
            Menu menu = menuMgr.createContextMenu((Control)tree);
            tree.setMenu(menu);
        }
    };
    private ISimpleTableDataProvider fTaskData;
    private TasksTreeContentProvider contentProvider;

    public TasksSection(TasksTabDescriptor.Column[] customColumns, Options options) {
        this.fCustomColumns = (TasksTabDescriptor.Column[])customColumns.clone();
        this.fInput = null;
        if (options != null) {
            this.fHideNameColumn = options.hideNameColumn;
            this.fNameColumnWidth = options.nameColumnWidth;
            this.fHideStatusColumn = options.hideStatusColumn;
            this.fHideIdColumn = options.hideIdColumn;
            this.fHexIdColumn = options.hexIdColumn;
            this.fTaskData = options.taskData;
        }
    }

    @Override
    public boolean shouldUseExtraSpace() {
        return true;
    }

    @Override
    public void createControls(Composite parent, Page page) {
        int width;
        super.createControls(parent, page);
        Composite composite = this.getWidgetFactory().createComposite(parent);
        composite.setLayout((Layout)new GridLayout());
        this.fTasksTableViewer = new TreeViewer(composite, 66306);
        this.fTasksTableViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        Tree tree = this.fTasksTableViewer.getTree();
        tree.setHeaderVisible(true);
        ArrayList<TasksTabDescriptor.Column> cols = new ArrayList<TasksTabDescriptor.Column>();
        if (!this.fHideNameColumn) {
            width = 100;
            if (this.fNameColumnWidth != null) {
                width = this.fNameColumnWidth;
            }
            cols.add(new TasksTabDescriptor.Column(Messages.TasksTab_Name_Column, "name", width));
        }
        if (!this.fHideIdColumn) {
            width = 50;
            cols.add(new TasksTabDescriptor.Column(Messages.TasksTab_ID_Column, "id", width));
        }
        if (!this.fHideStatusColumn) {
            cols.add(new TasksTabDescriptor.Column(Messages.TasksTab_Status_Column, "status", 100));
        }
        TasksTabDescriptor.Column[] columnArray = this.fCustomColumns;
        int n = this.fCustomColumns.length;
        int n2 = 0;
        while (n2 < n) {
            TasksTabDescriptor.Column customCol = columnArray[n2];
            cols.add(customCol);
            ++n2;
        }
        int colIndex = 0;
        for (TasksTabDescriptor.Column col : cols) {
            TreeColumn column = new TreeColumn(tree, 16384);
            column.setText(col.label);
            column.setWidth(col.width);
            final int index = colIndex++;
            column.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    TasksTreeComparator comparator = (TasksTreeComparator)TasksSection.this.fTasksTableViewer.getComparator();
                    if (comparator != null) {
                        comparator.setSortColumn(index);
                        TasksSection.this.fTasksTableViewer.refresh(false);
                    }
                }
            });
        }
        this.fTasksTableViewer.setLabelProvider((IBaseLabelProvider)new TasksTreeLabelProvider(cols.toArray(new TasksTabDescriptor.Column[cols.size()]), this.fHexIdColumn));
        this.contentProvider = new TasksTreeContentProvider((Viewer)this.fTasksTableViewer);
        this.fTasksTableViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.fTasksTableViewer.getTree().addMouseListener((MouseListener)this.fMouseListener);
        this.fTasksTableViewer.setComparator((ViewerComparator)new TasksTreeComparator(cols.toArray(new TasksTabDescriptor.Column[cols.size()])));
    }

    @Override
    public void aboutToBeShown() {
        super.aboutToBeShown();
        TasksTreeContentProvider contentProvider = (TasksTreeContentProvider)this.fTasksTableViewer.getContentProvider();
        contentProvider.viewerAboutToBeShown();
    }

    @Override
    public void aboutToBeHidden() {
        super.aboutToBeHidden();
        TasksTreeContentProvider contentProvider = (TasksTreeContentProvider)this.fTasksTableViewer.getContentProvider();
        if (contentProvider != null) {
            contentProvider.viewerAboutToBeHidden();
        }
    }

    @Override
    public void dispose() {
        this.contentProvider.dispose();
    }

    @Override
    public void setSectionInput(OSAwarenessData input) {
        SystemBrowserActivator.log(1, "setSectionInput =>" + input.toString());
        this.fInput = input;
        if (this.fTasksTableViewer == null) {
            return;
        }
        if (input.getContext() != null) {
            OSAwarenessData old_input = (OSAwarenessData)this.fTasksTableViewer.getInput();
            if (old_input != null && old_input.equals(input)) {
                return;
            }
            this.contentProvider.registerSession(input.getContext().getSessionId());
            input.setLink(this.fTaskData);
            this.fTasksTableViewer.setInput((Object)input);
        } else {
            this.contentProvider.registerSession(null);
            input.setLink(null);
            this.fTasksTableViewer.setInput(null);
        }
    }

    @Override
    public Object getSectionInput() {
        return this.fInput;
    }

    @Override
    public void refresh() {
        this.fTasksTableViewer.refresh();
        super.refresh();
    }

    @Override
    public void setActionBarsForTab(IActionBars actionBars) {
    }

    public static class Options {
        public boolean hideNameColumn;
        public Integer nameColumnWidth;
        public boolean hideStatusColumn;
        public boolean hideIdColumn;
        public boolean hexIdColumn;
        public ISimpleTableDataProvider taskData;
    }
}

