/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.system.browser.internal.ui.builtintab.tasks;

import com.freescale.system.browser.internal.SystemBrowserActivator;
import com.freescale.system.browser.internal.ui.builtintab.tasks.TasksTabDescriptor;
import com.freescale.system.browser.internal.ui.builtintab.tasks.TasksTreeContentProvider;
import com.freescale.system.browser.model.ThreadInfo;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;

public class TasksTreeLabelProvider
implements ITableLabelProvider {
    private TasksTabDescriptor.Column[] fColumns;
    private boolean fShowIdAsHex;

    public TasksTreeLabelProvider(TasksTabDescriptor.Column[] columns, boolean showIdAsHex) {
        this.fColumns = (TasksTabDescriptor.Column[])columns.clone();
        this.fShowIdAsHex = showIdAsHex;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (columnIndex < this.fColumns.length) {
            TasksTabDescriptor.Column col = this.fColumns[columnIndex];
            if (element instanceof TasksTreeContentProvider.ProcessElement) {
                if (col.dataId.equals("name")) {
                    return ((TasksTreeContentProvider.ProcessElement)element).processInfo.name;
                }
                if (col.dataId.equals("id")) {
                    return Long.toString(((TasksTreeContentProvider.ProcessElement)element).processInfo.processId);
                }
            } else if (element instanceof TasksTreeContentProvider.ThreadElement) {
                ThreadInfo tinfo = ((TasksTreeContentProvider.ThreadElement)element).threadInfo;
                if (col.builtIn) {
                    if (col.dataId.equals("name")) {
                        return tinfo.getName();
                    }
                    if (col.dataId.equals("id")) {
                        return this.fShowIdAsHex ? "0x" + Long.toString(tinfo.getThreadId(), 16) : Long.toString(tinfo.getThreadId());
                    }
                    if (col.dataId.equals("status")) {
                        return tinfo.getState();
                    }
                    SystemBrowserActivator.log(4, "internal error; unexpected column");
                } else {
                    String property = tinfo.getExtendedInfo(col.dataId);
                    if (property != null) {
                        return property;
                    }
                }
            }
        }
        return "";
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

