/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.system.browser.internal.ui.tabbed;

import com.freescale.system.browser.internal.SystemBrowserActivator;
import com.freescale.system.browser.internal.ui.SystemContributor;
import com.freescale.system.browser.internal.ui.Tab;
import com.freescale.system.browser.internal.ui.TabDescriptor;
import com.freescale.system.browser.internal.ui.TabListContentProvider;
import com.freescale.system.browser.internal.ui.TabbedComposite;
import com.freescale.system.browser.internal.ui.TabbedSystemViewer;
import com.freescale.system.browser.internal.ui.TabbedTitle;
import com.freescale.system.browser.internal.ui.builtintab.tasks.TasksTabDescriptor;
import com.freescale.system.browser.internal.ui.tabbed.ITabDescriptor;
import com.freescale.system.browser.internal.ui.tabbed.ITabSelectionListener;
import com.freescale.system.browser.internal.ui.tabbed.ITabbedPage;
import com.freescale.system.browser.internal.ui.tabbed.ITabbedPageContributor;
import com.freescale.system.browser.model.ISimpleTableDataProvider;
import com.freescale.system.browser.model.OSAwarenessData;
import com.freescale.system.browser.ui.IActionProvider;
import com.freescale.system.browser.ui.ISection;
import com.freescale.system.browser.ui.TabbedWidgetFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.Page;

public class TabbedSheetPage
extends Page
implements ITabbedPage,
ILabelProviderListener {
    private TabbedComposite fTabbedComposite;
    private TabbedWidgetFactory fWidgetFactory;
    private ITabbedPageContributor fPageContributor;
    private SystemContributor fSystemContributor;
    protected IStructuredContentProvider fTabListContentProvider;
    private TabbedSystemViewer fTabbedSystemViewer;
    private Tab fCurrentTab;
    private Map<ITabDescriptor, Tab> fDescriptorToTab;
    private Map<Tab, Composite> fTabToComposite;
    private List<String> fSelectionQueue;
    private boolean fSelectionQueueLocked;
    private List<ITabSelectionListener> fTabSelectionListeners;
    private IActionBars fActionBars;
    private OSAwarenessData fContext;

    public TabbedSheetPage(SystemContributor systemContributor) {
        final TabbedSheetPage page = this;
        final String id = systemContributor.getId();
        this.fPageContributor = new ITabbedPageContributor(){

            @Override
            public String getContributorId() {
                return id;
            }

            @Override
            public ITabbedPage getTabbedSheetPage() {
                return page;
            }
        };
        this.fTabToComposite = new HashMap<Tab, Composite>();
        this.fSelectionQueue = new ArrayList<String>(10);
        this.fTabSelectionListeners = new ArrayList<ITabSelectionListener>();
        this.initContributor(systemContributor);
    }

    public void createControl(Composite parent) {
        this.fWidgetFactory = new TabbedWidgetFactory();
        this.fTabbedComposite = new TabbedComposite(parent, this.fWidgetFactory, this.fSystemContributor.getLabelProvider() != null);
        this.fWidgetFactory.paintBordersFor(this.fTabbedComposite);
        this.fTabbedComposite.setLayout((Layout)new FormLayout());
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.top = new FormAttachment(0, 0);
        formData.bottom = new FormAttachment(100, 0);
        this.fTabbedComposite.setLayoutData(formData);
        ImageDescriptor iconDescr = this.fSystemContributor.getIcon();
        this.fTabbedComposite.setOsNameAndImage(this.fSystemContributor.getName(), iconDescr != null ? iconDescr.createImage() : null);
        this.fTabbedSystemViewer = new TabbedSystemViewer(this.fTabbedComposite.getList());
        this.fTabbedSystemViewer.setContentProvider((IContentProvider)this.fTabListContentProvider);
        this.fTabbedSystemViewer.setLabelProvider((IBaseLabelProvider)new TabbedPageLabelProvider());
        this.fTabbedSystemViewer.addSelectionChangedListener(new SelectionChangedListener());
        this.fTabbedComposite.getScrolledComposite().addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                TabbedSheetPage.this.resizeScrolledComposite();
            }
        });
        if (this.fSystemContributor.getLabelProvider() != null) {
            this.fSystemContributor.getLabelProvider().addListener((ILabelProviderListener)this);
        }
    }

    public void dispose() {
        this.disposeContributor();
        if (this.fWidgetFactory != null) {
            this.fWidgetFactory.dispose();
            this.fWidgetFactory = null;
        }
        this.fSystemContributor = null;
        this.fPageContributor = null;
    }

    public Control getControl() {
        return this.fTabbedComposite;
    }

    public void setActionBars(IActionBars actionBars) {
        IActionProvider actionProvider = this.fSystemContributor.getActionProvider();
        if (actionProvider != null) {
            actionProvider.setActionBars(actionBars);
        }
        this.fActionBars = actionBars;
    }

    public void setFocus() {
        if (this.fCurrentTab != null) {
            this.fCurrentTab.setFocus();
        } else {
            this.getControl().setFocus();
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
    }

    public Tab getCurrentTab() {
        return this.fCurrentTab;
    }

    public void addTabSelectionListener(ITabSelectionListener listener) {
        this.fTabSelectionListeners.add(listener);
    }

    public void removeTabSelectionListener(ITabSelectionListener listener) {
        this.fTabSelectionListeners.remove(listener);
    }

    public TabbedWidgetFactory getWidgetFactory() {
        return this.fWidgetFactory;
    }

    public void labelProviderChanged(LabelProviderChangedEvent event) {
    }

    @Override
    public ITabbedPageContributor getContributor() {
        return this.fPageContributor;
    }

    protected IStructuredContentProvider getTabListContentProvider() {
        return new TabListContentProvider(this.fSystemContributor);
    }

    protected void updateTabs(List<ITabDescriptor> descriptors) {
        HashMap<ITabDescriptor, Tab> newTabsMap = new HashMap<ITabDescriptor, Tab>(descriptors.size() * 2);
        boolean disposingCurrentTab = this.fCurrentTab != null;
        for (ITabDescriptor descriptor : descriptors) {
            Tab tab = this.fDescriptorToTab.remove(descriptor);
            if (tab != null && tab.controlsHaveBeenCreated()) {
                if (tab == this.fCurrentTab) {
                    disposingCurrentTab = false;
                }
            } else {
                tab = descriptor.createTab();
            }
            newTabsMap.put(descriptor, tab);
        }
        if (disposingCurrentTab) {
            this.fCurrentTab.aboutToBeHidden();
            this.fCurrentTab = null;
        }
        this.disposeTabs(this.fDescriptorToTab.values());
        this.fDescriptorToTab = Collections.synchronizedMap(newTabsMap);
    }

    private void initContributor(SystemContributor systemContributor) {
        this.fDescriptorToTab = new HashMap<ITabDescriptor, Tab>();
        this.fSystemContributor = systemContributor;
        this.fTabListContentProvider = this.getTabListContentProvider();
        if (this.fTabbedSystemViewer != null) {
            this.fTabbedSystemViewer.setContentProvider((IContentProvider)this.fTabListContentProvider);
        }
        if (this.fSystemContributor.getLabelProvider() != null) {
            this.fSystemContributor.getLabelProvider().addListener((ILabelProviderListener)this);
        }
    }

    private void disposeContributor() {
        if (this.fCurrentTab != null) {
            this.fCurrentTab.aboutToBeHidden();
            this.fCurrentTab = null;
        }
        this.disposeTabs(this.fDescriptorToTab.values());
        this.fDescriptorToTab = new HashMap<ITabDescriptor, Tab>();
        if (this.fSystemContributor != null && this.fSystemContributor.getLabelProvider() != null) {
            this.fSystemContributor.getLabelProvider().removeListener((ILabelProviderListener)this);
        }
    }

    private void storeCurrentTabSelection(String label) {
        if (!this.fSelectionQueueLocked) {
            this.fSelectionQueue.remove(label);
            this.fSelectionQueue.add(0, label);
        }
    }

    private void resizeScrolledComposite() {
        Point currentTabSize = new Point(0, 0);
        if (this.fCurrentTab != null) {
            Composite sizeReference = this.fTabToComposite.get(this.fCurrentTab);
            currentTabSize.y = sizeReference != null ? sizeReference.computeSize((int)-1, (int)-1).y : 0;
            int n = currentTabSize.x = sizeReference != null ? sizeReference.computeSize((int)-1, (int)-1).x : 0;
        }
        if (this.fSystemContributor.getLabelProvider() != null) {
            int titleHeight = this.fTabbedComposite.getTitle().computeSize((int)-1, (int)-1).y;
            currentTabSize.y += titleHeight;
        }
        this.fTabbedComposite.getScrolledComposite().setMinSize(currentTabSize.x, currentTabSize.y);
    }

    private void disposeTabs(Collection<Tab> tabs) {
        for (Tab tab : tabs) {
            Composite composite = this.fTabToComposite.remove(tab);
            tab.dispose();
            if (composite == null) continue;
            composite.dispose();
        }
    }

    private int getLastTabSelection(Object input) {
        List<ITabDescriptor> descriptors = this.fSystemContributor.getTabDescriptors(input);
        if (descriptors.size() != 0) {
            for (String label : this.fSelectionQueue) {
                int i = 0;
                while (i < descriptors.size()) {
                    if (label.equals(descriptors.get(i).getLabel())) {
                        return i;
                    }
                    ++i;
                }
            }
        }
        return 0;
    }

    private Composite createTabComposite() {
        Composite result = this.fWidgetFactory.createComposite(this.fTabbedComposite.getTabComposite(), 524288);
        result.setVisible(false);
        result.setLayout((Layout)new FillLayout());
        FormData data = new FormData();
        data.top = this.fSystemContributor.getLabelProvider() != null ? new FormAttachment((Control)this.fTabbedComposite.getTitle(), 0) : new FormAttachment(0, 0);
        data.bottom = new FormAttachment(100, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        result.setLayoutData((Object)data);
        return result;
    }

    @Override
    public void setPageInput(OSAwarenessData input) {
        if (this.fTabbedSystemViewer.getControl().isDisposed() && this.fContext != null) {
            this.shutdownTabs(this.fContext.getContext());
            ISimpleTableDataProvider provider = this.fContext.getLink();
            if (provider != null) {
                provider.getThreadSequenceHolder(null);
                SystemBrowserActivator.log(1, "setPageInput (shutdown) => " + provider.toString());
            }
            return;
        }
        IRunControl.IExecutionDMContext context = input.getContext();
        if (context == null) {
            if (this.fTabbedSystemViewer.getInput() != null) {
                String obj = this.fContext.getContext().getSessionId();
                this.fContext = input;
                List<ITabDescriptor> descriptors = this.fSystemContributor.getTabDescriptors(obj);
                descriptors.forEach(descriptor -> this.fDescriptorToTab.get(descriptor).setTabInput(this.fContext));
                this.fTabbedSystemViewer.setInput(null);
                SystemBrowserActivator.log(1, "setPageInput => null");
            }
            return;
        }
        SystemBrowserActivator.log(1, "setPageInput => " + context);
        this.fContext = input;
        String obj = context.getSessionId();
        this.fTabbedSystemViewer.setInput(obj);
        List<ITabDescriptor> descriptors = this.fSystemContributor.getTabDescriptors(obj);
        if (descriptors.isEmpty()) {
            return;
        }
        this.updateTabs(descriptors);
        ITabDescriptor tabToSelect = this.fTabbedSystemViewer.getNthTab(this.getLastTabSelection(obj));
        this.fSelectionQueueLocked = true;
        try {
            if (tabToSelect == null) {
                this.fTabbedSystemViewer.setSelection(null);
            } else {
                this.fTabbedSystemViewer.setSelection((ISelection)new StructuredSelection((Object)tabToSelect));
            }
        }
        finally {
            this.fSelectionQueueLocked = false;
        }
        TabbedTitle title = this.fTabbedComposite.getTitle();
        if (title != null) {
            if (this.fCurrentTab == null) {
                title.setTitle(null, null);
            } else {
                ILabelProvider labelProvider = this.fSystemContributor.getLabelProvider();
                if (labelProvider != null) {
                    title.setTitle(labelProvider.getText((Object)this.fContext), labelProvider.getImage((Object)this.fContext));
                } else {
                    title.setTitle(this.fContext.toString(), null);
                }
            }
        }
        Tab tab = this.fDescriptorToTab.get(tabToSelect);
        assert (tab != null);
        tab.setTabInput(this.fContext);
    }

    private void shutdownTabs(IRunControl.IExecutionDMContext context) {
        if (context != null) {
            String obj = context.getSessionId();
            List<ITabDescriptor> descriptors = this.fSystemContributor.getTabDescriptors(obj);
            for (ITabDescriptor descriptor : descriptors) {
                if (!(descriptor instanceof TasksTabDescriptor)) continue;
                TasksTabDescriptor ttDescriptor = (TasksTabDescriptor)descriptor;
                ttDescriptor.getTableDataObject().getThreadSequenceHolder(null);
            }
        }
    }

    private void handleTabSelection(TabDescriptor tabDescriptor) {
        if (this.fSelectionQueueLocked) {
            return;
        }
        for (ITabSelectionListener listener : this.fTabSelectionListeners) {
            listener.tabSelected(tabDescriptor);
        }
    }

    public void refresh() {
        Set<Tab> tabs = this.fTabToComposite.keySet();
        for (Tab tab : tabs) {
            if (tab == this.fCurrentTab) {
                tab.refresh();
                continue;
            }
            tab.invalidate();
        }
    }

    class SelectionChangedListener
    implements ISelectionChangedListener {
        SelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            Tab tab = null;
            TabDescriptor descriptor = (TabDescriptor)selection.getFirstElement();
            if (descriptor == null) {
                this.hideTab(TabbedSheetPage.this.fCurrentTab);
            } else {
                Composite tabComposite;
                tab = TabbedSheetPage.this.fDescriptorToTab.get(descriptor);
                if (tab != TabbedSheetPage.this.fCurrentTab) {
                    this.hideTab(TabbedSheetPage.this.fCurrentTab);
                }
                if ((tabComposite = TabbedSheetPage.this.fTabToComposite.get(tab)) == null) {
                    tabComposite = TabbedSheetPage.this.createTabComposite();
                    tab.createControls(tabComposite, TabbedSheetPage.this);
                    TabbedSheetPage.this.fTabToComposite.put(tab, tabComposite);
                }
                TabbedSheetPage.this.storeCurrentTabSelection(descriptor.getLabel());
                if (tab != TabbedSheetPage.this.fCurrentTab) {
                    tab.setTabInput(TabbedSheetPage.this.fContext);
                    this.showTab(tab);
                }
            }
            TabbedSheetPage.this.fTabbedComposite.getTabComposite().layout(true);
            TabbedSheetPage.this.fCurrentTab = tab;
            TabbedSheetPage.this.resizeScrolledComposite();
            if (descriptor != null) {
                TabbedSheetPage.this.handleTabSelection(descriptor);
                if (TabbedSheetPage.this.fActionBars != null) {
                    TabbedSheetPage.this.fActionBars.getToolBarManager().removeAll();
                    TabbedSheetPage.this.fActionBars.getMenuManager().removeAll();
                    TabbedSheetPage.this.fActionBars.getStatusLineManager().removeAll();
                    List<ISection> sections = TabbedSheetPage.this.fCurrentTab.getSections();
                    for (ISection section : sections) {
                        section.setActionBarsForTab(TabbedSheetPage.this.fActionBars);
                    }
                    if (TabbedSheetPage.this.fSystemContributor.getActionProvider() != null) {
                        TabbedSheetPage.this.fSystemContributor.getActionProvider().setActionBars(TabbedSheetPage.this.fActionBars);
                    }
                    TabbedSheetPage.this.fActionBars.getToolBarManager().update(true);
                    TabbedSheetPage.this.fActionBars.getMenuManager().update(true);
                    TabbedSheetPage.this.fActionBars.getStatusLineManager().update(true);
                }
            }
        }

        private void showTab(Tab target) {
            Composite tabComposite;
            if (target != null && (tabComposite = TabbedSheetPage.this.fTabToComposite.get(target)) != null) {
                tabComposite.moveAbove(null);
                target.aboutToBeShown();
                tabComposite.setVisible(true);
                target.setFocus();
            }
        }

        private void hideTab(Tab target) {
            Composite tabComposite;
            if (target != null && (tabComposite = TabbedSheetPage.this.fTabToComposite.get(target)) != null) {
                target.aboutToBeHidden();
                tabComposite.setVisible(false);
            }
        }
    }

    static class SystemPageContributor
    implements ITabbedPageContributor {
        private ITabbedPage m_page;
        private SystemContributor m_systemContributor;

        public SystemPageContributor(SystemContributor system, ITabbedPage page) {
            this.m_systemContributor = system;
            this.m_page = page;
        }

        @Override
        public String getContributorId() {
            return this.m_systemContributor.getId();
        }

        @Override
        public ITabbedPage getTabbedSheetPage() {
            return this.m_page;
        }
    }

    static class TabbedPageLabelProvider
    extends LabelProvider {
        TabbedPageLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof TabDescriptor) {
                return ((TabDescriptor)element).getLabel();
            }
            return null;
        }
    }
}

