/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.system.browser.ui;

import com.freescale.system.browser.internal.DSFEventListener;
import com.freescale.system.browser.internal.DSFSessionTrail;
import com.freescale.system.browser.internal.SystemBrowserActivator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.progress.UIJob;

public abstract class ContentProviderAutoUpdater {
    protected final Viewer fViewer;
    private boolean fViewerIsHidden;
    private volatile boolean fRefreshPending = true;
    private volatile boolean fAcceptingCommands = false;
    private final Object fDsfEventListener;
    private DSFSessionTrail m_sessionTrail;

    public ContentProviderAutoUpdater(Viewer viewer) {
        this.fViewer = viewer;
        this.fDsfEventListener = new DSFEventListener(this);
    }

    public final boolean getCommandState() {
        return this.fAcceptingCommands;
    }

    public synchronized void invalidate() {
        SystemBrowserActivator.log(1, "invalidate");
        if (this.fViewerIsHidden) {
            this.fRefreshPending = true;
        } else {
            UIJob job = new UIJob("update tasks table"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    ContentProviderAutoUpdater.this.fViewer.refresh();
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        }
    }

    protected void elementsRequested() {
        this.fRefreshPending = false;
    }

    public void dispose() {
        this.setDebugSession(null);
    }

    public synchronized void viewerAboutToBeShown() {
        this.fViewerIsHidden = false;
        if (this.fRefreshPending) {
            this.fViewer.refresh();
        }
    }

    public synchronized void viewerAboutToBeHidden() {
        this.fViewerIsHidden = true;
    }

    protected boolean setDebugSession(String sessionId) {
        boolean changed = false;
        if (this.m_sessionTrail != null && !this.m_sessionTrail.getSessionID().equals(sessionId)) {
            this.m_sessionTrail.removeServiceEventListener(this.fDsfEventListener);
            this.m_sessionTrail.dispose();
            this.m_sessionTrail = null;
            changed = true;
        }
        if (this.m_sessionTrail == null && sessionId != null) {
            this.m_sessionTrail = new DSFSessionTrail(sessionId);
            this.m_sessionTrail.addServiceEventListener(this.fDsfEventListener);
            changed = true;
        }
        return changed;
    }
}

