/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.dcd.model.settings;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.dcd.model.settings.ActionType;
import com.nxp.swtools.dcd.model.settings.Command;
import com.nxp.swtools.dcd.model.settings.CommandType;
import com.nxp.swtools.dcd.model.settings.HeaderParameters;
import com.nxp.swtools.dcd.model.settings.ICommand;
import com.nxp.swtools.dcd.model.settings.ICommandSetting;
import com.nxp.swtools.dcd.model.settings.ICommandSettings;
import com.nxp.swtools.dcd.model.settings.IProcessorModel;
import com.nxp.swtools.dcd.model.settings.IRegisterSetting;
import java.util.ArrayList;
import java.util.List;

public class CommandSettings
implements ICommandSettings {
    public static final String WRITE_BITFIELDS_ACTION_NAME = "Write - bitfields";
    public static final String WRITE_BITFIELDS_ACTION_ID = "write_bitfields";
    public static final String WRITE_CLEAR_AND_SET_BITS_ACTION_ID = "write_clear_and_set_bits";
    private IProcessorModel model;
    private List<ICommand> commands;

    public CommandSettings(IProcessorModel model) {
        this.model = model;
        this.commands = new ArrayList<ICommand>(this.model.getCommands());
        ICommandSetting writeSetting = (ICommandSetting)CollectionsUtils.findFirst(model.getCommandSettings(), c -> c.getCommandType().equals((Object)CommandType.WRITE));
        if (writeSetting != null) {
            int lastWriteIdx = 0;
            boolean writeFound = false;
            for (ICommand cmd : this.commands) {
                if (cmd.getCommandType().equals((Object)CommandType.WRITE)) {
                    writeFound = true;
                }
                if (writeFound && !cmd.getCommandType().equals((Object)CommandType.WRITE)) break;
                ++lastWriteIdx;
            }
            this.commands.add(writeFound ? lastWriteIdx : this.commands.size(), new Command(CommandType.WRITE, writeSetting, ActionType.WRITE_CLEAR_AND_SET_BITS));
        }
    }

    @Override
    public List<ICommand> getCommands() {
        return CollectionsUtils.unmodifiableList(this.commands);
    }

    @Override
    public @Nullable List<Object> getRegisters(ICommand context) {
        return this.isModifiable(context) ? null : CollectionsUtils.emptyList();
    }

    @Override
    public @Nullable List<Object> getValues(ICommand context) {
        return this.isModifiable(context) ? null : CollectionsUtils.emptyList();
    }

    @Override
    public List<HeaderParameters.TargetWidth> getSizes(ICommand command) {
        HeaderParameters params = CommandSettings.getHeaderParams(command);
        if (params != null) {
            return params.getTargetWidthSetting().getItems();
        }
        return CollectionsUtils.emptyList();
    }

    @Override
    public @Nullable HeaderParameters.TargetWidth getDefaultSize(@Nullable ICommandSetting commandSetting) {
        HeaderParameters params;
        if (commandSetting != null && (params = commandSetting.getHeader().getParameters()) != null) {
            String defaultItemId = params.getTargetWidthSetting().getDefaultItem();
            return (HeaderParameters.TargetWidth)CollectionsUtils.findFirst(params.getTargetWidthSetting().getItems(), i -> i.getId().equals(defaultItemId));
        }
        return null;
    }

    @Override
    public int getPolls(ICommand context) {
        IRegisterSetting registerSetting;
        ICommandSetting commandSetting = context.getCommandSetting();
        if (commandSetting != null && (registerSetting = commandSetting.getRegisterSetting()) != null) {
            return registerSetting.getCountSize();
        }
        return 0;
    }

    private static @Nullable HeaderParameters getHeaderParams(ICommand context) {
        ICommandSetting commandSetting = context.getCommandSetting();
        if (commandSetting != null) {
            return commandSetting.getHeader().getParameters();
        }
        return null;
    }

    @Override
    public boolean isModifiable(ICommand command) {
        return CommandSettings.getHeaderParams(command) != null;
    }
}

