/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.efuse.controls;

import com.nxp.swtools.efuse.controls.GridPaneStructNode;
import com.nxp.swtools.efuse.controls.IBaseControl;
import com.nxp.swtools.efuse.controls.SplitPaneStructNode;
import com.nxp.swtools.efuse.controls.TitledPaneStructNode;
import com.nxp.swtools.efuse.ui.xml.settings.LayoutType;
import com.nxp.swtools.efuse.ui.xml.settings.StructSetting;
import javafx.scene.layout.Region;
import org.eclipse.ui.services.IDisposable;

public class StructSettingNode
implements IDisposable {
    private StructSetting structSetting;
    private Region region;

    public StructSettingNode(StructSetting structSetting) {
        this.structSetting = structSetting;
        LayoutType layoutType = structSetting.getLayoutType();
        switch (layoutType) {
            case SPLIT_PANE: {
                this.region = new SplitPaneStructNode(structSetting);
                break;
            }
            case GRID_PANE: {
                this.region = new GridPaneStructNode(structSetting);
                break;
            }
            case TITLED_PANE: {
                this.region = new TitledPaneStructNode(structSetting);
                break;
            }
            default: {
                this.region = new Region();
            }
        }
    }

    public StructSetting getStructSetting() {
        return this.structSetting;
    }

    public Region getRegion() {
        return this.region;
    }

    public void refresh() {
        if (this.region instanceof IBaseControl) {
            ((IBaseControl)this.region).refresh();
        }
    }

    public void dispose() {
        if (this.region instanceof IDisposable) {
            ((IDisposable)this.region).dispose();
        }
    }
}

