/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.efuse.controls;

import com.nxp.swtools.bootimage.utils.ABootProblem;
import com.nxp.swtools.efuse.controller.EfuseController;
import com.nxp.swtools.efuse.controller.utils.EfuseControllerUtils;
import com.nxp.swtools.efuse.controls.IBaseControl;
import com.nxp.swtools.efuse.controls.StructSettingNode;
import com.nxp.swtools.efuse.gui.utils.EfuseGuiUtils;
import com.nxp.swtools.efuse.model.FuseWord;
import com.nxp.swtools.efuse.model.mcu.IMcu;
import com.nxp.swtools.efuse.model.utils.EfuseUtils;
import com.nxp.swtools.efuse.ui.xml.settings.AdvancedFuseSetting;
import com.nxp.swtools.efuse.ui.xml.settings.ArraySetting;
import com.nxp.swtools.efuse.ui.xml.settings.IntegerSetting;
import com.nxp.swtools.efuse.ui.xml.settings.StructSetting;
import com.nxp.swtools.efuse.ui.xml.settings.TabSetting;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.control.Tab;
import org.eclipse.ui.services.IDisposable;

public class TabSettingNode
extends Tab
implements IBaseControl,
IDisposable {
    private TabSetting tabSetting;
    private StructSettingNode tabContentNode;

    public TabSettingNode(TabSetting tabSetting) {
        this.tabSetting = tabSetting;
        this.tabContentNode = new StructSettingNode(tabSetting.getTabContent());
        this.create();
    }

    @Override
    public void create() {
        this.setId(this.tabSetting.getId());
        this.setText(this.tabSetting.getLabel());
        this.setClosable(false);
        this.setContent((Node)this.tabContentNode.getRegion());
        this.selectedProperty().addListener((obs, oldVal, newVal) -> {
            String tabSettingId = this.tabSetting.getId();
            EfuseUtils.setSwitchingBetweenModes((boolean)true);
            if (tabSettingId.equals("advanced_mode") && newVal.booleanValue() && EfuseUtils.getCurrentMode().equals((Object)EfuseUtils.Mode.STANDARD)) {
                IMcu mcu = EfuseController.getInstance().getMcu();
                if (mcu != null) {
                    EfuseControllerUtils.calculateAllFuseWordsValues((IMcu)mcu);
                }
                EfuseControllerUtils.addModifiedFusesInAdvancedArray();
                EfuseUtils.setCurrentMode((EfuseUtils.Mode)EfuseUtils.Mode.ADVANCED);
                EfuseGuiUtils.refreshEfuseBinaryConfigurationTable();
            } else if (tabSettingId.equals("standard_mode") && newVal.booleanValue() && EfuseUtils.getCurrentMode().equals((Object)EfuseUtils.Mode.ADVANCED)) {
                IMcu mcu;
                EfuseUtils.setCurrentMode((EfuseUtils.Mode)EfuseUtils.Mode.STANDARD);
                EfuseController.getInstance().getProblemsManager().clearProblems(ABootProblem.Type.WARNING_SYNCHRONIZATION_LOST);
                ArraySetting fuseArray = EfuseControllerUtils.getAdvancedFusesArray();
                if (fuseArray != null && (mcu = EfuseController.getInstance().getMcu()) != null) {
                    List advancedFuses = fuseArray.getSettings();
                    for (AdvancedFuseSetting advancedFuse : advancedFuses) {
                        String fuseWordId = advancedFuse.getFuseWordId();
                        StructSetting uiComponentStruct = advancedFuse.getUiComponent();
                        IntegerSetting valueInteger = uiComponentStruct.getIntegerSettingById("value_advanced");
                        FuseWord fuseWord = EfuseUtils.getFuseWordByID((List)mcu.getAllFuseWords(), (String)fuseWordId);
                        if (fuseWord == null || valueInteger == null) continue;
                        EfuseControllerUtils.setUIComponentsForFuseWord((IMcu)mcu, (FuseWord)fuseWord, (IntegerSetting)valueInteger);
                    }
                }
            }
            this.refresh();
            EfuseUtils.setSwitchingBetweenModes((boolean)false);
        });
    }

    @Override
    public void refresh() {
        this.tabContentNode.refresh();
    }

    public void dispose() {
        this.tabContentNode.dispose();
    }
}

