/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.efuse.gui;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.efuse.controller.EfuseController;
import com.nxp.swtools.efuse.gui.EfuseSceneCreator;
import com.nxp.swtools.efuse.gui.utils.EfuseGuiUtils;
import com.nxp.swtools.efuse.model.mcu.IMcu;
import com.nxp.swtools.utils.events.IEventListener;
import com.nxp.swtools.utils.view.ToolView;
import javafx.embed.swt.FXCanvas;
import javafx.scene.Scene;
import org.eclipse.swt.widgets.Composite;

public class EfuseView
extends ToolView {
    public static final String ID = "com.nxp.swtools.efuse.gui.EfuseView";
    @Nullable
    private EfuseSceneCreator sceneCreator;
    @Nullable
    private Composite parentComposite;

    public void createPartControl(@Nullable Composite parent) {
        this.parentComposite = parent;
        FXCanvas canvas = new FXCanvas(parent, 0);
        this.sceneCreator = new EfuseSceneCreator();
        Scene eFuseScene = this.sceneCreator.getRootScene();
        canvas.setScene(eFuseScene);
        this.setToolSceneState();
        assert (this.sceneCreator != null);
        this.sceneCreator.createLayout();
        assert (this.sceneCreator != null);
        IEventListener createUIListener = event -> this.sceneCreator.createLayout();
        EfuseController.getInstance().addListener(8, createUIListener);
        IEventListener setSceneStateListener = event -> this.setToolSceneState();
        EfuseController.getInstance().addListener(2, setSceneStateListener);
        IEventListener refreshUiListener = event -> EfuseGuiUtils.refreshUI(eFuseScene);
        EfuseController.getInstance().addListener(16, refreshUiListener);
    }

    public void setFocus() {
        if (this.parentComposite != null) {
            this.parentComposite.setFocus();
        }
    }

    public void dispose() {
        super.dispose();
        if (this.sceneCreator != null) {
            this.sceneCreator.dispose();
        }
    }

    public void setToolSceneState() {
        IMcu selectedMcu = EfuseController.getInstance().getMcu();
        if (selectedMcu != null) {
            boolean isMcuSupported = EfuseController.isMcuSupported((IMcu)selectedMcu);
            if (isMcuSupported && EfuseController.getInstance().isToolEnabled().get() && this.sceneCreator != null) {
                this.sceneCreator.getRootScene().getRoot().setVisible(true);
            } else if (!(isMcuSupported && EfuseController.getInstance().isToolEnabled().get() || this.sceneCreator == null)) {
                this.sceneCreator.getRootScene().getRoot().setVisible(false);
            }
        }
    }
}

