/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.visualization.xygraph.linearscale;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.nebula.visualization.xygraph.figures.DAxis;
import org.eclipse.nebula.visualization.xygraph.linearscale.IScaleProvider;
import org.eclipse.nebula.visualization.xygraph.linearscale.ITicksProvider;
import org.eclipse.nebula.visualization.xygraph.linearscale.Range;
import org.eclipse.nebula.visualization.xygraph.linearscale.Tick;
import org.eclipse.nebula.visualization.xygraph.linearscale.TickFactory;

public class LinearScaleTicks2
implements ITicksProvider {
    public static final String NAME = "DIAMOND";
    protected List<Tick> ticks = Collections.emptyList();
    private int maxWidth;
    private int maxHeight;
    protected ArrayList<Integer> minorPositions;
    protected IScaleProvider scale;
    private boolean ticksIndexBased;
    private boolean showMaxLabel = true;
    private boolean showMinLabel = true;
    private static final int TICKMINDIST_IN_PIXELS_X = 40;
    private static final int TICKMINDIST_IN_PIXELS_Y = 30;
    private static final int MAX_TICKS = 12;
    private static final int MIN_TICKS = 3;
    private static final String MINUS = "-";
    private static final double LAST_STEP_FRAC = 1.0 - Math.log10(9.0);

    public LinearScaleTicks2(DAxis scale) {
        this.scale = scale;
        this.minorPositions = new ArrayList();
    }

    @Override
    public List<Integer> getPositions() {
        ArrayList<Integer> positions = new ArrayList<Integer>();
        for (Tick t : this.ticks) {
            positions.add((int)Math.round(t.getPosition()));
        }
        return positions;
    }

    @Override
    public List<Boolean> getVisibilities() {
        ArrayList<Boolean> visibilities = new ArrayList<Boolean>();
        int i = 0;
        while (i < this.ticks.size()) {
            visibilities.add(true);
            ++i;
        }
        return visibilities;
    }

    @Override
    public List<String> getLabels() {
        ArrayList<String> labels = new ArrayList<String>();
        int i = 0;
        while (i < this.ticks.size()) {
            labels.add(this.ticks.get(i).getText());
            ++i;
        }
        return labels;
    }

    @Override
    public int getPosition(int index) {
        return (int)Math.round(this.ticks.get(index).getPosition());
    }

    @Override
    public int getLabelPosition(int index) {
        return this.ticks.get(index).getTextPosition();
    }

    @Override
    public double getValue(int index) {
        return this.ticks.get(index).getValue();
    }

    @Override
    public String getLabel(int index) {
        return this.ticks.get(index).getText();
    }

    @Override
    public boolean isVisible(int index) {
        return true;
    }

    @Override
    public int getMajorCount() {
        return this.ticks == null ? 0 : this.ticks.size();
    }

    @Override
    public int getMinorCount() {
        return this.minorPositions.size();
    }

    @Override
    public int getMinorPosition(int index) {
        return this.minorPositions.get(index);
    }

    @Override
    public int getMaxWidth() {
        return this.maxWidth;
    }

    @Override
    public int getMaxHeight() {
        return this.maxHeight;
    }

    @Override
    public boolean isShowMaxLabel() {
        return this.showMaxLabel;
    }

    @Override
    public void setShowMaxLabel(boolean showMaxLabel) {
        this.showMaxLabel = showMaxLabel;
    }

    @Override
    public boolean isShowMinLabel() {
        return this.showMinLabel;
    }

    @Override
    public void setShowMinLabel(boolean showMinLabel) {
        this.showMinLabel = showMinLabel;
    }

    @Override
    public Range update(double min, double max, int length) {
        String format;
        if (this.scale.isLogScaleEnabled() && (min <= 0.0 || max <= 0.0)) {
            throw new IllegalArgumentException("Range for log scale must be in positive range");
        }
        int maximumNumTicks = Math.min(12, length / (this.scale.isHorizontal() ? 40 : 30) + 1);
        int numTicks = Math.max(3, maximumNumTicks);
        DAxis aScale = (DAxis)this.scale;
        TickFactory tf = aScale.hasUserDefinedFormat() ? new TickFactory(this.scale) : (aScale.isAutoFormat() ? new TickFactory(TickFactory.TickFormatting.autoMode, this.scale) : ((format = aScale.getFormatPattern()).contains("E") ? new TickFactory(TickFactory.TickFormatting.useExponent, this.scale) : new TickFactory(TickFactory.TickFormatting.autoMode, this.scale)));
        int hMargin = this.getHeadMargin();
        int tMargin = this.getTailMargin();
        do {
            this.ticks = this.ticksIndexBased ? tf.generateIndexBasedTicks(min, max, numTicks) : (this.scale.isLogScaleEnabled() ? tf.generateLogTicks(min, max, numTicks, true, !this.scale.hasTicksAtEnds()) : tf.generateTicks(min, max, numTicks, true, !this.scale.hasTicksAtEnds()));
        } while (!this.updateLabelPositionsAndCheckGaps(length, hMargin, tMargin) && numTicks-- > 3);
        this.updateMinorTicks(hMargin + length);
        if (this.scale.hasTicksAtEnds() && this.ticks.size() > 1) {
            double hi;
            double lo;
            boolean isInverted = min > max;
            if (isInverted ^ (lo = this.ticks.get(0).getValue()) > min) {
                lo = min;
            }
            if (isInverted ^ (hi = this.ticks.get(this.ticks.size() - 1).getValue()) < max) {
                hi = max;
            }
            return new Range(lo, hi);
        }
        return null;
    }

    @Override
    public String getDefaultFormatPattern(double min, double max) {
        double power;
        String format = null;
        double mantissa = Math.max(Math.abs(min), Math.abs(max));
        double d = power = mantissa == 0.0 ? -1.0 : Math.log10(mantissa);
        if (power >= 4.0 || power < -6.0) {
            format = "0.####E0";
        } else if (power <= 0.0) {
            StringBuilder form = new StringBuilder("##0.00");
            while (power < -1.0) {
                power += 1.0;
                form.append("#");
            }
            format = form.toString();
        } else {
            format = "############.##";
        }
        return format;
    }

    @Override
    public int getHeadMargin() {
        if (this.ticks == null || this.ticks.size() == 0 || this.maxWidth == 0 || this.maxHeight == 0) {
            Dimension l = this.scale.getDimension(this.scale.getScaleRange().getLower());
            if (this.scale.isHorizontal()) {
                return l.width;
            }
            return l.height;
        }
        return this.scale.isHorizontal() ? (this.maxWidth + 1) / 2 : (this.maxHeight + 1) / 2;
    }

    @Override
    public int getTailMargin() {
        if (this.ticks == null || this.ticks.size() == 0 || this.maxWidth == 0 || this.maxHeight == 0) {
            Dimension h = this.scale.getDimension(this.scale.getScaleRange().getUpper());
            if (this.scale.isHorizontal()) {
                return h.width;
            }
            return h.height;
        }
        return this.scale.isHorizontal() ? (this.maxWidth + 1) / 2 : (this.maxHeight + 1) / 2;
    }

    private boolean updateLabelPositionsAndCheckGaps(int length, int hMargin, int tMargin) {
        int imax = this.ticks.size();
        if (imax == 0) {
            return true;
        }
        if (length <= 0) {
            return true;
        }
        this.maxWidth = 0;
        this.maxHeight = 0;
        boolean hasNegative = this.ticks.get(0).getText().startsWith(MINUS);
        int minus = this.scale.getDimension((Object)MINUS).width;
        for (Tick t : this.ticks) {
            String l = t.getText();
            Dimension d = this.scale.getDimension(l);
            if (hasNegative && !l.startsWith(MINUS)) {
                d.width += minus;
            }
            if (d.width > this.maxWidth) {
                this.maxWidth = d.width;
            }
            if (d.height <= this.maxHeight) continue;
            this.maxHeight = d.height;
        }
        for (Tick t : this.ticks) {
            t.setPosition((double)length * t.getPosition() + (double)hMargin);
        }
        length += hMargin + tMargin;
        if (this.scale.isHorizontal()) {
            int space = (int)(0.67 * (double)this.scale.getDimension((Object)" ").width);
            int last = 0;
            for (Tick t : this.ticks) {
                Dimension d = this.scale.getDimension(t.getText());
                int w = d.width;
                int p = (int)Math.ceil(t.getPosition() - (double)w * 0.5);
                if (p < 0) {
                    p = 0;
                } else if (p + w >= length) {
                    p = length - 1 - w;
                }
                t.setTextPosition(p);
                if (last > p) {
                    if (this.ticks.indexOf(t) == imax - 1 || imax > 3) {
                        return false;
                    }
                    t.setText("");
                    continue;
                }
                last = p + w + space;
            }
        } else {
            for (Tick t : this.ticks) {
                Dimension d = this.scale.getDimension(t.getText());
                int h = d.height;
                int p = (int)Math.ceil((double)(length - 1) - t.getPosition() - (double)h * 0.5);
                if (p < 0) {
                    p = 0;
                } else if (p + h >= length) {
                    p = length - 1 - h;
                }
                t.setTextPosition(p);
            }
        }
        return true;
    }

    private void updateMinorTicks(int end) {
        block22: {
            int minorTicks;
            double majorStepInPixel;
            int jmax;
            block21: {
                this.minorPositions.clear();
                jmax = this.ticks.size();
                if (jmax <= 1) {
                    return;
                }
                majorStepInPixel = (this.ticks.get(jmax - 1).getPosition() - this.ticks.get(0).getPosition()) / (double)(jmax - 1);
                if (majorStepInPixel == 0.0) {
                    return;
                }
                if (!this.scale.isLogScaleEnabled()) break block21;
                if (!(majorStepInPixel * LAST_STEP_FRAC >= (double)this.scale.getMinorTickMarkStepHint())) break block22;
                int minorTicks2 = 10 * (int)Math.round(Math.abs(Math.log10(this.ticks.get(1).getValue() / this.ticks.get(0).getValue())));
                if (minorTicks2 > 10) {
                    return;
                }
                double p = this.ticks.get(0).getPosition();
                if (p > 0.0) {
                    p -= majorStepInPixel;
                    int i = 1;
                    while (i < minorTicks2) {
                        int q = (int)(p + majorStepInPixel * Math.log10(10.0 * (double)i / (double)minorTicks2));
                        if (q >= 0 && q < end) {
                            this.minorPositions.add(q);
                        }
                        ++i;
                    }
                }
                int j = 0;
                while (j < jmax) {
                    p = this.ticks.get(j).getPosition();
                    int i = 1;
                    while (i < minorTicks2) {
                        int q = (int)(p + majorStepInPixel * Math.log10(10.0 * (double)i / (double)minorTicks2));
                        if (q >= 0 && q < end) {
                            this.minorPositions.add(q);
                        }
                        ++i;
                    }
                    ++j;
                }
                break block22;
            }
            double step = Math.abs(majorStepInPixel);
            if (this.ticksIndexBased) {
                minorTicks = (int)Math.abs(this.ticks.get(1).getValue() - this.ticks.get(0).getValue());
                if (minorTicks == 1) {
                    return;
                }
                if ((double)minorTicks > step / 5.0) {
                    minorTicks = step / 5.0 >= (double)this.scale.getMinorTickMarkStepHint() ? 5 : (step / 4.0 >= (double)this.scale.getMinorTickMarkStepHint() ? 4 : 2);
                } else if (minorTicks > 5) {
                    minorTicks = 5;
                }
            } else {
                minorTicks = this.scale.isDateEnabled() ? 6 : (step / 5.0 >= (double)this.scale.getMinorTickMarkStepHint() ? 5 : (step / 4.0 >= (double)this.scale.getMinorTickMarkStepHint() ? 4 : 2));
            }
            double minorStepInPixel = majorStepInPixel / (double)minorTicks;
            double p = this.ticks.get(0).getPosition();
            if (p > 0.0) {
                p -= majorStepInPixel;
                int i = 1;
                while (i < minorTicks) {
                    int q = (int)Math.floor(p + (double)i * minorStepInPixel);
                    if (q >= 0 && q < end) {
                        this.minorPositions.add(q);
                    }
                    ++i;
                }
            }
            int j = 0;
            while (j < jmax) {
                p = this.ticks.get(j).getPosition();
                int i = 1;
                while (i < minorTicks) {
                    int q = (int)Math.floor(p + (double)i * minorStepInPixel);
                    if (q >= 0 && q < end) {
                        this.minorPositions.add(q);
                    }
                    ++i;
                }
                ++j;
            }
        }
    }

    public void setTicksIndexBased(boolean isTicksIndexBased) {
        this.ticksIndexBased = isTicksIndexBased;
    }
}

