/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.ide.debugger.svd.launch;

import com.nxp.s32ds.cle.ide.debugger.internal.svd.DebuggerSvdActivator;
import com.nxp.s32ds.cle.ide.debugger.svd.SvdPathSource;
import com.nxp.s32ds.cle.ide.debugger.svd.SvdSource;
import com.nxp.s32ds.cle.ide.debugger.svd.SvdSourceType;
import com.nxp.s32ds.cle.ide.debugger.svd.SvdSources;
import com.nxp.s32ds.cle.ide.debugger.svd.SvdUrlSource;
import com.nxp.s32ds.cle.ide.debugger.svd.launch.SvdLaunchParams;
import com.nxp.s32ds.cle.runtime.hardware.launch.configuration.service.HardwareLaunchConfigurationActivator;
import com.nxp.s32ds.cle.runtime.hardware.launch.configuration.service.HardwareLaunchConfigurationService;
import com.nxp.s32ds.cle.runtime.hardware.registry.DeviceCoreDescriptor;
import com.nxp.s32ds.cle.runtime.svd.registry.SvdDescriptor;
import com.nxp.s32ds.cle.runtime.svd.registry.core.SvdDescriptors;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;

public class SvdLaunchConfigurations {
    public static boolean isUseSystemBus(ILaunchConfiguration configuration) {
        return SvdLaunchConfigurations.getFromLaunchParam(configuration, p -> p.isUseSystemBus(), false);
    }

    public static boolean isCleanWatchView(ILaunchConfiguration configuration) {
        return SvdLaunchConfigurations.getFromLaunchParam(configuration, p -> p.isCleanWatchView(), false);
    }

    public static boolean isAskBeforeClean(ILaunchConfiguration configuration) {
        return SvdLaunchConfigurations.getFromLaunchParam(configuration, p -> p.isAskBeforeClean(), false);
    }

    private static <T> T getFromLaunchParam(ILaunchConfiguration configuration, Function<SvdLaunchParams, T> function, T defaultValue) {
        try {
            return function.apply(new SvdLaunchParams(configuration));
        }
        catch (CoreException e) {
            DebuggerSvdActivator.getInstance().log(e.getStatus());
            return defaultValue;
        }
    }

    public static SvdSources getDefaultSvdSources(ILaunchConfiguration configuration) {
        SvdSource[] array = (SvdSource[])EnumSet.of(SvdSourceType.SVD, SvdSourceType.ARM, SvdSourceType.SYS).stream().sorted((t0, t1) -> t0.compareTo(t1)).map(t -> SvdLaunchConfigurations.getSvdSource(configuration, t)).filter(Objects::nonNull).toArray(SvdSource[]::new);
        return new SvdSources(array);
    }

    public static SvdSources getSvdSources(ILaunchConfiguration configuration) {
        Stream<SvdSource> stream;
        block6: {
            stream = SvdLaunchConfigurations.getDefaultSvdSources(configuration).stream();
            try {
                SvdSource source;
                SvdLaunchParams params = new SvdLaunchParams(configuration);
                if (!SvdLaunchParams.MERGE_STRATEGY.ALL.name().equals(params.getMergeStrategy())) {
                    stream = stream.filter(s -> s.getType() != SvdSourceType.ARM);
                }
                if (params.isUseDefault()) break block6;
                String svdPath = params.getSvdPath();
                if (svdPath == null || svdPath.isEmpty()) {
                    DebuggerSvdActivator.getInstance().logWarning("User defined SVD path is empty");
                    break block6;
                }
                String path = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(svdPath, true);
                try {
                    source = new SvdUrlSource(SvdSourceType.SVD, path);
                }
                catch (CoreException coreException) {
                    source = new SvdPathSource(SvdSourceType.SVD, path);
                }
                stream = Stream.concat(Stream.of(source), stream.filter(s -> s.getType() != SvdSourceType.SVD));
            }
            catch (CoreException e) {
                DebuggerSvdActivator.getInstance().log(e.getStatus());
            }
        }
        return new SvdSources((SvdSource[])stream.sorted((s0, s1) -> s0.getType().compareTo(s1.getType())).toArray(SvdSource[]::new));
    }

    private static SvdUrlSource getSvdSource(ILaunchConfiguration configuration, SvdSourceType type) {
        DeviceCoreDescriptor descriptor = SvdLaunchConfigurations.getDeviceCoreByLaunchConfiguration(configuration);
        if (descriptor == null) {
            return null;
        }
        return SvdLaunchConfigurations.getSvdSource(descriptor, type);
    }

    private static SvdUrlSource getSvdSource(DeviceCoreDescriptor deviceCoreDesriptor, SvdSourceType type) {
        switch (type) {
            case SYS: {
                return SvdLaunchConfigurations.createSvdSource(() -> SvdDescriptors.getSystemRegistersSvdByCoreId((String)deviceCoreDesriptor.getCoreId()), d -> SvdLaunchConfigurations.createUrlSource(SvdSourceType.SYS, d.getSysPath()));
            }
            case ARM: {
                return SvdLaunchConfigurations.createSvdSource(() -> SvdDescriptors.getCoreRegistersSvdByCoreId((String)deviceCoreDesriptor.getCoreId()), d -> SvdLaunchConfigurations.createUrlSource(SvdSourceType.ARM, d.getArmPath()));
            }
            case SVD: {
                return SvdLaunchConfigurations.createSvdSource(() -> SvdDescriptors.getSvdDescriptorsByDeviceIdCoreIds((String)deviceCoreDesriptor.getDeviceId(), (String)deviceCoreDesriptor.getCoreId()), d -> SvdLaunchConfigurations.createUrlSource(SvdSourceType.SVD, d.getSvdPath()));
            }
        }
        throw new IllegalArgumentException("Unknown SVD source type " + (Object)((Object)type));
    }

    private static SvdUrlSource createUrlSource(SvdSourceType svdSourceType, String path) throws CoreException {
        if (path == null || path.trim().isEmpty()) {
            return null;
        }
        return new SvdUrlSource(svdSourceType, path);
    }

    private static SvdUrlSource createSvdSource(Supplier<Optional<SvdDescriptor>> s, ThrowableFunction<SvdDescriptor, SvdUrlSource, CoreException> f) {
        Optional<SvdDescriptor> optional = s.get();
        if (!optional.isPresent()) {
            return null;
        }
        try {
            return f.apply(optional.get());
        }
        catch (CoreException e) {
            DebuggerSvdActivator.getInstance().log(e.getStatus());
            return null;
        }
    }

    private static DeviceCoreDescriptor getDeviceCoreByLaunchConfiguration(ILaunchConfiguration configuration) {
        HardwareLaunchConfigurationService service = HardwareLaunchConfigurationActivator.getInstance().getService();
        return service.getDeviceCoreDescriptor(configuration);
    }

    private static interface ThrowableFunction<T, R, E extends Throwable> {
        public R apply(T var1) throws E;
    }
}

