/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.ide.ui.dialogs;

import com.nxp.s32ds.ext.ide.core.refactoring.ProjectSet;
import com.nxp.s32ds.ext.ide.internal.ui.Messages;
import com.nxp.s32ds.ext.ide.ui.dialogs.validation.ProjectNameValidator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public abstract class AbstractRefactoringDialog
extends StatusDialog {
    private String result;
    private ProjectNameValidator validator;
    private Text text;

    public AbstractRefactoringDialog(Shell sh, ProjectSet projects) {
        super(sh);
        this.validator = new ProjectNameValidator(projects);
        this.result = projects.getName();
    }

    public String getResult() {
        return this.result;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.getTitle());
    }

    public boolean isHelpAvailable() {
        return false;
    }

    protected void buttonPressed(int buttonId) {
        this.result = buttonId == 0 ? this.text.getText() : null;
        super.buttonPressed(buttonId);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Label label = new Label(composite, 64);
        label.setText(Messages.refactoringDialogNewName);
        GridData data = new GridData(256);
        data.widthHint = this.convertHorizontalDLUsToPixels(300);
        label.setLayoutData((Object)data);
        label.setFont(parent.getFont());
        this.text = new Text(composite, 2052);
        this.text.setLayoutData((Object)new GridData(256));
        this.text.addModifyListener(e -> this.validateInput());
        this.text.setFocus();
        if (this.result != null) {
            this.text.setText(this.result);
            this.text.selectAll();
        }
        AbstractRefactoringDialog.applyDialogFont((Control)composite);
        return composite;
    }

    private void validateInput() {
        IStatus status = this.validator.validate(this.text.getText());
        this.updateStatus(status);
    }

    public abstract String getTitle();
}

