/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.ide.ui.util;

import com.nxp.s32ds.ext.ide.core.refactoring.ProjectSet;
import com.nxp.s32ds.ext.ide.internal.ui.Messages;
import com.nxp.s32ds.ext.ide.internal.ui.UiActivator;
import com.nxp.s32ds.ext.rcp.jse.utils.FuncUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.handlers.HandlerUtil;

public class RefactoringUtils {
    private RefactoringUtils() {
    }

    public static IResource findSelectedResource(ExecutionEvent event) {
        IStructuredSelection selection = (IStructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        IResource res = RefactoringUtils.stream(selection, IResource.class).findAny().orElse(RefactoringUtils.stream(selection, IAdaptable.class).map(adaptable -> (IResource)adaptable.getAdapter(IResource.class)).filter(IResource.class::isInstance).map(IResource.class::cast).findAny().orElse(RefactoringUtils.adapt(selection, ResourceMapping.class).map(FuncUtils.loggingFunction(RefactoringUtils::getTraversals, null)).filter(Objects::nonNull).flatMap(resourceTraversalArray -> Stream.of(resourceTraversalArray)).map(ResourceTraversal::getResources).flatMap(iResourceArray -> Stream.of(iResourceArray)).findAny().orElse(null)));
        return res;
    }

    public static ProjectSet findProjectSet(IResource resource) throws CoreException {
        int matchingSymb;
        ProjectSet projects = null;
        IPath wsLocation = ResourcesPlugin.getWorkspace().getRoot().getLocation();
        int segWorkspace = wsLocation.segmentCount();
        if (segWorkspace == (matchingSymb = wsLocation.matchingFirstSegments(resource.getLocation())) && (projects = RefactoringUtils.getProjects(resource)).isEmpty()) {
            projects = RefactoringUtils.getProjectsWithGraphs(resource);
        }
        return projects;
    }

    public static IStatus validateProjectSet(ProjectSet projects) {
        if (projects == null || projects.isEmpty()) {
            return UiActivator.getInstance().createError(Messages.refactoringErrorSelectionIsEmpty);
        }
        for (IProjectDescription project : projects.getProjects().collect(Collectors.toList())) {
            String projectFolder = new Path(project.getLocationURI().getPath()).lastSegment();
            if (project.getName().equals(projectFolder)) continue;
            return UiActivator.getInstance().createError(NLS.bind((String)Messages.refactoringErrorNonConsistent, (Object)project.getName(), (Object)projectFolder));
        }
        return Status.OK_STATUS;
    }

    private static <T> Stream<T> stream(IStructuredSelection selection, Class<T> clazz) {
        return selection.toList().stream().filter(clazz::isInstance);
    }

    private static <T> Stream<T> adapt(IStructuredSelection selection, Class<T> clazz) {
        return selection.toList().stream().map(o -> Platform.getAdapterManager().getAdapter(o, clazz)).filter(clazz::isInstance);
    }

    private static ResourceTraversal[] getTraversals(ResourceMapping mapping) throws CoreException {
        return mapping.getTraversals(ResourceMappingContext.LOCAL_CONTEXT, (IProgressMonitor)new NullProgressMonitor());
    }

    private static ProjectSet getProjects(IResource resource) throws CoreException {
        if (resource.getLocation().makeRelativeTo(ResourcesPlugin.getWorkspace().getRoot().getLocation()).segmentCount() == 1) {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(resource.getName());
            IProjectDescription pd = project.getDescription();
            pd.setLocation(project.getLocation());
            return new ProjectSet(pd);
        }
        File fileParent = resource.getLocation().toFile().getParentFile();
        Path path = new Path(fileParent.getAbsolutePath());
        ArrayList<IProjectDescription> listProjectDescr = new ArrayList<IProjectDescription>();
        File[] fileArray = fileParent.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File folder = fileArray[n2];
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(folder.getName());
            if (project.isAccessible()) {
                listProjectDescr.add(project.getDescription());
            }
            ++n2;
        }
        return new ProjectSet(fileParent.getName(), "", (IPath)path, listProjectDescr);
    }

    private static ProjectSet getProjectsWithGraphs(IResource resource) {
        IPath location = ResourcesPlugin.getWorkspace().getRoot().getLocation();
        IPath resLocation = resource.getLocation();
        File resParent = resLocation.toFile().getParentFile();
        if (resLocation.makeRelativeTo(location).segmentCount() == 2) {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(resource.getName());
            return new ProjectSet(project.getName(), project.getName(), resLocation, RefactoringUtils.collectSiblingProjects(resParent).collect(Collectors.toList()));
        }
        return null;
    }

    private static Stream<IProjectDescription> collectSiblingProjects(File parent) {
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        return Stream.of(parent.listFiles(File::isDirectory)).map(file -> new File((File)file, ".project")).filter(file -> file.isFile() && file.length() > 0L).map(File::toString).map(Path::new).map(FuncUtils.loggingFunction(arg_0 -> ((IWorkspace)ws).loadProjectDescription(arg_0), null)).filter(Objects::nonNull);
    }
}

