/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.debug.ide.s32debugger.flash.internal.core;

import com.nxp.s32ds.debug.ide.core.DebuggerLaunchSequence;
import com.nxp.s32ds.debug.ide.core.DebuggerUtils;
import com.nxp.s32ds.debug.ide.core.S32DSGdbLaunch;
import com.nxp.s32ds.debug.ide.core.S32DebuggerErrorStatuses;
import com.nxp.s32ds.debug.ide.s32debugger.core.S32DebuggerBackend;
import com.nxp.s32ds.debug.ide.s32debugger.flash.core.GenericProgressDialogStatusHandler;
import com.nxp.s32ds.debug.ide.s32debugger.flash.core.S32DebuggerFlashProgrammerCoreActivator;
import com.nxp.s32ds.debug.ide.s32debugger.flash.internal.core.S32DebuggerFlashProgrammerMessages;
import com.nxp.s32ds.debug.ide.s32debugger.flash.validation.S32DebuggerFlashProgrammerAttributesValidator;
import com.nxp.s32ds.debug.ide.s32debugger.flash.validation.S32DebuggerFlashProgrammerParams;
import com.nxp.s32ds.ext.rcp.statushandlers.RcpStatusHandler;
import com.nxp.s32ds.ext.rcp.statushandlers.RcpStatusHandlers;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateExecutor;
import org.eclipse.cdt.dsf.concurrent.ImmediateRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.Query;
import org.eclipse.cdt.dsf.concurrent.ReflectionSequence;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitorWithProgress;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.command.ICommand;
import org.eclipse.cdt.dsf.gdb.service.command.IGDBControl;
import org.eclipse.cdt.dsf.mi.service.IMIProcesses;
import org.eclipse.cdt.dsf.mi.service.command.commands.CLICommand;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.osgi.util.NLS;

public class S32DebuggerFlashProgrammerLaunchSequence
extends DebuggerLaunchSequence {
    private static final String SOURCE_SCRIPT = "${S32DS_GDB_SERVER_DIR}/Debugger/scripts/gdb_extensions/flash/s32flash.py";
    private static final String NO_FLASHING_HANDLER = "Cannot find flash progress handler, required for flashing operation";
    private static final String PY_GDB_TIMEOUT_S = "py _GDB_TIMEOUT = %s";
    private static final String PY_FLASH_TYPE_S = "py _FLASH_TYPE = \"%s\"";
    private static final String PY_INIT_SCRIPT_S = "py _INIT_SCRIPT = \"%s\"";
    private static final String PY_FLASH_NAME_S = "py _FLASH_NAME = \"%s\"";
    private static final String PY_FLASH_CMD = "py flash()";
    private static final String FL_CHIP_ERASE = "fl_erase_all";
    private static final String FL_WRITE_FLASH_ELF_CMD_S_S_S = "fl_write_elf %s%s%s%s";
    private static final String FL_WRITE_FLASH_ANY_BINARY_CMD_S_S_S = "fl_write %s%s%s %s";
    private static final String FL_WRITE_FLASH_VERIFY = "-v ";
    private static final String FL_WRITE_FLASH_ERASE = "-e ";
    private static final String FL_WRITE_FLASH_BASE_ADDRESS = "-b %s ";
    private static final String FL_CLOSE_CMD = "fl_close";
    private static final String STEP_EXECUTE_FLASH_SCRIPT = "stepExecuteFlashScript";
    private static final String STEP_MEMORY_ERASE = "stepMemoryErase";
    private static final String STEP_WRITE_FLASH = "stepWriteFlash";
    private static final String STEP_END_FLASH = "stepEndFlash";
    private static final double PROGRESS_PART_FOR_ERASING = 0.2;
    private IGDBControl commandControl;
    private IMIProcesses procService;
    private S32DebuggerBackend gdbServerBackend;
    private S32DebuggerFlashProgrammerAttributesValidator validator;
    private S32DebuggerFlashProgrammerParams params;
    private GenericProgressDialogStatusHandler flashStatusHandler;
    private int fullFlashDialogProgress;

    public S32DebuggerFlashProgrammerLaunchSequence(DsfSession session, Map<String, Object> attributes, RequestMonitorWithProgress rm) {
        super(session, attributes, rm);
        ILaunchConfiguration lc = this.launch.getLaunchConfiguration();
        this.params = S32DebuggerFlashProgrammerParams.getParams((ILaunchConfiguration)lc);
        this.validator = new S32DebuggerFlashProgrammerAttributesValidator();
        RcpStatusHandler handler = RcpStatusHandlers.getStatusHandlerService().getStatusHandler("com.nxp.s32ds.debug.ide.s32debugger.flash.internal.ui.flashingProgressStatusHandler");
        if (handler == null || !(handler instanceof GenericProgressDialogStatusHandler)) {
            rm.setStatus((IStatus)new Status(4, S32DebuggerFlashProgrammerCoreActivator.getDefault().getBundleId(), NO_FLASHING_HANDLER));
        } else {
            this.flashStatusHandler = (GenericProgressDialogStatusHandler)handler;
            this.fullFlashDialogProgress = this.flashStatusHandler.getFullTaskProgress();
            IStatus status = this.validator.validateFlashParameters(this.params, true);
            if (status.isOK()) {
                if (this.params.isInitialCore() && this.params.isUseSecureDebugging()) {
                    if ("PWD".equals(this.params.getSecureDebuggingType())) {
                        rm.setStatus(this.getSecureDebuggingKeyWord());
                    } else {
                        rm.setStatus(this.getSmartCardPassword());
                    }
                }
            } else {
                rm.setStatus(status);
            }
        }
        if (!rm.getStatus().isOK()) {
            rm.done();
        }
    }

    private void queueCommand(String command, RequestMonitor rm) {
        if (!command.isEmpty()) {
            this.commandControl.queueCommand((ICommand)new CLICommand((IDMContext)this.commandControl.getContext(), command), new DataRequestMonitor((Executor)this.getExecutor(), rm));
        } else {
            rm.done();
        }
    }

    protected String[] getExecutionOrder(String group) {
        if ("GROUP_TOP_LEVEL".equals(group)) {
            ArrayList<String> orderList = new ArrayList<String>(Arrays.asList(super.getExecutionOrder("GROUP_TOP_LEVEL")));
            orderList.removeAll(Arrays.asList("stepNewProcess"));
            orderList.add(orderList.indexOf("stepDataModelInitializationComplete"), "GROUP_S32Debugger");
            return orderList.toArray(new String[orderList.size()]);
        }
        if ("GROUP_S32Debugger".equals(group)) {
            return new String[]{"stepInitializeDebuggerFinalLaunchSequence", "stepInitializeGdbServerProcess", STEP_EXECUTE_FLASH_SCRIPT, STEP_MEMORY_ERASE, STEP_WRITE_FLASH, STEP_END_FLASH, "stepDebuggerCleanup"};
        }
        return super.getExecutionOrder(group);
    }

    @ReflectionSequence.Execute
    public void stepInitializeDebuggerFinalLaunchSequence(RequestMonitor rm) {
        this.tracker = new DsfServicesTracker(S32DebuggerFlashProgrammerCoreActivator.getContext(), this.getSession().getId());
        this.gdbServerBackend = (S32DebuggerBackend)this.tracker.getService(S32DebuggerBackend.class);
        if (this.gdbServerBackend == null) {
            this.shutdownOnError("com.nxp.s32ds.debug.ide.s32debugger.ui.gdbErrorStatusHandler", S32DebuggerErrorStatuses.getGDBNoBackendStatus());
            rm.done();
            return;
        }
        this.commandControl = (IGDBControl)this.tracker.getService(IGDBControl.class);
        if (this.commandControl == null) {
            this.shutdownOnError("com.nxp.s32ds.debug.ide.s32debugger.ui.gdbErrorStatusHandler", S32DebuggerErrorStatuses.getGDBNoControlStatus());
            rm.done();
            return;
        }
        this.procService = (IMIProcesses)this.tracker.getService(IMIProcesses.class);
        if (this.procService == null) {
            this.shutdownOnError("com.nxp.s32ds.debug.ide.s32debugger.ui.gdbErrorStatusHandler", S32DebuggerErrorStatuses.getGDBNoStatusProcessor());
            rm.done();
            return;
        }
        if (!this.params.getClientCommands().isEmpty()) {
            String gdbSetCommands = String.valueOf(this.params.getClientCommands()) + "\n";
            this.queueCommand(gdbSetCommands, rm);
        }
        rm.done();
    }

    @ReflectionSequence.RollBack(value="stepInitializeDebuggerFinalLaunchSequence")
    public void rollBackInitializeFinalLaunchSequence(RequestMonitor rm) {
        this.cleanUp();
        rm.done();
    }

    @ReflectionSequence.Execute
    public void stepInitializeGdbServerProcess(RequestMonitor rm) {
        this.flashStatusHandler.setTaskName(S32DebuggerFlashProgrammerMessages.S32DebuggerFlashProgrammer_board_initializing);
        if (!this.gdbServerBackend.initializeGdbServerProcess()) {
            this.shutdownOnError("com.nxp.s32ds.debug.ide.s32debugger.ui.gdbErrorStatusHandler", null);
        }
        rm.done();
    }

    @ReflectionSequence.Execute
    public void stepExecuteFlashScript(RequestMonitor rm) {
        String source = DebuggerUtils.substitute((String)SOURCE_SCRIPT);
        String normalized = new Path(source).toString();
        this.queueCommand(String.format("source %s", normalized), (RequestMonitor)new ImmediateRequestMonitor());
        this.queueCommand(String.format(PY_FLASH_TYPE_S, this.params.getFlashType()), (RequestMonitor)new ImmediateRequestMonitor());
        this.queueCommand(String.format("py _PROBE_IP = \"%s\"", this.validator.getVirtualIP()), (RequestMonitor)new ImmediateRequestMonitor());
        this.queueCommand(String.format("py _JTAG_SPEED = %s", this.params.getJtagSpeedKHz()), (RequestMonitor)new ImmediateRequestMonitor());
        boolean doLaunchServer = this.params.isDoLaunchServer();
        if (doLaunchServer) {
            this.queueCommand(String.format("py _IS_LOGGING_ENABLED = %s", this.params.isLogEnabled() ? "True" : "False"), (RequestMonitor)new ImmediateRequestMonitor());
        } else {
            this.queueCommand(String.format("py _IS_LOGGING_ENABLED = %s", "False"), (RequestMonitor)new ImmediateRequestMonitor());
        }
        this.queueCommand(String.format("py _GDB_SERVER_PORT = %s", this.params.getServerPort()), (RequestMonitor)new ImmediateRequestMonitor());
        this.queueCommand(String.format(PY_GDB_TIMEOUT_S, this.params.getRemoteTimeoutInSeconds()), (RequestMonitor)new ImmediateRequestMonitor());
        boolean doResetAndDelay = this.params.isDoResetAndDelay();
        if (doResetAndDelay) {
            String delayInMSeconds = this.params.getDelayInMSeconds();
            this.queueCommand(String.format("py _RESET_DELAY = %s", delayInMSeconds), (RequestMonitor)new ImmediateRequestMonitor());
        } else {
            this.queueCommand(String.format("py _RESET_DELAY = %s", 0), (RequestMonitor)new ImmediateRequestMonitor());
        }
        String resetTypeCommand = doResetAndDelay ? String.format("py _RESET_TYPE = \"%s\"", "default") : "py _RESET_TYPE = None";
        this.queueCommand(resetTypeCommand, (RequestMonitor)new ImmediateRequestMonitor());
        if (this.params.isUseSecureDebugging()) {
            this.queueCommand(String.format("py _SECURE_TYPE = \"%s\"", this.params.getSecureDebuggingType()), (RequestMonitor)new ImmediateRequestMonitor());
            this.queueCommand(String.format("py _SECURE_KEY = \"%s\"", this.keyWord), (RequestMonitor)new ImmediateRequestMonitor());
        }
        this.queueCommand(String.format("py _SOC_NAME = \"%s\"", this.params.getDeviceId()), (RequestMonitor)new ImmediateRequestMonitor());
        this.queueCommand(String.format(PY_INIT_SCRIPT_S, new Path(DebuggerUtils.substitute((String)this.params.getInitializationScript())).toString()), (RequestMonitor)new ImmediateRequestMonitor());
        this.queueCommand(String.format(PY_FLASH_NAME_S, this.params.getFlashName()), (RequestMonitor)new ImmediateRequestMonitor());
        this.queueCommand(PY_FLASH_CMD, rm);
    }

    @ReflectionSequence.Execute
    public void stepMemoryErase(RequestMonitor rm) {
        if (!S32DSGdbLaunch.isShutdowned((ILaunch)this.launch)) {
            boolean chipErase = this.params.isFlashMemoryErase();
            if (chipErase) {
                new Thread(() -> {
                    this.flashStatusHandler.setTaskName(S32DebuggerFlashProgrammerMessages.S32DebuggerFlashProgrammer_memory_erasing);
                    Query<Object> flashClosingQuery = new Query<Object>(){

                        protected void execute(DataRequestMonitor<Object> rm) {
                            S32DebuggerFlashProgrammerLaunchSequence.this.queueCommand(S32DebuggerFlashProgrammerLaunchSequence.FL_CHIP_ERASE, (RequestMonitor)rm);
                        }
                    };
                    ImmediateExecutor.getInstance().execute((Runnable)flashClosingQuery);
                    try {
                        flashClosingQuery.get();
                    }
                    catch (InterruptedException | ExecutionException exception) {}
                    if (this.tracker == null) {
                        rm.setStatus((IStatus)new Status(4, S32DebuggerFlashProgrammerCoreActivator.getDefault().getBundleId(), S32DebuggerFlashProgrammerMessages.S32DebuggerFlashProgrammerErasingMemory_error_message));
                        rm.done();
                    } else {
                        int progressMade = (int)((double)this.fullFlashDialogProgress * 0.2);
                        this.flashStatusHandler.worked(progressMade);
                        this.fullFlashDialogProgress -= progressMade;
                        rm.done();
                    }
                }).start();
            } else {
                rm.done();
            }
        } else {
            rm.done();
        }
    }

    @ReflectionSequence.Execute
    public void stepWriteFlash(RequestMonitor rm) {
        if (!S32DSGdbLaunch.isShutdowned((ILaunch)this.launch)) {
            boolean flashErase = this.params.isFlashMemoryErase();
            Map idToBinaryMap = this.params.getIdToBinaryMap();
            Map binaryIdToBinaryTypeMap = this.params.getBinaryIdToBinaryTypeMap();
            Map binariIdIsEnabledMap = this.params.getBinaryIdIsEnabledMap();
            Map binaryIdToProjectNameMap = this.params.getBinaryIdToProjectNameMap();
            Map binaryIdToBaseAddressMap = this.params.getBinaryIdToBaseAddressMap();
            boolean verifyAfterWrite = this.params.isVerifyAfterWrite();
            int elfsEnabled = 1;
            for (String binaryId : idToBinaryMap.keySet()) {
                String enabled = (String)binariIdIsEnabledMap.get(binaryId);
                if (!"enabled".equals(enabled)) continue;
                ++elfsEnabled;
            }
            int progressStep = this.fullFlashDialogProgress / elfsEnabled;
            ArrayDeque<String> commands = new ArrayDeque<String>();
            ArrayDeque<String> binaries = new ArrayDeque<String>();
            for (String binaryId : idToBinaryMap.keySet()) {
                String command;
                String baseAddr;
                String enabled = (String)binariIdIsEnabledMap.get(binaryId);
                if ("disabled".equals(enabled)) continue;
                String binaryPath = DebuggerUtils.substitute((String)((String)idToBinaryMap.get(binaryId)));
                if (!Files.exists(Paths.get(binaryPath, new String[0]), new LinkOption[0])) {
                    binaryPath = DebuggerUtils.getAbsoluteBinaryPathByProjectName((String)((String)binaryIdToProjectNameMap.get(binaryId)), (String)binaryPath);
                }
                String verifyStr = "";
                if (verifyAfterWrite) {
                    verifyStr = FL_WRITE_FLASH_VERIFY;
                }
                String eraseStr = "";
                if (!flashErase) {
                    eraseStr = FL_WRITE_FLASH_ERASE;
                }
                if (!(baseAddr = (String)binaryIdToBaseAddressMap.get(binaryId)).isEmpty() && !baseAddr.startsWith("0x")) {
                    baseAddr = "0x" + baseAddr;
                }
                if ("elf".equals(binaryIdToBinaryTypeMap.get(binaryId))) {
                    if (!baseAddr.isEmpty()) {
                        baseAddr = String.format(FL_WRITE_FLASH_BASE_ADDRESS, baseAddr);
                    }
                    command = String.format(FL_WRITE_FLASH_ELF_CMD_S_S_S, verifyStr, eraseStr, baseAddr, binaryPath);
                } else {
                    command = String.format(FL_WRITE_FLASH_ANY_BINARY_CMD_S_S_S, verifyStr, eraseStr, baseAddr, binaryPath);
                }
                Path path = new Path(binaryPath);
                commands.push(command);
                binaries.push(path.toFile().getName());
            }
            new FlashWriterWIthProgressThreadExecutor(commands, binaries, rm, progressStep).start();
        }
    }

    @ReflectionSequence.Execute
    public void stepEndFlash(RequestMonitor rm) {
        if (!S32DSGdbLaunch.isShutdowned((ILaunch)this.launch)) {
            new Thread(() -> {
                Object waiter;
                Query<Object> flashClosingQuery = new Query<Object>(){

                    protected void execute(DataRequestMonitor<Object> rm) {
                        S32DebuggerFlashProgrammerLaunchSequence.this.queueCommand(S32DebuggerFlashProgrammerLaunchSequence.FL_CLOSE_CMD, (RequestMonitor)rm);
                    }
                };
                ImmediateExecutor.getInstance().execute((Runnable)flashClosingQuery);
                try {
                    flashClosingQuery.get();
                }
                catch (InterruptedException | ExecutionException exception) {}
                this.flashStatusHandler.setTaskName(S32DebuggerFlashProgrammerMessages.S32DebuggerFlashProgrammer_flashing_finished);
                this.flashStatusHandler.setSubTask("");
                Object object = waiter = new Object();
                synchronized (object) {
                    try {
                        waiter.wait(1500L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                rm.done();
            }).start();
        } else {
            rm.done();
        }
    }

    @ReflectionSequence.Execute
    public void stepDebuggerCleanup(RequestMonitor rm) {
        this.cleanUp();
        rm.done();
    }

    private class FlashWriterWIthProgressThreadExecutor
    extends Thread {
        private final ArrayDeque<String> COMMANDS;
        private final ArrayDeque<String> BINARY_PATHS;
        private final int ELFS_QUANTITY;
        private final int PROGRESS_STEP;
        private final RequestMonitor PARENT;

        public FlashWriterWIthProgressThreadExecutor(ArrayDeque<String> commands, ArrayDeque<String> binaryPaths, RequestMonitor parent, int progressStep) {
            this.COMMANDS = commands;
            this.BINARY_PATHS = binaryPaths;
            this.ELFS_QUANTITY = commands.size();
            this.PARENT = parent;
            this.PROGRESS_STEP = progressStep;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int currentElf = 1;
            while (!this.COMMANDS.isEmpty()) {
                Object waiter;
                final String command = this.COMMANDS.pop();
                String binary = this.BINARY_PATHS.pop();
                S32DebuggerFlashProgrammerLaunchSequence.this.flashStatusHandler.setTaskName(NLS.bind((String)S32DebuggerFlashProgrammerMessages.S32DebuggerFlashProgrammer_flashing_file, (Object[])new Object[]{binary, currentElf, this.ELFS_QUANTITY}));
                Query<Object> flashWritingQuery = new Query<Object>(){

                    protected void execute(DataRequestMonitor<Object> rm) {
                        S32DebuggerFlashProgrammerLaunchSequence.this.queueCommand(command, (RequestMonitor)rm);
                    }
                };
                ImmediateExecutor.getInstance().execute((Runnable)flashWritingQuery);
                try {
                    flashWritingQuery.get();
                }
                catch (InterruptedException | ExecutionException exception) {}
                if (S32DebuggerFlashProgrammerLaunchSequence.this.tracker == null) {
                    this.PARENT.setStatus((IStatus)new Status(4, S32DebuggerFlashProgrammerCoreActivator.getDefault().getBundleId(), NLS.bind((String)S32DebuggerFlashProgrammerMessages.S32DebuggerFlashProgrammerFlashingProcess_error_message, (Object)binary)));
                    this.PARENT.done();
                    return;
                }
                S32DebuggerFlashProgrammerLaunchSequence.this.flashStatusHandler.worked(this.PROGRESS_STEP);
                Object object = waiter = new Object();
                synchronized (object) {
                    try {
                        waiter.wait(500L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                ++currentElf;
            }
            this.PARENT.done();
        }
    }
}

