/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.model;

import com.nxp.swtools.clocks.model.EDividerError;
import com.nxp.swtools.clocks.model.ENodeType;
import com.nxp.swtools.clocks.model.FreqLimitErrorI;
import com.nxp.swtools.clocks.model.Node;
import com.nxp.swtools.clocks.model.NodeSimpleCon;
import com.nxp.swtools.clocks.model.TimingScale;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.rational.BigRational;
import java.math.BigInteger;
import java.util.List;

public class ADivMul
extends NodeSimpleCon {
    protected TimingScale scaler;
    @Nullable
    protected BigRational setScale;
    @Nullable
    protected BigRational defaultScale;
    @Nullable
    protected BigRational compScale;
    @Nullable
    protected BigRational inputClock;
    @Nullable
    protected BigRational outputClock;
    @Nullable
    protected BigRational setOutputFreq;
    protected boolean importedFreq;
    @NonNull
    protected BigRational savedAcc;
    protected boolean useDefaults;

    public ADivMul(@NonNull String id, @NonNull ENodeType type) {
        super(id, type);
        this.scaler = null;
        this.setScale = null;
        this.defaultScale = null;
        this.setOutputFreq = null;
        this.accuracy = TimingScale.defaultAccuracy;
        this.compScale = null;
        this.importedFreq = false;
        this.savedAcc = this.accuracy;
        this.useDefaults = true;
    }

    public ADivMul(@NonNull String id, @NonNull ENodeType type, @NonNull TimingScale scaler) {
        super(id, type);
        this.scaler = scaler;
        this.setScale = null;
        this.defaultScale = null;
        this.setOutputFreq = null;
        this.accuracy = TimingScale.defaultAccuracy;
        this.importedFreq = false;
        this.savedAcc = this.accuracy;
        this.useDefaults = true;
    }

    public ADivMul(@NonNull String id, @NonNull ENodeType type, @NonNull TimingScale scaler, @NonNull BigRational defaultScale) {
        super(id, type);
        this.scaler = scaler;
        this.setScale = null;
        this.defaultScale = defaultScale;
        this.setOutputFreq = null;
        this.accuracy = TimingScale.defaultAccuracy;
        this.compScale = null;
        this.importedFreq = false;
        this.savedAcc = this.accuracy;
        this.useDefaults = true;
    }

    @Override
    public void includeDefaults() {
        this.useDefaults = true;
    }

    @Override
    public void excludeDefaults() {
        this.useDefaults = false;
    }

    @Override
    public boolean setOutputFrequency(byte freq) {
        BigRational clock = new BigRational(freq);
        return this.setOutputFrequency(clock);
    }

    @Override
    public boolean setOutputFrequency(short freq) {
        BigRational clock = new BigRational(freq);
        return this.setOutputFrequency(clock);
    }

    @Override
    public boolean setOutputFrequency(int freq) {
        BigRational clock = new BigRational(freq);
        return this.setOutputFrequency(clock);
    }

    @Override
    public boolean setOutputFrequency(long freq) {
        BigRational clock = new BigRational(freq);
        return this.setOutputFrequency(clock);
    }

    @Override
    public boolean setOutputFrequency(@NonNull BigInteger freq) {
        BigRational clock = new BigRational(freq);
        return this.setOutputFrequency(clock);
    }

    @Override
    public boolean setOutputFrequency(@NonNull BigRational freq) {
        this.setOutputFreq = freq;
        return this.checkOutputFreq(freq);
    }

    @Override
    public void setAccuracy(@NonNull BigRational acc) {
        this.accuracy = acc;
        assert (this.accuracy.compareTo(BigRational.ZERO) >= 0);
    }

    @Override
    public void printT(@NonNull Node callee, @NonNull String pref, @NonNull String prefLast) {
        String ps = null;
        ps = this.pred != null ? this.pred.id : "";
        String cs = null;
        cs = this.inputClock == null ? "" : "@" + this.inputClock;
        if (this.outputClock != null) {
            cs = String.valueOf(cs) + "#" + this.outputClock;
        }
        System.out.println(String.valueOf(pref) + "+--" + this.id + "(" + ps + ")" + cs);
        if (this.child != null) {
            if ("".equals(prefLast)) {
                this.child.printT(this, String.valueOf(pref) + "|    ", String.valueOf(pref) + "|    ");
            } else {
                this.child.printT(this, String.valueOf(prefLast) + "     ", String.valueOf(prefLast) + "     ");
            }
        }
    }

    @Override
    public @NonNull StringBuffer stringT(@NonNull Node callee, @NonNull String pref, @NonNull String prefLast) {
        StringBuffer ps = new StringBuffer();
        if (this.pred != null) {
            ps.append(this.pred.id);
        }
        StringBuffer cs = new StringBuffer();
        if (this.inputClock != null) {
            cs.append('@');
            cs.append(this.inputClock);
        }
        if (this.outputClock != null) {
            cs.append('#');
            cs.append(this.outputClock);
        }
        StringBuffer res = new StringBuffer(pref);
        res.append("+--");
        res.append(this.id);
        res.append('(');
        res.append(ps);
        res.append(')');
        res.append(cs);
        res.append('\n');
        if (this.child != null) {
            if ("".equals(prefLast)) {
                res.append(this.child.stringT(this, String.valueOf(pref) + "|    ", String.valueOf(pref) + "|    "));
            } else {
                res.append(this.child.stringT(this, String.valueOf(prefLast) + "     ", String.valueOf(prefLast) + "     "));
            }
        }
        return res;
    }

    @Override
    public TimingScale getTimingScaleValues() {
        return this.scaler;
    }

    @Override
    public void setTimingScaleValues(@NonNull TimingScale scaler) {
        this.scaler = scaler;
        this.defaultScale = null;
        this.setScale = null;
    }

    @Override
    public boolean setDefaultScale(@NonNull BigRational defaultScale) {
        if (this.scaler == null) {
            this.defaultScale = null;
            return false;
        }
        if (this.scaler.elem(defaultScale)) {
            this.defaultScale = defaultScale;
            return true;
        }
        this.defaultScale = null;
        return false;
    }

    @Override
    public @Nullable BigRational getDefaultScale() {
        return this.defaultScale;
    }

    @Override
    public boolean setScale(@Nullable BigRational newScale) {
        FreqLimitErrorI tmpLogFLE = this.logFLE;
        if (newScale == null || this.scaler == null) {
            this.setScale = null;
            if (newScale != null) {
                if (tmpLogFLE != null && this.enabled) {
                    tmpLogFLE.logDividerError(EDividerError.ScaleOutOfRange, this);
                }
                return false;
            }
            return true;
        }
        if (this.scaler.elem(newScale)) {
            this.setScale = newScale;
            return true;
        }
        this.setScale = null;
        if (tmpLogFLE != null && this.enabled) {
            tmpLogFLE.logDividerError(EDividerError.ScaleOutOfRange, this);
        }
        return false;
    }

    @Override
    public @Nullable BigRational getScale() {
        return this.setScale;
    }

    @Override
    public boolean isSet(@NonNull List<@NonNull Node> unset) {
        if (this.scaler == null || this.setScale == null) {
            unset.add(this);
            return false;
        }
        return true;
    }

    @Override
    public boolean isSetOrDefault(@NonNull List<@NonNull Node> unset) {
        if (this.scaler == null || this.setScale == null && this.defaultScale == null) {
            unset.add(this);
            return false;
        }
        return true;
    }

    @Override
    public void clean() {
        this.setScale = null;
        this.compScale = null;
        this.setOutputFreq = null;
    }

    protected @NonNull BigRational getCScale(@NonNull BigRational inClock, @NonNull BigRational outClock) {
        throw new UnsupportedOperationException("Method getCScale not implemented for ADivMul class.");
    }

    protected @NonNull BigRational evalOp(@NonNull BigInteger k, @NonNull BigRational in) {
        throw new UnsupportedOperationException("Method evalOp not implemented for ADivMul class.");
    }

    protected @NonNull BigRational evalOp(@NonNull BigRational k, @NonNull BigRational in) {
        throw new UnsupportedOperationException("Method evalOp not implemented for ADivMul class.");
    }

    protected @NonNull BigRational evalInverseOp(@NonNull BigInteger k, @NonNull BigRational out) {
        throw new UnsupportedOperationException("Method evalInverseOp not implemented for ADivMul class.");
    }

    protected @NonNull BigRational evalInverseOp(@NonNull BigRational k, @NonNull BigRational out) {
        throw new UnsupportedOperationException("Method evalInverseOp not implemented for ADivMul class.");
    }

    @Override
    public BigRational[] prepareAuto(@NonNull Node callee, boolean sendFreq) {
        assert (!this.called) : "Node " + this.id + " called 2nd times, now from " + callee.id;
        this.called = true;
        if (!this.enabled || !sendFreq) {
            this.child.prepareAuto(this, false);
            return null;
        }
        if (this.setScale != null || this.setOutputFreq != null || this.useDefaults && this.defaultScale != null) {
            this.child.prepareAuto(this, false);
            return null;
        }
        BigRational[] vals = this.child.prepareAuto(this, true);
        if (vals != null) {
            this.importedFreq = true;
            this.savedAcc = this.accuracy;
            this.setOutputFreq = vals[0];
            BigRational tmp = vals[1];
            assert (tmp != null);
            this.accuracy = tmp;
        }
        return null;
    }

    @Override
    public void closeAuto() {
        if (this.importedFreq) {
            this.importedFreq = false;
            this.savedAcc = this.accuracy = this.savedAcc;
            this.setOutputFreq = null;
        }
    }

    @Override
    public void setScaleComputed() {
        if (this.compScale == null) {
            return;
        }
        if (!(this.setScale != null || this.useDefaults && this.defaultScale != null)) {
            this.setScale = this.compScale;
        }
    }

    @Override
    public @Nullable BigRational getOutputClock() {
        return this.outputClock;
    }

    @Override
    public @Nullable BigRational getInputClock() {
        return this.inputClock;
    }

    @Override
    public @NonNull List<@NonNull Node> getDirectlyConnectedTo(@NonNull Node callee, @NonNull Node node) {
        assert (this.child != null) : "Null child in divider/multiplier node " + this.id;
        @NonNull List<@NonNull Node> res = this.child.getDirectlyConnectedTo(this, node);
        if (res.size() > 0) {
            if (this == node) {
                res.add(this);
            } else if (!res.contains(node)) {
                res.clear();
            }
        }
        return res;
    }

    @Override
    public void resetInputOutputClock() {
        this.inputClock = null;
        this.outputClock = null;
    }

    @Override
    public @Nullable BigRational getActualScale() {
        if (this.setScale != null) {
            return this.setScale;
        }
        if (this.useDefaults && this.defaultScale != null) {
            return this.defaultScale;
        }
        return this.compScale;
    }
}

