/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.model;

import com.nxp.swtools.clocks.model.ECompState;
import com.nxp.swtools.clocks.model.EErrorType;
import com.nxp.swtools.clocks.model.ENodeType;
import com.nxp.swtools.clocks.model.FrequencyRange;
import com.nxp.swtools.clocks.model.Node;
import com.nxp.swtools.clocks.model.NodeHidden;
import com.nxp.swtools.clocks.model.TimingScale;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.rational.BigRational;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class Consumer
extends NodeHidden {
    private NodeHidden pred = null;
    @Nullable
    private BigRational inputClock = null;
    @Nullable
    private BigRational setInputFreq = null;

    public Consumer(@NonNull String id) {
        super(id, ENodeType.Consumer);
        this.accuracy = TimingScale.defaultAccuracy;
    }

    @Override
    public void setPred(@NonNull Node pred) {
        if (!(pred instanceof NodeHidden)) {
            throw new UnsupportedOperationException("Method setPred can be used only for ancestors of NodeHidden class.");
        }
        this.pred = (NodeHidden)pred;
    }

    @Override
    public boolean setInputFrequency(byte freq) {
        BigRational clock = new BigRational(freq);
        return this.setInputFrequency(clock);
    }

    @Override
    public boolean setOutputFrequency(byte freq) {
        return this.setInputFrequency(freq);
    }

    @Override
    public boolean setInputFrequency(short freq) {
        BigRational clock = new BigRational(freq);
        return this.setInputFrequency(clock);
    }

    @Override
    public boolean setOutputFrequency(short freq) {
        return this.setInputFrequency(freq);
    }

    @Override
    public boolean setInputFrequency(int freq) {
        BigRational clock = new BigRational(freq);
        return this.setInputFrequency(clock);
    }

    @Override
    public boolean setOutputFrequency(int freq) {
        return this.setInputFrequency(freq);
    }

    @Override
    public boolean setInputFrequency(long freq) {
        BigRational clock = new BigRational(freq);
        return this.setInputFrequency(clock);
    }

    @Override
    public boolean setOutputFrequency(long freq) {
        return this.setInputFrequency(freq);
    }

    @Override
    public boolean setInputFrequency(@NonNull BigInteger freq) {
        BigRational clock = new BigRational(freq);
        return this.setInputFrequency(clock);
    }

    @Override
    public boolean setOutputFrequency(@NonNull BigInteger freq) {
        return this.setInputFrequency(freq);
    }

    @Override
    public boolean setInputFrequency(@NonNull BigRational freq) {
        this.setInputFreq = freq;
        return this.checkInputFreq(freq);
    }

    @Override
    public boolean setOutputFrequency(@NonNull BigRational freq) {
        return this.setInputFrequency(freq);
    }

    @Override
    public @Nullable BigRational getFrequency() {
        return this.setInputFreq;
    }

    @Override
    public void setAccuracy(@NonNull BigRational acc) {
        this.accuracy = acc;
        assert (this.accuracy.compareTo(BigRational.ZERO) >= 0);
    }

    public void pushBack() {
        if (this.pred == null) {
            return;
        }
        BigRational actSetInputFreq = this.setInputFreq;
        if (actSetInputFreq == null) {
            return;
        }
        this.pred.setOutputFrequency(actSetInputFreq);
        this.pred.setAccuracy(this.accuracy);
    }

    @Override
    public @Nullable BigRational getInputClock() {
        return this.inputClock;
    }

    @Override
    public void setMinOutputFreq(@Nullable BigRational minOutputFreq) {
        this.setMinInputFreq(minOutputFreq);
    }

    @Override
    public void setMaxOutputFreq(@Nullable BigRational maxOutputFreq) {
        this.setMaxInputFreq(maxOutputFreq);
    }

    @Override
    public void setOutputFrequencyRanges(@Nullable List<@NonNull FrequencyRange> outputRanges) {
        super.setInputFrequencyRanges(outputRanges);
    }

    @Override
    public void printT(@NonNull Node callee, @NonNull String pref, @NonNull String prefLast) {
        String ps = null;
        ps = this.pred == null ? "" : this.pred.id;
        String cs = null;
        cs = this.inputClock == null ? "" : "@" + this.inputClock;
        System.out.println(String.valueOf(pref) + "+--" + this.id + "(" + ps + ")" + cs);
    }

    @Override
    public @NonNull StringBuffer stringT(@NonNull Node callee, @NonNull String pref, @NonNull String prefLast) {
        StringBuffer ps = new StringBuffer();
        if (this.pred != null) {
            ps.append(this.pred.id);
        }
        StringBuffer cs = new StringBuffer();
        if (this.inputClock != null) {
            cs.append('@');
            cs.append(this.inputClock);
        }
        StringBuffer res = new StringBuffer(pref);
        res.append("+--");
        res.append(this.id);
        res.append('(');
        res.append(ps);
        res.append(')');
        res.append(cs);
        res.append('\n');
        return res;
    }

    @Override
    public boolean isSet(@NonNull List<@NonNull Node> unset) {
        return true;
    }

    @Override
    public boolean isSetOrDefault(@NonNull List<@NonNull Node> unset) {
        return true;
    }

    @Override
    public void clean() {
        this.setInputFreq = null;
    }

    @Override
    public boolean compute(@NonNull Node callee, @NonNull BigRational clock) {
        if (!this.enabled) {
            return true;
        }
        assert (!this.called) : "Node " + this.id + " called 2nd times, now from " + callee.id;
        this.called = true;
        this.wasComputed = true;
        boolean res = true;
        this.inputClock = clock;
        res = this.checkInputFreq(this.inputClock);
        return res;
    }

    @Override
    public BigRational[] prepareAuto(@NonNull Node callee, boolean sendFreq) {
        assert (!this.called) : "Node " + this.id + " called 2nd times, now from " + callee.id;
        this.called = true;
        if (!this.enabled) {
            return null;
        }
        if (!sendFreq) {
            return null;
        }
        if (this.setInputFreq == null) {
            return null;
        }
        BigRational[] res = new BigRational[]{this.setInputFreq, this.accuracy};
        return res;
    }

    @Override
    public @NonNull EErrorType computeAutoWR(@NonNull Node callee, @NonNull BigRational clock) {
        if (!this.enabled) {
            return EErrorType.NotEnabled;
        }
        if (this.lastComp == ECompState.NoComp) {
            this.lastComp = ECompState.AlwaysFailes;
        }
        this.wasComputed = true;
        EErrorType errInputFreq = this.testInputFreq(clock);
        if (errInputFreq != EErrorType.None) {
            return errInputFreq;
        }
        if (this.setInputFreq != null) {
            BigRational tmpSetInputFreq = this.setInputFreq;
            assert (tmpSetInputFreq != null);
            if (tmpSetInputFreq.compareTo(clock) < 0) {
                BigRational actualAccuracy = clock.divide(tmpSetInputFreq).subtract(BigRational.ONE);
                if (actualAccuracy.compareTo(this.accuracy) > 0) {
                    return EErrorType.TooFast;
                }
            } else {
                BigRational actualAccuracy = BigRational.ONE.subtract(clock.divide(tmpSetInputFreq));
                if (actualAccuracy.compareTo(this.accuracy) > 0) {
                    return EErrorType.TooSlow;
                }
            }
        }
        this.inputClock = clock;
        this.lastComp = ECompState.OnceSatisfied;
        return EErrorType.None;
    }

    @Override
    public void trackAutoWR(@NonNull Node callee) {
    }

    @Override
    public boolean getReversePath(@NonNull Node callee, @NonNull List<@NonNull Node> path) {
        assert (this.pred != null) : "Predecessor of " + this.id + " must be set";
        path.add(this);
        return this.pred.getReversePath(this, path);
    }

    @Override
    public @NonNull List<@NonNull Node> getDirectlyConnectedTo(@NonNull Node callee, @NonNull Node node) {
        @NonNull ArrayList<@NonNull Node> res = new ArrayList<Node>();
        res.add(this);
        return res;
    }

    @Override
    public void resetInputOutputClock() {
        this.inputClock = null;
    }
}

