/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.model;

import com.nxp.swtools.clocks.model.DivCommonSlave;
import com.nxp.swtools.clocks.model.DivMaster;
import com.nxp.swtools.clocks.model.DivMasterSlave;
import com.nxp.swtools.clocks.model.Divider;
import com.nxp.swtools.clocks.model.ECompState;
import com.nxp.swtools.clocks.model.EDividerError;
import com.nxp.swtools.clocks.model.EErrorType;
import com.nxp.swtools.clocks.model.ENodeType;
import com.nxp.swtools.clocks.model.FreqLimitErrorI;
import com.nxp.swtools.clocks.model.Node;
import com.nxp.swtools.clocks.model.TimingScale;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.rational.BigRational;
import java.util.ArrayList;
import java.util.List;

public class DivMultiSlave
extends DivCommonSlave {
    @NonNull
    private @NonNull List<@NonNull Divider> masters;
    private Divider firstCallFrom;
    @NonNull
    private EErrorType lastErrorToFirst = EErrorType.CannotSetup;

    public DivMultiSlave(@NonNull String id, @NonNull TimingScale scaler) {
        super(id, scaler);
        this.type = ENodeType.DivMultiSlave;
        this.masters = new ArrayList<Divider>();
        this.maximalRatio = null;
    }

    public DivMultiSlave(@NonNull String id, @NonNull TimingScale scaler, @NonNull BigRational defaultScale) {
        super(id, scaler, defaultScale);
        this.type = ENodeType.DivMultiSlave;
        this.masters = new ArrayList<Divider>();
        this.maximalRatio = null;
    }

    @Override
    public void addMaster(@NonNull Divider master) {
        if (this.masters.contains(master)) {
            return;
        }
        this.masters.add(master);
    }

    @Override
    public @NonNull List<@NonNull Divider> getMasters() {
        assert (this.masters.size() > 0);
        @NonNull ArrayList<@NonNull Divider> result = new ArrayList<Divider>(this.masters.size());
        for (Divider master : this.masters) {
            result.add(master);
        }
        return result;
    }

    @Override
    public boolean setScale(@Nullable BigRational newScale) {
        BigRational curScale = null;
        FreqLimitErrorI locLogFLE = this.logFLE;
        if (newScale == null || this.scaler == null) {
            this.setScale = null;
            if (this.useDefaults) {
                curScale = this.defaultScale;
            }
        } else if (this.scaler.elem(newScale)) {
            curScale = this.setScale = newScale;
        } else {
            this.setScale = null;
        }
        if (curScale == null && newScale != null) {
            if (locLogFLE != null && this.enabled) {
                locLogFLE.logDividerError(EDividerError.ScaleOutOfRange, this);
            }
            return false;
        }
        if (curScale != null && this.masters.size() > 0) {
            boolean result = true;
            for (Divider master : this.masters) {
                if (master.setScale != null) {
                    boolean bl = result = result && this.checkScaleRatio(curScale.divide(master.setScale), master);
                }
                if (!master.useDefaults || master.defaultScale == null) continue;
                boolean bl = result = result && this.checkScaleRatio(curScale.divide(master.defaultScale), master);
            }
            return result;
        }
        return true;
    }

    @Override
    public @NonNull EErrorType computeAutoWR(@NonNull Node callee, @NonNull BigRational clock) {
        assert (this.masters.size() > 0) : "Master dividers not set in " + this.id;
        if (!this.masters.contains(callee)) {
            return EErrorType.None;
        }
        if (!this.enabled) {
            return EErrorType.NotEnabled;
        }
        if (!(callee instanceof DivMaster) && !(callee instanceof DivMasterSlave)) {
            return EErrorType.None;
        }
        Divider locMaster = (Divider)callee;
        if (this.lastComp == ECompState.NoComp) {
            this.firstCallFrom = locMaster;
            this.lastComp = ECompState.AlwaysFailes;
            this.wasComputed = true;
        } else if (this.firstCallFrom != locMaster) {
            if (this.lastComp != ECompState.OnceSubtreeOK) {
                return this.lastErrorToFirst;
            }
            BigRational masterScaleVal = locMaster.getActualScale();
            assert (masterScaleVal != null) : "Computation failed";
            BigRational myActualScaleVal = this.getActualScale();
            assert (myActualScaleVal != null) : "Computation failed";
            return this.testScaleRatio(myActualScaleVal.divide(masterScaleVal));
        }
        EErrorType sbr = this.lastErrorToFirst = this.testInputFreq(clock);
        if (sbr != EErrorType.None) {
            return sbr;
        }
        assert (this.scaler != null) : "Null scaler in divider " + this.id;
        assert (this.child != null) : "Null child in divider " + this.id;
        this.inputClock = clock;
        this.compScale = null;
        BigRational xxCompScale = this.getActualScale();
        BigRational masterCompScale = locMaster.getActualScale();
        assert (masterCompScale != null) : "Not defined master division scale";
        if (xxCompScale != null) {
            this.lastErrorToFirst = this.computeWith2Scales(clock, xxCompScale, masterCompScale);
            return this.lastErrorToFirst;
        }
        BigRational xxSetOutputFreq = this.setOutputFreq;
        if (xxSetOutputFreq != null) {
            this.lastErrorToFirst = this.computeWithFreqScale(clock, xxSetOutputFreq, masterCompScale);
            return this.lastErrorToFirst;
        }
        BigRational xxDefaultScale = this.defaultScale;
        if (xxDefaultScale != null && xxDefaultScale.compareTo(this.scaler.from) != 0 && this.computeWith2Scales(clock, xxDefaultScale, masterCompScale) == EErrorType.None) {
            EErrorType otherMasterRes = EErrorType.None;
            for (Divider master : this.masters) {
                BigRational masterScale;
                if (master != locMaster && (masterScale = master.getActualScale()) != null && (otherMasterRes = this.testScaleRatio(xxDefaultScale.divide(masterScale))) != EErrorType.None) break;
            }
            if (otherMasterRes == EErrorType.None) {
                return EErrorType.None;
            }
        }
        EErrorType res = EErrorType.TooFast;
        boolean fst = true;
        EErrorType outres = EErrorType.None;
        block10: for (BigRational scale : this.scaler) {
            assert (scale != null);
            @NonNull EErrorType scaleRes = this.testScaleRatio(scale.divide(masterCompScale));
            if (scaleRes != EErrorType.None) {
                switch (scaleRes) {
                    case TooFast: {
                        continue block10;
                    }
                    case TooSlow: {
                        if (outres == EErrorType.None) {
                            this.lastErrorToFirst = EErrorType.TooSlow;
                            return EErrorType.TooSlow;
                        }
                        this.lastErrorToFirst = EErrorType.CannotSetup;
                        return EErrorType.CannotSetup;
                    }
                    case CannotSetup: {
                        if (outres != EErrorType.None) continue block10;
                        outres = EErrorType.CannotSetup;
                        continue block10;
                    }
                    default: {
                        this.lastErrorToFirst = scaleRes;
                        return scaleRes;
                    }
                }
            }
            for (Divider master : this.masters) {
                BigRational masterScale;
                if (master != locMaster && (masterScale = master.getActualScale()) != null && (scaleRes = this.testScaleRatio(scale.divide(masterScale))) != EErrorType.None) break;
            }
            if (scaleRes != EErrorType.None) {
                switch (scaleRes) {
                    case TooFast: {
                        continue block10;
                    }
                    case CannotSetup: {
                        if (outres != EErrorType.None) continue block10;
                        outres = EErrorType.CannotSetup;
                        continue block10;
                    }
                    default: {
                        this.lastErrorToFirst = scaleRes;
                        return scaleRes;
                    }
                }
            }
            xxCompScale = scale;
            BigRational newClock = clock.divide(xxCompScale);
            sbr = this.testOutputFreq(newClock);
            if (sbr != EErrorType.None) {
                if (outres != EErrorType.CannotSetup || sbr == EErrorType.TooFast) {
                    outres = sbr == EErrorType.TooFast ? sbr : (outres == EErrorType.TooFast ? EErrorType.CannotSetup : sbr);
                }
                if (sbr != EErrorType.TooSlow) continue;
                this.lastErrorToFirst = outres;
                return outres;
            }
            this.outputClock = newClock;
            this.lastComp = ECompState.OnceSatisfied;
            EErrorType nres = this.child.computeAutoWR(this, newClock);
            if (nres == EErrorType.None || nres == EErrorType.NotEnabled) {
                this.lastComp = ECompState.OnceSubtreeOK;
                this.compScale = xxCompScale;
                this.lastErrorToFirst = EErrorType.None;
                return EErrorType.None;
            }
            if (nres == EErrorType.BothFastSlow) {
                this.lastErrorToFirst = nres;
                return nres;
            }
            if (nres == EErrorType.TooSlow) {
                if (fst) {
                    this.lastErrorToFirst = EErrorType.TooSlow;
                    return EErrorType.TooSlow;
                }
                this.lastErrorToFirst = EErrorType.CannotSetup;
                return EErrorType.CannotSetup;
            }
            fst = false;
            if (nres == EErrorType.TooFast && res == nres) continue;
            res = EErrorType.CannotSetup;
        }
        if (outres == EErrorType.CannotSetup) {
            res = outres;
        }
        this.lastErrorToFirst = res;
        return res;
    }
}

