/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.model;

import com.nxp.swtools.clocks.model.EScaleType;
import com.nxp.swtools.clocks.model.GeometricTimingScale;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.rational.BigRational;

public class LargeGeometricScale
extends GeometricTimingScale {
    public LargeGeometricScale(@NonNull BigRational fromScale, @NonNull BigRational toScale, @NonNull BigRational mulFactor) {
        super(fromScale, toScale, mulFactor);
        this.type = EScaleType.GeometricLarge;
    }

    @Override
    public boolean elem(@Nullable BigRational value) {
        if (value == null) {
            return false;
        }
        if (value.compareTo(this.from) < 0 || value.compareTo(this.to) > 0) {
            return false;
        }
        if (ONE.equals(this.numOfScales)) {
            return true;
        }
        @NonNull BigRational low = this.from;
        @NonNull BigRational high = this.to;
        int tmpN = this.numOfScales.divide(TWO).intValue();
        @NonNull BigRational mid = low.multiply(LargeGeometricScale.powBI(this.mul, tmpN));
        while (true) {
            switch (mid.compareTo(value)) {
                case 0: {
                    return true;
                }
                case -1: {
                    low = mid.multiply(this.mul);
                    break;
                }
                default: {
                    high = mid.divide(this.mul);
                }
            }
            if (high.compareTo(low) < 0) {
                return false;
            }
            @NonNull BigRational expval = low.multiply(high).multiply(this.mul);
            mid = LargeGeometricScale.sqrtRoundLow(expval, this.mul);
        }
    }

    @Override
    public @NonNull BigRational closest(@NonNull BigRational value) {
        if (value.compareTo(this.from) < 0) {
            return this.from;
        }
        if (value.compareTo(this.to) > 0) {
            return this.to;
        }
        if (ONE.equals(this.numOfScales)) {
            return this.from;
        }
        @NonNull BigRational low = this.from;
        @NonNull BigRational high = this.to;
        int tmpN = this.numOfScales.divide(TWO).intValue();
        @NonNull BigRational mid = this.from.multiply(LargeGeometricScale.powBI(this.mul, tmpN));
        while (true) {
            switch (value.compareTo(mid)) {
                case 0: {
                    return mid;
                }
                case -1: {
                    low = mid.multiply(this.mul);
                    break;
                }
                default: {
                    high = mid.divide(this.mul);
                }
            }
            if (high.compareTo(low) < 0) {
                if (value.subtract(high).compareTo(value.subtract(low).negate()) < 0) {
                    return high;
                }
                return low;
            }
            @NonNull BigRational expval = low.multiply(high).multiply(this.mul);
            mid = LargeGeometricScale.sqrtRoundLow(expval, this.mul);
        }
    }

    @Override
    public @Nullable BigRational closestUp(@NonNull BigRational value) {
        if (value.compareTo(this.from) < 0) {
            return this.from;
        }
        if (value.compareTo(this.to) > 0) {
            return null;
        }
        if (ONE.equals(this.numOfScales)) {
            return this.from;
        }
        @NonNull BigRational low = this.from;
        @NonNull BigRational high = this.to;
        int tmpN = this.numOfScales.divide(TWO).intValue();
        @NonNull BigRational mid = this.from.multiply(LargeGeometricScale.powBI(this.mul, tmpN));
        while (true) {
            switch (value.compareTo(mid)) {
                case 0: {
                    return mid;
                }
                case -1: {
                    low = mid.multiply(this.mul);
                    break;
                }
                default: {
                    high = mid.divide(this.mul);
                }
            }
            if (high.compareTo(low) < 0) {
                return low;
            }
            @NonNull BigRational expval = low.multiply(high).multiply(this.mul);
            assert (expval != null) : "BigInteger operations failed - expval";
            mid = LargeGeometricScale.sqrtRoundLow(expval, this.mul);
        }
    }

    @Override
    public @Nullable BigRational closestDown(@NonNull BigRational value) {
        if (value.compareTo(this.from) < 0) {
            return this.from;
        }
        if (value.compareTo(this.to) > 0) {
            return this.to;
        }
        if (ONE.equals(this.numOfScales)) {
            return this.from;
        }
        @NonNull BigRational low = this.from;
        @NonNull BigRational high = this.to;
        int tmpN = this.numOfScales.divide(TWO).intValue();
        @NonNull BigRational mid = this.from.multiply(LargeGeometricScale.powBI(this.mul, tmpN));
        while (true) {
            switch (value.compareTo(mid)) {
                case 0: {
                    return mid;
                }
                case -1: {
                    low = mid.multiply(this.mul);
                    break;
                }
                default: {
                    high = mid.divide(this.mul);
                }
            }
            if (high.compareTo(low) < 0) {
                return high;
            }
            @NonNull BigRational expval = low.multiply(high).multiply(this.mul);
            mid = LargeGeometricScale.sqrtRoundLow(expval, this.mul);
        }
    }
}

