/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.runtime.sdk.registry.resource;

import com.nxp.s32ds.cle.runtime.sdk.registry.resource.ResourceSdkAction;
import java.util.Arrays;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public enum ResourceSdkKind {
    BINARY_FILE("binaryFile"),
    COPY_BINARY_FILE("copyBinaryFile", BINARY_FILE),
    LINK_BINARY_FILE("addBinaryFile", BINARY_FILE),
    COPY_BINARY_FILES("copyBinaryFiles", BINARY_FILE),
    LINK_BINARY_FILES("addBinaryFiles", BINARY_FILE),
    HEADER_FOLDER("headerFolder", true),
    COPY_HEADER_FOLDER("copyHeaderFolder", HEADER_FOLDER),
    LINK_HEADER_FOLDER("addHeaderFolder", HEADER_FOLDER),
    COPY_HEADER_FOLDERS("copyHeaderFolders", HEADER_FOLDER),
    LINK_HEADER_FOLDERS("addHeaderFolders", HEADER_FOLDER),
    HEADER_FILE("headerFile"),
    COPY_HEADER_FILE("copyHeaderFile", HEADER_FILE),
    LINK_HEADER_FILE("addHeaderFile", HEADER_FILE),
    COPY_HEADER_FILES("copyHeaderFiles", HEADER_FILE),
    LINK_HEADER_FILES("addHeaderFiles", HEADER_FILE),
    INCLUDE_FILE("includeFile"),
    COPY_INCLUDE_FILE("copyIncludeFile", INCLUDE_FILE),
    LINK_INCLUDE_FILE("addIncludeFile", INCLUDE_FILE),
    COPY_INCLUDE_FILES("copyIncludeFiles", INCLUDE_FILE),
    LINK_INCLUDE_FILES("addIncludeFiles", INCLUDE_FILE),
    LINKER_FILE("linkerFile"),
    COPY_LINKER_FILE("copyLinkerFile", LINKER_FILE),
    LINK_LINKER_FILE("addLinkerFile", LINKER_FILE),
    COPY_LINKER_FILES("copyLinkerFiles", LINKER_FILE),
    LINK_LINKER_FILES("addLinkerFiles", LINKER_FILE),
    RESOURCE_FOLDER("resourceFolder", true),
    COPY_RESOURCE_FOLDER("copyResourceFolder", RESOURCE_FOLDER),
    LINK_RESOURCE_FOLDER("addResourceFolder", RESOURCE_FOLDER),
    COPY_RESOURCE_FOLDERS("copyResourceFolders", RESOURCE_FOLDER),
    LINK_RESOURCE_FOLDERS("addResourceFolders", RESOURCE_FOLDER),
    RESOURCE_FILE("resourceFile"),
    COPY_RESOURCE_FILE("copyResourceFile", RESOURCE_FILE),
    LINK_RESOURCE_FILE("addResourceFile", RESOURCE_FILE),
    COPY_RESOURCE_FILES("copyResourceFiles", RESOURCE_FILE),
    LINK_RESOURCE_FILES("addResourceFiles", RESOURCE_FILE),
    SOURCE_FOLDER("sourceFolder", true),
    COPY_SOURCE_FOLDER("copySourceFolder", SOURCE_FOLDER),
    LINK_SOURCE_FOLDER("addSourceFolder", SOURCE_FOLDER),
    COPY_SOURCE_FOLDERS("copySourceFolders", SOURCE_FOLDER),
    LINK_SOURCE_FOLDERS("addSourceFolders", SOURCE_FOLDER),
    SOURCE_FILE("sourceFile"),
    COPY_SOURCE_FILE("copySourceFile", SOURCE_FILE),
    LINK_SOURCE_FILE("addSourceFile", SOURCE_FILE),
    COPY_SOURCE_FILES("copySourceFiles", SOURCE_FILE),
    LINK_SOURCE_FILES("addSourceFiles", SOURCE_FILE),
    UNRECOGNIZED_RESOURCE("");

    private String xmlElementName;
    private boolean isFolderKind;
    private ResourceSdkKind baseKind;

    private ResourceSdkKind(String xmlElementName) {
        this.xmlElementName = xmlElementName;
        this.isFolderKind = false;
        this.baseKind = this;
    }

    private ResourceSdkKind(String xmlElementName, ResourceSdkKind baseKind) {
        this(xmlElementName);
        this.isFolderKind = baseKind.isFolderKind();
        this.baseKind = baseKind;
    }

    private ResourceSdkKind(String xmlElementName, boolean isFolderKind) {
        this(xmlElementName);
        this.isFolderKind = isFolderKind;
    }

    public String getXmlElementName() {
        return this.xmlElementName;
    }

    public static ResourceSdkKind of(String xmlElementName) {
        Optional<ResourceSdkKind> optional = ResourceSdkKind.validValues().stream().filter(resourceKindValue -> resourceKindValue.xmlElementName.equals(xmlElementName)).findFirst();
        return optional.isPresent() ? optional.get() : UNRECOGNIZED_RESOURCE;
    }

    public boolean isFolderKind() {
        return this.isFolderKind;
    }

    public boolean isFileKind() {
        return !this.isFolderKind();
    }

    public boolean isAction() {
        return ResourceSdkAction.UNRECOGNIZED_RESOURCE_ACTION != ResourceSdkAction.of(this.xmlElementName);
    }

    public ResourceSdkKind getBaseKind() {
        return this.baseKind;
    }

    public Set<ResourceSdkKind> getRelatedValues() {
        return ResourceSdkKind.valuesOfBaseKind(this.baseKind);
    }

    public static Set<ResourceSdkKind> valuesOfBaseKind(ResourceSdkKind baseKind) {
        return ResourceSdkKind.validValues().stream().filter(kind -> baseKind == kind.getBaseKind()).collect(Collectors.toSet());
    }

    public static Set<ResourceSdkKind> validValues() {
        return Arrays.stream(ResourceSdkKind.values()).filter(value -> UNRECOGNIZED_RESOURCE != value).collect(Collectors.toSet());
    }
}

