/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.debug.ide.s32debugger.internal.ui.handlers;

import com.nxp.s32ds.debug.ide.s32debugger.core.BoardConnectionDescriptor;
import com.nxp.s32ds.debug.ide.s32debugger.core.ProcessCheckingJob;
import com.nxp.s32ds.debug.ide.s32debugger.core.S32DebuggerBackend;
import com.nxp.s32ds.debug.ide.s32debugger.internal.ui.dialogs.StatusMessages;
import com.nxp.s32ds.debug.ide.ui.DebuggerUIActivator;
import com.nxp.s32ds.debug.ide.ui.ErrorMessages;
import com.nxp.s32ds.ext.rcp.statushandlers.RcpStatusHandler;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class S32DebuggerTestConnectionStatusHandler
implements RcpStatusHandler {
    public Object handleStatus(IStatus status, Object source) throws CoreException {
        Display display = Display.getDefault();
        if (source instanceof String) {
            final ProcessCheckingJob processCheckingJob = new ProcessCheckingJob("ProcessIsCancelledCheckingJob");
            DialogRunnable runnable = new DialogRunnable((String)source, processCheckingJob);
            display.syncExec(() -> {
                ProgressMonitorDialog dialog = new ProgressMonitorDialog(display.getActiveShell()){

                    protected void cancelPressed() {
                        processCheckingJob.cancel();
                    }
                };
                try {
                    dialog.setCancelable(true);
                    dialog.run(true, true, (IRunnableWithProgress)runnable);
                    BoardConnectionDescriptor result = runnable.getConnectionTestResult();
                    if (result == null) {
                        if (!processCheckingJob.getIsCancelled()) {
                            MessageDialog.openError((Shell)display.getActiveShell(), (String)ErrorMessages.ErrorDialogTitle_message, (String)runnable.getErrorString());
                        }
                    } else {
                        String message = result.isSuccessful() ? StatusMessages.InfoDialogBoardIsConnected_info_message : StatusMessages.InfoDialogBoardIsNotConnected_info_message;
                        MessageDialog.openInformation((Shell)display.getActiveShell(), (String)StatusMessages.InfoDialogTitle_message, (String)message);
                    }
                }
                catch (InvocationTargetException ex) {
                    DebuggerUIActivator.getInstance().logError("InvocationTargetException was thrown while testing board connection", (Throwable)ex);
                }
                catch (InterruptedException ex) {
                    DebuggerUIActivator.getInstance().logError("InterruptedException was thrown while testing board connection", (Throwable)ex);
                }
            });
        } else {
            MessageDialog.openError((Shell)display.getActiveShell(), (String)ErrorMessages.ErrorDialogTitle_message, (String)StatusMessages.UsbDeviceDisconnected_message);
        }
        return null;
    }

    private static class DialogRunnable
    implements IRunnableWithProgress {
        private String deviceStr;
        private String error;
        private BoardConnectionDescriptor operationResult;
        private ProcessCheckingJob processCheckingJob;

        public DialogRunnable(String device, ProcessCheckingJob processCheckingJob) {
            this.deviceStr = device;
            this.processCheckingJob = processCheckingJob;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            monitor.beginTask(StatusMessages.ProgressDialogBody_message, -1);
            try {
                this.operationResult = S32DebuggerBackend.isBoardConnected((String)this.deviceStr, (ProcessCheckingJob)this.processCheckingJob);
            }
            catch (IOException ex) {
                this.operationResult = null;
                this.error = ex.getMessage();
            }
        }

        public BoardConnectionDescriptor getConnectionTestResult() {
            return this.operationResult;
        }

        public String getErrorString() {
            return this.error;
        }
    }
}

