/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.debug.ide.s32debugger.ui.crosstriggering.memento;

import com.nxp.s32ds.debug.ide.s32debugger.internal.ui.S32DebuggerUIActivator;
import com.nxp.s32ds.debug.ide.s32debugger.ui.crosstriggering.CrossTriggeringState;
import com.nxp.s32ds.ext.rcp.runtime.ui.memento.RcpMementos;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IMemento;

public class CrossTriggeringContextMemento
extends RcpMementos<Collection<CrossTriggeringState>> {
    private static final String STATE_CHILD = "state_";
    private static final String CROSSTRIGGER_DEVICECOREID = "device_core_id";
    private static final String CROSSTRIGGER_SOURCE = "source";
    private static final String CROSSTRIGGER_DESTINATION = "destination";

    public CrossTriggeringContextMemento(String mementoId) {
        super("CrossTriggeringContextMemento", mementoId);
    }

    protected void saveToMemento(IMemento memento, Collection<CrossTriggeringState> statesList) {
        int number = 0;
        for (CrossTriggeringState state : statesList) {
            IMemento memSpaceChild = memento.createChild(STATE_CHILD + String.valueOf(number++));
            memSpaceChild.putString(CROSSTRIGGER_DEVICECOREID, state.getDeviceCoreId());
            memSpaceChild.putBoolean(CROSSTRIGGER_SOURCE, state.isSource());
            memSpaceChild.putBoolean(CROSSTRIGGER_DESTINATION, state.isDestination());
        }
    }

    protected Collection<CrossTriggeringState> restoreFromMemento(IMemento memento, Collection<CrossTriggeringState> statesList) {
        IMemento[] states = memento.getChildren();
        if (states.length == 0) {
            return Collections.emptyList();
        }
        Arrays.stream(states).forEach(child -> {
            CrossTriggeringState state = new CrossTriggeringState(child.getString(CROSSTRIGGER_DEVICECOREID));
            state.setSource(child.getBoolean(CROSSTRIGGER_SOURCE));
            state.setDestination(child.getBoolean(CROSSTRIGGER_DESTINATION));
            statesList.add(state);
        });
        return statesList;
    }

    protected IPreferenceStore getPreferenceStore() {
        return S32DebuggerUIActivator.getInstance().getPreferenceStore();
    }
}

