/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.project.info.core.exports;

import com.nxp.s32ds.cle.cdt.project.info.core.exports.IPIExporterDataProvider;
import com.nxp.s32ds.cle.cdt.project.info.core.exports.ProjectInfoExportSettings;
import com.nxp.s32ds.cle.cdt.project.info.core.exports.toolchains.DiabS32DSToolchainExporter;
import com.nxp.s32ds.cle.cdt.project.info.core.exports.toolchains.FreescaleS32DSToolChainExporter;
import com.nxp.s32ds.cle.cdt.project.info.core.exports.toolchains.GDBToolChainExporter;
import com.nxp.s32ds.cle.cdt.project.info.core.exports.toolchains.GHSToolChainExporter;
import com.nxp.s32ds.cle.cdt.project.info.core.exports.toolchains.IARToolChainExporter;
import com.nxp.s32ds.cle.cdt.project.info.core.internal.Messages;
import com.nxp.s32ds.cle.cdt.project.info.core.internal.PIActivator;
import com.nxp.s32ds.cle.cdt.project.info.core.internal.ProjectInfoPathProcessor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.ProviderNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICSettingEntry;
import org.eclipse.cdt.core.settings.model.ICSourceEntry;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;

public class DefaultOptionProvider
implements IPIExporterDataProvider {
    private static final List<String> FILE_EXTENSIONS_FILTER = Arrays.asList("s", "o");
    private static final List<String> FOLDERS_FILTER = Arrays.asList("Debug_");
    private static final String STARTUP_FILE = "startup.s";
    private static final String IAR_TOOLCHAIN = "ghs";
    private static final String GHS_TOOLCHAIN = "iar";
    private static final String DIAB_TOOLCHAIN = "diab";
    private static final GDBToolChainExporter[] EXPORTERS = new GDBToolChainExporter[]{new IARToolChainExporter(), new GHSToolChainExporter(), new FreescaleS32DSToolChainExporter(), new DiabS32DSToolchainExporter()};
    private final IToolChain toolchain;
    private final GDBToolChainExporter exporter;
    private final ProjectInfoExportSettings settings;

    public DefaultOptionProvider(ProjectInfoExportSettings settings) {
        this.settings = settings;
        this.toolchain = this.getConfig().getToolChain();
        this.exporter = DefaultOptionProvider.getToolChainExporter(this.toolchain);
        if (this.exporter == null) {
            throw new ProviderNotFoundException(Messages.ProjectInfoExporter_export_no_toolchain_processor);
        }
    }

    @Override
    public List<String> getCCOpts() {
        return this.getOptionsForTool(this.exporter::isCCompiler);
    }

    @Override
    public List<String> getAsmOpts() {
        return this.getOptionsForTool(this.exporter::isAssembler);
    }

    @Override
    public List<String> getLinkerOptions() {
        return this.getOptionsForTool(this.exporter::isLinker);
    }

    @Override
    public List<String> getSptAsmOpts() {
        return this.getOptionsForTool(this.exporter::isSptAssembler);
    }

    @Override
    public Collection<String> getLinkerCommandFiles() {
        if (this.exporter == null) {
            return Collections.emptySet();
        }
        return this.exporter.getLinkerCommandFiles(this.getLinkerOptions(), this.settings.getConfiguration());
    }

    @Override
    public boolean mergeOptions() {
        String id = this.toolchain.getId();
        return id.contains(IAR_TOOLCHAIN) || id.contains(GHS_TOOLCHAIN) || id.contains(DIAB_TOOLCHAIN) ? false : this.settings.getDefaultPaths();
    }

    private List<String> getOptionsForTool(Predicate<ITool> predicate) {
        ArrayList<String> result = new ArrayList<String>();
        if (this.exporter == null) {
            PIActivator.getDefault().createWarning("Tool Chain Exporter Missing for " + this.toolchain.getId());
            return result;
        }
        try {
            ITool[] iToolArray = this.toolchain.getTools();
            int n = iToolArray.length;
            int n2 = 0;
            while (n2 < n) {
                ITool tool = iToolArray[n2];
                if (predicate.test(tool)) {
                    result.addAll(this.exporter.processOptions(tool, this.getOptions(tool), this.settings));
                }
                ++n2;
            }
        }
        catch (BuildException e) {
            PIActivator.getDefault().logError(e.getMessage());
        }
        return result;
    }

    private static GDBToolChainExporter getToolChainExporter(IToolChain toolchain) {
        return Stream.of(EXPORTERS).filter(e -> e.isFits(toolchain)).findAny().orElse(null);
    }

    private List<String> getOptions(ITool tool) throws BuildException {
        List<String> toolCommandFlagsString = Arrays.asList(tool.getToolCommandFlags(null, null));
        if (this.settings.getDefaultPaths().booleanValue()) {
            toolCommandFlagsString.stream().forEach(option -> {
                String string = ProjectInfoPathProcessor.substituteVarsPaths(option, tool);
            });
        }
        return toolCommandFlagsString;
    }

    @Override
    public List<String> getSourceCodePaths() {
        ArrayList<String> sourceCodePaths = new ArrayList<String>();
        ICSourceEntry[] iCSourceEntryArray = this.getConfig().getSourceEntries();
        int n = iCSourceEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICSourceEntry se = iCSourceEntryArray[n2];
            sourceCodePaths.add(se.getName());
            ++n2;
        }
        return sourceCodePaths;
    }

    @Override
    public List<String> getIncludePaths() {
        List paths = Arrays.stream(this.settings.getConfiguration().getRootFolderDescription().getLanguageSettings()).map(e -> e.getSettingEntries(1)).flatMap(Arrays::stream).map(ICSettingEntry::getName).collect(Collectors.toList());
        ArrayList<String> result = new ArrayList<String>();
        for (String path : paths) {
            try {
                String processedPath = ProjectInfoPathProcessor.process(path, this.settings.getDefaultPaths(), this.settings.getConfiguration());
                if (result.contains(processedPath)) continue;
                result.add(processedPath);
            }
            catch (CoreException e2) {
                PIActivator.getDefault().log(e2.getStatus());
            }
        }
        return result;
    }

    private IConfiguration getConfig() {
        return ManagedBuildManager.getConfigurationForDescription((ICConfigurationDescription)this.settings.getConfiguration().getConfiguration());
    }

    private static List<IResource> getResources(IConfiguration configuration, IContainer project) {
        ArrayList<IResource> result = new ArrayList<IResource>();
        try {
            IResource[] iResourceArray = project.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource r = iResourceArray[n2];
                if (r.getType() == 1 && (DefaultOptionProvider.isInConfiguration(r, configuration) || DefaultOptionProvider.isStartupFile(r))) {
                    result.add(r);
                } else if (r.getType() == 2) {
                    result.addAll(DefaultOptionProvider.getResources(configuration, (IContainer)r));
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            PIActivator.getDefault().log(e.getStatus());
        }
        return result;
    }

    private static boolean isStartupFile(IResource r) {
        String name;
        if (r != null && (name = r.getName()) != null) {
            return name.equalsIgnoreCase(STARTUP_FILE);
        }
        return false;
    }

    private static boolean isInConfiguration(IResource resource, IConfiguration configuration) {
        return Stream.of(configuration.getSourceEntries()).anyMatch(r -> CDataUtil.isOnSourceEntry((IPath)resource.getProjectRelativePath(), (ICSourceEntry)r));
    }

    @Override
    public List<String> getFiles(String exts) {
        ArrayList<String> result = new ArrayList<String>();
        for (IResource r : DefaultOptionProvider.getResources(this.getConfig(), (IContainer)this.settings.getProject())) {
            if (DefaultOptionProvider.filterResource(r)) continue;
            String[] stringArray = exts.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String ext = stringArray[n2];
                if (ext.trim().equalsIgnoreCase(r.getFileExtension())) {
                    String prefix = "";
                    if (r.isLinked()) {
                        StringBuilder sb = new StringBuilder("link::");
                        sb.append(r.getFullPath().removeFirstSegments(1).removeLastSegments(1).toOSString());
                        sb.append("::");
                        prefix = sb.toString();
                    }
                    if (this.settings.getAbsolutePaths().booleanValue()) {
                        result.add(String.valueOf(prefix) + r.getLocation().toOSString().trim());
                    } else {
                        result.add(String.valueOf(prefix) + r.getProjectRelativePath().toOSString());
                    }
                }
                ++n2;
            }
        }
        return result;
    }

    public List<String> getLibFilesFromToolChain() {
        ArrayList<String> result = new ArrayList<String>();
        ITool[] iToolArray = this.toolchain.getTools();
        int n = iToolArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITool tool = iToolArray[n2];
            if (tool.getId().contains("tool.c.linker")) {
                result.addAll(DefaultOptionProvider.getLibFiles(tool, "gnu.c.link.option.libs", "gnu.c.link.option.paths"));
            }
            if (tool.getId().contains("tool.cpp.linker")) {
                result.addAll(DefaultOptionProvider.getLibFiles(tool, "gnu.cpp.link.option.libs", "gnu.cpp.link.option.paths"));
            }
            ++n2;
        }
        return result;
    }

    public static List<String> getLibFiles(ITool tool, String libsId, String pathsId) {
        String[] paths;
        String[] files;
        try {
            IOption filesOption = tool.getOptionBySuperClassId(libsId);
            files = filesOption.getBasicStringListValue();
            IOption pathsOption = tool.getOptionBySuperClassId(pathsId);
            paths = pathsOption.getBasicStringListValue();
        }
        catch (BuildException e) {
            PIActivator.getDefault().logError(e.getMessage());
            return Collections.emptyList();
        }
        HashSet resolvedPaths = new HashSet();
        Arrays.stream(paths).forEach(path -> {
            try {
                String resolvedPath = DefaultOptionProvider.removeOddQuotes(path);
                IStringVariableManager manager = VariablesPlugin.getDefault().getStringVariableManager();
                if (manager != null) {
                    resolvedPath = manager.performStringSubstitution(resolvedPath, false);
                }
                resolvedPaths.add(resolvedPath);
            }
            catch (CoreException e) {
                PIActivator.getDefault().logError(e.getMessage());
            }
        });
        ArrayList<String> result = new ArrayList<String>();
        Arrays.stream(files).forEach(file -> {
            file = DefaultOptionProvider.removeOddQuotes(file);
            boolean colonStarted = file.startsWith(":");
            boolean libIsAdded = false;
            if (!colonStarted) {
                for (String path : resolvedPaths) {
                    Path p = Paths.get(path, file);
                    if (!Files.isRegularFile(p, new LinkOption[0]) && !path.contains("$")) continue;
                    result.add(p.toString());
                    libIsAdded = true;
                    break;
                }
            }
            if (!libIsAdded) {
                result.add((String)file);
            }
        });
        return result;
    }

    private static String removeOddQuotes(String path) {
        while (path.startsWith("\"") && path.endsWith("\"") && path.length() > 2) {
            path = path.substring(1, path.length() - 1);
        }
        return path;
    }

    private static boolean filterResource(IResource resource) {
        IPath path = resource.getRawLocation();
        if (path != null) {
            String s = path.toString();
            String ext = resource.getFileExtension();
            return DefaultOptionProvider.filterFolders(s) && DefaultOptionProvider.filterExtensions(ext);
        }
        return false;
    }

    public static boolean filterFolders(String s) {
        if (s == null || s.isEmpty()) {
            return false;
        }
        return FOLDERS_FILTER.stream().anyMatch(f -> s.contains((CharSequence)f));
    }

    public static boolean filterExtensions(String ext) {
        if (ext == null || ext.isEmpty()) {
            return false;
        }
        return FILE_EXTENSIONS_FILTER.contains(ext.toLowerCase());
    }
}

