/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.project.info.core.exports;

import com.freescale.s32ds.cross.core.ProjectContextSettings;
import com.nxp.s32ds.cle.cdt.core.imports.ImportExportConfigurationUtil;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;

public class ProjectInfoExportSettings {
    private static final String PI_FILENAME = "ProjectInfo.xml";
    private Boolean absolutePaths = true;
    private Boolean defaultPaths = false;
    private ICConfigurationDescription configuration;
    private final IProject project;
    private static final String IAR_ID = ".*\\.\\d*$";

    public ProjectInfoExportSettings(IProject project) {
        this.project = project;
    }

    public Path getOutputFile() {
        return Paths.get(String.valueOf(this.project.getLocation().toString()) + File.separator + PI_FILENAME, new String[0]);
    }

    public IProject getProject() {
        return this.project;
    }

    public Boolean getAbsolutePaths() {
        return this.absolutePaths;
    }

    public void setAbsolutePaths(Boolean absolutePaths) {
        this.absolutePaths = absolutePaths;
    }

    public ICConfigurationDescription getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(ICConfigurationDescription configuration) {
        this.configuration = configuration;
    }

    public String toString() {
        return "ProjectInfoExportSettings [absolutePaths=" + this.absolutePaths + ", defaultPaths=" + this.defaultPaths + ", configurationName=" + this.getConfiguration().getName() + "]";
    }

    public String getDeviceCore() {
        ProjectContextSettings projectContext = new ProjectContextSettings(this.project);
        return projectContext.getAttributeByKey("com.nxp.s32ds.cle.runtime.hardware.registry.deviceCore.id");
    }

    public String getDevice() {
        ProjectContextSettings projectContext = new ProjectContextSettings(this.project);
        return projectContext.getAttributeByKey("com.nxp.s32ds.cle.runtime.hardware.registry.device.id");
    }

    public String getDeviceRevision() {
        ProjectContextSettings projectContext = new ProjectContextSettings(this.project);
        return projectContext.getAttributeByKey("com.nxp.s32ds.cle.runtime.hardware.registry.device.revision.id");
    }

    public IFile getOutputIFile() {
        return this.project.getFile(PI_FILENAME);
    }

    public Boolean getDefaultPaths() {
        return this.defaultPaths;
    }

    public void setDefaultPaths(Boolean defaultPaths) {
        this.defaultPaths = defaultPaths;
    }

    public List<ICConfigurationDescription> getApplicableConfigurations() {
        ICProjectDescription description = CoreModel.getDefault().getProjectDescription(this.project);
        if (description == null) {
            return Collections.emptyList();
        }
        ICConfigurationDescription[] configurations = description.getConfigurations();
        if (configurations.length == 0) {
            return Collections.emptyList();
        }
        String deviceCoreId = this.getDeviceCore();
        if (deviceCoreId.isEmpty()) {
            return Arrays.asList(configurations);
        }
        Set configurationIds = ImportExportConfigurationUtil.getS32ProjectTypesByDeviceCoreId((String)deviceCoreId).stream().flatMap(pt -> Stream.of(pt.getConfigurations())).map(c -> c.getId()).collect(Collectors.toSet());
        return Stream.of(configurations).filter(c -> {
            String id = c.getId();
            return !id.matches(IAR_ID) || configurationIds.contains(id.substring(0, id.lastIndexOf(46)));
        }).collect(Collectors.toList());
    }
}

