/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.project.info.core.imports;

import com.nxp.s32ds.cle.cdt.project.info.core.internal.jaxb.BuildOptionsType;
import com.nxp.s32ds.cle.cdt.project.info.core.internal.jaxb.Export;
import com.nxp.s32ds.cle.cdt.project.info.core.internal.jaxb.FilesType;
import com.nxp.s32ds.cle.cdt.project.info.core.internal.jaxb.OptionListType;
import com.nxp.s32ds.cle.cdt.project.info.core.internal.jaxb.PathListType;
import com.nxp.s32ds.cle.cdt.project.info.core.internal.jaxb.PathNameListType;
import com.nxp.s32ds.cle.cdt.project.info.core.internal.jaxb.PathNameType;
import com.nxp.s32ds.cle.cdt.project.info.core.internal.jaxb.PathsType;
import com.nxp.s32ds.cle.cdt.project.info.core.internal.jaxb.ProcessorType;
import com.nxp.s32ds.ext.orbit.jaxb.OrbitJAXBContextFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

public class PIReader {
    private final String rootFolder;
    private List<String> linkerCommandFiles = new ArrayList<String>();
    private String projectInfoPath = null;
    private final List<String> generatedFiles = new ArrayList<String>();
    private final List<String> generatedASMFiles = new ArrayList<String>();
    private final List<String> libFiles = new ArrayList<String>();
    private final List<String> includePaths = new ArrayList<String>();
    private final List<String> sourcePaths = new ArrayList<String>();
    private final List<String> libPaths = new ArrayList<String>();
    private final List<String> optionsASM = new ArrayList<String>();
    private final List<String> optionsCC = new ArrayList<String>();
    private final List<String> optionsLinker = new ArrayList<String>();
    private final List<String> optionsSptASM = new ArrayList<String>();
    private final List<String> supportedBuildConfiguration = new ArrayList<String>();
    private final String deviceId;
    private final String revision;
    private final String coreSet;
    private final String coreId;
    private final String flash;
    private final String ram;
    private final Map<String, List<String>> extraOptions = new HashMap<String, List<String>>();

    public PIReader(String configFile) throws IOException, JAXBException {
        this.rootFolder = new File(configFile).getParentFile().getAbsolutePath();
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileInputStream in = new FileInputStream(Paths.get(configFile, new String[0]).toFile());){
            BuildOptionsType buildOptions;
            JAXBContext jc = OrbitJAXBContextFactory.createContext(Export.class);
            Unmarshaller unmarchaller = jc.createUnmarshaller();
            Export export = (Export)unmarchaller.unmarshal((InputStream)in);
            ProcessorType processor = export.getPROCESSOR();
            this.coreSet = processor.getCores().getCore().get(0).getCoreSet();
            this.coreId = processor.getCores().getCore().get(0).getCoreID();
            this.deviceId = processor.getDeviceID();
            this.revision = processor.getRevision();
            this.ram = processor.getSRAMsize();
            this.flash = processor.getFLASHsize();
            PathsType paths = export.getPATHS();
            this.projectInfoPath = paths.getProjectInfoPath();
            this.linkerCommandFiles = paths.getLinkerCommandFile();
            this.addToPathList(paths.getIncludePaths(), this.includePaths);
            this.addToPathList(paths.getSourceCodePaths(), this.sourcePaths);
            this.addToPathList(paths.getLibPaths(), this.libPaths);
            FilesType files = export.getFILES();
            this.addToPathList(files.getGeneratedCs(), this.generatedFiles);
            this.addToPathList(files.getGeneratedHs(), this.generatedFiles);
            this.addToPathList(files.getGeneratedASMs(), this.generatedASMFiles);
            this.addToPathList(files.getLibraries(), this.libFiles);
            OptionListType supportedConfigurationsExported = export.getOPTIONS().getSupportedBuildConfigurations();
            if (supportedConfigurationsExported != null) {
                PIReader.addToOptionsList(supportedConfigurationsExported, this.supportedBuildConfiguration);
            }
            if ((buildOptions = export.getOPTIONS().getBuildOptions()) != null) {
                PIReader.addToOptionsList(buildOptions.getASMoptList(), this.optionsASM);
                PIReader.addToOptionsList(buildOptions.getCCoptList(), this.optionsCC);
                PIReader.addToOptionsList(buildOptions.getLinkerOptList(), this.optionsLinker);
                this.extractExtraOptions(buildOptions.getASMoptList());
                this.extractExtraOptions(buildOptions.getCCoptList());
                this.extractExtraOptions(buildOptions.getLinkerOptList());
                OptionListType sptAsmOptsList = buildOptions.getSPTASMoptList();
                if (sptAsmOptsList != null) {
                    PIReader.addToOptionsList(sptAsmOptsList, this.optionsSptASM);
                }
            }
            export.getOPTIONS().getDebugOptions();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void extractExtraOptions(OptionListType cCoptList) {
        for (String option : cCoptList.getOption()) {
            Matcher optMatcher = Pattern.compile("^\\-X(\\w*) (.*)$").matcher(option);
            if (!optMatcher.find()) continue;
            String target = optMatcher.group(1);
            String value = optMatcher.group(2);
            if (!this.extraOptions.containsKey(target)) {
                this.extraOptions.put(target, new ArrayList());
            }
            this.extraOptions.get(target).add(value);
        }
    }

    private static void addToOptionsList(OptionListType optionListType, List<String> opts) {
        if (optionListType != null) {
            for (String option : optionListType.getOption()) {
                opts.add(option);
            }
        }
    }

    private void addToPathList(PathNameListType paths, List<String> list) {
        if (paths != null) {
            for (PathNameType path : paths.getPathName()) {
                String rel = PIReader.makeRelative(path.getValue(), this);
                if (list.contains(rel)) continue;
                list.add(rel);
            }
        }
    }

    private void addToPathList(PathListType paths, List<String> list) {
        if (paths != null) {
            for (String path : paths.getPath()) {
                String rel = PIReader.makeRelative(path, this);
                if (list.contains(rel)) continue;
                list.add(rel);
            }
        }
    }

    public static String makeRelative(String path, PIReader pi) {
        Path rf;
        String infoPath;
        if (path.startsWith("link::") || path.startsWith(":")) {
            return path;
        }
        Path result = Paths.get(path, new String[0]);
        if (result.isAbsolute() && (infoPath = pi.getProjectInfoPath()) != null && result.startsWith(rf = Paths.get(infoPath, new String[0]).getParent())) {
            result = rf.relativize(result);
        }
        return result.toString();
    }

    public List<String> getLinkerCommandFiles() {
        return this.linkerCommandFiles;
    }

    public List<String> getIncludePaths() {
        return this.includePaths;
    }

    public List<String> getSourcePaths() {
        return this.sourcePaths;
    }

    public List<String> getGeneratedFiles() {
        return this.generatedFiles;
    }

    public List<String> getGeneratedASMFiles() {
        return this.generatedASMFiles;
    }

    public String getRootFolder() {
        return this.rootFolder;
    }

    public String getProjectInfoPath() {
        return this.projectInfoPath;
    }

    public List<String> getOptionsLinker() {
        return this.optionsLinker;
    }

    public List<String> getOptionsCC() {
        return this.optionsCC;
    }

    public List<String> getOptionsASM() {
        return this.optionsASM;
    }

    public List<String> getOptionsSptASM() {
        return this.optionsSptASM;
    }

    public List<String> getLibFiles() {
        return this.libFiles;
    }

    public List<String> getLibPaths() {
        return this.libPaths;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public String getRevision() {
        return this.revision;
    }

    public String getCoreSet() {
        return this.coreSet;
    }

    public String getCoreId() {
        return this.coreId;
    }

    public String getFlash() {
        return this.flash;
    }

    public String getRam() {
        return this.ram;
    }

    public List<String> getSupportedBuildConfiguration() {
        return this.supportedBuildConfiguration;
    }

    public String toString() {
        return "INC= " + Arrays.toString(this.getIncludePaths().toArray()) + '\n' + "SRC= " + Arrays.toString(this.getSourcePaths().toArray()) + '\n' + "LBP= " + Arrays.toString(this.libPaths.toArray()) + '\n' + "GEN= " + Arrays.toString(this.generatedFiles.toArray()) + '\n' + "GEN_ASM= " + Arrays.toString(this.generatedASMFiles.toArray()) + '\n' + "LD= " + Arrays.toString(this.getLinkerCommandFiles().toArray()) + '\n' + "ID= " + this.deviceId + '\n' + "CoreSet= " + this.coreSet + '\n' + "FL= " + this.flash + '\n' + "RM= " + this.ram;
    }

    public List<String> getExtraOptions(String taget) {
        return this.extraOptions.containsKey(taget) ? this.extraOptions.get(taget) : Collections.emptyList();
    }
}

