/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.project.info.core.imports;

import com.freescale.s32ds.cross.core.ProjectContextSettings;
import com.freescale.s32ds.cross.wizard.EmbSysSettingsUtil;
import com.nxp.s32ds.cle.cdt.core.imports.ImportExportConfigurationUtil;
import com.nxp.s32ds.cle.cdt.project.info.core.imports.PIReader;
import com.nxp.s32ds.cle.cdt.project.info.core.imports.ProjectInfoImportSettings;
import com.nxp.s32ds.cle.cdt.project.info.core.imports.processors.IOptionProcessor;
import com.nxp.s32ds.cle.cdt.project.info.core.imports.processors.OptionDelta;
import com.nxp.s32ds.cle.cdt.project.info.core.internal.Messages;
import com.nxp.s32ds.cle.cdt.project.info.core.internal.PIActivator;
import com.nxp.s32ds.cle.cdt.project.info.core.internal.ProjectInfoPathProcessor;
import com.nxp.s32ds.cle.runtime.hardware.registry.CoreDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.DeviceCoreDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.FamilyDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.core.CoreDescriptors;
import com.nxp.s32ds.cle.runtime.hardware.registry.core.DeviceDescriptors;
import com.nxp.s32ds.ext.ide.launch.core.LaunchConfigurationSupportConstants;
import com.nxp.s32ds.ext.rcp.statushandlers.RcpStatusHandlers;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.CProjectNature;
import org.eclipse.cdt.core.envvar.EnvironmentVariable;
import org.eclipse.cdt.core.envvar.IContributedEnvironment;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescriptionManager;
import org.eclipse.cdt.core.settings.model.ICSourceEntry;
import org.eclipse.cdt.core.settings.model.extension.CConfigurationData;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IBuilder;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IProjectType;
import org.eclipse.cdt.managedbuilder.core.IResourceConfiguration;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.Configuration;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedProject;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.osgi.util.NLS;

public class ProjectInfoImporter {
    private static final String NEWLIB_VARIABLE = "S32DS_ARM32_NEWLIB_DIR";
    private static final String NEWLIB_GCC_92_VALUE = "${S32DS_ARM32_GNU_9_2_TOOLCHAIN_DIR}/arm-none-eabi/newlib";
    private static final String NEWLIB_GCC_63_VALUE = "${S32DS_ARM32_TOOLCHAIN_DIR}/arm-none-eabi/newlib";
    private static final String GHS_TOOLCHAIN_ID = "ghs";
    private static final String GNU_TOOLCHAIN_92_SUFFIX = "gnu.9.2.toolchain";
    private static final String GNU_TOOLCHAIN_63_SUFFIX = "arm32.bare.toolchain";
    private static final String ELF_EXTENSION = "elf";
    private static final String IAR_OUT_EXTENSION = "out";
    private static final String IAR_TOOLCHAIN_NAME = "iar.arm.toolchain";
    private static final String TOOLCHAIN_OPT_COMPILER_PATH = "compiler.path";
    private static final String PATH_VARIABLE_NAME = "PATH";
    private static final String PATH_VARIABLE_VALUE_WINDOWS = "${S32DS_GHS_PATH};${MSYS_LOC};${PATH}";
    private static final String PATH_VARIABLE_VALUE_LINUX = "${S32DS_GHS_PATH}:${MSYS_LOC}:${PATH}";
    private static final String PATH_LINKER = "Project_Settings/Linker_Files/";
    private static final String PATH_STARTUP = "Project_Settings/Startup_Code/";
    private static final String ERROR_LOG_FILE_NAME = "copyErrorLog.txt";
    private static final String RCP_STATUS_FAILURE = "Cannot proceed with RCP status sending";
    private final ProjectInfoImportSettings settings;
    private String deviceCoreId;

    public ProjectInfoImporter(ProjectInfoImportSettings settings) {
        this.settings = settings;
        this.deviceCoreId = settings.getPiReader().getCoreId();
        if (this.deviceCoreId == null) {
            String coreName = settings.getPiReader().getCoreSet();
            if (coreName == null) {
                PIActivator.getDefault().logError("No hardware data was found in PI settings");
            } else {
                String coreId = null;
                for (CoreDescriptor descriptor : CoreDescriptors.getCoreDescriptors()) {
                    if (!descriptor.getName().contains(coreName)) continue;
                    coreId = descriptor.getId();
                    break;
                }
                List descriptors = DeviceDescriptors.getDeviceCoreDescriptors((String)settings.getPiReader().getDeviceId(), coreId);
                if (!descriptors.isEmpty()) {
                    this.deviceCoreId = ((DeviceCoreDescriptor)descriptors.get(0)).getId();
                } else {
                    PIActivator.getDefault().logError("Device core descriptor was not found in PI settings");
                }
            }
        }
    }

    public void createProject(IProgressMonitor monitor) throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        String projectName = this.settings.getProjectName();
        IProject project = workspace.getRoot().getProject(projectName);
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.ProjectInfoImporter_project_creation_operation, (int)7);
        project.create((IProgressMonitor)subMonitor.split(1));
        project.open(128, (IProgressMonitor)subMonitor.split(1));
        IProjectDescription description = ProjectInfoImporter.createNewProjectDescription(projectName, this.settings);
        project.setDescription(description, (IProgressMonitor)subMonitor.split(1));
        CProjectNature.addCNature((IProject)project, (IProgressMonitor)subMonitor.split(1));
        this.createCProjectDescription(project, (IProgressMonitor)subMonitor.split(1));
        project.build(6, (IProgressMonitor)subMonitor.split(1));
        if (this.settings.getLCCreator() != null) {
            IToolChain toolchain = this.settings.getConfiguration().getToolChain();
            this.createLaunchConfig(project, toolchain);
        }
        subMonitor.worked(1);
    }

    private void storeHardwareSettings(IProject project, ICProjectDescription projectDesc) throws CoreException {
        String deviceId = this.settings.getPiReader().getDeviceId();
        String familyId = "";
        ProjectContextSettings projectSettings = new ProjectContextSettings(project);
        projectSettings.setAttribute("com.nxp.s32ds.cle.runtime.hardware.registry.device.id", deviceId);
        projectSettings.setAttribute("com.nxp.s32ds.cle.runtime.hardware.registry.deviceCore.id", this.deviceCoreId);
        projectSettings.setAttribute("com.nxp.s32ds.cle.runtime.lang.registry.lang.id", "c");
        if (ImportExportConfigurationUtil.isLibrarySelected((IProjectType)this.settings.getSelectedProjectType())) {
            projectSettings.setAttribute("com.nxp.s32ds.cle.runtime.component.registry.archetype.id", "library");
        } else {
            projectSettings.setAttribute("com.nxp.s32ds.cle.runtime.component.registry.archetype.id", "application");
        }
        DeviceCoreDescriptor deviceCoreDescriptor = DeviceDescriptors.getDeviceCoreDescriptor((String)this.deviceCoreId);
        if (deviceCoreDescriptor == null) {
            PIActivator.getDefault().logError(NLS.bind((String)"Device descriptor was not found for device core id {0}", (Object)this.deviceCoreId));
            projectSettings.store();
            return;
        }
        String coreId = deviceCoreDescriptor.getCoreId();
        projectSettings.setAttribute("com.nxp.s32ds.cle.runtime.hardware.registry.core.id", coreId);
        List familyDescriptors = DeviceDescriptors.getFamilyDescriptors((String)deviceId);
        if (familyDescriptors.isEmpty()) {
            PIActivator.getDefault().logError(NLS.bind((String)"Family descriptor was not found for the device {0}", (Object)deviceId));
        } else {
            familyId = ((FamilyDescriptor)familyDescriptors.get(0)).getId();
            if (familyDescriptors.size() > 1) {
                PIActivator.getDefault().logWarning(NLS.bind((String)"More than 1 family descriptor found for the device {0} unexpectedely", (Object)deviceId));
            }
        }
        projectSettings.setAttribute("com.nxp.s32ds.cle.runtime.hardware.registry.family.id", familyId);
        projectSettings.store();
        EmbSysSettingsUtil.setEmbsysDescriptionDataExt((String)familyId, (String)deviceId, (String)coreId, (ICProjectDescription)projectDesc);
    }

    private static void writeResult(String copyResult, IProject iProject, IProgressMonitor monitor) {
        try {
            IFile errorFile = iProject.getFile(ERROR_LOG_FILE_NAME);
            errorFile.create((InputStream)new ByteArrayInputStream(copyResult.getBytes(StandardCharsets.UTF_8)), true, monitor);
            try {
                RcpStatusHandlers.getStatusHandlerService().getStatusHandler(PIActivator.HANDLER_ID_PROJECT_CREATION_ERROR_LOG).handleStatus((IStatus)new Status(4, PIActivator.getDefault().getBundleId(), ""), (Object)errorFile);
            }
            catch (CoreException e) {
                PIActivator.getDefault().logError(RCP_STATUS_FAILURE, e);
            }
        }
        catch (CoreException e) {
            PIActivator.getDefault().logError("Cannot save ProjectInfo error log file copyErrorLog.txt", e);
        }
    }

    private ICSourceEntry[] getSources(IProject project) {
        ArrayList<String> forSrc = new ArrayList<String>();
        PIReader pi = this.settings.getPiReader();
        for (String srcPath : pi.getSourcePaths()) {
            if (".".equals(srcPath)) {
                forSrc.add("");
                continue;
            }
            forSrc.add(PIReader.makeRelative(srcPath, pi));
        }
        try {
            return ProjectInfoImporter.createSources(forSrc, project);
        }
        catch (CoreException e) {
            PIActivator.getDefault().logError("Failed to create ProjectInfo source files", e);
            return new ICSourceEntry[0];
        }
    }

    private static ICSourceEntry[] createSources(List<String> forSrc, IProject project) throws CoreException {
        LinkedHashSet<String> unique = new LinkedHashSet<String>(forSrc);
        ICSourceEntry[] result = new ICSourceEntry[]{};
        for (String src : unique) {
            IPath srcPath = Path.fromOSString((String)src);
            result = CDataUtil.setExcluded((IPath)srcPath, (boolean)true, (boolean)false, (ICSourceEntry[])result);
        }
        return result;
    }

    private static IProjectDescription createNewProjectDescription(String projectName, ProjectInfoImportSettings settings) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProjectDescription result = workspace.newProjectDescription(projectName);
        result.setComment(Messages.ProjectInfoImporter_project_description);
        return result;
    }

    private static String copy(IProject project, IConfiguration config, PIReader pi, IProgressMonitor monitor) {
        Supplier<IFile> path2File;
        int errs = 0;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        StringBuilder sb = new StringBuilder();
        for (String path : pi.getGeneratedFiles()) {
            if (path.contains("$")) continue;
            path2File = () -> ProjectInfoPathProcessor.makeOutIFile(project, path, pi);
            errs = ProjectInfoImporter.resolveGeneratedPathToFile(path, project, pi, subMonitor, path2File, sb, errs);
        }
        for (String path : pi.getLinkerCommandFiles()) {
            path2File = () -> project.getFile(PATH_LINKER + Paths.get(path, new String[0]).getFileName());
            errs = ProjectInfoImporter.resolveGeneratedPathToFile(path, project, pi, subMonitor, path2File, sb, errs);
        }
        for (String path : pi.getGeneratedASMFiles()) {
            path2File = () -> project.getFile(PATH_STARTUP + Paths.get(path, new String[0]).getFileName());
            errs = ProjectInfoImporter.resolveGeneratedPathToFile(path, project, pi, subMonitor, path2File, sb, errs);
        }
        ProjectInfoImporter.excludeLinkerFolderFromBuild(config, project.getFile(PATH_LINKER));
        subMonitor.worked(2);
        return errs == 0 ? null : sb.toString();
    }

    private static int resolveGeneratedPathToFile(String path, IProject project, PIReader pi, SubMonitor subMonitor, Supplier<IFile> file, StringBuilder sb, int errs) {
        block14: {
            try {
                if (path.startsWith("link::")) {
                    ProjectInfoImporter.createLinkOnFile(path, project, subMonitor);
                    break block14;
                }
                IFile outFile = file.get();
                try {
                    Throwable throwable = null;
                    Object var9_12 = null;
                    try (FileInputStream in = new FileInputStream(ProjectInfoPathProcessor.makeInPath(path, pi).toFile());){
                        ProjectInfoImporter.createFolders(outFile.getParent(), (IProgressMonitor)subMonitor.split(1));
                        outFile.create((InputStream)in, true, (IProgressMonitor)subMonitor.split(1));
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    throw new CoreException(PIActivator.getDefault().createError(NLS.bind((String)"Cannot create file {0}", (Object)outFile.getFullPath().toString()), e));
                }
            }
            catch (CoreException e) {
                PIActivator.getDefault().logError("ProjectInfo generated file creation's failed", e);
                sb.append(String.valueOf(++errs) + "> " + e.getMessage() + '\n');
            }
        }
        return errs;
    }

    private static void createLinkOnFile(String path, IProject project, SubMonitor subMonitor) throws CoreException {
        String[] paths = path.split("::");
        if (paths.length == 3) {
            Path resourceContainerPath = new Path(paths[1]);
            Path resourcePath = new Path(paths[2]);
            IFolder container = project.getFolder((IPath)resourceContainerPath);
            IFile linkedFile = project.getFile(String.valueOf(container.getProjectRelativePath().toOSString()) + '/' + resourcePath.lastSegment());
            if (!container.exists()) {
                ProjectInfoImporter.createFolders((IContainer)container, (IProgressMonitor)subMonitor.split(1));
            }
            linkedFile.createLink((IPath)resourcePath, 0, (IProgressMonitor)subMonitor.split(1));
        } else {
            PIActivator.getDefault().logError(NLS.bind((String)"Linker path {0} has unknown format structure", (Object)path));
        }
    }

    private static void excludeLinkerFolderFromBuild(IConfiguration config, IFile file) {
        IResourceConfiguration resConfig = config.getResourceConfiguration(file.getProjectRelativePath().toString());
        if (resConfig == null) {
            resConfig = config.createResourceConfiguration(file);
        }
        if (resConfig != null) {
            resConfig.setExclude(true);
        }
    }

    private static void createFolders(IContainer container, IProgressMonitor monitor) throws CoreException {
        if (container.exists()) {
            return;
        }
        if (container instanceof IFolder) {
            ProjectInfoImporter.createFolders(container.getParent(), monitor);
            ((IFolder)container).create(true, true, monitor);
            return;
        }
        throw new CoreException(PIActivator.getDefault().createError(NLS.bind((String)"Cannot create folder for container {0} as its resource is not folder", (Object)container.getName())));
    }

    private void createCProjectDescription(IProject project, IProgressMonitor monitor) throws CoreException {
        Optional<IOption> pathOption;
        SubMonitor submonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)8);
        ICProjectDescriptionManager mngr = CoreModel.getDefault().getProjectDescriptionManager();
        ICProjectDescription des = mngr.createProjectDescription(project, false, false);
        ManagedBuildInfo info = ManagedBuildManager.createBuildInfo((IResource)project);
        IProjectType projectType = this.settings.getSelectedProjectType();
        IConfiguration configurtaion = this.settings.getConfiguration();
        IToolChain toolchain = configurtaion.getToolChain();
        IOptionProcessor optionProcessor = this.settings.getSelectedToolChainOptionProcessor(toolchain);
        PIReader reader = this.settings.getPiReader();
        submonitor.worked(1);
        ManagedProject mProj = new ManagedProject((IResource)project, projectType);
        info.setManagedProject((IManagedProject)mProj);
        String id = ManagedBuildManager.calculateChildId((String)configurtaion.getId(), null);
        Configuration config = new Configuration(mProj, (Configuration)configurtaion, id, false, true);
        CConfigurationData data = config.getConfigurationData();
        ICConfigurationDescription cfgDes = des.createConfiguration("org.eclipse.cdt.managedbuilder.core.configurationDataProvider", data);
        config.setConfigurationDescription(cfgDes);
        config.setArtifactName(mProj.getDefaultArtifactName());
        if (toolchain.getId().contains(GHS_TOOLCHAIN_ID)) {
            String pathValue = PATH_VARIABLE_VALUE_WINDOWS;
            if (Platform.getOS().equals("linux")) {
                pathValue = PATH_VARIABLE_VALUE_LINUX;
            }
            ProjectInfoImporter.setEnvironmentVariable(cfgDes, PATH_VARIABLE_NAME, pathValue);
            config.setArtifactExtension(ELF_EXTENSION);
        }
        if (toolchain.getId().contains(GNU_TOOLCHAIN_92_SUFFIX)) {
            ProjectInfoImporter.setEnvironmentVariable(cfgDes, NEWLIB_VARIABLE, NEWLIB_GCC_92_VALUE);
        }
        if (toolchain.getId().contains(GNU_TOOLCHAIN_63_SUFFIX)) {
            ProjectInfoImporter.setEnvironmentVariable(cfgDes, NEWLIB_VARIABLE, NEWLIB_GCC_63_VALUE);
        }
        config.exportArtifactInfo();
        submonitor.worked(1);
        IBuilder bld = config.getEditableBuilder();
        if (bld != null) {
            bld.setManagedBuildOn(true);
        }
        if ((pathOption = Arrays.stream(toolchain.getOptions()).filter(p -> p.getId().endsWith(TOOLCHAIN_OPT_COMPILER_PATH)).findAny()).isPresent()) {
            IOption option = pathOption.get();
            String pathValue = String.valueOf(option.getValue());
            ManagedBuildManager.setOption((IConfiguration)config, (IHoldsOptions)toolchain, (IOption)option, (String)pathValue);
        }
        ICSourceEntry[] srcs = this.createSourceEntry(project, submonitor.split(1));
        config.setSourceEntries(srcs);
        submonitor.worked(1);
        String copyResult = ProjectInfoImporter.copy(project, (IConfiguration)config, reader, (IProgressMonitor)submonitor.split(10));
        submonitor.worked(1);
        if (optionProcessor != null) {
            ProjectInfoImporter.setOptions(optionProcessor, config, reader);
        }
        ProjectInfoImporter.setLibOptions(config, reader);
        submonitor.worked(1);
        this.storeHardwareSettings(project, des);
        submonitor.worked(1);
        mngr.setProjectDescription(project, des);
        submonitor.worked(1);
        if (copyResult != null) {
            ProjectInfoImporter.writeResult(copyResult, project, (IProgressMonitor)submonitor);
        }
        submonitor.worked(1);
    }

    private static void setEnvironmentVariable(ICConfigurationDescription configuration, String name, String value) {
        IContributedEnvironment ce = CCorePlugin.getDefault().getBuildEnvironmentManager().getContributedEnvironment();
        EnvironmentVariable varible = new EnvironmentVariable(name, value);
        ce.addVariable((IEnvironmentVariable)varible, configuration);
    }

    public static void setLibOptions(Configuration config, PIReader reader) {
        List<String> libFiles = reader.getLibFiles();
        if (!libFiles.isEmpty()) {
            try {
                ITool[] cppLinkerTools;
                HashSet resolvedLibs = new HashSet();
                libFiles.forEach(lib -> {
                    if (!lib.startsWith(":") && Paths.get(lib, new String[0]).toFile().exists()) {
                        resolvedLibs.add(Paths.get(lib, new String[0]).getFileName().toString());
                    } else {
                        resolvedLibs.add(lib);
                    }
                });
                String[] libFilesArray = resolvedLibs.toArray(new String[0]);
                ITool[] cLinkerTools = config.getToolChain().getToolsBySuperClassId("cdt.managedbuild.tool.gnu.cross.c.linker");
                if (cLinkerTools.length > 0) {
                    ITool cTool = cLinkerTools[0];
                    IOption libFilesOption = cTool.getOptionBySuperClassId("gnu.c.link.option.libs");
                    config.setOption((IHoldsOptions)cTool, libFilesOption, libFilesArray);
                }
                if ((cppLinkerTools = config.getToolChain().getToolsBySuperClassId("cdt.managedbuild.tool.gnu.cross.cpp.linker")).length > 0) {
                    ITool cppTool = cppLinkerTools[0];
                    IOption libFilesOption = cppTool.getOptionBySuperClassId("gnu.cpp.link.option.libs");
                    config.setOption((IHoldsOptions)cppTool, libFilesOption, libFilesArray);
                }
            }
            catch (BuildException e) {
                PIActivator.getDefault().logError("Unable to set C tools options for the project", e);
            }
        }
    }

    private ICSourceEntry[] createSourceEntry(IProject project, SubMonitor monitor) throws CoreException {
        ICSourceEntry[] srcs;
        ICSourceEntry[] iCSourceEntryArray = srcs = this.getSources(project);
        int n = srcs.length;
        int n2 = 0;
        while (n2 < n) {
            IFolder container;
            ICSourceEntry dir = iCSourceEntryArray[n2];
            if (!dir.getFullPath().toString().isEmpty() && !(container = project.getFolder(dir.getFullPath())).exists()) {
                ProjectInfoImporter.createFolders((IContainer)container, (IProgressMonitor)monitor);
            }
            ++n2;
        }
        return srcs;
    }

    private void createLaunchConfig(IProject project, IToolChain toolchain) {
        try {
            String name = DebugPlugin.getDefault().getLaunchManager().generateLaunchConfigurationName(project.getName());
            IFolder folder = project.getFolder("Project_Settings/Debugger");
            if (!folder.exists()) {
                IFolder parent = (IFolder)folder.getParent();
                if (!parent.exists()) {
                    parent.create(true, true, (IProgressMonitor)new NullProgressMonitor());
                }
                folder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
            }
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            attributes.put(LaunchConfigurationSupportConstants.PROJECT_KEY, project);
            String execExt = ELF_EXTENSION;
            String toolchainBaseId = toolchain.getBaseId();
            if (toolchainBaseId.contains(IAR_TOOLCHAIN_NAME)) {
                execExt = IAR_OUT_EXTENSION;
            }
            String componentId = String.valueOf(name) + '.' + execExt;
            if (toolchainBaseId.contains(GHS_TOOLCHAIN_ID) || toolchainBaseId.contains(IAR_TOOLCHAIN_NAME)) {
                while (toolchain.getSuperClass() != null) {
                    toolchain = toolchain.getSuperClass();
                }
                toolchainBaseId = toolchain.getBaseId();
            }
            attributes.put("com.nxp.s32ds.cle.runtime.component.registry.component.id", componentId);
            attributes.put("projectExecutable", String.valueOf(this.settings.getDebugConfigurationName()) + File.separator + componentId);
            attributes.put("com.nxp.s32ds.cle.runtime.hardware.registry.toolchain.id", toolchainBaseId);
            attributes.put("com.nxp.s32ds.cle.runtime.hardware.registry.deviceCore.id", this.settings.getPiReader().getCoreId());
            attributes.put("com.nxp.s32ds.cle.runtime.hardware.registry.device.revision.id", this.settings.getPiReader().getRevision());
            ILaunchConfigurationWorkingCopy wc = this.settings.getLCCreator().createLaunchConfigurationWorkingCopy(attributes);
            try {
                RcpStatusHandlers.getStatusHandlerService().getStatusHandler(PIActivator.HANDLER_ID_LC_OPENING).handleStatus((IStatus)new Status(0, PIActivator.getDefault().getBundleId(), ""), (Object)wc.doSave());
            }
            catch (CoreException e) {
                PIActivator.getDefault().logError(RCP_STATUS_FAILURE, e);
            }
        }
        catch (CoreException e) {
            PIActivator.getDefault().logError("Launch configuration creation failure", e);
        }
    }

    private static void setOptions(IOptionProcessor optionProcessor, Configuration cfg, PIReader piReader) {
        optionProcessor.prepareChanges((IConfiguration)cfg, piReader).forEach(OptionDelta::apply);
    }
}

